/***************************************************************************
                          ksdataobjectfactory.cpp  -  description
                             -------------------
    begin                : Thu Dec 6 2001
    copyright            : (C) 2001 by kamil
    email                : kamil@localhost.localdomain
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "ksdataobjectfactory.h"
#include "widgets/qsdata.h"
#include "widgets/qssurface.h"
#include "widgets/qscontour.h"
#include "widgets/qsimage.h"
#include "ksmatrix.h"
#include "ksworkbook.h"
#include <qwidget.h>

//-------------------------------------------------------------------------//

KSDataObjectFactory::KSDataObjectFactory()
 {
 }

//-------------------------------------------------------------------------//

KSDataObjectFactory::~KSDataObjectFactory()
 {
 }

//-------------------------------------------------------------------------//

MPSymbol *KSDataObjectFactory::channelVariable( QSData *object, const char *identifier, MPSymbolList *args, int columnFrom, int columnTo )
 {
  // ups, ugly hack ! - do not return x and y as a vector but rather make grid from them
  if ( dynamic_cast<QSImage*>(object) ) {
	QSImage *plot = dynamic_cast<QSImage*>(object);
	int rows = plot->matrix(QSImage::YVector) ? plot->matrix(QSImage::YVector)->rows()-1 : 0;
	int cols = plot->matrix(QSImage::XVector) ? plot->matrix(QSImage::XVector)->cols()-1 : 0;
	if ( plot->channelVariable( QSImage::XVector ) == identifier && object->matrix(QSImage::XVector) )
		return new MPSymQSMatrix( object->matrix(QSImage::XVector), QRect(0,0,cols,rows), args, columnFrom, columnTo, identifier );
	if ( plot->channelVariable( QSImage::YVector ) == identifier && object->matrix(QSImage::YVector) )
		return new MPSymQSMatrix( object->matrix(QSImage::YVector), QRect(0,0,cols,rows), args, columnFrom, columnTo, identifier );	
	}
  if ( dynamic_cast<QSGriddedContour*>(object) ) {
	QSGriddedContour *plot = dynamic_cast<QSGriddedContour*>(object);
	int rows = plot->matrix(QSGriddedContour::YVector) ? plot->matrix(QSGriddedContour::YVector)->rows() : 0;
	int cols = plot->matrix(QSGriddedContour::XVector) ? plot->matrix(QSGriddedContour::XVector)->cols() : 0;
	if ( plot->channelVariable( QSGriddedContour::XVector ) == identifier && object->matrix(QSGriddedContour::XVector) )
		return new MPSymQSMatrix( object->matrix(QSGriddedContour::XVector), QRect(0,0,cols,rows), args, columnFrom, columnTo, identifier );
	if ( plot->channelVariable( QSGriddedContour::YVector ) == identifier && object->matrix(QSGriddedContour::YVector) )
		return new MPSymQSMatrix( object->matrix(QSGriddedContour::YVector), QRect(0,0,cols,rows), args, columnFrom, columnTo, identifier );
	}
  if ( dynamic_cast<QSSurface*>(object) ) {
	QSSurface *plot = dynamic_cast<QSSurface*>(object);
	int rows = plot->matrix(QSSurface::YVector) ? plot->matrix(QSSurface::YVector)->rows() : 0;
	int cols = plot->matrix(QSSurface::XVector) ? plot->matrix(QSSurface::XVector)->cols() : 0;
	if ( plot->channelVariable( QSSurface::XVector ) == identifier && object->matrix(QSSurface::XVector) )
		return new MPSymQSMatrix( object->matrix(QSSurface::XVector), QRect(0,0,cols,rows), args, columnFrom, columnTo, identifier );
	if ( plot->channelVariable( QSSurface::YVector ) == identifier && object->matrix(QSSurface::YVector) )
		return new MPSymQSMatrix( object->matrix(QSSurface::YVector), QRect(0,0,cols,rows), args, columnFrom, columnTo, identifier );
	}
  for( int i=0; i<object->channelCount(); i++ ) {
	if ( object->channelVariable(i) == identifier &&
		object->matrix(i) &&
		object->matrix(i)->rows() &&
		object->matrix(i)->cols()  ) {
		 MPSymbol *sym = new MPSymQSMatrix( object->matrix(i), args, columnFrom, columnTo, identifier );
		 return sym;		
		 }
	}
	
  return NULL;
 }


//-------------------------------------------------------------------------//

#include"dialogs/kschannellist.h"
#include"dialogs/ksmpanels.h"
#include"widgets/qsaxes2d.h"
#include"widgets/qsaxes3d.h"
#include"widgets/qscurve.h"
#include"widgets/qscontour.h"
#include"widgets/qsimage.h"
#include"widgets/qssurface.h"
#include"widgets/qsfigure.h"
#include"ksmatrix.h"
#include"ksglobalmatrixlist.h"
#include"ksmatrixeditor.h"

#define LINE_INVISIBLE "0"
#define LINE_SOLID "1"
#define LINE_DASH "2"
#define LINE_DASHDOT "4"
#define LINE_DOT "3"
#define LINE_DASHDOTDOT "5"


#define FILL_TRANSPARENT "0"
#define FILL_SOLID "1"
#define FILL_HORIZ "9"
#define FILL_VERT "10"
#define FILL_CROSS "11"
#define FILL_BDIAG "12"
#define FILL_FDIAG "13"
#define FILL_DIAGCROSS "14"
#define FILL_HALF "6"
//-------------------------------------------------------------//
// TODO: i18n

static const char *caxis[] = {
        QT_TR_NOOP( "0. Tic marks"  ),
        QT_TR_NOOP( "1. Lines"  ),
        QT_TR_NOOP( "2. Fonts"  ),
        QT_TR_NOOP( "3. Fills"  ),
       };

static const char *daxis[] = {
        QT_TR_NOOP( "<b>Labels - x axis:</b> <i></i><br> Position of user-defined tic marks on the <b>X</b> axis." ),
	QT_TR_NOOP( " Line styles column vector ( M-1 rows ) "),
	QT_TR_NOOP( " Font styles column vector ( M-1 rows ) "),
	QT_TR_NOOP( " Fill styles column vector ( M-1 rows ) ")	
       };

//-------------------------------------------------------------//
// TODO: i18n

static const char *caxes2d[] = {
        QT_TR_NOOP( "0"  )
       };

static const char *daxes2d[] = {
        QT_TR_NOOP( "0" )
       };

//-------------------------------------------------------------//


static const char *caxes3d[] = {
        QT_TR_NOOP( "0" )
       };

static const char *daxes3d[] = {
        QT_TR_NOOP( "0" )
       };

//-------------------------------------------------------------//


static const char *ccurve[] = {
        QT_TR_NOOP( "0. X"        ),
        QT_TR_NOOP( "1. Y"        ),
        QT_TR_NOOP( "2. DX"       ),
        QT_TR_NOOP( "3. DY"       ),
        QT_TR_NOOP( "4. Lines"    ),
        QT_TR_NOOP( "5. Fills"    ),
	QT_TR_NOOP( "6. Points "  ),
	QT_TR_NOOP( "7. Arrows"   ),
	QT_TR_NOOP( "8. ErrLines" ),
	QT_TR_NOOP( "9. XLines"   ),
	QT_TR_NOOP( "10. YLines"  )
       };

static const char *dcurve[] = {
	QT_TR_NOOP( " X column vector ( M rows ) "),
	QT_TR_NOOP( " Y column vector ( M rows ) "),
	QT_TR_NOOP( " DX column vector ( M rows ) "),
	QT_TR_NOOP( " DY column vector ( M rows ) "),
	QT_TR_NOOP( " Line styles column vector ( M-1 rows ) "),
	QT_TR_NOOP( " Fill styles column vector ( M-1 rows ) "),
	QT_TR_NOOP( " Point styles column vector ( M rows ) "),
	QT_TR_NOOP( " Arrow styles column vector ( M rows ) "),
	QT_TR_NOOP( " Error line styles vector ( M rows ) "),
        QT_TR_NOOP( " X line styles vector ( M rows ) "),
        QT_TR_NOOP( " Y line styles vector ( M rows ) ")
	};
	
//-------------------------------------------------------------//



static const char *ccontour[] = {
        QT_TR_NOOP( "0. X"    ),
        QT_TR_NOOP( "1. Y"    ),
	QT_TR_NOOP( "2. Z"    )
       };

static const char *dcontour[] = {
	QT_TR_NOOP( "<b>Column index</b> <i>( 1 x N vector )</i><br>"
        "Contains <i>x</i> coordinates of surface points. "
        "If it is empty, a default <i>(0,1,2...)</i> vector is used. "
        "This vector must be monotone. " ),
	QT_TR_NOOP( "<b>Row index</b> <i>( M x 1 vector )</i><br>"
        "Contains <i>y</i> coordinates of surface points. "
        "If it is empty, a default <i>(0,1,2...)</i> vector is used. "
        "This vector must be monotone. " ),
	QT_TR_NOOP( "<b>Surface values</b> <i>( M x N matrix )</i><br>"
        "This matrix contains surface <i>v</i> values."
        "<b>Surface value[i,j]</b> is a <i>v</i> value at the point"
        "<b>(Column index[i], Row index[j])</b> " )
	};

//-------------------------------------------------------------//



static const char *cngcontour[] = {
	QT_TR_NOOP( "0. X" ),
	QT_TR_NOOP( "1. Y" ),
	QT_TR_NOOP( "2. Z" ),
        QT_TR_NOOP( "3. TriangIdx"    ),
       };

static const char *dngcontour[] = {
        QT_TR_NOOP( "<b>Points - x coords</b> <i>( N x 1 matrix )</i><br> Values at the same position in <b>x,y,z-coords</b> define coordinates of a single point. "),
        QT_TR_NOOP( "<b>Points - y coords</b> <i>( N x 1 matrix )</i><br> Values at the same position in <b>x,y,z-coords</b> define coordinates of a single point. "),
        QT_TR_NOOP( "<b>Points - z coords</b> <i>( N x 1 matrix )</i><br> Values at the same position in <b>x,y,z-coords</b> define coordinates of a single point. "),
	QT_TR_NOOP( "<b>Triangles</b> <i>( N x 3 vector )</i><br> Each value in this matrix is an index to a row in <b>x,y,z-coords</b>. i-th row of <b>Triangles</b> describes the triangle. ")
	};


//-------------------------------------------------------------//


static const char *cimage[] = {
        QT_TR_NOOP( "0. X" ),
        QT_TR_NOOP( "1. Y" ),
        QT_TR_NOOP( "2. R" ),
        QT_TR_NOOP( "3. G" ),
        QT_TR_NOOP( "4. B" ),
        QT_TR_NOOP( "5. Palette " )
       };

static const char *dimage[] = {
        QT_TR_NOOP( "<b>Column index</b> <i>( 1 x N+1 vector )</i><br>"
        "This vector may be used to form a rectangular grid, where each "
        "pixel spreads over a single mesh. All pixels in column <b>C</b> spread "
        "from <b>Column index[C]</b> to <b>Column index[C+1]</b> on "
        "the X axis. This vector must be monotone. See also <b>Row index</b>." ),

        QT_TR_NOOP( "<b>Row index</b> <i>( M+1 x 1 vector )</i><br>"
        "This vector may be used to form a rectangular grid, where each "
        "pixel spreads over a single mesh. All pixels in row <b>R</b> spread "
        "from <b>Row index[R]</b> to <b>Row index[R+1]</b> on "
        "the Y axis. This vector must be monotone. See also <b>Column index</b>." ),

        QT_TR_NOOP( "<b>Red or Index or Gray</b> <i>( M x N matrix )</i><br> "
        "Pixel values. If <b>Green</b> and <b>Blue</b> channels "
        "contains matrix of the same <i>M x N</i> size, this acts as "
        "a red channel of a color value. If a <i>Palette</i> is not "
        "empty this acts as an index to the color palette. Otherwise "
        "acts a grey value of a pixel. " ),

        QT_TR_NOOP( "<b>Green</b> <i>( M x N matrix )</i><br>"
        "If <b>Red</b> and <b>Blue</b> channels "
        "contains matrix of the same <i>M x N</i> size, this acts as "
        "a green channel of a color value. Otherwise is not used." ),

        QT_TR_NOOP( "<b>Blue</b> <i>( M x N matrix )</i><br>"
        "If <b>Red</b> and <b>Green</b> channels "
        "contains matrix of the same <i>M x N</i> size, this acts as "
        "a green channel of a color value. Otherwise is not used." ),

        QT_TR_NOOP( "<b>Palette</b> <i>( C x 3 matrix )</i><br> "
        "Color palette Each row is occupied by one color in format "
        "( red, green, blue ). Channel <b>Red-Index-Gray</b> contains "
        "indexes to this palette ( row number ) for each pixel." )

       };

//-------------------------------------------------------------//

static const char *csurface[] = {
        QT_TR_NOOP( "0. X"  ),
        QT_TR_NOOP( "1. Y"  ),
        QT_TR_NOOP( "2. Z"  ),
        QT_TR_NOOP( "3. V"  )
        };

static const char *dsurface[] = {

        QT_TR_NOOP( "<b>Column index</b> <i>( 1 x N vector )</i><br>"
        "Contains <i>x</i> coordinates of surface points. "
        "If it is empty, a default <i>(0,1,2...)</i> vector is used. "
        "This vector must be monotone." ),

        QT_TR_NOOP( "<b>Row index</b> <i>( M x 1 vector )</i><br>"
        "Contains <i>y</i> coordinates of surface points. "
        "If it is empty, a default <i>(0,1,2...)</i> vector is used. "
        "This vector must be monotone." ),

        QT_TR_NOOP( "<b>Surface values</b> <i>( M x N matrix )</i><br>"
        "This matrix contains surface <i>z</i> values."
        "<b>Surface value[i,j]</b> is a <i>z</i> value at the point"
        " <b>(Column index[i], Row index[j])</b>" ),

        QT_TR_NOOP( "<b>V values</b> <i>( M x N matrix )</i><br>"
        "This matrix contains surface <i>V</i> values used for "
        "plotting 4D data ( x, y, z, v ) " )
        };

//-------------------------------------------------------------//

static const char *cfigure[] = {
        QT_TR_NOOP( "0. X"  ),
        QT_TR_NOOP( "1. Y"  ),
        QT_TR_NOOP( "2. Z"  ),
        QT_TR_NOOP( "3. V" ),
        QT_TR_NOOP( "4. MeshIdx"  )
        };

static const char *dfigure[] = {
        QT_TR_NOOP( "<b>Facets - x coords</b> <i>( N x M matrix )</i><br>"
	"Values at the same position in <b>x,y,z,v-coords</b> define coordinates of a single point. "
        "i-th row of <b>x coords</b> contains <i>x</i> coordinates of vertices of "
        "the i-th facet. <i>M</i> is a number of vertices of a single "
        "facet."),

        QT_TR_NOOP( "<b>Facets - y coords</b> <i>( N x M matrix )</i><br>"
	"Values at the same position in <b>x,y,z,v-coords</b> define coordinates of a single point. "
        "i-th row of <b>y coords</b> contains <i>y</i> coordinates of vertices of "
        "the i-th facet. <i>M</i> is a number of vertices of a single "
        "facet."),

        QT_TR_NOOP( "<b>Facets - z coords</b> <i>( N x M matrix )</i><br>"
 	"Values at the same position in <b>x,y,z,v-coords</b> define coordinates of a single point. "
        "i-th row of <b>x coords</b> contains <i>z</i> coordinates of vertices of "
        "the i-th facet. <i>M</i> is a number of vertices of a single "
        "facet."),

        QT_TR_NOOP( "<b>Facets - v coords</b> <i>( N x M matrix )</i><br>"
	"Values at the same position in <b>x,y,z,v-coords</b> define coordinates of a single point. "
        "i-th row of <b>v coords</b> contains <i>v</i> coordinates of of vertices of "
        "the i-th facet. <i>M</i> is a number of vertices of a single "
        "facet. Used when drawing 4D data."),

        QT_TR_NOOP( "<b>Facets - indices</b> <i>( A x B matrix )</i><br>"
        " Each value in this matrix is an index to a row in <b>x,y,z,v-coords</b>. "
        " Those matrices have only one column in this case. i-th row of <b>indices</b> describes a one facet. ")
        };

//-------------------------------------------------------------//

static const char *dsheet =
        QT_TR_NOOP( "<b>Sheet</b><br>"
		    "Choose File/New from the main menu to set a new data. "
		    "Double click on colun header to change column data type."
		    "Click a left mouse button to show menu." );

//-------------------------------------------------------------//

QString KSDataObjectFactory::channelNameFactory( QSData *bobject, int num )
  {
   if ( dynamic_cast<QSAxis *>(bobject)  ) if ( num >= 0 ) return QString( caxis[num]  ); else return QObject::tr("Axis");
   else
   if ( dynamic_cast<QSAxes2D *>(bobject)  ) if ( num >= 0 ) return QString( caxes2d[num]  ); else return QObject::tr("Axes2D");
   else
   if ( dynamic_cast<QSAxes3D *>(bobject)  ) if ( num >= 0 ) return QString( caxes3d[num]  ); else return QObject::tr("Axes3D");
   else
   if ( dynamic_cast<QSCurve *>(bobject)   ) if ( num >= 0 ) return QString( ccurve[num]   ); else return QObject::tr("Curve");
   else
   if ( dynamic_cast<QSImage *>(bobject)   ) if ( num >= 0 ) return QString( cimage[num]   ); else return QObject::tr("Image");
   else
   if ( dynamic_cast<QSGriddedContour *>(bobject) ) if ( num >= 0 ) return QString( ccontour[num] ); else return QObject::tr("Contour");
   else
   if ( dynamic_cast<QSNonGriddedContour *>(bobject) ) if ( num >= 0 ) return QString( cngcontour[num] ); else return QObject::tr("NgContour");
   else
   if ( dynamic_cast<QSSurface *>(bobject) ) if ( num >= 0 ) return QString( csurface[num] ); else return QObject::tr("Surface");
   else
   if ( dynamic_cast<QSFigure *>(bobject)  ) if ( num >= 0 ) return QString( cfigure[num]  ); else return QObject::tr("Figure");
   else
   if ( dynamic_cast<KSSheetList*>(bobject) ) return QObject::tr("Sheet list");
   else
   if ( dynamic_cast<KSSheet*>(bobject) ) return QObject::tr("Sheet");
	
   return QString();
  }
//-------------------------------------------------------------//

QString KSDataObjectFactory::channelNameFactory( DataObject objectType, int num )
  {
   switch( objectType ) {
	case ObjectAxis:		if ( num >= 0 ) return QString( caxis[num]      ); else return QObject::tr("Axis");	
	case ObjectAxes2D:		if ( num >= 0 ) return QString( caxes2d[num]    ); else return QObject::tr("Axes2D");	
	case ObjectAxes3D:		if ( num >= 0 ) return QString( caxes3d[num]    ); else return QObject::tr("Axes3D");	
	case ObjectCurve:		if ( num >= 0 ) return QString( ccurve[num]     ); else return QObject::tr("Curve");	
	case ObjectGriddedContour:	if ( num >= 0 ) return QString( ccontour[num]   ); else return QObject::tr("Contour");
	case ObjectNonGriddedContour:	if ( num >= 0 ) return QString( cngcontour[num] ); else return QObject::tr("NgContour");
	case ObjectImage:		if ( num >= 0 ) return QString( cimage[num]     ); else return QObject::tr("Image");	
	case ObjectSurface:		if ( num >= 0 ) return QString( csurface[num]   ); else return QObject::tr("Surface");	
	case ObjectFigure:		if ( num >= 0 ) return QString( cfigure[num]    ); else return QObject::tr("Figure");	
	case ObjectSheetList:		return QObject::tr("Sheet list");	
	case ObjectSheet:		return QObject::tr("Sheet");
	}
	
   return QString();
  }

//-------------------------------------------------------------//

QString KSDataObjectFactory::channelDescFactory( QSData *bobject, int num )
  {
   if ( num >= 0 ) {
   if ( dynamic_cast<QSAxis *>(bobject)  ) return QString( daxis[num]  );
   else
   if ( dynamic_cast<QSAxes2D *>(bobject)  ) return QString( daxes2d[num]  );
   else
   if ( dynamic_cast<QSAxes3D *>(bobject)  ) return QString( daxes3d[num]  );
   else
   if ( dynamic_cast<QSCurve *>(bobject)   ) return QString( dcurve[num]   );
   else
   if ( dynamic_cast<QSGriddedContour *>(bobject) ) return QString( dcontour[num] );
   else
   if ( dynamic_cast<QSNonGriddedContour *>(bobject) ) return QString( dngcontour[num] );
   else
   if ( dynamic_cast<QSImage *>(bobject)   ) return QString( dimage[num]   );
   else
   if ( dynamic_cast<QSSurface *>(bobject) ) return QString( dsurface[num] );
   else
   if ( dynamic_cast<QSFigure *>(bobject)  ) return QString( dfigure[num]  );
   else
   if ( dynamic_cast<KSSheet *>(bobject) ) return QString( dsheet );
   }
   return QString();
  }

//-------------------------------------------------------------//

int KSDataObjectFactory::channelNumber( DataObject objectType )
 {
  switch( objectType ) {
	case ObjectAxis:		return 4;
	case ObjectCurve:		return 11;
	case ObjectGriddedContour:	return 3;
	case ObjectNonGriddedContour:	return 4;
	case ObjectImage:		return 6;
	case ObjectSurface:		return 4;
	case ObjectFigure:		return 5;
	case ObjectSheet:		return 1;
	}
  return 0;
 }

//-------------------------------------------------------------//

QString KSDataObjectFactory::channelDescFactory( DataObject objectType, int num )
  {
   if ( num >= 0 )
	switch( objectType ) {
		case ObjectAxis:		return QString( daxis[num]    );
		case ObjectAxes2D:		return QString( daxes2d[num]  );
		case ObjectAxes3D:		return QString( daxes3d[num]  );
		case ObjectCurve:		return QString( dcurve[num]   );
		case ObjectGriddedContour:	return QString( dcontour[num] );
		case ObjectNonGriddedContour:	return QString( dngcontour[num] );
		case ObjectImage:		return QString( dimage[num]   );
		case ObjectSurface:		return QString( dsurface[num] );
		case ObjectFigure:		return QString( dfigure[num]  );
		case ObjectSheet:		return QString( dsheet );
   		}
	
   return QString();
  }

//-------------------------------------------------------------//

QStringList KSDataObjectFactory::channelColumnTitlesFactory( QSData *object, int channel )
 {
  QStringList result;
  if ( channel >= 0 ) {
  if ( dynamic_cast<QSAxes2D *>(object) ||
       dynamic_cast<QSAxes3D *>(object) ||
       dynamic_cast<QSAxis *>(object) && channel == 0 ) {
		result += QObject::tr("value");
		result += QObject::tr("format");
		result += QObject::tr("major");
		result += QObject::tr("angle");		
		}
   else
   if ( dynamic_cast<QSCurve*>(object) && channel == 4 ||
	dynamic_cast<QSCurve*>(object) && channel == 8 ||
	dynamic_cast<QSAxis*>(object) && channel == 1 ) {
	// line
 	result += QObject::tr("l-style");
	result += QObject::tr("l-width");
	result += QObject::tr("l-red");
        result += QObject::tr("l-green");
        result += QObject::tr("l-blue");
        result += QObject::tr("l-alpha");
	}
   else
   if ( dynamic_cast<QSCurve*>(object) && channel == 5 ||
	dynamic_cast<QSAxis*>(object) && channel == 3 ) {
	// fill
 	result += QObject::tr("f-style");
	result += QObject::tr("f-red");
        result += QObject::tr("f-green");
        result += QObject::tr("f-blue");
        result += QObject::tr("f-alpha");
	}
   if ( dynamic_cast<QSAxis*>(object) && channel == 2 ) {
	// font
	result += QObject::tr("f-family");
	result += QObject::tr("f-size");
	result += QObject::tr("f-bold");
	result += QObject::tr("f-italic");
	result += QObject::tr("f-red");
	result += QObject::tr("f-green");
	result += QObject::tr("f-blue");
	result += QObject::tr("f-alpha");
	}
   else
   if ( dynamic_cast<QSCurve*>(object) && channel == 6 ) {
	// point
 	result += QObject::tr("p-style");
	result += QObject::tr("p-fill");
	result += QObject::tr("p-size");
	result += QObject::tr("p-red");
        result += QObject::tr("p-green");
        result += QObject::tr("p-blue");
        result += QObject::tr("p-alpha");	
	}
   else
   if ( dynamic_cast<QSCurve*>(object) && channel == 7 ) {
	// arrow
	result += QObject::tr("a1-style");
	result += QObject::tr("a1-size");
	result += QObject::tr("a2-style");
	result += QObject::tr("a2-size");
	}
   else
   if ( dynamic_cast<QSCurve*>(object) ) {
	switch( channel ) {
		case 0: result+=QObject::tr("x");break;
		case 1: result+=QObject::tr("y");break;
		case 2: result+=QObject::tr("dx");break;
		case 3: result+=QObject::tr("dy");break;
		}
	}
  }
  return result;
 }

//-------------------------------------------------------------//

KSMatrixEditorInterf *KSDataObjectFactory::createEditor( KSWorkbook *workbook, QSData *dataObject, int channel, QWidget *parent )
  {
   if ( dynamic_cast<KSSheet*>(dataObject) && dataObject->matrix(channel) ) {
	return new KSMatrixSheetEditor( workbook, dynamic_cast<KSSheet*>(dataObject), parent );
	}
   else if ( dataObject->matrix(channel) ) {
   	return new KSMatrixEditor( workbook, dataObject->matrix(channel), parent );
	}
   return NULL;
  }

// if ( dynamic_cast<KSSheet*>(matrix->dataObject()) ) return new KSMatrixSheetEditor( dynamic_cast<KSSheet*>(matrix->dataObject()), parent );

//-------------------------------------------------------------//

KSMPanel *KSDataObjectFactory::createCfgPanel( QSMatrix *matrix, KSWorkbook *workbook, QWidget *parent )
  {
   if ( dynamic_cast<KSMatrixString*>(matrix) ) {
	return new KSMPanelString(workbook,dynamic_cast<KSMatrixString*>(matrix),parent);
	}
   else if ( dynamic_cast<KSMatrixWorksheetCellRange*>(matrix) ) {
	return new KSMPanelRef(workbook,dynamic_cast<KSMatrixWorksheetCellRange*>(matrix),parent);
	}
   else if ( dynamic_cast<KSMatrix*>(matrix) ) {
	return new KSMPanelMatrix(workbook,dynamic_cast<KSMatrix*>(matrix),parent);
	}
   else if ( dynamic_cast<KSMatrixFormula*>(matrix) ) {
	return new KSMPanelFormula(workbook,dynamic_cast<KSMatrixFormula*>(matrix),parent);
	}
   return NULL;
  }



