/***************************************************************************
                             ksglobalmatrixlist.h
                             -------------------
    version              : 
    begin                :

    copyright            : (C) 2001 by Kamil Dobkowski
    email                : kamildobk@poczta.onet.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef KSGLOBALMATRIXLIST_H
#define KSGLOBALMATRIXLIST_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include"widgets/qsdata.h"
#include"ksmatrix.h"
#include<qmap.h>
#include<deque.h>

//---------------------------------------------------------------------------------------------//

class KSSheetList;

/**
  * Global sheet
  */
class KSSheet : public QSData
  {
   Q_OBJECT
	friend KSMatrixWorksheetCellRange;
  public:
   /**
     * Column Type
     */
   enum ColumnType { ColumnUnknown=0, ColumnX, ColumnY, ColumnZ, ColumnV, ColumnDX, ColumnDY };
   /**
     *  Column data
     */
   class ColumnData {
	public:
	int column;
	ColumnType type;
	QString title;
	ColumnData( int col = -1 ) { column = col; type = ColumnUnknown; }
	~ColumnData() {}
	};
   /**
     * List of column infos.
     */
   typedef QMap<int,ColumnData> ColumnInfo;
   /**
     * Constructor. You must add the sheet to the sheet list immediately - see KSSeetList::addSheet().
     */
    KSSheet( KSSheetList *parent );
    /**
      * Destructor.
      */
    virtual ~KSSheet();
    /**
      * Sets a new matrix as the given channel in the plot.
      */
    virtual bool setMatrix( int channel, QSMatrix *m );
    /**
      * Returns a matrix and sets a data to NULL.
      */
    virtual QSMatrix *takeMatrix( int channel, QSMatrix *newMatrix = NULL );
    /**
      * Returns matrix 'channel' if any, or NULL.
      */
    virtual QSMatrix *matrix( int channel ) const;
    /**
      * Deletes the choosen matrix.
      */
    virtual void deleteMatrix( int channel );
    /**
      * Returns 1.
      */
    virtual int channelCount() const { return 1; }
     /**
       * Sets column data
       */
     void setColumnData( int column, ColumnType type, const QString& title );
     /**
       * Sets data for the column
       */
     void setColumnData( ColumnData data );
     /**
       * Removes column data
       */
     void removeColumnData( int column );
     /**
       *  Returns column data
       */
     ColumnData columnData( int column ) const;
     /**
       * Checks if there is column data for the column
       */
     bool isColumnDataPresent( int column ) const;
     /**
       *  Returns a pointer on the column info list.
       */
     const ColumnInfo *columnInfo() const { return &m_column_info; }
     /**
       * Returns a number of cell ranges
       */
     int cellRangeCount() const;
     /**	
       * Return a cell range at index 'index'.
       */
     KSMatrixWorksheetCellRange *cellRange( int index );
     /**
       * On which position this sheet should be inserted when adding to the sheet.list.
       * This is always -1, but can be different when loading sheet from stream.
       */
     int insertPos() const { return m_insert_pos; }
     /**
       * Loads sheet from a stream.
       */
     virtual void loadStateFromStream( QDataStream& stream, QSObjectFactory *factory );
     /**
       * Saves sheet to a stream.
       */
     virtual void saveStateToStream( QDataStream& stream, QSObjectFactory *factory );

   protected:
     /**
       * Adds cell range to the list. This is called automatically
       * by KSWorksheetCellRange. Matrices are not deleted.
       */
     void cellRangeAdd( KSMatrixWorksheetCellRange *matrix );
     /**
       * Removes cell range from the list.
       */
     void cellRangeRemove( KSMatrixWorksheetCellRange *matrix );

	ColumnInfo m_column_info;
	QSMatrix *m_matrix;
	KSSheetList *m_parent;
        deque<KSMatrixWorksheetCellRange*> m_cell_range_list;
	int m_insert_pos;
 };

//---------------------------------------------------------------------------------------------//

template<class CHILD_OBJECT> class QSChildList;
/**
  * The list of global sheets
  */
class KSSheetList : public QSData
 {
  Q_OBJECT
  friend KSSheet;
  public:
      /**
        * Constructor
        */
      KSSheetList( QObject * parent=0, const char * name=0 );
      /**
	* Destructor.
	*/
      virtual ~KSSheetList();
      /**
        * Number of child QSData objects
        */
      virtual int childCount() const;
      /**
        * Returns a child object. Reimplemented from QSData.
        */
      virtual KSSheet *child( int index ) const;
      /**
        * Removes all sheets
        */
      virtual void clearAll();
      /**
        * Adds a new sheet
        */
      void sheetAdd( KSSheet *sheet );
	/**
	  * Inserts a sheet at a given position
	  */
	void sheetInsert( int position, KSSheet *sheet );
      /**
        * Removes a sheet
        */
      void sheetRemove( int index );
      /**
        * Removes and deletes a sheet
        */
      void sheetDelete( int index );
	/**
	  * Raises ( increases index ) sheet on the list.
	  */
	void sheetRaise( int index );
	/**
	  * Lowers ( decreases index ) sheet on the list.
	  */
	void sheetLower( int index );
	/**
	  * Brings sheet to the front ( max index ).
	  */
	void sheetToFront( int index );
	/**
	  * Sends sheet to the back ( index = 0 )
	  */
	void sheetToBack( int index );
	/**
	  * Move sheet at position 'atPosition'.
	  */
	void sheetReorder( int atPosition, int index );
	/**
	  * Returns an index of the given sheet ot -1.
	  */
	int sheetFind( KSSheet *sheet );
	
//	int sheetFind( const QString& title );

   protected:
       QSChildList<KSSheet> *m_sheets;
 };

//---------------------------------------------------------------------------------------------//



#endif


