/***************************************************************************
                             ksglobalsettings.h
                             -------------------
    begin                : Mon Jan 14 2002
    copyright            : (C) 2002 by kamil
    email                : kamil@localhost.localdomain
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KSGLOBALSETTINGS_H
#define KSGLOBALSETTINGS_H

#include<qstring.h>

/**
  * global settings path
  * @author kamil
  */
class KSGlobalSettings {

  public:
	/**
	  * Constructor
	  */
	KSGlobalSettings();
	/**
	  * Destructor
	  */
	~KSGlobalSettings();
	/**
	  * Turns on opening socket at start
	  * The socket is always opened when KMatplot is run from
	  * withing Octave or Scilab
	  */
	static void setOpenSocket( bool enable );	
	/**
	  * Returns whether socket is opened at start.
	  */
	static bool openSocket();
	/**
	  * Sets a number of undo levels
	  */
	static void setUndoLevels( int levels );
	/**
	  * Returns a number of undo levels.
	  */
	static int undoLevels();
	/**
	  * Use custom dpi when printing or a default one
	  */
	static void setUseCustomPrintDpi( bool enabled );
	/**
	  * Uses custom printing dpi or not
	  */
	static bool useCustomPrintDpi();
	/**
	  * Set custom dpi value
	  */
	static void setCustomPrintDpi( int dpi );
	/**
	  * Returns custom dpi value
	  */
	static int customPrintDpi();
	/**
	  * Sets the base directory
	  */
	static void setInstallPath( const QString& installPath );
	/**
	  * Returns the base directory
	  */
	static QString installPath();
	/**
	  * Returns installPath/share/kmatplot/examples
	  */
	static QString examplePath();
	/**
	  * Returns installPath/share/kmatplot/pics
	  */
	static QString picturePath();
	/**
	  * Loads settings from a file
	  */
	static void load();
	/**
	  * Saves settings in a file
	  */
	static void save();
	/**
	  * Sets parameters in apriopriate object, whenever it is possible.
	  * Currently sets 'undoLevels'
	  */
	static void apply();

  private:
	typedef struct {
		QString m_install_path;
		bool m_use_custom_dpi;
		int m_custom_dpi;
		bool m_open_socket;
		int m_undo_levels;
		} settings_t;
	static settings_t m_settings;
  };

#endif
