/***************************************************************************
                                  ksmatrixascii.h
                             -------------------
    begin                : Wed Feb 9 2000
    copyright            : (C) 2000 by Kamil Dobkowski
    email                : kamildbk@friko.onet.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KSMATRIXASCII_H
#define KSMATRIXASCII_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "ksmatrixiohandler.h"
#include <qstring.h>

/**
  * Imports matrices from ASCII text files.
  * @author Kamil Dobkowski
  */

class KSMatrixASCII : public KSMatrixIOHandler
 {
  public:
       KSMatrixASCII();
      ~KSMatrixASCII();

       bool check( QDataStream &is );
       KSHeadersList* headers( QDataStream& is );
       KSMatrix* load( QDataStream& is, const QString& matrixname );
       void save( QDataStream& os, QSMatrix *m, const QString& matrixname );

        /**
          * Returns "ASCII".
          */
       virtual QString format() { return QString("ASCII"); }

  private:


       KSMatrix *read_header( QDataStream& is, int* data_pos = NULL );

 };

#endif
