/***************************************************************************
                                 ksmatrixiohandler.h
                             -------------------
    begin                : 01-January-2000
    copyright            : (C) 2000 by Kamil Dobkowski
    email                : kamildobk@poczta.onet.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KSMATRIXIOHANDLER_H
#define KSMATRIXIOHANDLER_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include"ksmatrix.h"
#include<qstring.h>
#include<qdatastream.h>
#include<qobject.h>
#include<list>

/**
  * List of matrix headers.
  */
typedef list<KSMatrix*> KSHeadersList;

/**
  * STL template specialization.
  */
inline void destroy( KSMatrix **p ) { (*p)->~KSMatrix(); }

/**
  * Abstract base class for any format handlers.
  * see @ref KSMatrixIO
  * @author Kamil Dobkowski
  * @version 0.0.1
  */
class KSMatrixIOHandler : public QObject
 {
   Q_OBJECT

   public:

     /**
        * Constructor.
        */
      KSMatrixIOHandler() {}

      /**
        * Destructor.
        */
     virtual ~KSMatrixIOHandler() {}

      /**
        * Checks if this handler can decode contents of 'is'.
        */
      virtual bool check( QDataStream &is );

      /**
        * This method returns a list of matrices from 'is'.
        * Number of matrices is returned in 'headersNum'.
        * Matrices have the valid size and type but no data memory is allocated !
        * Remember to delete this list after use !
        * Throws @ref KSException .
        */
      virtual KSHeadersList *headers( QDataStream& is );

      /**
        * Loads 'matrixName' matrix from 'is'.
        * Throws @ref KSException .
        */
      virtual KSMatrix *load( QDataStream& is, const QString& matrixname );

      /**
        * Saves 'm' matrix to 'os'.
        * Throws @ref KSException .
        */
      virtual void save( QDataStream& os, QSMatrix *m, const QString& matrixname );

      /**
        * Returns the format QString.
        */
      virtual QString format() = 0;
 };

#endif


























