/***************************************************************************
                              ksobjectfactory.h
                             -------------------
    begin                : Tue Oct 16 2001
    copyright            : (C) 2001 by kamil
    email                : kamil@localhost.localdomain
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KSOBJECTFACTORY_H
#define KSOBJECTFACTORY_H

#include"widgets/qsserializable.h"
#include<qcstring.h>
class QSMatrix;
class QSCObject;
class QSCObjectCollection;
class QSPlot;
class QSAxis;
class QSAxes;
class KSSheet;
class KSSheetList;
class KSWorkbook;
/**
  *@author kamil
  */
class KSObjectFactory : public QSObjectFactory
 {
  public:
	/**
	  * Constructor
	  */
	KSObjectFactory( KSWorkbook *workbook );
	/**
          * Destructor
	  */
	virtual ~KSObjectFactory();
	/**
	  * Loads an object from a data stream
	  */
	virtual QSSerializable *loadObjectFromStream( QDataStream& stream, QObject *parent=NULL );
	/**
	  * Saves object to a datastream.
	  */
	virtual void saveObjectToStream( QSSerializable *object, QDataStream& stream );
	/**
	  * Creates object of class 'className'
	  */
	virtual QSSerializable *createObject( const QCString& className, QObject *parent );
	/**
	  * Returns a class name of a given object
	  */
	virtual QCString className( QSSerializable *object );
	/**
	  * Clone and detach matrix.
	  */
	static QSMatrix *cloneMatrix( QSMatrix *matrix, bool copyData = false );
	/**
	  * Copies an object to a system clipboard.
	  */
	void copyToClipboard( QSSerializable *object, const QCString& format );
	/**
	  * Loads object from clipboard
	  */
	QSSerializable *pasteFromClipboard( const QCString& format, QObject *parent=NULL );
	/**
	  * Copies a canvas object to system clipboard
	  */
	void copyQSCObjectToClipboard( QSCObject *object );
	/**
	  * Loads a canvas object from clipboard
	  */
	QSCObject *pasteQSCObjectFromClipboard();
	/**
	  * Copies a canvas object collection to system clipboard
	  */
	void copyQSCObjectCollectionToClipboard( QSCObjectCollection *objects );
	/**
	  * Loads a canvas object collection from clipboard
	  */
	QSCObjectCollection *pasteQSCObjectCollectionFromClipboard();
	/**
	  * Copies dataset to clipboard
	  */
	void copyQSPlotToClipboard( QSPlot *dataset );
	/**
	  * Loads dataset from clipboard
	  */
	QSPlot *pasteQSPlotFromClipboard( QSAxes *parentAxes );
	/**
	  * Copies the axis to clipboard
	  */
	void copyQSAxisToClipboard( QSAxis *axis );
	/**
	  * Loads axis from clipboard
	  */
	QSAxis *pasteQSAxisFromClipboard( QSAxes *parentAxes );
	/**
	  * Copies matrix to clipboard
	  */
	void copyQSMatrixToClipboard( QSMatrix *matrix );
	/**
	  * Loads matrix from clipboard
	  */
	QSMatrix *pasteQSMatrixFromClipboard();
	/**
	  * Copies sheet from clipboard
	  */
	void copyKSSheetToClipboard( KSSheet *sheet );
	/**
	  * Loads sheet from clipboard
	  */
	KSSheet *pasteKSSheetFromClipboard( KSSheetList *parent );	

  protected:
	QSSerializable *transform_object( QSSerializable *, int flags );
	KSWorkbook *m_workbook;
};

#endif
