/***************************************************************************
                                ksworkbook.cpp
                             -------------------                                         
    begin                :
    copyright            : (C) 2001 by Kamil Dobkowski
    email                : kamildobk@poczta.onet.pl                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include"ksworkbook.h"
#include"ksglobalmatrixlist.h"

//---------------------------------------------------------------------------------------------//

KSCommand::KSCommand( const QString& title )
 {
  m_title = title;
 }

//---------------------------------------------------------------------------------------------//

KSCommand::~KSCommand()
 {
 }

//---------------------------------------------------------------------------------------------//

void KSCommand::setError( const QString& message )
 {
  m_error = message;
 }

//---------------------------------------------------------------------------------------------//
//---------------------------------------------------------------------------------------------//
//---------------------------------------------------------------------------------------------//
//---------------------------------------------------------------------------------------------//

int KSCommandHistory::m_undo_levels = 5;

KSCommandHistory::KSCommandHistory( QObject *parent )
:QObject( parent )
 {
  m_last_executed_command = -1;
  m_command_history.setAutoDelete( TRUE );
 }

//---------------------------------------------------------------------------------------------//

KSCommandHistory::~KSCommandHistory()
 {
 }

//---------------------------------------------------------------------------------------------//

void KSCommandHistory::clear()
 {
  m_command_history.clear();
  m_last_executed_command = -1;
  sigNewUndo();
  sigNewRedo();
 }

//---------------------------------------------------------------------------------------------//

void KSCommandHistory::setUndoLevels( int levels )
 {
  m_undo_levels = levels;
 }

//---------------------------------------------------------------------------------------------//

bool KSCommandHistory::execute( KSCommand *command )
 {
  if ( command->execute() ) {
  	// clear all undid commands
  	while( isRedoPossible() ) m_command_history.removeLast();

  	m_command_history.append( command );

  	// adjust list size
  	while( (int )m_command_history.count() > m_undo_levels ) m_command_history.removeFirst();
  	m_last_executed_command = m_command_history.count()-1;

	emit sigNewUndo();
	emit sigNewRedo();
	return true;
	} else {
	emit sigError( command->error() );
	delete command;
	return false;
	}
 }

//---------------------------------------------------------------------------------------------//

void KSCommandHistory::undo()
 {
  if ( isUndoPossible() ) {
	m_command_history.at(m_last_executed_command)->unexecute();
	m_last_executed_command --;
	emit sigNewUndo();
	emit sigNewRedo();
	}
 }

//---------------------------------------------------------------------------------------------//

void KSCommandHistory::redo()
 {
  if ( isRedoPossible() ) {
	m_command_history.at(m_last_executed_command+1)->execute();
	m_last_executed_command ++;
	emit sigNewUndo();
	emit sigNewRedo();
	}
 }

//---------------------------------------------------------------------------------------------//

bool KSCommandHistory::isUndoPossible()
 {
  return m_last_executed_command >= 0;
 }

//---------------------------------------------------------------------------------------------//

bool KSCommandHistory::isRedoPossible()
 {
  return m_last_executed_command < (int )m_command_history.count()-1;
 }

//---------------------------------------------------------------------------------------------//

QString KSCommandHistory::undoCommandTitle()
 {
  if ( isUndoPossible() ) {
	 return m_command_history.at(m_last_executed_command)->title();
	}
  return QString::null;
 }

//---------------------------------------------------------------------------------------------//

QString KSCommandHistory::redoCommandTitle()
 {
  if ( isRedoPossible() ) {
        return m_command_history.at(m_last_executed_command+1)->title();
	}
  return QString::null;
 }

//---------------------------------------------------------------------------------------------//
//---------------------------------------------------------------------------------------------//
//---------------------------------------------------------------------------------------------//
//---------------------------------------------------------------------------------------------//

KSWorkbook::KSWorkbook( QObject *parent )
:QSWorkbook( parent )
 {
  m_sheets = new KSSheetList( this );
  m_command_history = new KSCommandHistory( this );
 }

//---------------------------------------------------------------------------------------------//

KSWorkbook::~KSWorkbook()
 {
 }

//---------------------------------------------------------------------------------------------//

void KSWorkbook::clear()
 {
  QSWorkbook::clear();
  m_command_history->clear();
  m_sheets->clearAll();
 }

//---------------------------------------------------------------------------------------------//

