/***************************************************************************
                                  kaddaxes.cpp
                             -------------------
    begin                : Sun Jun 25 2000
    copyright            : (C) 2000 by Kamil Dobkowski
    email                : kamildobk@friko.onet.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <octave/oct.h>
#include <iostream.h>
#include <errno.h>
#include "octave-common.h"

//------------------------------------------------------------------//

DEFUN_DLD (kaddaxes, args, ,
" usage: kaddaxes(type)\n"
"\n"
"Adds a new axes\n"
" 0 - 2d axes\n"
" 1 - 3d axes\n"
" Sets a newly added axes as the active axes. \n"
"See also: kadd, kremove, kremove, kremoveall, ksetapp, ksetplot, kplot, kimage, kcontour, kmesh, ksetmatrix\n" )
{
 int axes_number = -1;
 int type = (int )args(0).double_value();
 if ( type < 0 || type > 1 ) {
      	error("Type must be 0 or 1.");
     } else {
      	int socket_fd = plot_connect( appNumber(), NULL, NULL );
      	if ( socket_fd == -1 && errno < sys_nerr && errno >= 0 ) {
			 error( sys_errlist[errno] );
			 return octave_value_list();
			 }
 	axes_number = plot_add_axes( socket_fd, type );
 	if ( axes_number > 0 ) setAxes( axes_number );
 	plot_disconnect( socket_fd );
     }
 return octave_value_list( (double )axes_number );
}

