/***************************************************************************
                                  kimage.cc
                             -------------------
    begin                : Sun Jun 25 2000
    copyright            : (C) 2000 by Kamil Dobkowski
    email                : kamildobk@friko.onet.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <octave/oct.h>
//#include <iostream.h>
#include <errno.h>
#include "octave-common.h"

DEFUN_DLD ( kimage, args, ,
" usage: image(V)\n"
"        image(X,Y,V)\n"
"        image(R,G,B)\n"
"        image(X,Y,R,G,B)\n"
"\n"
"See also: kadd, kremove, kremoveall, kaddaxes, kremoveaxes, ksetapp, ksetaxes, kplot, kcontour, kmesh, ksetmatrix" )
{
  octave_value_list result(-1.0);
  int nargin = args.length ();

  if ( nargin != 1 &&
       nargin != 3 &&
       nargin != 5  ) {
       error("wrong number of arguments");
       return result;
      }

  int socket_fd = plot_connect( appNumber(), NULL, NULL );
  if ( socket_fd == -1 && errno < sys_nerr && errno >= 0 ) {
			 error( sys_errlist[errno] );
			 return result;
			}
			
  int dataset_number = plot_add_dataset( socket_fd, axesNumber(), PlotImage );

  if ( nargin == 1 ) {
	Matrix m = args(0).matrix_value();
        setMatrix( socket_fd, dataset_number, 2, m ); //r
  	}
  else if ( nargin == 3 ) {

     Matrix xr = args(0).matrix_value();
     Matrix yg = args(1).matrix_value();
     Matrix vb = args(2).matrix_value();

     int rows = vb.rows();
     int cols = vb.cols();

     if ( xr.rows() == rows &&
          xr.cols() == cols &&
          yg.rows() == rows &&
          yg.cols() == cols  ) {
          setMatrix( socket_fd, dataset_number, 2, xr ); //r
          setMatrix( socket_fd, dataset_number, 3, yg ); //g
          setMatrix( socket_fd, dataset_number, 4, vb ); //b

        } else {

          if ( xr.rows() > 1 ) { Matrix temp = xr.transpose(); xr = Matrix(); xr = temp; }
          if ( yg.cols() > 1 ) { Matrix temp = yg.transpose(); yg = Matrix(); yg = temp; }

          if ( xr.cols() != cols+1 || xr.rows() > 1 ) {
              error("x must be a vector with size columns(v)+1");
              plot_disconnect( socket_fd );
              return result;
             }

         if ( yg.rows() != rows+1 || yg.cols() > 1 ) {
              error("y must be a vector with size rows(v)+1");
              plot_disconnect( socket_fd );
              return result;
             }

         setMatrix( socket_fd, dataset_number, 0, xr ); //x
         setMatrix( socket_fd, dataset_number, 1, yg ); //y
         setMatrix( socket_fd, dataset_number, 2, vb ); //v
        }
    }

  else if ( nargin == 5 ) {

     Matrix x = args(0).matrix_value();
     Matrix y = args(1).matrix_value();
     Matrix r = args(2).matrix_value();
     Matrix g = args(3).matrix_value();
     Matrix b = args(4).matrix_value();

     int rows = r.rows();
     int cols = r.cols();
     if ( x.rows() > 1 ) { Matrix temp = x.transpose(); x = Matrix(); x = temp; }
     if ( y.cols() > 1 ) { Matrix temp = y.transpose(); y = Matrix(); y = temp; }

     if ( x.cols() != cols+1 || x.rows() > 1 ) {
         error("x must be a vector with size columns(r)+1");
         plot_disconnect( socket_fd );
         return result;
        }

     if ( y.rows() != rows+1 || y.cols() > 1 ) {
         error("y must be a vector with size rows(r)+1");
         plot_disconnect( socket_fd );
         return result;
        }

     if ( g.rows() != rows ||
          g.cols() != cols ||
          b.rows() != rows ||
          b.cols() != cols  ) {
         error(" r, g and b must have the same size");
         plot_disconnect( socket_fd );
         return result;
        }

      setMatrix( socket_fd, dataset_number, 0, x );
      setMatrix( socket_fd, dataset_number, 1, y );
      setMatrix( socket_fd, dataset_number, 2, r );
      setMatrix( socket_fd, dataset_number, 3, g );
      setMatrix( socket_fd, dataset_number, 4, b );
   }

  plot_disconnect( socket_fd );
  return octave_value_list( (double )dataset_number );
}


