/***************************************************************************
                              octave-common.h
                             -------------------
    begin                : Sun Jun 25 2000
    copyright            : (C) 2000 by Kamil Dobkowski
    email                : kamildobk@friko.onet.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include"../interface/common.h"

#define ENV_APP_NUMBER "__kmatplot_app_num__"
#define ENV_AXES_NUMBER "__kmatplot_axes_num__"

//--------------------------------------------------------------------//

int appNumber()
 {
  int app_num = 0;
  char *app_num_str = getenv( ENV_APP_NUMBER );
  if ( app_num_str  ) app_num = atoi( app_num_str );
  if ( app_num <= 0 ) app_num = 1;
  return app_num;
 }

//--------------------------------------------------------------------//

int axesNumber()
 {
  int axes_num = 0;
  char *axes_num_str = getenv( ENV_AXES_NUMBER );
  if ( axes_num_str  ) axes_num = atoi( axes_num_str );
  if ( axes_num <= 0 ) axes_num = 1;
  return axes_num;
 }

//--------------------------------------------------------------------//

void setMatrix( int socket_fd, int dataset, int channel, const Matrix& m )
  {
   // remember to reorder matrix
  if ( m.data() )
  plot_set_channel( socket_fd, axesNumber(), dataset, channel,
		 EDouble, m.rows(), m.cols(),
		 m.data(), 0,
		 m.rows()*sizeof(double), sizeof(double) );	
 }

//--------------------------------------------------------------------//

void setAxes( int new_axes_number )
    {
     if ( new_axes_number <= 0 ) new_axes_number = 1;
     char buff[50];
     sprintf( buff, "%d", new_axes_number );
     setenv( ENV_AXES_NUMBER, buff, 1 );
     }


