function [result]=kimage(x,y,r,g,b)
//
//  image(gray)     - plots matrix gray
//  image(x,y,gray) - plots matrix gray versus vectors x and y.
//                    length(x) = cols(gray)+1, length(y) = rows(gray)+1
//                    x and y must be monotone
//  image(r,g,b)    - plots rgb matrices.
//  image(x,y,r,g,b) - plots rgb matrices versus x,y vectors.

result=1;
[out, in]=argn(0);
// kremoveall();
dataset = kadd(1);    // function defined in plots.o
if in==1 then
  ksetmatrix(dataset,2,x);  // gray
elseif in==5 then
  ksetmatrix(dataset,0,x);  // x
  ksetmatrix(dataset,1,y);  // y
  ksetmatrix(dataset,2,r);  // r
  ksetmatrix(dataset,3,g);  // g
  ksetmatrix(dataset,4,b);  // b
elseif in==3 then
  if size(x)==size(y) & size(y)==size(r) then
    ksetmatrix(dataset,2,x); // r
    ksetmatrix(dataset,3,y); // g
    ksetmatrix(dataset,4,r); // b
  else
    if size(x,2) <> size(r,2)+1 then, x=x', end
    if size(y,1) <> size(r,1)+1 then, y=y', end

    if size(x,2) <> size(r,2)+1 then, error("length(x) must be equal to cols(gray)+1 !"); result=0, end
    if size(y,1) <> size(r,1)+1 then, error("length(y) must be equal to rows(gray)+1 !"); result=0, end
    ksetmatrix(dataset,0,x);  // x
    ksetmatrix(dataset,1,y);  // y
    ksetmatrix(dataset,2,r);  // gray
  end
else
  error("Wrong number of arguments !");
  result = 0;
end
end