/***************************************************************************
                                 qbase.cpp
                             -------------------
    begin                : 01-January-2001

    copyright            : (C) 2001 by Kamil Dobkowski
    email                : kamildobk@poczta.onet.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "qsgraphicaldata.h"
#include <qstrlist.h>
#include <qmetaobject.h>
#include <qvariant.h>
#include <iostream>

//-------------------------------------------------------------//

QSData::QSData( QObject * parent, QSData *parentObject, const char * name )
:QObject( parent, name ), QSSerializable()
 {
  m_parent_object = parentObject;
 }

//-------------------------------------------------------------//

QSData::~QSData()
 {
  emit sigDeleted(this);
 }

//-------------------------------------------------------------//

void QSData::setObjectName( const char *name )
 {
  setName( name );
  emit sigNameChanged( name );
  nameChanged( this, name );
 }

//-------------------------------------------------------------//

bool QSData::setMatrix( int, QSMatrix * )
 {
  return false;
 }

//-------------------------------------------------------------//

QSMatrix *QSData::matrix( int  ) const
 {
 return NULL;
 }

//-------------------------------------------------------------//

QSMatrix *QSData::takeMatrix( int, QSMatrix* )
 {
  return NULL;
 }

//-------------------------------------------------------------//

void QSData::deleteMatrix( int  )
 {
 }

//-------------------------------------------------------------//

int QSData::channelCount() const
 {
 return 0;
 }

//-------------------------------------------------------------//

void QSData::dataChanging( int channel  )
 {
  dataChanging( this, channel );
 }

//-------------------------------------------------------------//

void QSData::dataChanged( int channel )
 {
  dataChanged( this, channel );
 }

 //-------------------------------------------------------------//

void QSData::dataChanging( QSData *object, int channel  )
 {
  if ( m_parent_object )  m_parent_object->dataChanging( object, channel );
 }

//-------------------------------------------------------------//

void QSData::dataChanged( QSData *object, int channel )
 {
  emit sigDataChanged( object, channel );
  if ( m_parent_object )  m_parent_object->dataChanged( object, channel );
 }

//-------------------------------------------------------------//

int QSData::childIndex( QSData *searched_child ) const
 {
  for( int child_nr=0; child_nr<childCount(); child_nr++ )
	if ( child(child_nr) == searched_child ) return child_nr;
	
  return -1;
 }

//-------------------------------------------------------------//

void QSData::nameChanged( QSData *object, const char *newName )
 {
  emit sigNameChanged( object, newName );
  if ( m_parent_object ) m_parent_object->nameChanged( object, newName );
 }

//-------------------------------------------------------------//

void QSData::loadStateFromStream( QDataStream& stream, QSObjectFactory *factory )
 {
  QSSerializable::loadStateFromStream( stream, factory );
  // load properties
  QMetaObject *meta_object = metaObject();
  QStrList properties = meta_object->propertyNames( TRUE );
  for( unsigned int property_nr=0; property_nr<properties.count(); property_nr++ ) {
	QCString property_name;
	QVariant property_value;
	stream >> property_name >> property_value;
	setProperty(property_name,property_value);
	}
  // load matrices
  for( int i=0; i<channelCount(); i++ ) {
	setMatrix( i, dynamic_cast<QSMatrix*>(factory->loadObjectFromStream(stream)) );
	}
 }

//-------------------------------------------------------------//

void QSData::saveStateToStream( QDataStream& stream, QSObjectFactory *factory )
 {
  QSSerializable::saveStateToStream( stream, factory );
  // save properties
  QMetaObject *meta_object = metaObject();
  QStrList properties = meta_object->propertyNames( TRUE );
  for( unsigned int property_nr=0; property_nr<properties.count(); property_nr++ ) {
  	stream << QCString(properties.at(property_nr)) << property(properties.at(property_nr));
	}
  // save matrices
  for( int i=0; i<channelCount(); i++ ) {
	 factory->saveObjectToStream(matrix(i),stream);
	}
 }




