/***************************************************************************
                                qsfigure.h
                             -------------------                                         
    begin                : 01-January-2000
    copyright            : (C) 2000 by Kamil Dobkowski                         
    email                : kamildobk@poczta.onet.pl                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef QSFIGURE_H
#define QSFIGURE_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include"qsaxes.h"
#include"qsplot.h"
#include<vector.h>
#include<math.h>




/**
  * \brief Dataset : 3D figure
  *
  * Dataset which draws any set of 3d polygons. Data format is described in QSFigure::Channels .
  * See also : QSAxes::plotAdd()
  */

class QSFigure : public QSPlot3D
 {
  Q_OBJECT
	Q_PROPERTY( int vertexCompareAccuracy READ vertexCompareAccuracy WRITE setVertexCompareAccuracy )

  public:

        /**
          * Descriptive names of data channels. See QSData::setMatrix().
	  * VXCoord, VYCoord, VZCoord, VVCoord ( V is optional ) must be matrices with the same size.
	  * VXCoord contains x coordinates, VYCord contains y coordinates, and VZCoord contains z coordinates.
	  * The same row in all matrices describes one polygon. The same column in this row descripes a one vertex.
	  * So there is rows polygons and all polygons have cols vertices. If VTableI is not empty and VXCoords,
	  * VYCoords, VZCoords contain a single column other format is used. VTableI contains indexes
	  * to the row in Coords matrices. One index defines a one data point. One row in VTable in describes one polygon.
	  * There is rows(VTableI) polygons, which have cols(VTableI) vertices.
          */
        enum Channels   { VXCoord = 0,
                          VYCoord = 1,
                          VZCoord = 2,
                          VVCoord = 3,
                          VTableI = 4 };

        /**
          * Constructor.
          */
        QSFigure( QSAxes* parent, const char * name=0 );
       /**
         * Destructor.
         */
       virtual ~QSFigure();
       /**
         * Accuracy is used to detect if two vertices are in fact the same vertex,
         * so two polygons are neighbours. Coordinates of vertices are mapped to
         * the range <-1,1> and rounded to 'accuracy' places after the point before
         * comparing. 'accuracy' must be larger than 0.
         * Valid only if the gr. driver uses normals to vertices ( OpenGL ).
         */
       void setVertexCompareAccuracy( int accuracy );
       /**
         * Returns the vertex compare accuracy.
         */
       int vertexCompareAccuracy() const { return m_accuracy; }

       virtual QString posInfo( QSPt2f& pos );
       virtual QSPt2f legendItemSize( QSDrv *drv );
       virtual void drawLegendItem( const QSPt2f& pos, QSDrv *drv );
	virtual void loadStateFromStream( QDataStream& stream, QSObjectFactory *factory );
	virtual void saveStateToStream( QDataStream& stream, QSObjectFactory *factory );
         virtual ColumnType columnType( int channel, int column ) const;
	virtual QString channelVariable( int channel ) const;

  protected:

      virtual void dataChanged( int channel = -1 );
      virtual void allocRuntimeData();
      virtual void freeRuntimeData();
      virtual bool getAxisRange( QSAxis *axis, double& min, double& max );
      virtual bool start();
      virtual bool step();
      virtual void end();

    private:
	struct figure_runtime_data;
      struct figure_runtime_data *d;

      int  m_accuracy;  // vertex comparing accuracy.
      bool m_extremes_valid; // are extremes valid
      bool m_minmax_v_valid;
      QSPt3f m_dmin;    // minimum value in data
      QSPt3f m_dmax;    // maximum value in data
      double m_vmin;
      double m_vmax;

      void init_data();
      void init_draw();
      void init_colors();
      void init_draw_figure();

      void alloc_buffers();
      void free_buffers();

      void order_vertices_step();
      void init_find_neighbours();
      void find_neighbours_step();
      void draw_figure_step();

      bool is_equal( int bindex1, int bindex2 );
      void get_facet( int nr, QSPt3f *vert, double *values=NULL );
      void get_facet_colors( int findex, QSGFill *fbuff );
      void get_facet_normals( int findex, QSPt3f *normals );
      void get_vertex_normal( int bindex1, int bindex2, int inc, QSPt3f *normal );
      void draw_point_marks( int number, const QSPt3f* wbuff );
      void map_facet_to_world( const QSPt3f *vbuff, QSPt3f *wbuff );
 };

#endif





































