/***************************************************************************
                                 qsmatrix.cpp
                             -------------------
    begin                : Wed Oct 24 2001
    copyright            : (C) 2001 by kamil
    email                : kamil@localhost.localdomain
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include"qsmatrix.h"
#include"qsdata.h"
#include<qmetaobject.h>
#include<qstrlist.h>
#include<qvariant.h>

//-------------------------------------------------------------//

QSMatrix::QSMatrix()
: QObject(), QSSerializable()
 {
  m_data_object = NULL;
  m_channel = -1;
 }

//-------------------------------------------------------------//

QSMatrix::~QSMatrix()
  {
  }

//-------------------------------------------------------------//

void QSMatrix::setDataObject( QSData *data, int channel )
  {
   m_data_object = data;
   m_channel = channel;
  }

//-------------------------------------------------------------//

void QSMatrix::setValue( int, int, double )
  {
  }

//-------------------------------------------------------------//

void QSMatrix::setString( int row, int col, const QString& string )
 {
  setValue( row, col, string.toDouble() );
 }

//-------------------------------------------------------------//

bool QSMatrix::resize( int, int )
 {
  return false;
 }

//-------------------------------------------------------------//

bool QSMatrix::isEditable() const
  {
   return false;
  }

//-------------------------------------------------------------//

bool QSMatrix::isReference() const
  {
   return false;
  }

//-------------------------------------------------------------//

bool QSMatrix::isString() const
 {
  return false;
 }

//-------------------------------------------------------------//

void QSMatrix::dataChanging()
  {
   if ( m_data_object ) m_data_object->dataChanging(m_channel);
  }

//-------------------------------------------------------------//

void QSMatrix::dataChanged()
  {
   if ( m_data_object ) m_data_object->dataChanged(m_channel);
  }
//-------------------------------------------------------------//

void QSMatrix::loadStateFromStream( QDataStream& stream, QSObjectFactory *factory )
 {
  QSSerializable::loadStateFromStream( stream, factory );
  // load properties
  QMetaObject *meta_object = metaObject();
  QStrList properties = meta_object->propertyNames( TRUE );
  for( unsigned int property_nr=0; property_nr<properties.count(); property_nr++ ) {
	QCString property_name;
	QVariant property_value;
	stream >> property_name >> property_value;
	setProperty(property_name,property_value);
	}
 }

//-------------------------------------------------------------//

void QSMatrix::saveStateToStream( QDataStream& stream, QSObjectFactory *factory )
 {
  QSSerializable::saveStateToStream( stream, factory );
  // save properties
  QMetaObject *meta_object = metaObject();
  QStrList properties = meta_object->propertyNames( TRUE );
  for( unsigned int property_nr=0; property_nr<properties.count(); property_nr++ ) {
  	stream << QCString(properties.at(property_nr)) << property(properties.at(property_nr));
	}
 }
//-------------------------------------------------------------//

void QSMatrix::copyRange( int dstRowStart, int dstColStart, QSMatrix *srcMatrix, int srcRowStart, int srcColStart, int srcRowEnd, int srcColEnd )
 {
  int startCol;
  int endCol;
  int colStep;
  if ( srcColStart > dstColStart ) {
	 startCol = srcColStart; endCol = srcColEnd; colStep = 1;
	} else {
	 startCol = srcColEnd; endCol = srcColStart; colStep = -1;
	}

  int startRow;
  int endRow;
  int rowStep;
  if ( srcRowStart > dstRowStart ) {
	 startRow = srcRowStart; endRow = srcRowEnd; rowStep = 1;
	} else {
	 startRow = srcRowEnd; endRow = srcRowStart; rowStep = -1;
	}

  int row = startRow;
  while( row >= srcRowStart && row <= srcRowEnd ) {
	int col = startCol;
	while( col >= srcColStart && col <= srcColEnd ) {
		int dst_row = dstRowStart + row - srcRowStart;
		int dst_col = dstColStart + col - srcColStart;
		if (	row >= 0 && dst_row >= 0 &&
		     	col >= 0 && dst_col >= 0 &&
			dst_row < rows() && row < srcMatrix->rows() &&
			dst_col < cols() && col < srcMatrix->cols()  ) {	
			if ( isString() ) setString( dst_row, dst_col, srcMatrix->string( row, col ) );
				     else  setValue( dst_row, dst_col, srcMatrix->value(  row, col ) );
			}
		col += colStep;
		}
	row += rowStep;
	}
 }










	