/*              Name:           callbacks.c
                Version:        0.0.12
                Date:           11/7/2001
				Functions called on actions from the GTK interface
*/
#include <glib.h>
#include <gdk/gdkkeysyms.h>
#include <ctype.h>
#include <math.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>                   /* Callbacks from GTK are caught here*/
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include<sys/resource.h>
#include <signal.h>
#include <fcntl.h>
#include "callbacks.h"
#include "breakcalls.h"
#include "interface.h"
#include "serial.h"
#include "misc.h"
#include "view.h"
#include "chump.h"
#include "progload.h"
#include "asmload.h"
#include "dotparse.h"
#include "lint.h"

uchar board_startcommand = BR_START|0x30;
int board_running=0;
GList* view_load_isa = NULL;

void callback_button_load (GtkButton* button, gpointer entry)  /* Load button pressed*/
{ /*                Load button       Text entry*/
 char* filename = g_strdup(gtk_entry_get_text (GTK_ENTRY (entry))); /* Get filename*/
 GList* list;
 GList* element; 
 
 progload_load (filename);

 list = gtk_object_get_data (GTK_OBJECT(entry),"list");   /* append filename to list of past filenames*/
 if (!(element = g_list_find_custom(list, filename, (GCompareFunc) g_strcasecmp)))
                list = g_list_prepend (list, filename);
 else         list = g_list_concat (element, g_list_remove_link(list,element));
 
 gtk_object_set_data (GTK_OBJECT (entry), "list", list);
 gtk_combo_set_popdown_strings (GTK_COMBO (GTK_WIDGET(entry)->parent), list);
 gtk_entry_set_text (GTK_ENTRY(entry), filename);
 if (element) g_free(filename);
 callback_global_refresh(); /* refresh all */
}

void callback_load_isa (GtkMenuItem* menuitem, gpointer newvalue) /* the line width and gran */
{
  view_load_isa = (GList*) newvalue;
}

void callback_load_binary_address(GtkEntry* entry, gpointer label)
{
 uchar* address = g_new0(uchar,board_memory_ptr_width);
 char* text = gtk_editable_get_chars(GTK_EDITABLE(view_binary_load_address),0,-1);
 if (!view_hexstr2chararr(board_memory_ptr_width, text, address)){        /* get address from entry*/
                g_free(text);
                g_free(address);
                gtk_label_set_text(label, "Not Valid!");
                return;}
 g_free(text);
 text = view_chararr2hexstrbe (board_memory_ptr_width, address);
 gtk_label_set_text(label, text);
 g_free(text);
 g_free(address);
 
}

void callback_load_isa_binary(GtkButton* button, gpointer entry)
{
 char* filename;
 if (!view_load_isa){
  callback_load_binary(button, entry);
  return;
  }
 filename = g_strdup(gtk_entry_get_text (GTK_ENTRY (entry))); /* Get filename*/
 gtk_widget_hide(view_fileerror);
 asmload_load (filename);

 g_free(filename);
 callback_main_progress_bar_update(1);/* update progress bar*/
 callback_memory_refresh(); /* refresh all */
}



void callback_load_binary(GtkButton* button, gpointer entry)
{
 char* filename = g_strdup(gtk_entry_get_text (GTK_ENTRY (entry))); /* Get filename*/
 GList* list;
 GList* element; 
 int file;
 int rep;
 uchar buf[80];
 uchar* address = g_new0(uchar,board_memory_ptr_width);
 struct stat status;
 int sofar = 0;
 char* text = gtk_editable_get_chars(GTK_EDITABLE(view_binary_load_address),0,-1);
 if (!view_hexstr2chararr(board_memory_ptr_width, text, address))        /* get address from entry*/
                {g_free(filename);g_free(text); g_free(address);return;}
 g_free(text);
 file = open(filename, O_RDONLY);
 if (!*filename) {g_free(filename);g_free(text); g_free(address);return;}
 gtk_widget_hide(view_fileerror);
 fstat(file, &status);
 while ((rep = read(file, buf,80)))   {
    sofar+=rep;
    board_set_memory (rep, address, buf, 1);
    if (!board_micro_ping())   {
            board_set_memory (rep, address, buf, 1);
            if (!board_micro_ping()) {g_free(filename);g_free(text); g_free(address);return;}
            }                    /* if errored with microping then do again*/
    view_chararrAddintsame(board_memory_ptr_width, address, rep); /* send data 80 at a time*/
    
    callback_main_progress_bar_update((float)sofar/status.st_size);/* update progress bar*/
    while (gtk_events_pending())  gtk_main_iteration();          /*update display and do user stuff*/
    }
 callback_main_progress_bar_update(1);/* update progress bar*/
 g_free(address);
 close (file);
   list = gtk_object_get_data (GTK_OBJECT(entry),"list");   /* append filename to list of past filenames*/
   if (!(element = g_list_find_custom(list, filename, (GCompareFunc) g_strcasecmp)))
                list = g_list_prepend (list, g_strdup(filename));
   else         list = g_list_concat (element, g_list_remove_link(list,element));
   gtk_object_set_data (GTK_OBJECT (entry), "list", list);
   gtk_combo_set_popdown_strings (GTK_COMBO (GTK_WIDGET(entry)->parent), list);
  gtk_entry_set_text (GTK_ENTRY(entry), filename);
 if (element) g_free(filename);
 callback_memory_refresh(); /* refresh all */
}





void callback_button_compile (GtkButton* button, gpointer entry)  /* Compile button pressed*/
{
 GList* list;
 GList* element; 
 char* filename = gtk_entry_get_text (GTK_ENTRY (entry)); /* Get filename*/
 if (!*filename) return ;
  if (!fork()) {  close(1);
                  dup2(compile_communication[1],1);
                  close(2);
                  dup2(compile_communication[1],2);
                  close(0);
                  if (VERBOSE)g_print("Compiling: %s\n",filename);
                  setpgid(0,0);
                  {
                    char* exec_string = g_strconcat("kmd_compile ", filename, " " , board_cpu_name, NULL);
                    system (exec_string);
                  }
                  _exit(0);
              }


   list = gtk_object_get_data (GTK_OBJECT(entry),"list");   // append filename to list of past filenames



 
   filename = g_strdup(filename);
   if (!(element = g_list_find_custom(list, filename, (GCompareFunc) g_strcasecmp)))
                list = g_list_prepend (list, filename);
   else         list = g_list_concat (element, g_list_remove_link(list,element));



   gtk_object_set_data (GTK_OBJECT (entry), "list", list);
   gtk_combo_set_popdown_strings (GTK_COMBO (GTK_WIDGET(entry)->parent), list);

 gtk_entry_set_text (GTK_ENTRY(entry), filename);
 if (element) g_free(filename);
 
if (view_source)
   {
    GList* temp = progload_source_files;
    while (temp) {
        g_free(((source_file*)temp->data)->filename);
        g_list_free_contents(((source_file*)temp->data)->lines);
        g_list_free(((source_file*)temp->data)->lines);
        g_free( (source_file*)temp->data);
        temp = temp->next;
        }
    g_list_free(progload_source_files);

    g_list_free_contents(address_line_list);
    g_list_free(address_line_list);

    progload_source_files =NULL;    
    address_line_list = NULL;
    old_pcline=NULL;
    old_raline=NULL;
    
    gtk_text_freeze(GTK_TEXT (view_source));
    gtk_text_set_point(GTK_TEXT (view_source), 0);
    gtk_text_forward_delete(GTK_TEXT (view_source), gtk_text_get_length(GTK_TEXT (view_source)));
    gtk_text_thaw(GTK_TEXT (view_source));

    symbol_free_table(symbol_table);
    symbol_table=NULL;

   }
}



void callback_button_ok_file(GtkButton* button, gpointer entry)  /* on fileentry ok button send to text entry*/
{
  char* text= gtk_file_selection_get_filename (GTK_FILE_SELECTION
                                              (GTK_WIDGET(button)->parent->parent->parent));
  gtk_editable_delete_text (GTK_EDITABLE (entry), 0, -1); /* clear entry*/
  gtk_entry_append_text (GTK_ENTRY(entry), text);/* insert new text*/
}



void callback_fpgaload (GtkButton* button, gpointer container)  /* Load button pressed*/
{
 char* filename = gtk_entry_get_text (GTK_ENTRY (gtk_object_get_data(GTK_OBJECT(container),"fileentry"))); /* Get filename*/
 GList* list;
 uchar data[0x100];
 FILE* file;	
 int rep;
 int temp;
 unsigned int size, originalsize;
 char* name;
 char ch;
 if (!*filename) return;
 file =  fopen (filename, "r");	
 if (!file) return;
 
 rep = fread(data, 1, 0x100, file);
 if (rep<0x100) return;
 if (data[0]) return;
 temp = 1;
 temp += data[temp] + 5;
 name = data+temp+1;
 temp += data[temp] + 3;
 if (g_strcasecmp(board_features[GPOINTER_TO_INT(gtk_object_get_data(GTK_OBJECT(container),"feature"))].data.xilinx_fpga.filestring, data+temp+1)) return;   //  device  = temp+1
 if (VERBOSE)g_print("%d\n",rep);
 gtk_label_set_text ((GTK_LABEL(gtk_object_get_data(GTK_OBJECT(container),"labelfpganame"))),name); //  name  = temp+1
 temp += data[temp] + 3;
 gtk_label_set_text ((GTK_LABEL(gtk_object_get_data(GTK_OBJECT(container),"labelfpgadate"))),data+temp+1); //  date  = temp+1
 temp += data[temp] + 3;
 gtk_label_set_text ((GTK_LABEL(gtk_object_get_data(GTK_OBJECT(container),"labelfpgatime"))),data+temp+1); //  time  = temp+1
 temp += data[temp] + 2;
 size = 0;
 size += data[temp++];
 size = size <<8;
 size += data[temp++];
 size = size <<8;
 size += data[temp++];
 size = size <<8;
 size += data[temp++];
 size += temp;
 originalsize = size;
 if (VERBOSE)g_print("size:%x\n",size);
 
 board_sendchar(BR_FR_FILE);
 board_sendchar(GPOINTER_TO_INT(gtk_object_get_data(GTK_OBJECT(container),"feature")));
 board_sendb32(size);
 board_getchar(&ch);
 if ('A' != ch) return;
 
 

for (temp=0;temp<0x100;temp+=0x10){
 board_sendchar(BR_FR_SEND);
 board_sendchar(GPOINTER_TO_INT(gtk_object_get_data(GTK_OBJECT(container),"feature")));
 board_sendchar(0x10);
 board_sendchararray(0x10,data+temp);
 board_getchar(&ch);
 if ('A' != ch) return;
 size-=0x10;
 }
 

 
     while (size){
        int x;
        for (x=10;x;x--){
            rep=MIN(size,0x50); /* send data 0x100 at a time*/
            fread(data, 1, rep, file);
            board_sendchar(BR_FR_SEND);
            board_sendchar(GPOINTER_TO_INT(gtk_object_get_data(GTK_OBJECT(container),"feature")));
        	board_sendchar((rep)&0xFF);
            board_sendchararray(rep,data);
            board_getchar(&ch);
            if ('A' != ch) return;
            size-=rep;
            if (!size) break;
            }

	    if (!board_micro_ping())return;                      /* if errored with microping then do again*/
	    gtk_progress_bar_update (GTK_PROGRESS_BAR(gtk_object_get_data(GTK_OBJECT(container),"progressbar")),1-(float)size/originalsize);/* update progress bar*/
        while (gtk_events_pending())  gtk_main_iteration();          /*update display and do user stuff*/
	    }

 list = gtk_object_get_data(GTK_OBJECT(container),"list");   /* append filename to list of past filenames*/
 if (!g_list_find_custom(list, filename, (GCompareFunc) g_strcasecmp))
             list = g_list_prepend (list, g_strdup(filename));
 gtk_object_set_data (GTK_OBJECT (container), "list", list);
 gtk_combo_set_popdown_strings (GTK_COMBO (gtk_object_get_data(GTK_OBJECT(container),"combo")), list);
 fclose (file);

}




void callback_fpgaupdate (GtkButton* button, gpointer container)  /* Load button pressed*/
{
 char* filename = gtk_entry_get_text (GTK_ENTRY (gtk_object_get_data(GTK_OBJECT(container),"fileentry"))); /* Get filename*/
 uchar data[0x100];
 FILE* file;	
 int rep;
 int temp;
 unsigned int size;
 char* name;
 if (!*filename) return;
 file =  fopen (filename, "r");	
 if (!file) return;
 
 rep = fread(data, 1, 0x80, file);
 if (rep<0x80) return;
 if (data[0]) return;
 temp = 1;
 temp += data[temp] + 5;
 name = data+temp+1;
 temp += data[temp] + 3;
 if (g_strcasecmp(board_features[GPOINTER_TO_INT(gtk_object_get_data(GTK_OBJECT(container),"feature"))].data.xilinx_fpga.filestring, data+temp+1)) return;   //  device  = temp+1
 if (VERBOSE)g_print("%d\n",rep);
 gtk_label_set_text ((GTK_LABEL(gtk_object_get_data(GTK_OBJECT(container),"labelfilename"))),name); //  name  = temp+1
 temp += data[temp] + 3;
 gtk_label_set_text ((GTK_LABEL(gtk_object_get_data(GTK_OBJECT(container),"labelfiledate"))),data+temp+1); //  date  = temp+1
 temp += data[temp] + 3;
 gtk_label_set_text ((GTK_LABEL(gtk_object_get_data(GTK_OBJECT(container),"labelfiletime"))),data+temp+1); //  time  = temp+1
 temp += data[temp] + 2;
 size = 0;
 size += data[temp++];
 size = size <<8;
 size += data[temp++];
 size = size <<8;
 size += data[temp++];
 size = size <<8;
 size += data[temp++];
 size += temp;
 fclose (file);
}


void callback_window_raise (GtkObject* window)
{
 gtk_widget_show (GTK_WIDGET(window));
 gdk_window_raise (GTK_WIDGET(window)->window);
}

void callback_button_start(GtkButton* button,gpointer steps)
{
//   mem_window_list* mlist = view_memwindowlist; /* start button pressed*/
//   reg_window_list* rlist = view_regwindowlist;
  if(3 == board_enq()) return;

  board_sendchar(board_startcommand);
  board_sendb32(*((int*)steps)); /* start board*/
  
//   while (NULL != rlist){ /* for all regbanks */
//      if (!rlist->reg_data_ptr->timer)
//          rlist->reg_data_ptr->timer = g_timeout_add(rlist->reg_data_ptr->wait,
//                   callback_updateregwindow, rlist->reg_data_ptr); /* update every timer milisecs*/
//      rlist=rlist->next;
//      }
//   while (NULL != mlist){ /* for all memory lists */
//      if (!mlist->mem_data_ptr->timer)
//          mlist->mem_data_ptr->timer = g_timeout_add(mlist->mem_data_ptr->wait,
//                    callback_updatememwindow, mlist->mem_data_ptr); /* update every timer milisecs*/
//      mlist=mlist->next;
//      }
     
 if(view_global_refresh_timer) gtk_timeout_remove(view_global_refresh_timer);
 view_global_refresh_timer=0;
 board_running=1;
 gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON (view_refreshbutton), TRUE);
 callback_updateall(NULL);
}


void callback_button_start_custom(GtkButton* button,gpointer command)
{
  custom_start* request = command;
  if(3 == board_enq()) return;

  board_sendchar(request->command);
  board_sendb32(request->steps); /* start board*/
  
 if(view_global_refresh_timer) gtk_timeout_remove(view_global_refresh_timer);
 view_global_refresh_timer=0;
 board_running=1;
 gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON (view_refreshbutton), TRUE);
 callback_updateall(NULL);
}

void callback_button_stop(GtkButton* button,gpointer ignore)
{
//   mem_window_list* mlist = view_memwindowlist;
//   reg_window_list* rlist = view_regwindowlist;
  board_sendchar(BR_STOP);
//   while (NULL != rlist){ /* for all mem lists */
//      if (rlist->reg_data_ptr->timer)
//          gtk_timeout_remove(rlist->reg_data_ptr->timer);
//    view_updateregwindow(rlist->reg_data_ptr); /* stop timer and refresh*/
//      rlist->reg_data_ptr->timer=0;
//      rlist=rlist->next;
//      }
//   while (NULL != mlist){ /* for all regbanks */
//      if (mlist->mem_data_ptr->timer)
//          gtk_timeout_remove(mlist->mem_data_ptr->timer);
//      view_updatememwindow(mlist->mem_data_ptr);  /* stop timer and refresh */
//      mlist->mem_data_ptr->timer=0;
//      mlist=mlist->next;
//      }
 gtk_label_set_text (GTK_LABEL(view_enqlabel),"Stopped");
 if(view_global_refresh_timer) gtk_timeout_remove(view_global_refresh_timer);
 view_global_refresh_timer=0;
 board_running=0;
 gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON (view_refreshbutton), FALSE);
 callback_global_refresh();
 
}





void callback_button_continue(GtkButton* button,gpointer ignore)
{
  board_sendchar(BR_CONTINUE);
 if(view_global_refresh_timer) gtk_timeout_remove(view_global_refresh_timer);
 view_global_refresh_timer=0;
 board_running=1;
 gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON (view_refreshbutton), TRUE);

}





void callback_button_walk(GtkButton* button,gpointer steps)
{
 board_sendchar(board_startcommand);
 board_sendb32(*((int*)steps)); /* walk board*/
 callback_global_refresh();
 gtk_label_set_text (GTK_LABEL(view_enqlabel),"Walking");
 if(view_global_refresh_timer) gtk_timeout_remove(view_global_refresh_timer);
 view_global_refresh_timer = g_timeout_add(view_step_freq, callback_walk, steps);
 board_running=0;
 gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON (view_refreshbutton), FALSE);

}





void callback_start_toggle (GtkToggleButton *togglebutton, gpointer user_data)
{
 if ((gtk_toggle_button_get_active(togglebutton)&& !(GPOINTER_TO_INT(user_data)&0x100)) ||
     (!gtk_toggle_button_get_active(togglebutton)&& (GPOINTER_TO_INT(user_data)&0x100)))
        board_startcommand = board_startcommand |  GPOINTER_TO_INT(user_data);
 else   board_startcommand = board_startcommand & ~GPOINTER_TO_INT(user_data);
}




void callback_rtf_toggle (GtkToggleButton *togglebutton, gpointer user_data)
{
 uchar rtf;
 board_sendchar(BR_RTF_GET);
 if (!board_getchar(&rtf))
   if (!board_mini_ping(0) ||
       !board_getchar(&rtf)) return; /* if that didnt work then dont panic just try again*/
 if (gtk_toggle_button_get_active(togglebutton))
        rtf |=  GPOINTER_TO_INT(user_data);
 else   rtf &= ~GPOINTER_TO_INT(user_data);
 board_sendchar(BR_RTF_SET);
 board_sendchar(rtf); 
}



void callback_refresh_toggle (GtkToggleButton *togglebutton, gpointer user_data)
{

}




void callback_button_ping (GtkButton* ignore, gpointer ignore2)
{
  board_micro_ping();
  board_enq();
 callback_global_refresh(); /* refresh all */
}




void callback_button_reset (GtkButton* ignore, gpointer ignore2)
{
 board_sendchar(BR_RESET);
 board_micro_ping();
 if(view_global_refresh_timer) gtk_timeout_remove(view_global_refresh_timer);
 view_global_refresh_timer=0;
 board_running=0;
 gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON (view_refreshbutton), FALSE);

 board_micro_ping();
 board_enq();
 callback_global_refresh(); /* refresh all */
}




void callback_global_refresh(void)
{
  mem_window_list* mlist = view_memwindowlist; /* refresh all*/
  reg_window_list* rlist = view_regwindowlist;
  int regbank;
  int found;
  while (NULL != rlist){
	 view_updateregwindow(rlist->reg_data_ptr);
     rlist=rlist->next;
     }
   for (regbank=0;regbank<board_num_regbanks;regbank++)
         if (board_reg_banks[regbank].pointer){
            found=0;
            for (rlist = view_regwindowlist;rlist && !found; rlist=rlist->next){
                if (rlist->reg_data_ptr->regbank_no == regbank) found=1;
                }
            if (!found)
                if (!board_get_regbank(regbank))
                    if (!board_mini_ping(0) || !board_get_regbank(regbank))
                        return;
            }

  while (NULL != mlist){
     view_updatememwindow(mlist->mem_data_ptr);
     mlist=mlist->next;
     }
  progload_update();
}




void callback_memory_refresh(void)
{
  mem_window_list* mlist = view_memwindowlist; /* refresh all*/
  while (NULL != mlist){
     view_updatememwindow(mlist->mem_data_ptr);
     mlist=mlist->next;
     }
}

void callback_main_progress_bar_update(gfloat ammount)
{
// g_print("gtk_progress_set_percentage ammount:%f\n", ammount);
 if (ammount<1) gtk_progress_set_format_string (GTK_PROGRESS(view_progressbar), "Loading:%p\%");
 else gtk_progress_set_format_string (GTK_PROGRESS(view_progressbar), "Loaded");
 gtk_progress_set_percentage  (GTK_PROGRESS(view_progressbar),(gfloat)ammount);/* update progress bar*/
 while (gtk_events_pending())  gtk_main_iteration();          /*update display and do user stuff*/
}


void callback_step_number(GtkEditable *editable, gpointer value)
{
  *((int*)value) = gtk_spin_button_get_value_as_int   /* change the step number for multistep*/
                              (GTK_SPIN_BUTTON (editable));
}


void callback_memwindow_length (GtkMenuItem* menuitem, gpointer newvalue) /* the line width and gran */
{
  int temp;
  mem_window* memwin = view_getmemwindowptr(GTK_WIDGET (menuitem));
  memwin->width = (int) newvalue&15;                  /* the newvalue holds the granularty and width */
  memwin->gran = (int) newvalue/16;
  gtk_clist_freeze (GTK_CLIST(memwin->clist_ptr)); 

  for (temp=4;temp>(memwin->width/memwin->gran);temp--)
    gtk_clist_set_column_visibility(GTK_CLIST(memwin->clist_ptr),temp, FALSE);
  while(temp){
    gtk_clist_set_column_visibility(GTK_CLIST(memwin->clist_ptr),temp,TRUE);/* make hex collumns visible or not*/
    gtk_clist_set_column_width (GTK_CLIST (memwin->clist_ptr), temp,
                                      (memwin->width*25)/(memwin->width/memwin->gran)-7);
    temp--;
    }
    gtk_widget_set_usize (memwin->hex_entry, (memwin->width*25), -2);
	
    gtk_clist_set_column_width (GTK_CLIST (memwin->clist_ptr), 5,
                                      (memwin->width*10));
    gtk_widget_set_usize (memwin->ascii_entry, (memwin->width*10)+7, -2);
                                      
//  if (8 == memwin->width) gtk_widget_set_usize (memwin->dis_entry, 507, -2);/* if double disassembly*/
//  else                    gtk_widget_set_usize (memwin->dis_entry, 257, -2);
  gtk_clist_thaw (GTK_CLIST(memwin->clist_ptr)); 
  view_updatememwindow(memwin);
}



void callback_memwindow_isa (GtkMenuItem* menuitem, gpointer newvalue) /* the line width and gran */
{
  mem_window* memwin = view_getmemwindowptr(GTK_WIDGET (menuitem));
  memwin->isa = (GList*) newvalue;
  view_updatememwindow(memwin);
}

void callback_memwindow_listsize (GtkEditable *editable, gpointer ignore) /* change number of rows*/
{
  char *startdata[] = {"Address","Hex","Hex","Hex","Hex","ASCII","DISS"};
  int new = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (editable));
  mem_window* memwin = view_getmemwindowptr(GTK_WIDGET (editable));
  
  gtk_clist_freeze (GTK_CLIST(memwin->clist_ptr)); 
  if (memwin->count<new)
    while (memwin->count<new)
	  gtk_clist_insert (GTK_CLIST(memwin->clist_ptr),++memwin->count,startdata); /* add or kill rows*/
  if (memwin->count>new)
    while (memwin->count>new)
      gtk_clist_remove (GTK_CLIST(memwin->clist_ptr),--memwin->count);
  view_updatememwindow(memwin);
  gtk_clist_thaw (GTK_CLIST(memwin->clist_ptr));

}


void callback_memwindow_ascii_toggle (GtkToggleButton* tbutton, gpointer ignore)
{
  mem_window* memwin = view_getmemwindowptr(GTK_WIDGET (tbutton));    /*Turn on/off ASCII collumn*/
  if(gtk_toggle_button_get_active (tbutton)){
    gtk_widget_show (memwin->ascii_entry);
    gtk_clist_set_column_visibility (GTK_CLIST (memwin->clist_ptr), 5, TRUE);
    }
  else {
    gtk_widget_hide (memwin->ascii_entry);
    gtk_clist_set_column_visibility (GTK_CLIST (memwin->clist_ptr), 5, FALSE);
    }
}  




void callback_memwindow_dis_toggle (GtkToggleButton* tbutton, gpointer ignore)
{
  mem_window* memwin = view_getmemwindowptr(GTK_WIDGET (tbutton));       /*Turn on/off Disassembly collumn*/
  if(gtk_toggle_button_get_active (tbutton)){
    gtk_widget_show (memwin->dis_entry);
    gtk_clist_set_column_visibility (GTK_CLIST (memwin->clist_ptr), 6, TRUE);
    }
  else {
    gtk_widget_hide (memwin->dis_entry);
    gtk_clist_set_column_visibility (GTK_CLIST (memwin->clist_ptr), 6, FALSE);
    }
}




void callback_memwindow_address (GtkEditable* editable, gpointer ignore)
{
  int ptr=0;
  char saved;
  int regbanks=-1;
  mem_window* memwin = view_getmemwindowptr(GTK_WIDGET (editable));      /*New address passed*/
  char* text = gtk_editable_get_chars(editable,0,-1);
  memwin->regoffset = board_nulreg;
  while (' '==text[ptr]) ptr++;
  if ('#'==text[ptr]){                                          /*if starts with # then link to register*/
    text[ptr] = ' ';
    while ('+'!=text[ptr] && '-'!=text[ptr] &&text[ptr]) ptr++;
	saved = text[ptr];
    text[ptr] = '\0';
    ptr=-1;
    while (ptr<0 && ++regbanks<board_num_regbanks) {
        if (board_reg_banks[regbanks].pointer)
	        ptr = view_findstrinarr(text, board_reg_banks[regbanks].names,
                                           board_reg_banks[regbanks].number); /* find link register value address*/
	    }
    			
	if (ptr<0){g_free(text);return;}
  	memwin->regoffset=&board_reg_banks[regbanks].values  /* memwin->regoffset is linked register value*/
                [ptr * board_reg_banks[regbanks].width];  
	for (ptr=0;text[ptr];ptr++);
	text[ptr]=saved;
	text[--ptr]='0';                                            /* replace Register Name with '0'*/
    }
  view_hexstr2chararr(board_memory_ptr_width, &text[ptr], memwin->address); /* get address */
  g_free(text);
  view_updatememwindow(memwin);
}




void callback_memwindow_hex (GtkEditable* editable, gpointer ignore) /* return pressed in hex entry*/
{
  mem_window* memwin = view_getmemwindowptr(GTK_WIDGET (editable));
  char* text = gtk_editable_get_chars(GTK_EDITABLE(memwin->address_entry),0,-1);
  uchar* hex;
  int row;
  uchar* address = g_new(uchar,board_memory_ptr_width);
  uchar* new_address;

  if (!view_hexstr2chararr(board_memory_ptr_width, text, address))  /* get address from entry*/
                {g_free(text); g_free(address);return;}
  if (board_wordaline) address[0] &= -(memwin->gran); /* word aline */

  g_free(text);
  hex = g_new(uchar,memwin->gran);
  text = gtk_editable_get_chars(GTK_EDITABLE(memwin->hex_entry),0,-1); /* get hex value*/
  if (!view_hexstr2chararr(memwin->gran, text, hex))
                {g_free(text); g_free(hex); g_free(address);return;}
  g_free(text);
  board_set_memory(1,address,hex,memwin->gran);      /* set memory*/
  g_free(hex);
  new_address = view_chararrAddchararr(board_memory_ptr_width,
                         memwin->address, memwin->regoffset);
  row = view_chararrSubchararr(board_memory_ptr_width, address, new_address)
                                                              + memwin->gran; /* move row one forard*/
  g_free(new_address);
  g_free(address);
  if (row == memwin->count * memwin->width){  /* if at end then move list one foward*/
  view_chararrAddintsame(board_memory_ptr_width, memwin->address, memwin->width);
  row -= memwin->width;
  }
  if (row < memwin->count * memwin->width)
        gtk_clist_select_row(GTK_CLIST(memwin->clist_ptr),row/memwin->width
                                       ,(row%memwin->width)/memwin->gran+1);
                                    
 
  callback_memory_refresh(); /* refresh all */
  while (gtk_events_pending())  gtk_main_iteration();                /*update display */
  gtk_entry_select_region (GTK_ENTRY(memwin->hex_entry),0,-1); /* select all of region*/
}




void callback_memwindow_ascii (GtkEditable* editable, gpointer ignore) /* not implemented yet*/
{}



void callback_memwindow_dis (GtkEditable* editable, gpointer ignore)
{
  mem_window* memwin = view_getmemwindowptr(GTK_WIDGET (editable));
  char* text = gtk_editable_get_chars(GTK_EDITABLE(memwin->address_entry),0,-1);
  uchar* hex;
  int row;
  int temp;
  uchar* address = g_new(uchar,board_memory_ptr_width);
  uchar* new_address;
  Asm* asmed;
  GList* asmlist;
  AsmStatus stat = asm_default_status;

  stat.symbol_table = symbol_table;
  
  if (!view_hexstr2chararr(board_memory_ptr_width, text, address))  /* get address from entry*/
                {g_free(text); g_free(address);return;}
  if (board_wordaline) address[0] &= -(memwin->gran); /* word aline */

  g_free(text);
  
  
  text = gtk_editable_get_chars(GTK_EDITABLE(memwin->dis_entry),0,-1); /* get hex value*/
  stat.address= view_chararr2int(board_memory_ptr_width, address);
  asmlist = asm_assemble(text,memwin->isa, stat,1);
  g_free(text);
  if (!asmlist){ g_free(address); g_print("no assembly\n");return;}
  asmed = (Asm*) (asmlist->data);

  {
    GList* symbol_list;
    Symbol* symbol;
    symbol_list = asm_print_symbols(asmed->binary, NULL);

    while(symbol_list) {
        symbol = symbol_findstring(symbol_table, (char*)symbol_list->data);
        if (symbol) {
            symbol->value = lint_new(view_chararr2int(board_memory_ptr_width, address));
            }
        else {
            symbol = g_new(Symbol, 1);
            symbol->flags = 2;
            symbol->name = symbol_list->data;
            symbol->value = lint_new((long long)view_chararr2int(board_memory_ptr_width, address));
            symbol_table = g_list_append(symbol_table,symbol);
//            g_print("%x:\"%s\"\n", address, symbol->name);
            }
        symbol_list = g_list_remove(symbol_list,symbol_list->data);
        }
  }

  temp = asm_sbprint(asmed->binary, &hex);
  if (asmlist->next) if (VERBOSE) g_print("Multiple possible assemblies, size:%d",g_list_length(asmlist));
  while(asmlist) {
    asm_freestringlist(((Asm*)asmlist->data)->binary);
    g_free(asmlist->data);
    asmlist = g_list_remove(asmlist,asmlist->data);
    }
    
  board_set_memory(temp,address,hex,1);      /* set memory*/
  g_free(hex);
  new_address = view_chararrAddchararr(board_memory_ptr_width,
                         memwin->address, memwin->regoffset);
  row = view_chararrSubchararr(board_memory_ptr_width, address, new_address)
                                                              + temp; /* move row one forard*/

  g_free(new_address);
  g_free(address);
  if (row == memwin->count * memwin->width){  /* if at end then move list one foward*/
  view_chararrAddintsame(board_memory_ptr_width, memwin->address, memwin->width);
  row -= memwin->width;
  }
  if (row < memwin->count * memwin->width)
      gtk_clist_select_row(GTK_CLIST(memwin->clist_ptr),row/memwin->width
                                       ,(row%memwin->width)/memwin->gran+1);
  gtk_editable_select_region (GTK_EDITABLE(memwin->dis_entry),0,-1); /* select all of region*/
  if (gtk_events_pending()>2)
      while (gtk_events_pending())  gtk_main_iteration();                /*update display */
  else callback_memory_refresh(); /* refresh all */

}





void callback_memwindow_scrollmove(GtkAdjustment *adjustment,gpointer ignore2) /* move scroll bar*/
{
  uchar temp[4];
  mem_window* memwin = gtk_object_get_data (GTK_OBJECT(adjustment),"mem_window");
  if (ABS(adjustment->value)<0.05) {view_updatememwindow(memwin); return;}
  view_chararrCpychararr(board_memory_ptr_width,memwin->address,temp);
  if (adjustment->value<0) view_chararrAddintsame(board_memory_ptr_width,   /* move to new position*/
		  memwin->address ,-pow(16,-adjustment->value) * memwin->width);
  else  view_chararrAddintsame(board_memory_ptr_width,
		  memwin->address , pow(16, adjustment->value) * memwin->width);
  
  view_updatememwindow(memwin);
  view_chararrCpychararr(board_memory_ptr_width,temp, memwin->address); /* refresh and put back to original */

}



gboolean callback_memwindow_scrollrelease(GtkWidget *scroll,gpointer ignore1, /* let go of scroll bar*/
                                                            gpointer ignore2)
{
  mem_window* memwin = view_getmemwindowptr(GTK_WIDGET (scroll));
  if (ABS(gtk_range_get_adjustment(GTK_RANGE(scroll))->value)<0.1) return FALSE;
  if (gtk_range_get_adjustment(GTK_RANGE(scroll))->value<0)
   view_chararrAddintsame(board_memory_ptr_width, memwin->address,
    -pow(16,-gtk_range_get_adjustment(GTK_RANGE(scroll))->value) * memwin->width);   /* move to new position */
  else
   view_chararrAddintsame(board_memory_ptr_width, memwin->address,
     pow(16, gtk_range_get_adjustment(GTK_RANGE(scroll))->value) * memwin->width);
  
  gtk_adjustment_set_value(gtk_range_get_adjustment(GTK_RANGE(scroll)),0);     /* move scroll bar back */
  view_updatememwindow(memwin);
  return FALSE;
}




void  callback_memwindow_clist (GtkCList *clist, gint row, gint column,  /* a line in the c-list was pressed*/
                                GdkEventButton *event,gpointer ignore)
{
  mem_window* memwin = view_getmemwindowptr(GTK_WIDGET (clist));
  uchar* new_address = view_chararrAddchararr(board_memory_ptr_width,
                              memwin->address, memwin->regoffset);
  uchar* address;
  char* address_text;
  uchar* memdata;
  
  if (board_wordaline) new_address[0] &= -memwin->width;              /* word aline   */
  address = view_chararrAddint(board_memory_ptr_width,
           new_address, row * memwin->width + 
		  ((column > 4) ? 0 : (column <= 0) ? 0 : column-1) * memwin->gran);   /* work out wich collumn  */
  g_free(new_address);
  
  if (event)
   if (GDK_2BUTTON_PRESS == event->type) {
    unsigned int worda;
    unsigned int wordb;
    board_sendchar(BR_BP_GET);
    if (4 != board_getb32(&worda)) {g_free(address);return;}
    if (4 != board_getb32(&wordb)) {g_free(address);return;}
    {
      int temp,temp2;
      uchar repc;
      int flag=0;
      uchar* value=g_new(uchar,board_memory_ptr_width);
      for (temp=0;temp<32;temp++)
        if ((worda>>temp)&1){
            value=g_new(uchar,board_memory_ptr_width);
            board_sendchar(BR_BP_READ);
            board_sendchar(temp);
            for (temp2=2;temp2;temp2--)
                if (1 != board_getchar(&repc)) {g_free(address);return;}
            if (board_memory_ptr_width != board_getchararray(board_memory_ptr_width,value))
                                               {g_free(address);return;}
            for (temp2=board_memory_ptr_width+16;temp2;temp2--)
                if (1 != board_getchar(&repc)) {g_free(address);return;}
            if (!view_chararrSubchararr(board_memory_ptr_width, address, value)){
                    flag=1;
                    board_sendchar(BR_BP_SET);
                    board_sendb32(0);
                    board_sendb32(1<<temp);
                    }
            }
       g_free(value);
       if (flag) {
            g_free(address);
            breakpoint_refresh (0);
            callback_memory_refresh(); /* refresh all */
            return;
            }
    }
    worda=(~worda) & wordb;
    wordb=0;
    if (!worda) {g_free(address);return;}
    while (!((worda>>wordb)&1)) wordb++;
    board_sendchar(BR_BP_WRITE);
    board_sendchar(wordb);
    board_sendb16(-1);
    board_sendchararray(board_memory_ptr_width, address);
    for (worda=board_memory_ptr_width;worda;worda--)    board_sendchar(0xff);
    for (worda=16;worda;worda--)                        board_sendchar(0);
    g_free(address);
    breakpoint_refresh (0);
    callback_memory_refresh(); /* refresh all */
    return;
    }

  memdata = g_new(uchar,memwin->gran);
  address_text = view_chararr2hexstrbe(board_memory_ptr_width,address);
  gtk_entry_set_text(GTK_ENTRY(memwin->address_entry),address_text);
  g_free(address_text);
  if  (!board_get_memory (1, address, memdata, memwin->gran)){    /* get value into the text entry*/
   if (!board_mini_ping(0) ||
       !board_get_memory (1, address, memdata, memwin->gran)){ /* if that didnt work then dont panic just try again*/
 	                            g_free(memdata);g_free(address);return;}} /* sorry but board is lost*/
  
  address_text = view_chararr2hexstrbe (memwin->gran,memdata);  /* set hex entry*/
  gtk_entry_set_text(GTK_ENTRY(memwin->hex_entry),address_text);
  g_free(address_text); 
  
  address_text = view_chararr2asciistr (memwin->gran,memdata);  /* set ascii entry */
  gtk_entry_set_text(GTK_ENTRY(memwin->ascii_entry),address_text);  
  g_free(address_text);
  
  address_text = view_dis(address, memdata, memwin->gran, memwin->isa );  /* set dis entry */
  gtk_entry_set_text(GTK_ENTRY(memwin->dis_entry),address_text);  
  g_free(address_text);
  
  g_free(address);
  g_free(memdata);
  
}




void callback_regwindow_hex (GtkEditable* editable,gpointer ignore)   /* register hex set*/
{
  reg_window* regwin = view_getregwindowptr(GTK_WIDGET (editable));
  char* text = gtk_editable_get_chars(GTK_EDITABLE(regwin->address_entry),0,-1);
  uchar* hex;
  int count;
  count = view_findstrinarr(text, board_reg_banks[regwin->regbank_no].names
		                        , board_reg_banks[regwin->regbank_no].number); /* find which register*/
  g_free(text);
  if (count<0) {return;}   /* if not there then do nothing */ 
  hex = g_new(uchar,MAX(1,board_reg_banks[regwin->regbank_no].width)); /* make space for the value*/
  text = gtk_editable_get_chars(GTK_EDITABLE(regwin->hex_entry),0,-1); /* get chars*/
  if (!view_hexstr2chararr
          (MAX(1,board_reg_banks[regwin->regbank_no].width), text, hex))/* convert to bin*/
          {g_free(text);g_free(hex);return;}
  g_free(text);
  board_set_register (regwin->regbank_no,count,hex); /* set register*/ 
  g_free(hex);
  view_updateregwindow(regwin); /* update regbank*/
  callback_global_refresh(); /* refresh all */
  
}




void  callback_regwindow_clist (GtkCList *clist, gint row, gint column, /* c-list register bank pressed*/
                                GdkEventButton *event, gpointer ignore)
{
  reg_window* regwin = view_getregwindowptr(GTK_WIDGET (clist));
  char* value;
  if (board_reg_banks[regwin->regbank_no].width)                           /* get register value*/
    value = view_chararr2hexstrbe(board_reg_banks[regwin->regbank_no].width,
                             &board_reg_banks[regwin->regbank_no].values[
                              board_reg_banks[regwin->regbank_no].width * row]);
  else if (board_reg_banks[regwin->regbank_no].values[row]) value = "1";   /* if flag then 1 or 0*/
       else                                                 value = "0";
  
  gtk_entry_set_text(GTK_ENTRY(regwin->address_entry),
                     board_reg_banks[regwin->regbank_no].names[row]);
  gtk_entry_set_text(GTK_ENTRY(regwin->hex_entry),value);
  if (board_reg_banks[regwin->regbank_no].width) g_free(value);
}






gint callback_walk(gpointer steps)
{ 
  int val = board_enq();
  
  if (2 == val>>6) return 1;
  
  if (0x40 != val){
        if(view_global_refresh_timer)
                gtk_timeout_remove(view_global_refresh_timer);
        view_global_refresh_timer=0;
        board_running=0;
        gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON (view_refreshbutton), FALSE);

        }
  else {
    board_sendchar(board_startcommand|1);
    board_sendb32(*((int*)steps)); /* walk board*/
    gtk_label_set_text (GTK_LABEL(view_enqlabel),"Walking");
    }
  callback_global_refresh();
  while (gtk_events_pending())  gtk_main_iteration();          /*update display and do user stuff*/
  return 1;
}


gint callback_update_comms(gpointer comms)
{
 char* string;
 uchar length;
 feature* comms_console=comms;
 do {
    board_sendchar(BR_FR_READ);
    board_sendchar(comms_console->number);
    board_getchar(&length);
    if (length){
        string = g_new(char, length);
        board_getchararray(length,string);
    
#ifndef GTK2
        gtk_text_insert (GTK_TEXT (comms_console->data.console.text), fixed_font, NULL, NULL, string, length);
#endif

#ifdef GTK2
        gtk_text_buffer_insert_at_cursor(GTK_TEXT_BUFFER(comms_console->data.console.text),string,length);
#endif
        g_free(string);
        }
    while (gtk_events_pending())  gtk_main_iteration();          /*update display and do user stuff*/
    } while (length);
 return 1;
}











gint callback_terminal_keysnoop(GtkWidget *grab_widget, GdkEventKey *event,
                                gpointer comms)
{
 uint key_pressed;  /* to save the value of the key that invoked this function */
 feature *comms_terminal = comms;   /* record feature from which callback came */


 if ((grab_widget == comms_terminal->data.console.text))
  {        /* only when called from the window defined and character is valid */
//    key_pressed = (event->keyval) & 0xFF;
    key_pressed = event->keyval;
    switch (key_pressed)    /* Translate key codes if necessary andunderstood */
      {
      case GDK_Return:
      case GDK_KP_Enter:    key_pressed = '\n'; break;
      case GDK_BackSpace:   key_pressed = '\b'; break;
      case GDK_Tab:         key_pressed = '\t'; break;
      case GDK_Escape:      key_pressed = 0x1B; break;
      case GDK_KP_0:
      case GDK_KP_1:
      case GDK_KP_2:
      case GDK_KP_3:
      case GDK_KP_4:
      case GDK_KP_5:
      case GDK_KP_6:
      case GDK_KP_7:
      case GDK_KP_8:
      case GDK_KP_9:        key_pressed = key_pressed - GDK_KP_0 + '0'; break;
      case GDK_KP_Add:      key_pressed = '+'; break;
      case GDK_KP_Subtract: key_pressed = '-'; break;
      case GDK_KP_Multiply: key_pressed = '*'; break;
      case GDK_KP_Divide:   key_pressed = '/'; break;
      case GDK_KP_Decimal:  key_pressed = '.'; break;
      default:
        if ((key_pressed < ' ') || (key_pressed > 0x7F)) key_pressed = '\a';
        break;                                     /* Illegal character = BEL */
      }
    board_sendchar(BR_FR_WRITE);
    board_sendchar(comms_terminal->number);
    board_sendchar(1);
    board_sendchar(key_pressed);
  }
 else
  gtk_propagate_event(grab_widget, (gpointer) event);
 return 1;                                   // Meaning? @@@
}

void callback_clear_text (gpointer text)
{
 gtk_text_freeze(GTK_TEXT (text));
 gtk_text_set_point(GTK_TEXT (text), 0);
 gtk_text_forward_delete(GTK_TEXT (text), gtk_text_get_length(GTK_TEXT (text)));
 gtk_text_thaw(GTK_TEXT (text));


}


gint callback_updateall(gpointer ignore)    /* wrapper function to go from timer interrupts*/
{
// board_micro_ping();

 if (!gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON (view_refreshbutton))) return 1;
  if(2!=board_enq()>>6){
        if (board_running){
                board_running=0;
                gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON (view_refreshbutton), FALSE);
                }
        }
  callback_global_refresh();
  while (gtk_events_pending())  gtk_main_iteration();          /*update display and do user stuff*/
  return 1;
}



gint callback_updatememwindow(gpointer memwindowptr)    /* wrapper functions to go from timer interrupts*/
{
  if(2!=board_enq()>>6) 
        if(view_global_refresh_timer && board_running){
                gtk_timeout_remove(view_global_refresh_timer);
                view_global_refresh_timer=0;
                board_running=1;
                gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON (view_refreshbutton), FALSE);
                }

  view_updatememwindow((mem_window*) memwindowptr);
  while (gtk_events_pending())  gtk_main_iteration();          /*update display and do user stuff*/
  return 1;
}



gint callback_updateregwindow(gpointer regwindowptr)
{
  if(2!=board_enq()>>6) 
        if(view_global_refresh_timer && board_running){
                gtk_timeout_remove(view_global_refresh_timer);
                view_global_refresh_timer=0;
                board_running=1;
                gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON (view_refreshbutton), FALSE);
                }


  view_updateregwindow((reg_window*) regwindowptr);
  while (gtk_events_pending())  gtk_main_iteration();          /*update display and do user stuff*/
  return 1;
}



gint callback_console_update (gpointer data, gint source,
                                 GdkInputCondition condition)
{
  char getbuff[2]={0,0};
  static int exp=0;
  static char *filename=NULL;
  char* oldfilename;
  static GdkColor* colour=NULL;
  
  if (!read(compile_communication[0], &getbuff[0], 1))
    return 1;


  if (filename){
    if ('!' == getbuff[0]){
        gtk_editable_delete_text (GTK_EDITABLE (view_load_centry), 0, -1); /* clear entry*/
        gtk_entry_append_text (GTK_ENTRY(view_load_centry), filename);/* insert new text*/
        filename=NULL;
        return 1;
        }
    oldfilename = filename;
    filename = g_strconcat(filename, getbuff, NULL);
    g_free(oldfilename);
    return 1;
    }


  if (exp >= 3) {
        switch (getbuff[0]){
            case 'B':
                colour = &view_blackcolour;
                break;
            case 'R':
                colour = &view_redcolour;
                break;
            case 'G':
                colour = &view_greycolour;
                break;
            case '-':
                filename = g_strdup("");
                break;
            case '!':
                return 1;
            default:
                break;
            }
        exp = 0;
        return 1;
        }

  if ('!' == getbuff[0]) {
        exp++;
        return 1;
        }
    
#ifndef GTK2
  gtk_text_insert (GTK_TEXT (view_console), fixed_font, colour, NULL,&getbuff[0] , 1);
#endif

#ifdef GTK2
  gtk_text_buffer_insert_at_cursor(GTK_TEXT_BUFFER(view_console),&getbuff[0],1);
#endif

  exp=0;
  return 1;
}



void callback_comms (GtkEditable* entry, gpointer comms_console)
{
 char* tosend = gtk_entry_get_text (GTK_ENTRY (entry));
 int length = strlen(tosend) + 1;
 int index = 0;
 int sub;
 feature* comms=comms_console;
   while (length-index){
        board_sendchar(BR_FR_WRITE);
        board_sendchar(comms->number);
        sub = MIN(length - index, 255);
        board_sendchar(sub);
        board_sendchararray(sub, tosend + index);
        index+=sub;
        }
 gtk_entry_set_text(GTK_ENTRY(entry), "");
 return;
}

void callback_main_quit(gpointer ignore, gpointer ignore2)
{
 if (SERIAL == board_type){
	tcsetattr (serial_FD, TCSANOW, &serial_originalportsettings);
	close (serial_FD);
    g_print("Closed Serial\n");
   	}
 if (EMULATOR == board_type){
    kill(board_emulation_pid, SIGKILL);
                             /* If emulator in use shut down emulator process */
   	}
// g_print("callback crash\n");
 
{
 GList* toplist=config_toplist;
 GList* list;
 GList* dotlist=NULL;
 PtrSCANNode newnode;
 PtrSCANNode topnode;
 int limit;
 
 list = gtk_object_get_data (GTK_OBJECT(view_compile_centry),"list");
 limit = 5;
 while (list && limit--){
//    g_print("%s\n", list->data);
    newnode = ScanNewSCANString (list->data, -1);
    dotlist = g_list_append(dotlist, newnode);
    list=list->next;
    }
 toplist = ScanAddSymbolList (toplist, "Compile-List", dotlist);
 
 
 dotlist=NULL;
 list = gtk_object_get_data (GTK_OBJECT(view_load_centry),"list");   
 limit = 5;
 while (list && limit--){
//    g_print("%s\n", list->data);
    newnode = ScanNewSCANString (list->data, -1);
    dotlist = g_list_append(dotlist, newnode);
    list=list->next;
    }
 toplist = ScanAddSymbolList (toplist, "Load-List", dotlist);
 
 topnode = ScanNewSCANList (toplist);

// ScanPrintSCANNode(stdout, topnode);
 {
  FILE* fd;
  fd = fopen (config_file,"w");
  if (!fd) g_print("cant open .kmd_config file\n");
  else {
    ScanPrintSCANNode(fd, topnode);
    fclose(fd);
    }
        
 }
}
 exit(0);

}


void callback_crash(void)
{
 if (SERIAL == board_type){
	tcsetattr (serial_FD, TCSANOW, &serial_originalportsettings);
	close (serial_FD);
    g_print("Closed Serial\n");
   	}
 if (EMULATOR == board_type){
    kill(board_emulation_pid, SIGKILL);
                             /* If emulator in use shut down emulator process */
   	}
// g_print("callback crash\n");
 
{
 GList* toplist=config_toplist;
 GList* list;
 GList* dotlist=NULL;
 PtrSCANNode newnode;
 PtrSCANNode topnode;
 int limit;
 
 list = gtk_object_get_data (GTK_OBJECT(view_compile_centry),"list");
 limit = 5;
 while (list && limit--){
//    g_print("%s\n", list->data);
    newnode = ScanNewSCANString (list->data, -1);
    dotlist = g_list_append(dotlist, newnode);
    list=list->next;
    }
 toplist = ScanAddSymbolList (toplist, "Compile-List", dotlist);
 
 
 dotlist=NULL;
 list = gtk_object_get_data (GTK_OBJECT(view_load_centry),"list");   
 limit = 5;
 while (list && limit--){
//    g_print("%s\n", list->data);
    newnode = ScanNewSCANString (list->data, -1);
    dotlist = g_list_append(dotlist, newnode);
    list=list->next;
    }
 toplist = ScanAddSymbolList (toplist, "Load-List", dotlist);
 
 topnode = ScanNewSCANList (toplist);

// ScanPrintSCANNode(stdout, topnode);
 {
  FILE* fd;
  fd = fopen (config_file,"w");
  if (!fd) g_print("cant open .kmd_config file\n");
  else {
    ScanPrintSCANNode(fd, topnode);
    fclose(fd);
    }
        
 }
}


 {
 struct rlimit rlimit;
 rlimit.rlim_cur = RLIM_INFINITY;
 rlimit.rlim_max = RLIM_INFINITY;
 (void)setrlimit(RLIMIT_CORE, &rlimit);
 (void)abort();
 }

}
