/*		Name:		misc.c
		Version:	0.0.12
		Date:		11/7/2001
		Misc functions mainly hex and binary conversions
*/
#include "interface.h"
#include <glib.h>
#include <ctype.h>
#include "misc.h"
#define uchar unsigned char

char* view_chararr2hexstrbe(int count, uchar* values) 
{
  char* ret = g_new(char, count * 2 + 1);  /* convert bit array into hex string*/
  char* ptr = ret;                         /* bigendian*/
  while (count--){ 
    g_snprintf(ptr,3,"%02X ",(int) values[count]);
    ptr+=2;
    }
  return ret;                              /* Must g_free result*/
}

char* view_chararr2hexstr(int count, uchar* values)
{
  char* ret = g_new(char, count * 2+1);  /* convert bit array into hex string*/
  char* ptr = ret;
  while (count--){
    g_snprintf(ptr,4,"%02X ",(int) *values);
    ptr+=3; values++;
    }
  return ret;                              /* Must g_free result*/
}

char* view_chararr2asciistr(int count, uchar* values)
{
  char* ret = g_new(char, count+1);  /* convert bit array into ASCII string*/
  int ptr=0;
  while (ptr<count){
    ret[ptr]=values[ptr];
    if (ret[ptr] < 0x10 /*|| ret[ptr] > 126*/) ret[ptr]='.';
    ptr++;
    }
	ret[ptr]='\0';
  return ret;                              /* Must g_free result*/
}

uchar* view_chararrAddint(int count, uchar* values,int toadd)
{
  uchar* ret = g_new(uchar, count);       /*bit array + int => bitarray */
  int ptr=0;
  int current;
  while (count--){
  
    current = values[ptr] + (toadd &255);
	ret[ptr] = current;
    ptr++;
	toadd = toadd>>8;
	if (current>255) toadd++;
    }
  return ret;                              /* Must g_free result*/
}

void view_chararrAddintsame(int count, uchar* values,int toadd)
{
  int ptr=0;
  int current;
  while (count--){       /*bit array + int => bitarray */
    current = values[ptr] + (toadd &255);
	values[ptr++] = current;
	toadd = toadd>>8;
	if (current>255) toadd++;     /* overwrites original value*/
    }
}

uchar* view_chararrAddchararr(int count, uchar* value1,uchar* value2)
{
  uchar* ret = g_new0(uchar,count);  /*bit array + bit array => bit array */
  uchar* ret2 = ret;
  int carry=0;
  while (count--){
    *(ret++) = *value1 + *value2 + carry;
    if (((int) *(value1++) + *(value2++) + carry)>0xff) carry = 1;
    else carry=0;
    }
  return ret2;                              /* Must g_free result*/
}

int view_chararrSubchararr(int count, uchar* value1, uchar* value2)
{
  int ret=0;  /*bit array - bit array => int */
  while (count--) ret = (ret<<8) + value1[count]-value2[count];
  return ret;
}

long view_chararrSublong (int count, uchar* value1, long value2)
{
  while (count--) value2 -= value1[count]<<(count<<3);
  return value2;    /*bit array - long => long */
}

int view_chararr2int(int count, uchar* value1)
{
  int ret=0;  /*bit array =>int */
  while (count--) ret = (ret<<8) + (value1[count]&0xff);
  return ret;
}

long view_chararr2long(int count, uchar* value1)
{
  long ret=0;  /*bit array =>int */
  while (count--) ret = (ret<<8) + (value1[count]&0xff);
  return ret;
}


uchar* view_int2chararr(int count, int value)
{
 uchar* ret = g_new(uchar, count);
 uchar* c=ret;
 while(count--){    /*int => bit array */
    *c=value & 0xff;
    value = value>>8;
    c++;
    }
  return ret;

}

void view_chararrCpychararr(int count, uchar* pass , uchar* ret)
{
  while (count--) ret[count]=pass[count];/* copy bit array */
}                                        /* must malloc destination*/

int view_hexstr2chararr2(int count, char* pass, uchar* ret)
{                              /* dont call this!*/
  int temp = 0;                /* Hex string to bit array*/
  int temp2= 0;
  int regbank;
  char* text = g_strdup(pass);
  while (text[temp]){
    while (' ' == text[temp]) temp++;
    if (!text[temp]) break;                /*also spot register names in text*/
    if (!isxdigit(text[temp])){
      g_free(text);
      regbank=board_main_regbank;
      temp = view_findstrinarr(pass, board_reg_banks[regbank].names,
                                     board_reg_banks[regbank].number);
                                     
	  if (temp<0) {
            for (regbank=0;temp<0;regbank++){
                if(regbank >= board_num_regbanks) break;
                temp = view_findstrinarr(pass, board_reg_banks[regbank].names,
                                               board_reg_banks[regbank].number);
                }
            regbank--;
            }

      if (temp<0) {
        
         Symbol* symb = symbol_findstring(symbol_table, pass);
         if (!symb) return 0;
         
         while (count--) ret[count] = ((1)>>(count<<3)) & 0xff;   //     FIXME!!! use a lint to chararr or exp
         return 1;
         }
      else  
         if (board_reg_banks[regbank].width)
              view_chararrCpychararr(MIN(count,board_reg_banks[regbank].width)
                                    ,&board_reg_banks[regbank].values
                                    [temp * board_reg_banks[regbank].width] ,ret);
         else { if (board_reg_banks[regbank].values[temp])  ret[0]=1;
                else                                        ret[0]=0;
	            while (count) ret[count--]=0;
                return 1;
                }

	  while (count-->board_reg_banks[regbank].width) ret[count]=0;
	  return 1;
      }
	 
    if (text[temp]>0x39) text[temp] -= 7;
    text[temp2++] = text[temp++];
    }
  if (!temp2) {g_free(text); return 0;}
  temp = 0;
  if (temp2 > (count<<1)) temp2=(count<<1);
  while (temp2--){
    ret[temp]=text[temp2]&15;
    if (!temp2--) {temp++; break;}
    ret[temp++]+=(text[temp2]&15)<<4;
    }
  while (temp<count) ret[temp++]=0;
  g_free(text);
  return 1;
}

int view_hexstr2chararr(int count, char* pass, uchar* ret)
{
  uchar* right;          /* call this!*/
  uchar* left;
  uchar* res;            /* allows '+','-' etc */
  int temp=0;
  int carry=0;
  char op;
  while (pass[temp]>=0x30 || pass[temp]<0x21)
      if (pass[temp++]=='\0')
            return view_hexstr2chararr2(count, pass, ret);
  right = g_new(uchar, count);
  if (!view_hexstr2chararr(count, pass +temp+1, right)) {g_free(right);return 0;}
  left = g_new(uchar, count);
  op = pass[temp];
  pass[temp]='\0';
  if (!view_hexstr2chararr(count, pass, left))
                                        {g_free(right);g_free(left);return 0;}
  switch (op){
    case '+': res = view_chararrAddchararr(count, left, right);
              view_chararrCpychararr(count, res , ret);
			  g_free (right); g_free (left); g_free (res);
			  return 1;                /*also spot register names in text*/
    case '-': for (temp=0;temp<count;temp++){
                ret[temp]=left[temp]-right[temp]-carry;
                if ((int) (left[temp]-right[temp]-carry)<0) carry=1;
				else carry=0;
                }
              g_free (right); g_free (left);
              return 1;
    default:  return 0;
    }
          g_free (right); g_free (left);
          return 0;
}

int view_findstrinarr(char* string, char** array,int arrcount)
{
  char* mystr = g_strdup(string);  /*find string in an array of strings and return position*/
  int temp1=0 ,temp2=0;
  while (mystr[temp1]) if (' ' == mystr[temp1]) temp1++;
                       else mystr[temp2++] = mystr[temp1++];
  mystr[temp2]='\0';
  while (arrcount--){
	if (!g_strcasecmp(mystr,array[arrcount])) break;
    }
  g_free(mystr);
  return arrcount;
}



char* view_chararrinregbank(int count,uchar* value)
{
 int regbank;
 int regno;
 int byteno;
 int flag;    /* find a value in the registerbank and return the register string*/
 char* ret="";
 char* ret2;
 regbank = board_main_regbank;
  for (regbank = board_num_regbanks-1; regbank>=0; regbank--)
   if (board_reg_banks[regbank].pointer)
    if (count == board_reg_banks[regbank].width){
        for (regno = 0; regno < board_reg_banks[regbank].number; regno++){
            flag=0;
            for (byteno = board_reg_banks[regbank].width-1; byteno>=0; byteno--)
                if (value[byteno] != board_reg_banks[regbank].values
                            [regno * board_reg_banks[regbank].width + byteno]) flag=1;
            if (!flag)  {
                ret2=ret;
                if (*ret2) {
                    ret = g_strconcat(ret2,"+", NULL);
                    g_free(ret2);
                    return ret;
                    }
                ret = g_strdup(board_reg_banks[regbank].names[regno]);
                }
            }
        }
 
 if (*ret) return ret;
 else return NULL;
}



void g_list_free_contents (GList* list)
{
 while (list){
    g_free(list->data);
    list = list->next;
    }
}



