
/*		Name:		view.c
		Version:	0.0.12
		Date:		11/7/2001
		General interface with the graphical front end.
        Most of these functions are created using glade and so comment free
*/



#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>
#include <string.h>
#include "callbacks.h"
#include "view.h"
#include "interface.h"
#include "misc.h"
#include "serial.h"
#include "chump.h"
#include "breakview.h"
#include "breakcalls.h"
#include "config.h"
#include "progload.h"
#include "dotparse.h"
#include "tick.xpm"
#include "break.xpm"
#include "break_inactive.xpm"
#include "mulogo.xpm"
#include "chump.xpm"
#include "pkomodotitle.xpm"
#include "pkomodologo.xpm"
#include "pkomodoicon.xpm"

mem_window_list* view_memwindowlist = NULL;
reg_window_list* view_regwindowlist = NULL;
GdkColor view_greycolour = {1,0xc000,0xc000,0xa000};
GdkColor view_redcolour  = {1,0xFFFF,0x0000,0x0000};
GdkColor view_blackcolour ={1,0x0000,0x0000,0x0000};

/*              These are ARM.C disassemble instructions replaced by LITHP in ASM.C
 * 
 * char* view_dis_arm(uchar* address, uchar* code) // disassemble an arm instruction
 * {
 *   char* str = g_new0(char, 100);
 *   dis_string_ptr = str;
 *   if(board_cpu_reference_number==1)
 *   	arm_disassemble(view_chararr2int(4,address),view_chararr2int(4,code));
 *   else if(board_cpu_reference_number==2)
 *   	mips_disassemble(str, view_chararr2int(4,code),view_chararr2int(4,address));
 *   return str;
 * }
 *  
 * char* view_dis_thumb(uchar* address, uchar* code) // disassemble an arm instruction
 * {
 *   char* str = g_new0(char, 100);
 *   dis_string_ptr = str;
 *   if(board_cpu_reference_number==1)
 * 	thumb_disassemble(view_chararr2int(4,address),view_chararr2int(2,code));
 *   return str;
 * }
 */

char* view_dis(uchar* address, uchar* code,int count, GList* isa) /* disassemble an instruction count specifies the length*/
{
 Disasm disasm;
 char* ret = g_strdup("");
 char* temp;
 char* codelist;
 int intaddress = view_chararr2int(board_memory_ptr_width, address);
 AsmStatus stat = asm_default_status;
 stat.symbol_table = symbol_table;
 codelist = uchararr2str (count, (char *)code);
 disasm.bitfield= codelist;
// do     {
        stat.address = intaddress;
        disasm = asm_disassemble (disasm.bitfield, isa, stat);
        
          if (disasm.distext == &dis_error ) {
                            temp = g_strconcat (ret, "Undefined Instruction", NULL);
                            g_free (ret);
                            ret=temp;
                            disasm.bitfield=NULL;
                             } 
            else                    {
                            ret = asm_sprint(disasm.distext, ret);
                            asm_freestringlist (disasm.distext);
                            }
                            
                            
 //        } while (disasm.bitfield);
         
 g_free(codelist);
 
 
/*
 *  {
 *   //TEST
 *   address_line test_line;
 *   address_line* found_line;
 *   GList* list;
 *   test_line.address = intaddress;
 *   list = g_list_find_custom(address_line_list,&test_line,progload_address_line_compare);
 *   if (list){
 *     found_line = (address_line*)list->data;
 *     if (found_line->line){
 *         char* temp2=ret;
 *         temp = g_list_nth_data(found_line->file->lines,found_line->line);
 *         g_print("%d %s\n", found_line->line, found_line->file->filename);
 *         ret = g_strconcat(ret, " ; ", temp, NULL);
 *         g_free(temp2);
 *         }
 *     }
 *   
 *  
 *  
 *  
 *  // -TEST 
 *  }
 */
 return ret;


/*  char* str;            These are MIPS.C and ARM.C disassemble instructions replaced by CHUMP in ASM.C  
  if (8 == count) {
    str = g_new0(char, 150);
	dis_string_ptr = str;
	if(board_cpu_reference_number==1)
		arm_disassemble(view_chararr2int(4,address)  ,view_chararr2int(4,code));
	if(board_cpu_reference_number==2)
  		mips_disassemble(dis_string_ptr, view_chararr2int(4,code),view_chararr2int(4,address));
	while(dis_string_ptr<str+50) (*(dis_string_ptr++))=' ';
	if(board_cpu_reference_number==1)
		arm_disassemble(view_chararr2int(4,address)+4,view_chararr2int(4,code+4));
	if(board_cpu_reference_number==2)
  		mips_disassemble(dis_string_ptr, view_chararr2int(4,code),view_chararr2int(4,address));
	return str;
    }
  if (4 == count) return view_dis_arm  (address, code);
  if (2 == count) return view_dis_thumb(address, code);
  return g_strdup("Unsupported instruction width"); */
}

int view_updatememwindow(mem_window* memwindowptr)   /* update memory window*/
{
 GtkCList* clist = GTK_CLIST(memwindowptr->clist_ptr);
 int count = memwindowptr->count * memwindowptr->width;
 unsigned char* memdata = g_new(unsigned char, count);
 char* data;
 char* address;
 int temp;
 int flag;
 char* test;
 char* test2;
 GList* breaks=NULL;
 GList* breaksinactive=NULL;
 GList* templist;
 GdkColor* colour;
 uchar* new_address = view_chararrAddchararr(board_memory_ptr_width,
                               memwindowptr->address, memwindowptr->regoffset);
  {
    unsigned int worda;
    unsigned int wordb;
    int temp, temp2;
    uchar* value;
    uchar repc;
    board_sendchar(BR_BP_GET);
    if (4 != board_getb32(&worda)) {g_free(new_address);return 0;}    //get breaks and breaksinactive list
    if (4 != board_getb32(&wordb)) {g_free(new_address);return 0;}
    for (temp=0;temp<32;temp++)
        if ((worda>>temp)&1){
 //if (VERBOSE) g_print("foundnumber:%d",temp);
            value=g_new(uchar,board_memory_ptr_width);
            board_sendchar(BR_BP_READ);
            board_sendchar(temp);
            flag=0;
            for (temp2=2;temp2;temp2--){
                if (1 != board_getchar(&repc)) {g_free(new_address);return 0;}
                if (0xff != repc) flag=1;
                }
            if (board_memory_ptr_width != board_getchararray(board_memory_ptr_width,value)) 
                                               {g_free(new_address);return 0;}
 //if (VERBOSE) g_print("found:%x\n",view_chararr2int(board_memory_ptr_width,value));
            for (temp2=board_memory_ptr_width;temp2;temp2--){
                if (1 != board_getchar(&repc)) {g_free(new_address);return 0;}
                if (0xff != repc) flag=1;
                }
            for (temp2=16;temp2;temp2--){
                if (1 != board_getchar(&repc)) {g_free(new_address);return 0;}
                if (0x0 != repc) flag=1;
                }
            if (flag) g_free(value);
            else    if ((wordb>>temp)&1) breaks = g_list_append (breaks, value);
                    else breaksinactive = g_list_append (breaksinactive, value);
            }
  }
 if (board_wordaline) new_address[0] &= -memwindowptr->width;
 if (!board_get_memory (count / memwindowptr->gran, new_address, memdata, memwindowptr->gran)){
   if (!board_mini_ping(0) ||
       !board_get_memory (count / memwindowptr->gran, new_address, memdata, memwindowptr->gran)){       /*get new memory data*/
                              g_free(new_address);g_free(memdata); return 0;}
   }
 gtk_clist_freeze (clist); 
 count = 0;
 while (count < memwindowptr->count){
   address = view_chararrAddint(board_memory_ptr_width,
                       new_address, count * memwindowptr->width);
   test = view_chararrinregbank (board_memory_ptr_width, address);

   data = view_chararr2hexstrbe (board_memory_ptr_width, address);              //create an address string
    
   
   {
    Symbol* symbol = symbol_findaddress(symbol_table, lint_new(view_chararr2long(board_memory_ptr_width, address)));
    if (symbol){
        g_free(data);
        data = g_strdup(symbol->name);
//        g_print("Printing symbol:\"%s\" %x\n", data, view_chararr2long(board_memory_ptr_width, address));
        }
   }
   
   
   if (test) {
        test2 = g_strconcat (data, " " , test, NULL);
        g_free(data);
        g_free(test);
        data = test2;
        }

   flag=0;

   templist=breaksinactive;
   while(templist){
        if (!view_chararrSubchararr(board_memory_ptr_width, address, templist->data)) {
            gtk_clist_set_pixtext(clist,count,0,data,0,view_break_inactive_pixmap,view_break_inactive_bitmap);
            flag=1;
            }
        templist=templist->next;
        }
   templist=breaks;
   while(templist){
        if (!view_chararrSubchararr(board_memory_ptr_width, address, templist->data)) {
            flag=2;
            gtk_clist_set_pixtext(clist,count,0,data,0,view_break_pixmap,view_break_bitmap);
            }
         templist=templist->next;
        }

   for (temp=0;temp<special_register_count;temp++)
        if (special_registers[temp].active)
            if (!view_chararrSubchararr(board_memory_ptr_width, special_registers[temp].value,address)){
                colour = &special_registers[temp].colour;
                if(special_registers[temp].pixmap)
                     gtk_clist_set_pixtext(clist,count,0,data,0,special_registers[temp].pixmap,special_registers[temp].bitmap);
                else gtk_clist_set_text(clist,count,0,data);
                flag=3;
                }
   
   if (!flag)   {if (!gtk_clist_get_text(clist,count,0,&test)) gtk_clist_set_text(clist,count,0,data);    // only update if it has changed
                 else                   if (strcmp(data,test)) gtk_clist_set_text(clist,count,0,data);}
   
   g_free (data);


   for (temp=0;temp<(memwindowptr->width/memwindowptr->gran);temp++){  /*insert new info into window*/
     data = view_chararr2hexstrbe (memwindowptr->gran, memdata  +
                                    count * memwindowptr->width +
                                    temp  * memwindowptr->gran);
     if (!gtk_clist_get_text(clist,count,temp+1,&test)) gtk_clist_set_text(clist,count,temp+1,data);
     else if (strcmp(data,test)) gtk_clist_set_text(clist,count,temp+1,data);
     g_free (data);
     }
   
   switch (flag){
        case (0):
            gtk_clist_set_foreground (clist,count ,&view_blackcolour);
            break;
        case (1):
            gtk_clist_set_foreground (clist,count, &view_greycolour);
            break;
        case (2):
            gtk_clist_set_foreground (clist,count, &view_redcolour);
            break;
        case (3):
            gtk_clist_set_foreground (clist,count, colour);
            break;
        }


   data = view_chararr2asciistr (memwindowptr->width, memdata + count
                               * memwindowptr->width);
   if (!gtk_clist_get_text(clist,count,5,&test)) gtk_clist_set_text(clist,count,5,data);
   else if (strcmp(data,test)) gtk_clist_set_text(clist,count,5,data);
   g_free (data);
   data = view_dis(address, memdata + count * memwindowptr->width,
                         memwindowptr->width, memwindowptr->isa);
   if (!gtk_clist_get_text(clist,count,6,&test)) gtk_clist_set_text(clist,count,6,data);
   else if (strcmp(data,test)) gtk_clist_set_text(clist,count,6,data);
   
    

   g_free (data);
   g_free (address);
   count++;
   }
   g_free (new_address);
   g_free(memdata);
 templist=breaksinactive;
 while(templist){
        g_free(templist->data);
        templist=templist->next;
        }
 templist=breaks;
 while(templist){
        g_free(templist->data);
        templist=templist->next;
        }
 
 
  gtk_clist_thaw (clist);
  return 1;
}


int view_updateregwindow(reg_window* regwindowptr) /* refresh register window*/
{
 GtkCList* clist = GTK_CLIST(regwindowptr->clist_ptr);
 int count;
 char* data[2];
 char* test;
 reg_bank* regbank = &board_reg_banks[regwindowptr->regbank_no];
 if (!board_get_regbank(regwindowptr->regbank_no)){
   if (!board_mini_ping(0) || !board_get_regbank(regwindowptr->regbank_no))
                                                                return 0;}
 gtk_clist_freeze (clist);
 count = 0;
 while (count < regbank->number){ 
   data[0] = g_strdup(regbank->names[count]);
   if (regbank->width) data[1] = view_chararr2hexstrbe (regbank->width,
                               &regbank->values[count * regbank->width]);
   else {if (regbank->values[count]) data[1]="1"; else data[1]="0";}

   if (!gtk_clist_get_text(clist,count,0,&test)) gtk_clist_set_text(clist,count,0,data[0]);
   else if (strcmp(data[0],test)) gtk_clist_set_text(clist,count,0,data[0]);
   
   if (!gtk_clist_get_text(clist,count,1,&test)) gtk_clist_set_text(clist,count,1,data[1]);
   else if (strcmp(data[1],test))  gtk_clist_set_text(clist,count,1,data[1]); 

   g_free(data[0]);
   if (regbank->width) g_free(data[1]);
   count++; 
   }
 gtk_clist_thaw (clist); 
 return 1;
}

mem_window* view_getmemwindowptr(GtkWidget* widget) /*climb up the tree to got the parent who is a mem_window*/
{
  mem_window *mem_window_ptr = NULL;
  while (NULL == mem_window_ptr){
   mem_window_ptr = gtk_object_get_data (GTK_OBJECT(widget),"mem_window");
   widget = (GTK_WIDGET(widget))->parent;
   }
  return mem_window_ptr;
}
		
reg_window* view_getregwindowptr(GtkWidget* widget) /*climb up the tree to got the parent who is a reg_window*/
{
  reg_window *reg_window_ptr = NULL;
  while (NULL == reg_window_ptr){
   reg_window_ptr = gtk_object_get_data (GTK_OBJECT(widget),"reg_window");
   widget = (GTK_WIDGET(widget))->parent;
   }
  return reg_window_ptr;  
}

GtkWidget* view_create_h_mov_split (void) /*standard make a horisontal movable split*/
{
  GtkWidget* view_mov_h_split = gtk_hpaned_new ();
  gtk_widget_show (view_mov_h_split);
  gtk_paned_set_gutter_size (GTK_PANED (view_mov_h_split), 10);
  return view_mov_h_split;
}

GtkWidget* view_create_v_mov_split (void) /*standard make a vertical movable split*/
{
  GtkWidget* view_mov_v_split = gtk_vpaned_new ();
  gtk_widget_show (view_mov_v_split);
  gtk_paned_set_gutter_size (GTK_PANED (view_mov_v_split), 10);
  return view_mov_v_split;
}


void view_create_mainwindow (void) /*create main window*/
{
  GtkWidget *hbox;
  GtkWidget *vbox;
  GtkWidget *sepp;

  view_tooltips = gtk_tooltips_new ();
  gdk_colormap_alloc_color(gdk_colormap_get_system(),&view_greycolour,0,1);
  gdk_colormap_alloc_color(gdk_colormap_get_system(),&view_redcolour,0,1);
  gdk_colormap_alloc_color(gdk_colormap_get_system(),&view_blackcolour,0,1);
  view_tick_pixmap =   gdk_pixmap_colormap_create_from_xpm_d (NULL, gdk_colormap_get_system(), &view_tick_bitmap,  NULL,tick_xpm);
  view_break_pixmap =   gdk_pixmap_colormap_create_from_xpm_d (NULL, gdk_colormap_get_system(), &view_break_bitmap,  NULL,break_xpm);
  view_break_inactive_pixmap =   gdk_pixmap_colormap_create_from_xpm_d (NULL, gdk_colormap_get_system(), &view_break_inactive_bitmap,  NULL,break_inactive_xpm);
  view_mulogo_pixmap = gdk_pixmap_colormap_create_from_xpm_d (NULL, gdk_colormap_get_system(), &view_mulogo_bitmap,NULL,mulogo_xpm);
  view_komodotitle_pixmap = gdk_pixmap_colormap_create_from_xpm_d (NULL, gdk_colormap_get_system(), &view_komodotitle_bitmap,NULL,komodotitle_xpm);
  view_komodoicon_pixmap = gdk_pixmap_colormap_create_from_xpm_d (NULL, gdk_colormap_get_system(), &view_komodoicon_bitmap,NULL,komodoicon_xpm);
  view_chump_pixmap = gdk_pixmap_colormap_create_from_xpm_d (NULL, gdk_colormap_get_system(), &view_chump_bitmap,NULL,chump_xpm);


  view_mainwindow = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title (GTK_WINDOW (view_mainwindow),PACKAGE " " VERSION " " DATE " (C) University of Manchester");
  gtk_container_set_border_width (GTK_CONTAINER (view_mainwindow), 3);
  gtk_window_set_default_size (GTK_WINDOW (view_mainwindow), 600, 600);
  gtk_signal_connect (GTK_OBJECT (view_mainwindow), "destroy",   /*if closed then quit*/
                             GTK_SIGNAL_FUNC(callback_main_quit),
                             NULL);
  gtk_window_set_policy (GTK_WINDOW (view_mainwindow), FALSE, TRUE, FALSE);
  vbox = gtk_vbox_new (FALSE, 3);
  gtk_widget_ref (vbox);
  gtk_widget_show (vbox);
  hbox = gtk_hbox_new (FALSE, 3);
  gtk_widget_ref (hbox);
  gtk_widget_show (hbox);
  gtk_container_set_border_width (GTK_CONTAINER (hbox),4);
  gtk_container_add (GTK_CONTAINER (view_mainwindow), vbox);
  gtk_box_pack_start (GTK_BOX (hbox), view_create_prog_ctrl (), FALSE, FALSE, 0); /* add a program controll bar*/
  sepp = gtk_vseparator_new();
  gtk_widget_ref (sepp);
  gtk_widget_show (sepp);
  gtk_box_pack_start (GTK_BOX (hbox), sepp, FALSE, FALSE, 0); 
  gtk_box_pack_start (GTK_BOX (hbox), view_create_filebar   (), TRUE, TRUE, 0); /* add a file bar*/
  gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);
  
  view_maincontainer=vbox;
  gtk_widget_show (view_mainwindow);
  gdk_window_set_icon (view_mainwindow->window,NULL,view_komodoicon_pixmap,view_komodoicon_bitmap);
}


GtkWidget* view_create_filebar (void)
{
  GtkWidget *hbox;
  GtkWidget *vbox;
  GtkWidget *button_compile;
  GtkWidget *combo_compile;
  GtkWidget *centry_compile;
  GtkWidget *button_findcompile;
  GtkWidget *button_load;
  GtkWidget *combo_load;
  GtkWidget *centry_load;
  GtkWidget *button_findload;
  GtkWidget *progressbar;
  GtkWidget *fileselection;
  GtkWidget *ok_button;
  GtkWidget *cancel_button;
  GtkWidget *button_about;
  GtkWidget *window_about;
  GtkWidget *button_feature;
  GtkWidget *window_feature;
  GtkWidget *dialog_vbox1;
  GtkWidget *label;
  GtkWidget *dialog_action_area1;
  GtkWidget *buttonok;
  GtkWidget *buttoncancel;
  GtkWidget *optionmenu_isa;
  GtkWidget *optionmenu_menu;
  GtkWidget *menuitem;
  DefinitionStack* isa_list;

  vbox = gtk_vbox_new (FALSE, 2);
  gtk_widget_ref (vbox);
  gtk_widget_show (vbox);

  hbox = gtk_hbox_new (FALSE, 4);
  gtk_widget_ref (hbox);
  gtk_widget_show (hbox);

  button_compile = gtk_button_new_with_label (_("Compile ->"));
  gtk_widget_ref (button_compile);
  gtk_widget_show (button_compile);
  gtk_box_pack_start (GTK_BOX (hbox), button_compile, FALSE, FALSE, 4);
  combo_compile = gtk_combo_new ();
  gtk_widget_ref (combo_compile);
  gtk_widget_show (combo_compile);
  gtk_box_pack_start (GTK_BOX (hbox), combo_compile, TRUE, TRUE, 0);
  centry_compile = GTK_COMBO (combo_compile)->entry;
  gtk_widget_ref (centry_compile);
  gtk_widget_show (centry_compile);
  view_compile_centry = centry_compile;
  button_findcompile = gtk_button_new_with_label (_("Browse..."));
  gtk_widget_ref (button_findcompile);  gtk_widget_show (button_findcompile);
  gtk_box_pack_start (GTK_BOX (hbox), button_findcompile, FALSE, FALSE, 0);
  gtk_signal_connect (GTK_OBJECT (button_compile), "clicked",
                      GTK_SIGNAL_FUNC (callback_button_compile),centry_compile);
  {
  GList* file_list=NULL;
  GList* list = ScanfindSymbolList(config_toplist, "Compile-List", NULL);
  if (list){
    if (SCAN_IS_STRING(SCAN_LIST_FIRST(list))) 
    while (list){
        if (SCAN_IS_STRING(SCAN_LIST_FIRST(list))) {
            file_list = g_list_append(file_list, g_strdup(SCAN_STRING(SCAN_LIST_FIRST(list))));
//            g_print("compile:%s\n",SCAN_STRING(SCAN_LIST_FIRST(list)));
            }
        list = list->next;
        }
    gtk_object_set_data (GTK_OBJECT (centry_compile), "list", file_list);
    gtk_combo_set_popdown_strings (GTK_COMBO (combo_compile), file_list);
    }
  else{
    gtk_object_set_data (GTK_OBJECT (centry_compile), "list", NULL);
    }
  }



  gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);
  hbox = gtk_hbox_new (FALSE, 4);
  gtk_widget_ref (hbox);
  gtk_widget_show (hbox);

  button_load = gtk_button_new_with_label (_("Load ->"));
  gtk_widget_ref (button_load);
  gtk_widget_show (button_load);
  gtk_box_pack_start (GTK_BOX (hbox), button_load, FALSE, FALSE, 4);

  combo_load = gtk_combo_new ();
  gtk_widget_ref (combo_load);
  gtk_widget_show (combo_load);
  gtk_box_pack_start (GTK_BOX (hbox), combo_load, TRUE, TRUE, 0);
  centry_load = GTK_COMBO (combo_load)->entry;
  gtk_widget_ref (centry_load);
  gtk_widget_show (centry_load);
  view_load_centry = centry_load;
  button_findload = gtk_button_new_with_label (_("Browse..."));
  gtk_widget_ref (button_findload);  gtk_widget_show (button_findload);
  gtk_box_pack_start (GTK_BOX (hbox), button_findload, FALSE, FALSE, 0);
  gtk_signal_connect (GTK_OBJECT (button_load), "clicked",
                      GTK_SIGNAL_FUNC (callback_button_load),centry_load);
  
  {
  GList* file_list=NULL;
  GList* list = ScanfindSymbolList(config_toplist, "Load-List", NULL);
  if (list){
    while (list){
        if (SCAN_IS_STRING(SCAN_LIST_FIRST(list))) {
            file_list = g_list_append(file_list, g_strdup(SCAN_STRING(SCAN_LIST_FIRST(list))));
//            g_print("load:%s\n",SCAN_STRING(SCAN_LIST_FIRST(list)));
            }
        list = list->next;
        }
    gtk_object_set_data (GTK_OBJECT (centry_load), "list", file_list);
    gtk_combo_set_popdown_strings (GTK_COMBO (combo_load), file_list);
    }
  else{
    gtk_object_set_data (GTK_OBJECT (centry_load), "list", NULL);
    }
  }

  

  view_fileerror = gtk_dialog_new ();
  gtk_object_set_data (GTK_OBJECT (view_fileerror), "view_fileerror", view_fileerror);
  gtk_window_set_title (GTK_WINDOW (view_fileerror), _("File load error"));

  
#ifdef GTK2
  gtk_window_set_type_hint (GTK_WINDOW(view_fileerror),GDK_WINDOW_TYPE_HINT_DIALOG);
#endif

#ifndef GTK2
  GTK_WINDOW (view_fileerror)->type = GTK_WINDOW_DIALOG;
#endif
  

  gtk_window_set_position (GTK_WINDOW (view_fileerror), GTK_WIN_POS_CENTER);
  gtk_window_set_policy (GTK_WINDOW (view_fileerror), FALSE, TRUE, TRUE);

  dialog_vbox1 = GTK_DIALOG (view_fileerror)->vbox;
  gtk_widget_show (dialog_vbox1);

  label = gtk_label_new (_("This file is not an ELF executable!\nDo you wish to load it as a binary file?\nOr attempt to assemble it?"));
  gtk_widget_ref (label);
  gtk_widget_show (label);
  gtk_box_pack_start (GTK_BOX (dialog_vbox1), label, TRUE, TRUE, 0);                //This is the contents of the file error window

  view_binary_load_address = gtk_entry_new_with_max_length (64);
  gtk_widget_ref (view_binary_load_address);
  gtk_widget_show (view_binary_load_address);
  gtk_box_pack_start (GTK_BOX (dialog_vbox1), view_binary_load_address, TRUE, TRUE, 0);
  
  label = gtk_label_new (_("Valid:0"));
  gtk_widget_ref (label);
  gtk_widget_show (label);
  gtk_box_pack_start (GTK_BOX (dialog_vbox1), label, TRUE, TRUE, 0);                //This is the contents of the file error window


  optionmenu_isa = gtk_option_menu_new();
  gtk_widget_ref (optionmenu_isa);
  gtk_widget_show (optionmenu_isa);
  optionmenu_menu = gtk_menu_new();
  gtk_widget_ref (optionmenu_menu);
  
  isa_list = board_asm_tables;
  while (isa_list){
    menuitem = gtk_menu_item_new_with_label (isa_list->string);
    gtk_widget_show (menuitem);
    gtk_menu_prepend (GTK_MENU (optionmenu_menu), menuitem);
    gtk_signal_connect (GTK_OBJECT(menuitem), "activate",
                        GTK_SIGNAL_FUNC (callback_load_isa),(gpointer)isa_list->rules);
    isa_list=isa_list->next;
    }

   menuitem = gtk_menu_item_new_with_label ("Binary");
   gtk_widget_show (menuitem);
   gtk_menu_prepend (GTK_MENU (optionmenu_menu), menuitem);
   gtk_signal_connect (GTK_OBJECT(menuitem), "activate",
                       GTK_SIGNAL_FUNC (callback_load_isa), NULL);



  gtk_box_pack_start (GTK_BOX (dialog_vbox1), optionmenu_isa, TRUE, TRUE, 0);
  gtk_option_menu_set_menu (GTK_OPTION_MENU (optionmenu_isa), optionmenu_menu);




  dialog_action_area1 = GTK_DIALOG (view_fileerror)->action_area;
  gtk_widget_show (dialog_action_area1);
  gtk_container_set_border_width (GTK_CONTAINER (dialog_action_area1), 10);         //Action area is the bottom box which holds the OK and Cancel buttons

  buttonok = gtk_button_new_with_label (_("OK"));
  gtk_widget_ref (buttonok);
  gtk_widget_show (buttonok);
  gtk_box_pack_start (GTK_BOX (dialog_action_area1), buttonok, TRUE, TRUE, 0);

  buttoncancel = gtk_button_new_with_label (_("Cancel"));
  gtk_widget_ref (buttoncancel);
  gtk_widget_show (buttoncancel);
  gtk_box_pack_start (GTK_BOX (dialog_action_area1), buttoncancel, TRUE, TRUE, 0);

  gtk_signal_connect_object (GTK_OBJECT (view_fileerror), "delete_event",           //If window is closed then just hide and dont destroy
                            GTK_SIGNAL_FUNC (gtk_widget_hide),
                            GTK_OBJECT (view_fileerror));

  gtk_signal_connect (GTK_OBJECT (buttonok), "clicked",                             //If ok pressed the load
                      GTK_SIGNAL_FUNC (callback_load_isa_binary),
                      centry_load);
                      
  gtk_signal_connect_object (GTK_OBJECT (buttoncancel), "clicked",                  //If cancel pressed then hide
                             GTK_SIGNAL_FUNC (gtk_widget_hide),
                             GTK_OBJECT (view_fileerror));
                             
  gtk_signal_connect_after (GTK_OBJECT (view_binary_load_address), "changed",                  //If entry changed then update
                             GTK_SIGNAL_FUNC (callback_load_binary_address),
                             GTK_OBJECT (label));
  
  gtk_entry_set_text (GTK_ENTRY(view_binary_load_address),"0");


  gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);
  hbox = gtk_hbox_new (FALSE, 4);
  gtk_widget_ref (hbox);
  gtk_widget_show (hbox);
  
  progressbar = gtk_progress_bar_new ();
  gtk_widget_ref (progressbar);
  gtk_widget_show (progressbar);
  gtk_box_pack_start (GTK_BOX (hbox), progressbar, TRUE, TRUE, 4);
//  gtk_progress_set_adjustment(GTK_PROGRESS (progressbar), gtk_adjustment_new (0, 0, 100, 1, 1, 1));
  gtk_progress_configure (GTK_PROGRESS (progressbar), 100, 100, 200);

  gtk_progress_set_show_text (GTK_PROGRESS (progressbar), TRUE);
  view_progressbar=progressbar;
  
  button_feature = gtk_button_new_with_label ("Console");
  gtk_widget_ref (button_feature);
  gtk_widget_show (button_feature);
  gtk_box_pack_start (GTK_BOX (hbox), button_feature, FALSE, FALSE, 0);
  window_feature = create_featurewindow();
  gtk_signal_connect_object(GTK_OBJECT (button_feature), "clicked", gtk_widget_show ,GTK_OBJECT (window_feature));
  gtk_signal_connect_object_after(GTK_OBJECT (button_feature), "clicked", callback_window_raise ,GTK_OBJECT (window_feature));
  
  button_about = gtk_button_new_with_label ("About");
  gtk_widget_ref (button_about);
  gtk_widget_show (button_about);
  gtk_box_pack_start (GTK_BOX (hbox), button_about, FALSE, FALSE, 0);
  window_about = create_aboutwindow();
 
  gtk_signal_connect_object(GTK_OBJECT (button_about), "clicked", gtk_widget_show ,GTK_OBJECT (window_about));
 
  gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);

  fileselection = gtk_file_selection_new (_("Select Source File"));
  gtk_container_set_border_width (GTK_CONTAINER (fileselection), 10);
  ok_button = GTK_FILE_SELECTION (fileselection)->ok_button;
  gtk_widget_show (ok_button);
  GTK_WIDGET_SET_FLAGS (ok_button, GTK_CAN_DEFAULT);
  cancel_button = GTK_FILE_SELECTION (fileselection)->cancel_button;
  gtk_widget_show (cancel_button);
  GTK_WIDGET_SET_FLAGS (cancel_button, GTK_CAN_DEFAULT);
//  gtk_file_selection_complete (GTK_FILE_SELECTION(fileselection),"*.s");
  gtk_signal_connect_object (GTK_OBJECT (fileselection), "delete_event",           //If window is closed then just hide and dont destroy
                            GTK_SIGNAL_FUNC (gtk_widget_hide),
                            GTK_OBJECT (fileselection));
  gtk_signal_connect_object (GTK_OBJECT (button_findcompile), "clicked", /* these are the two file selection satelite windows*/
                             GTK_SIGNAL_FUNC (callback_window_raise),
                             GTK_OBJECT (fileselection));
  gtk_signal_connect_object (GTK_OBJECT (cancel_button), "clicked",
                             GTK_SIGNAL_FUNC (gtk_widget_hide),
                             GTK_OBJECT (fileselection));
  gtk_signal_connect_object (GTK_OBJECT (ok_button), "clicked",
                             GTK_SIGNAL_FUNC (gtk_widget_hide),
                             GTK_OBJECT (fileselection));
  gtk_signal_connect (GTK_OBJECT (ok_button), "clicked",
                      GTK_SIGNAL_FUNC (callback_button_ok_file),centry_compile);

  
  fileselection = gtk_file_selection_new (_("Select Object File"));
  gtk_container_set_border_width (GTK_CONTAINER (fileselection), 10);
  ok_button = GTK_FILE_SELECTION (fileselection)->ok_button;
  gtk_widget_show (ok_button);
  GTK_WIDGET_SET_FLAGS (ok_button, GTK_CAN_DEFAULT);
  cancel_button = GTK_FILE_SELECTION (fileselection)->cancel_button;
  gtk_widget_show (cancel_button);
  GTK_WIDGET_SET_FLAGS (cancel_button, GTK_CAN_DEFAULT);
//  gtk_file_selection_complete (GTK_FILE_SELECTION(fileselection),"*.elf");
  gtk_signal_connect_object (GTK_OBJECT (fileselection), "delete_event",           //If window is closed then just hide and dont destroy
                            GTK_SIGNAL_FUNC (gtk_widget_hide),
                            GTK_OBJECT (fileselection));
  gtk_signal_connect_object (GTK_OBJECT (button_findload), "clicked",
                             GTK_SIGNAL_FUNC (callback_window_raise),
                             GTK_OBJECT (fileselection));
  gtk_signal_connect_object (GTK_OBJECT (cancel_button), "clicked",
                             GTK_SIGNAL_FUNC (gtk_widget_hide),
                             GTK_OBJECT (fileselection));
  gtk_signal_connect_object (GTK_OBJECT (ok_button), "clicked",
                             GTK_SIGNAL_FUNC (gtk_widget_hide),
                             GTK_OBJECT (fileselection));
  gtk_signal_connect (GTK_OBJECT (ok_button), "clicked",
                      GTK_SIGNAL_FUNC (callback_button_ok_file),centry_load);
  
  
  return vbox;
}




GtkWidget*
create_featurewindow (void)
{
  GtkWidget *window;
  GtkWidget *notebook;
  GtkWidget *label;
  GtkWidget *segment;  
  int count;

  window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_default_size(GTK_WINDOW(window), 400, 200);
  gtk_object_set_data (GTK_OBJECT (window), "window", window);
  gtk_window_set_title (GTK_WINDOW (window), _("Features"));
  if (board_num_features){
    notebook = gtk_notebook_new ();
    gtk_widget_ref (notebook);
    gtk_object_set_data_full (GTK_OBJECT (window), "notebook", notebook,
                             (GtkDestroyNotify) gtk_widget_unref);
    gtk_widget_show (notebook);
    gtk_container_add (GTK_CONTAINER (window), notebook);
    gtk_notebook_set_tab_pos (GTK_NOTEBOOK (notebook), GTK_POS_LEFT);
   
    for (count=0; count<board_num_features; count++){
     switch (board_features[count].type){
         case XILINX_FPGA:
                  segment = create_xfpgasegment();
                  break;
         case CONSOLE:
                  segment = view_create_comms(&board_features[count]);
                  break;
         default:
                  segment = gtk_label_new ("Unknown feature");
                  gtk_widget_ref (segment);
                  gtk_widget_show (segment);
                  g_print("Unknown feature\n");
                  break;
         }
     gtk_object_set_data (GTK_OBJECT (segment), "feature", GINT_TO_POINTER(count));
     gtk_container_add (GTK_CONTAINER (notebook), segment);
     label = gtk_label_new (board_features[count].name);
     gtk_widget_ref (label);
     gtk_widget_show (label);
     gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook),
              gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook), count), label);
     }
   }
  else {
   label = gtk_label_new ("There are no features!");
   gtk_widget_ref (label);
  gtk_widget_show (label);
   gtk_misc_set_padding (GTK_MISC (label), 100, 50);
   gtk_container_add (GTK_CONTAINER (window), label);
   }



  gtk_signal_connect_object (GTK_OBJECT (window), "delete_event",
                            GTK_SIGNAL_FUNC (gtk_widget_hide),
                            GTK_OBJECT (window));
  return window;
}

GtkWidget*
create_xfpgasegment (void)
{
  GtkWidget *container;
  GtkWidget *hbox1;
  GtkWidget *buttonupdate;
  GtkWidget *combo;
  GtkWidget *fileentry;
  GtkWidget *browse;
  GtkWidget *hbox2;
  GtkWidget *table;
  GtkWidget *label27;
  GtkWidget *labelfilename;
  GtkWidget *label29;
  GtkWidget *labelfiledate;
  GtkWidget *label42;
  GtkWidget *labelfiletime;
  GtkWidget *buttondownload;
  GtkWidget *progressbar;
  GtkWidget *hbox3;
  GtkWidget *table8;
  GtkWidget *label44;
  GtkWidget *labelfpganame;
  GtkWidget *label46;
  GtkWidget *labelfpgadate;
  GtkWidget *label48;
  GtkWidget *labelfpgatime;
  GtkWidget *buttonerase;
  GtkWidget *fileselection;
  GtkWidget *ok_button;
  GtkWidget *cancel_button;

  container = gtk_vbox_new (FALSE, 11);
  gtk_object_set_data (GTK_OBJECT (container), "list", NULL);
  gtk_widget_ref (container);
  gtk_widget_show (container);
  gtk_container_set_border_width (GTK_CONTAINER (container), 6);

  hbox1 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox1);
  gtk_object_set_data_full (GTK_OBJECT (container), "hbox1", hbox1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox1);
  gtk_box_pack_start (GTK_BOX (container), hbox1, FALSE, FALSE, 0);

  buttonupdate = gtk_button_new_with_label (_("Update"));
  gtk_widget_ref (buttonupdate);
  gtk_object_set_data_full (GTK_OBJECT (container), "buttonupdate", buttonupdate,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (buttonupdate);
  gtk_box_pack_start (GTK_BOX (hbox1), buttonupdate, FALSE, FALSE, 0);
  
  gtk_signal_connect (GTK_OBJECT (buttonupdate), "clicked",
                      GTK_SIGNAL_FUNC (callback_fpgaupdate),container);

  combo = gtk_combo_new ();
  gtk_widget_ref (combo);
  gtk_object_set_data_full (GTK_OBJECT (container), "combo", combo,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (combo);
  gtk_box_pack_start (GTK_BOX (hbox1), combo, TRUE, TRUE, 0);

  fileentry = GTK_COMBO (combo)->entry;
  gtk_widget_ref (fileentry);
  gtk_object_set_data_full (GTK_OBJECT (container), "fileentry", fileentry,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (fileentry);

  browse = gtk_button_new_with_label (_("Browse..."));
  gtk_widget_ref (browse);
  gtk_object_set_data_full (GTK_OBJECT (container), "browse", browse,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (browse);
  gtk_box_pack_start (GTK_BOX (hbox1), browse, FALSE, FALSE, 0);

  hbox2 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox2);
  gtk_object_set_data_full (GTK_OBJECT (container), "hbox2", hbox2,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox2);
  gtk_box_pack_start (GTK_BOX (container), hbox2, FALSE, FALSE, 0);

  table = gtk_table_new (3, 2, FALSE);
  gtk_widget_ref (table);
  gtk_object_set_data_full (GTK_OBJECT (container), "table", table,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (table);
  gtk_box_pack_start (GTK_BOX (hbox2), table, TRUE, TRUE, 0);
  gtk_table_set_row_spacings (GTK_TABLE (table), 2);
  gtk_table_set_col_spacings (GTK_TABLE (table), 30);

  label27 = gtk_label_new (_("Name:"));
  gtk_widget_ref (label27);
  gtk_object_set_data_full (GTK_OBJECT (container), "label27", label27,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label27);
  gtk_table_attach (GTK_TABLE (table), label27, 0, 1, 0, 1,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_justify (GTK_LABEL (label27), GTK_JUSTIFY_LEFT);

  labelfilename = gtk_label_new (_("Empty"));
  gtk_widget_ref (labelfilename);
  gtk_object_set_data_full (GTK_OBJECT (container), "labelfilename", labelfilename,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (labelfilename);
  gtk_table_attach (GTK_TABLE (table), labelfilename, 1, 2, 0, 1,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 0, 0);

  label29 = gtk_label_new (_("Date:"));
  gtk_widget_ref (label29);
  gtk_object_set_data_full (GTK_OBJECT (container), "label29", label29,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label29);
  gtk_table_attach (GTK_TABLE (table), label29, 0, 1, 1, 2,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_justify (GTK_LABEL (label29), GTK_JUSTIFY_LEFT);

  labelfiledate = gtk_label_new (_("0000/00/00"));
  gtk_widget_ref (labelfiledate);
  gtk_object_set_data_full (GTK_OBJECT (container), "labelfiledate", labelfiledate,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (labelfiledate);
  gtk_table_attach (GTK_TABLE (table), labelfiledate, 1, 2, 1, 2,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 0, 0);

  label42 = gtk_label_new (_("Time"));
  gtk_widget_ref (label42);
  gtk_object_set_data_full (GTK_OBJECT (container), "label42", label42,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label42);
  gtk_table_attach (GTK_TABLE (table), label42, 0, 1, 2, 3,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 0, 0);

  labelfiletime = gtk_label_new (_("00:00:00"));
  gtk_widget_ref (labelfiletime);
  gtk_object_set_data_full (GTK_OBJECT (container), "labelfiletime", labelfiletime,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (labelfiletime);
  gtk_table_attach (GTK_TABLE (table), labelfiletime, 1, 2, 2, 3,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 0, 0);

  buttondownload = gtk_button_new_with_label (_("Download"));
  gtk_widget_ref (buttondownload);
  gtk_object_set_data_full (GTK_OBJECT (container), "buttondownload", buttondownload,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (buttondownload);
  gtk_box_pack_start (GTK_BOX (hbox2), buttondownload, FALSE, FALSE, 0);
  gtk_signal_connect (GTK_OBJECT (buttondownload), "clicked",
                      GTK_SIGNAL_FUNC (callback_fpgaload),container);
                      
  progressbar = gtk_progress_bar_new ();
  gtk_widget_ref (progressbar);  gtk_widget_show (progressbar);
  gtk_object_set_data_full (GTK_OBJECT (container), "progressbar", progressbar,
                            (GtkDestroyNotify) gtk_widget_unref);

  gtk_box_pack_start (GTK_BOX (container), progressbar, FALSE, FALSE, 0);
  gtk_progress_configure (GTK_PROGRESS (progressbar), 0, 0, 100);
  gtk_progress_set_show_text (GTK_PROGRESS (progressbar), TRUE);

  hbox3 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox3);
  gtk_object_set_data_full (GTK_OBJECT (container), "hbox3", hbox3,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox3);
  gtk_box_pack_start (GTK_BOX (container), hbox3, FALSE, FALSE, 0);

  table8 = gtk_table_new (3, 2, FALSE);
  gtk_widget_ref (table8);
  gtk_object_set_data_full (GTK_OBJECT (container), "table8", table8,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (table8);
  gtk_box_pack_start (GTK_BOX (hbox3), table8, TRUE, TRUE, 0);
  gtk_table_set_row_spacings (GTK_TABLE (table8), 2);
  gtk_table_set_col_spacings (GTK_TABLE (table8), 30);

  label44 = gtk_label_new (_("Name:"));
  gtk_widget_ref (label44);
  gtk_object_set_data_full (GTK_OBJECT (container), "label44", label44,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label44);
  gtk_table_attach (GTK_TABLE (table8), label44, 0, 1, 0, 1,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_justify (GTK_LABEL (label44), GTK_JUSTIFY_LEFT);

  labelfpganame = gtk_label_new (_("Empty"));
  gtk_widget_ref (labelfpganame);
  gtk_object_set_data_full (GTK_OBJECT (container), "labelfpganame", labelfpganame,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (labelfpganame);
  gtk_table_attach (GTK_TABLE (table8), labelfpganame, 1, 2, 0, 1,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 0, 0);

  label46 = gtk_label_new (_("Date:"));
  gtk_widget_ref (label46);
  gtk_object_set_data_full (GTK_OBJECT (container), "label46", label46,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label46);
  gtk_table_attach (GTK_TABLE (table8), label46, 0, 1, 1, 2,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_justify (GTK_LABEL (label46), GTK_JUSTIFY_LEFT);

  labelfpgadate = gtk_label_new (_("0000/00/00"));
  gtk_widget_ref (labelfpgadate);
  gtk_object_set_data_full (GTK_OBJECT (container), "labelfpgadate", labelfpgadate,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (labelfpgadate);
  gtk_table_attach (GTK_TABLE (table8), labelfpgadate, 1, 2, 1, 2,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 0, 0);

  label48 = gtk_label_new (_("Time"));
  gtk_widget_ref (label48);
  gtk_object_set_data_full (GTK_OBJECT (container), "label48", label48,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label48);
  gtk_table_attach (GTK_TABLE (table8), label48, 0, 1, 2, 3,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 0, 0);

  labelfpgatime = gtk_label_new (_("00:00:00"));
  gtk_widget_ref (labelfpgatime);
  gtk_object_set_data_full (GTK_OBJECT (container), "labelfpgatime", labelfpgatime,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (labelfpgatime);
  gtk_table_attach (GTK_TABLE (table8), labelfpgatime, 1, 2, 2, 3,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 0, 0);

  buttonerase = gtk_button_new_with_label (_("Erase"));
  gtk_widget_ref (buttonerase);
  gtk_object_set_data_full (GTK_OBJECT (container), "buttonerase", buttonerase,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (buttonerase);
  gtk_box_pack_start (GTK_BOX (hbox3), buttonerase, FALSE, FALSE, 0);


  fileselection = gtk_file_selection_new (_("Select FPGA .bit File"));
  gtk_container_set_border_width (GTK_CONTAINER (fileselection), 10);
  ok_button = GTK_FILE_SELECTION (fileselection)->ok_button;
  gtk_widget_show (ok_button);
  GTK_WIDGET_SET_FLAGS (ok_button, GTK_CAN_DEFAULT);
  cancel_button = GTK_FILE_SELECTION (fileselection)->cancel_button;
  gtk_widget_show (cancel_button);
  GTK_WIDGET_SET_FLAGS (cancel_button, GTK_CAN_DEFAULT);
  gtk_file_selection_complete (GTK_FILE_SELECTION(fileselection),"*.bit");
  gtk_signal_connect_object (GTK_OBJECT (browse), "clicked",
                             GTK_SIGNAL_FUNC (gtk_widget_show),
                             GTK_OBJECT (fileselection));
  gtk_signal_connect_object (GTK_OBJECT (cancel_button), "clicked",
                             GTK_SIGNAL_FUNC (gtk_widget_hide),
                             GTK_OBJECT (fileselection));
  gtk_signal_connect_object (GTK_OBJECT (ok_button), "clicked",
                             GTK_SIGNAL_FUNC (gtk_widget_hide),
                             GTK_OBJECT (fileselection));
  gtk_signal_connect (GTK_OBJECT (ok_button), "clicked",
                      GTK_SIGNAL_FUNC (callback_button_ok_file),fileentry);
  gtk_signal_connect (GTK_OBJECT (ok_button), "clicked",
                      GTK_SIGNAL_FUNC (callback_fpgaupdate),container);


  return container;
}



#ifdef GTK2
GtkWidget* view_create_comms (feature* console)  /*create a comms window*/
{
  GtkWidget *vbox1;
  GtkWidget *scrolledwindow1;
  GtkWidget *text1;
  GtkWidget *hbox1;
  GtkWidget *entry1;
  GtkWidget *clear_button;

  vbox1 = gtk_vbox_new (FALSE, 0);
  gtk_widget_ref (vbox1);
  gtk_widget_show (vbox1);

  scrolledwindow1 = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_ref (scrolledwindow1);
  gtk_widget_show (scrolledwindow1);
  gtk_box_pack_start (GTK_BOX (vbox1), scrolledwindow1, TRUE, TRUE, 0);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow1), GTK_POLICY_NEVER, GTK_POLICY_ALWAYS);

  text1 = gtk_text_new (NULL, NULL);
  gtk_widget_ref (text1);
  gtk_widget_show (text1);
  gtk_container_add (GTK_CONTAINER (scrolledwindow1), text1);

  hbox1 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox1);
  gtk_widget_show (hbox1);
  gtk_box_pack_start (GTK_BOX (vbox1), hbox1, FALSE, FALSE, 0);

  entry1 = gtk_entry_new ();
  gtk_widget_ref (entry1);
  gtk_widget_show (entry1);
  gtk_box_pack_start (GTK_BOX (hbox1), entry1, FALSE, FALSE, 0);
  gtk_signal_connect (GTK_OBJECT(entry1), "activate",
                         GTK_SIGNAL_FUNC (callback_comms),console);
  
  
  
  clear_button = gtk_button_new_with_label (_("Clear"));
  gtk_widget_ref (clear_button);
  gtk_widget_show (clear_button);
  gtk_box_pack_start (GTK_BOX (hbox1), clear_button, FALSE, FALSE, 0);
  gtk_signal_connect_object (GTK_OBJECT (clear_button), "clicked",
                             GTK_SIGNAL_FUNC (callback_clear_text),text1);

  console->data.console.text=text1;
  g_timeout_add(REFRESH_PERIOD, callback_update_comms, console);
  
  gtk_key_snooper_install(callback_terminal_keysnoop, console);
                           /* send to callback with pointer to the text area */
  
  return vbox1;
}
#endif

#ifndef GTK2
GtkWidget* view_create_comms (feature* console)  /*create a comms window*/
{
  GtkWidget *vbox1;
  GtkWidget *scrolledwindow1;
  GtkWidget *text1;
  GtkWidget *hbox1;
  GtkWidget *entry1;
  GtkWidget *clear_button;

  vbox1 = gtk_vbox_new (FALSE, 0);
  gtk_widget_ref (vbox1);
  gtk_widget_show (vbox1);

  scrolledwindow1 = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_ref (scrolledwindow1);
  gtk_widget_show (scrolledwindow1);
  gtk_box_pack_start (GTK_BOX (vbox1), scrolledwindow1, TRUE, TRUE, 0);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow1), GTK_POLICY_NEVER, GTK_POLICY_ALWAYS);

  text1 = gtk_text_new (NULL, NULL);
  gtk_widget_ref (text1);
  gtk_widget_show (text1);
  gtk_container_add (GTK_CONTAINER (scrolledwindow1), text1);

  hbox1 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox1);
  gtk_widget_show (hbox1);
  gtk_box_pack_start (GTK_BOX (vbox1), hbox1, FALSE, FALSE, 0);

  entry1 = gtk_entry_new ();
  gtk_widget_ref (entry1);
  gtk_widget_show (entry1);
  gtk_box_pack_start (GTK_BOX (hbox1), entry1, FALSE, FALSE, 0);
  gtk_signal_connect (GTK_OBJECT(entry1), "activate",
                         GTK_SIGNAL_FUNC (callback_comms),console);
  
  
  
  clear_button = gtk_button_new_with_label (_("Clear"));
  gtk_widget_ref (clear_button);
  gtk_widget_show (clear_button);
  gtk_box_pack_start (GTK_BOX (hbox1), clear_button, FALSE, FALSE, 0);
  gtk_signal_connect_object (GTK_OBJECT (clear_button), "clicked",
                             GTK_SIGNAL_FUNC (callback_clear_text),GTK_OBJECT(text1));

  console->data.console.text=text1;
  g_timeout_add(REFRESH_PERIOD, callback_update_comms, console);
  
  gtk_key_snooper_install(callback_terminal_keysnoop, console);
                           /* send to callback with pointer to the text area */
  
  return vbox1;
}
#endif

#ifdef GTK2
GtkWidget* view_create_source (void)  /*create a source window*/
{
  GtkWidget *vbox1;
  GtkWidget *scrolledwindow1;
  GtkWidget *text1;

  vbox1 = gtk_vbox_new (FALSE, 0);
  gtk_widget_ref (vbox1);
  gtk_widget_show (vbox1);

  scrolledwindow1 = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_ref (scrolledwindow1);
  gtk_widget_show (scrolledwindow1);
  gtk_box_pack_start (GTK_BOX (vbox1), scrolledwindow1, TRUE, TRUE, 0);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow1), GTK_POLICY_NEVER, GTK_POLICY_ALWAYS);

  text1 = gtk_text_new (NULL, NULL);
  gtk_widget_ref (text1);
  gtk_widget_show (text1);
  gtk_container_add (GTK_CONTAINER (scrolledwindow1), text1);
  
  view_source= text1;
 
  
  return vbox1;
}
#endif

#ifndef GTK2
GtkWidget* view_create_source (void)  /*create a source window*/
{
  GtkWidget *vbox1;
  GtkWidget *scrolledwindow1;
  GtkWidget *text1;

  vbox1 = gtk_vbox_new (FALSE, 0);
  gtk_widget_ref (vbox1);
  gtk_widget_show (vbox1);

  scrolledwindow1 = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_ref (scrolledwindow1);
  gtk_widget_show (scrolledwindow1);
  gtk_box_pack_start (GTK_BOX (vbox1), scrolledwindow1, TRUE, TRUE, 0);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow1), GTK_POLICY_NEVER, GTK_POLICY_ALWAYS);

  text1 = gtk_text_new (NULL, NULL);
  gtk_widget_ref (text1);
  gtk_widget_show (text1);
  gtk_container_add (GTK_CONTAINER (scrolledwindow1), text1);

  view_source= text1;


  return vbox1;
}
#endif











GtkWidget* create_splashwindow (void)
{
  GtkWidget *vbox;  
  GtkWidget *pixmap;
  GtkWidget *view_splashwindow = gtk_window_new (GTK_WINDOW_POPUP);
  view_komodologo_pixmap = gdk_pixmap_colormap_create_from_xpm_d (NULL, gdk_colormap_get_system(), &view_komodologo_bitmap,NULL,komodologo_xpm);
  
  gtk_window_set_position (GTK_WINDOW(view_splashwindow),GTK_WIN_POS_CENTER);

  vbox = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox);
  gtk_container_add (GTK_CONTAINER (view_splashwindow), vbox);

  pixmap = gtk_pixmap_new  (view_komodologo_pixmap, view_komodologo_bitmap);
  gtk_widget_show (pixmap);
  gtk_box_pack_start (GTK_BOX (vbox), pixmap, FALSE, FALSE, 0);
  gtk_widget_ref (view_splashwindow);
  gtk_widget_show (view_splashwindow);
  gtk_widget_add_events  (view_splashwindow, 1);
  while (gtk_events_pending())  gtk_main_iteration();
  return view_splashwindow;
}



int view_show_pointer(GtkWidget* aboutwindow)
{
  static unsigned char cursor1_bits[] = {
   0x00, 0x00, 
   0x00, 0x00, 
   0xe0, 0x00, 
   0xf8, 0x07,
   
   0xfc, 0x0f, 
   0x0e, 0x1e, 
   0x0f, 0x3c, 
   0x07, 0x38, 

   0x07, 0x38, 
   0x07, 0x18, 
   0x06, 0x1c, 
   0x0e, 0x1c, 

   0x1c, 0x0c, 
   0x38, 0x00, 
   0xc0, 0x00, 
   0x00, 0x00};

  static unsigned char cursor1mask_bits[] = {
   0x00, 0x00, 
   0x7c, 0x00, 
   0xf0, 0x00, 
   0xf8, 0x07,

   0xfc, 0x0f, 
   0xfe, 0x1f, 
   0xff, 0x3f, 
   0xe7, 0x7f, 

   0xb7, 0xff, 
   0xbf, 0xdf, 
   0xd6, 0x1c, 
   0xce, 0x1c, 
   
   0x1c, 0x1c, 
   0x38, 0x18, 
   0xc0, 0x18, 
   0x00, 0x00};

  GdkCursor *cursor;
  GdkPixmap *source, *mask;
  GdkColor fg = { 0, 0, 0, 0 }; /* Black. */
  GdkColor bg = { 0, 0, 65535, 0 }; /* Blue. */

  static int a = 65535;
  static int b = 0;
  static int c = 0;
  int temp;
  
  bg.red=a;
  bg.green=b;
  bg.blue=c;
  
  temp = a;
  a=b;
  b=c;
  c=temp;

  source = gdk_bitmap_create_from_data (NULL, cursor1_bits,
					16, 16);
  mask = gdk_bitmap_create_from_data (NULL, cursor1mask_bits,
				      16, 16);
  cursor = gdk_cursor_new_from_pixmap (source, mask, &fg, &bg, 8, 8);
  gdk_pixmap_unref (source);
  gdk_pixmap_unref (mask);
  gdk_window_set_cursor (aboutwindow->window, cursor); 
  return 0;
}








GtkWidget*
create_aboutwindow (void)
{
  GtkWidget *aboutwindow;
  GtkWidget *hbox1;
  GtkWidget *pixmap1;
  GtkWidget *vbox;
  GtkWidget *vbox1;
  GtkWidget *label1;
  GtkWidget *button1;

  aboutwindow = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_position (GTK_WINDOW(aboutwindow),GTK_WIN_POS_CENTER);
  gtk_object_set_data (GTK_OBJECT (aboutwindow), "aboutwindow", aboutwindow);
  gtk_window_set_title (GTK_WINDOW (aboutwindow), _("About"));
  gtk_widget_ref (aboutwindow);

  vbox = gtk_vbox_new (FALSE, 0);
  gtk_widget_ref (vbox);
  gtk_object_set_data_full (GTK_OBJECT (aboutwindow), "vbox", vbox,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vbox);
  gtk_container_add (GTK_CONTAINER (aboutwindow), vbox);
  
  pixmap1 = gtk_pixmap_new  (view_komodotitle_pixmap, view_komodotitle_bitmap);
  gtk_widget_ref (pixmap1);
  gtk_object_set_data_full (GTK_OBJECT (aboutwindow), "pixmap1", pixmap1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (pixmap1);
  gtk_box_pack_start (GTK_BOX (vbox), pixmap1, FALSE, FALSE, 0);

  hbox1 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox1);
  gtk_object_set_data_full (GTK_OBJECT (aboutwindow), "hbox1", hbox1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox1);
  gtk_box_pack_start (GTK_BOX (vbox), hbox1, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (hbox1), 3);
  
  pixmap1 = gtk_pixmap_new  (view_mulogo_pixmap, view_mulogo_bitmap);
  gtk_widget_ref (pixmap1);
  gtk_object_set_data_full (GTK_OBJECT (aboutwindow), "pixmap1", pixmap1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (pixmap1);
  gtk_box_pack_start (GTK_BOX (hbox1), pixmap1, FALSE, FALSE, 0);

  vbox1 = gtk_vbox_new (FALSE, 0);
  gtk_widget_ref (vbox1);
  gtk_object_set_data_full (GTK_OBJECT (aboutwindow), "vbox1", vbox1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vbox1);
  gtk_box_pack_start (GTK_BOX (hbox1), vbox1, TRUE, TRUE, 0);

  label1 = gtk_label_new ((PACKAGE "\nVersion " VERSION " (" DATE ")\n\nCopyright " YEAR ":\nUniversity of Manchester\n\nAuthors:\nCharlie Brej\nhttp://www.cs.man.ac.uk/~brejc8\nJim Garside\nhttp://www.cs.man.ac.uk/amulet/staff/details/jim.html \n\nBug reports and feature requests:\n komodo@cs.man.ac.uk\nWebsite:\nhttp://www.cs.man.ac.uk/~brejc8/kmd/"));
  gtk_misc_set_padding (GTK_MISC (label1), 10, 10);
  gtk_widget_ref (label1);
  gtk_object_set_data_full (GTK_OBJECT (aboutwindow), "label1", label1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label1);
  gtk_box_pack_start (GTK_BOX (vbox1), label1, FALSE, FALSE, 0);

  button1 = gtk_button_new_with_label (_("Dismiss"));
  gtk_widget_ref (button1);
  gtk_object_set_data_full (GTK_OBJECT (aboutwindow), "button1", button1,
                            (GtkDestroyNotify) gtk_widget_unref);
  
  gtk_widget_show (button1);
  gtk_box_pack_start (GTK_BOX (vbox1), button1, FALSE, FALSE, 0);

  vbox1 = gtk_vbox_new (FALSE, 0);
  gtk_widget_ref (vbox1);  gtk_widget_show (vbox1);
  gtk_box_pack_start (GTK_BOX (hbox1), vbox1, TRUE, TRUE, 0);

  label1 = gtk_label_new ("Powered By");
  gtk_misc_set_padding (GTK_MISC (label1), 10, 10);
  gtk_widget_ref (label1);  
  gtk_widget_show (label1);
  gtk_box_pack_start (GTK_BOX (vbox1), label1, FALSE, FALSE, 0);
  
  pixmap1 = gtk_pixmap_new  (view_chump_pixmap, view_chump_bitmap);
  gtk_widget_ref (pixmap1);
  gtk_object_set_data_full (GTK_OBJECT (aboutwindow), "pixmap1", pixmap1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (pixmap1);
  gtk_box_pack_start (GTK_BOX (vbox1), pixmap1, TRUE, TRUE, 0);


  gtk_signal_connect_object (GTK_OBJECT (aboutwindow), "delete_event",
                            GTK_SIGNAL_FUNC (gtk_widget_hide),
                            GTK_OBJECT (aboutwindow));
  gtk_signal_connect_object (GTK_OBJECT (button1), "clicked",
                             GTK_SIGNAL_FUNC (gtk_widget_hide),
                             GTK_OBJECT (aboutwindow));





  gtk_signal_connect_object_after (GTK_OBJECT (aboutwindow), "show",
                                GTK_SIGNAL_FUNC (view_show_pointer),
                                GTK_OBJECT (aboutwindow));
                                
  return aboutwindow;
}



GtkWidget* view_create_prog_ctrl (void)
{ 
  GtkAccelGroup *accel_group = gtk_accel_group_new ();
  GtkWidget *hbox;
  GtkWidget *vbox;
  GtkWidget *button_start;
  GtkWidget *button_stop;
  GtkWidget *button_single;
  GtkObject *stepnumber_adj;
  GtkWidget *stepnumber;
  GtkWidget *button_multi;
  GtkWidget *cbutton_break;
  GtkWidget *cbutton_swi;
  GtkWidget *cbutton_proc;
  GtkWidget *label;
  
  const static int zero = 0;
  const static int one = 1;
  

  vbox = gtk_vbox_new (FALSE, 2);
  gtk_widget_ref (vbox);
  gtk_widget_show (vbox);
  
  hbox = gtk_hbox_new (FALSE, 4);
  gtk_widget_ref (hbox);
  gtk_widget_show (hbox);

  button_start = gtk_button_new_with_label (_("Run"));
  gtk_widget_ref (button_start);
  gtk_widget_show (button_start);
  gtk_box_pack_start (GTK_BOX (hbox), button_start, FALSE, FALSE, 0);
  gtk_signal_connect (GTK_OBJECT (button_start), "clicked",
                      GTK_SIGNAL_FUNC (callback_button_start),(gpointer)&zero);/* link to callback and pass stepcount*/
  gtk_widget_add_accelerator (button_start, "clicked", accel_group,
                              GDK_F5, 0, GTK_ACCEL_VISIBLE);
  gtk_tooltips_set_tip (view_tooltips, button_start, "Start execution [F5]", NULL);

  button_stop = gtk_button_new_with_label (_("Stop"));
  gtk_widget_ref (button_stop);
  gtk_widget_show (button_stop);
  gtk_box_pack_start (GTK_BOX (hbox), button_stop, FALSE, FALSE, 0);
  gtk_signal_connect (GTK_OBJECT (button_stop), "clicked",
                      GTK_SIGNAL_FUNC (callback_button_stop),NULL);
  gtk_widget_add_accelerator (button_stop, "clicked", accel_group,
                              GDK_F6, 0, GTK_ACCEL_VISIBLE);
  gtk_tooltips_set_tip (view_tooltips, button_stop, "Stop execution [F6]", NULL);

#ifndef SIMPLE_INTERFACE
  button_single = gtk_button_new_with_label (_("Single-Step"));
  gtk_widget_ref (button_single);
  gtk_widget_show (button_single);
  gtk_box_pack_start (GTK_BOX (hbox), button_single, FALSE, FALSE, 0);
  gtk_signal_connect (GTK_OBJECT (button_single), "clicked",
                      GTK_SIGNAL_FUNC (callback_button_start),(gpointer)&one);
  gtk_widget_add_accelerator (button_single, "clicked", accel_group,
                              GDK_F7, 0, GTK_ACCEL_VISIBLE);
  gtk_tooltips_set_tip (view_tooltips, button_single, "Take one step [F7]", NULL);
#endif

  button_single = gtk_button_new_with_label (_("Step-In"));
  gtk_widget_ref (button_single);
  gtk_widget_show (button_single);
  gtk_box_pack_start (GTK_BOX (hbox), button_single, FALSE, FALSE, 0);
    {
    custom_start* command = g_new(custom_start,1);
    command->steps=1;
    command->command=BR_START|0x30;
    gtk_signal_connect (GTK_OBJECT (button_single), "clicked",
                      GTK_SIGNAL_FUNC (callback_button_start_custom),(gpointer)command);
    }
#ifdef SIMPLE_INTERFACE
  gtk_widget_add_accelerator (button_single, "clicked", accel_group,
                              GDK_F7, 0, GTK_ACCEL_VISIBLE);
  gtk_tooltips_set_tip (view_tooltips, button_single, "Take one step, stepping into functions [F7]", NULL);
#endif

#ifndef SIMPLE_INTERFACE
  gtk_tooltips_set_tip (view_tooltips, button_single, "Take one step, stepping into functions", NULL);
#endif

  button_single = gtk_button_new_with_label (_("Step-Out"));
  gtk_widget_ref (button_single);
  gtk_widget_show (button_single);
  gtk_box_pack_start (GTK_BOX (hbox), button_single, FALSE, FALSE, 0);
    {
    custom_start* command = g_new(custom_start,1);
    command->steps=1;
    command->command=BR_START|0x32;
    gtk_signal_connect (GTK_OBJECT (button_single), "clicked",
                      GTK_SIGNAL_FUNC (callback_button_start_custom),(gpointer)command);
    }
  gtk_tooltips_set_tip (view_tooltips, button_single, "Take one step, stepping out and over functions", NULL);

  button_multi = gtk_button_new_with_label (_("Multi-Step"));
  gtk_widget_ref (button_multi);
  gtk_widget_show (button_multi);
  gtk_box_pack_start (GTK_BOX (hbox), button_multi, FALSE, FALSE, 0);
  gtk_signal_connect (GTK_OBJECT (button_multi), "clicked",
                      GTK_SIGNAL_FUNC (callback_button_start),(gpointer)&view_step_number);
  gtk_widget_add_accelerator (button_multi, "clicked", accel_group,
                              GDK_F8, 0, GTK_ACCEL_VISIBLE);
  gtk_tooltips_set_tip (view_tooltips, button_multi, "Take a number of steps [F8]", NULL);
  
  stepnumber_adj = gtk_adjustment_new (1, 1, 2000000000, 1, 1000, 10);
  stepnumber = gtk_spin_button_new (GTK_ADJUSTMENT (stepnumber_adj), 1, 0);
  gtk_widget_ref (stepnumber);
  gtk_widget_show (stepnumber);
  gtk_box_pack_start (GTK_BOX (hbox), stepnumber, FALSE, FALSE, 0);
  gtk_signal_connect (GTK_OBJECT (stepnumber), "changed",
                      GTK_SIGNAL_FUNC (callback_step_number), &view_step_number);
  gtk_widget_set_usize (stepnumber, 70, -2);
  gtk_tooltips_set_tip (view_tooltips, stepnumber, "Change number of steps to take. Remember to press return after entering a new value", NULL);
  
  button_multi = gtk_button_new_with_label (_("Walk"));
  gtk_widget_ref (button_multi);
  gtk_widget_show (button_multi);
  gtk_box_pack_start (GTK_BOX (hbox), button_multi, FALSE, FALSE, 0);
  gtk_signal_connect (GTK_OBJECT (button_multi), "clicked",
                      GTK_SIGNAL_FUNC (callback_button_walk),(gpointer)&view_step_number);
  gtk_widget_add_accelerator (button_multi, "clicked", accel_group,
                              GDK_F9, 0, GTK_ACCEL_VISIBLE);
  gtk_tooltips_set_tip (view_tooltips, button_multi, "Repeatedly take a number of steps [F9]", NULL);
  
  stepnumber_adj = gtk_adjustment_new (1000, 1, 10000, 1, 1000, 10);
  stepnumber = gtk_spin_button_new (GTK_ADJUSTMENT (stepnumber_adj), 1, 0);
  gtk_widget_ref (stepnumber);
  gtk_widget_show (stepnumber);
  gtk_box_pack_start (GTK_BOX (hbox), stepnumber, FALSE, FALSE, 0);
  gtk_signal_connect (GTK_OBJECT (stepnumber), "changed",
                      GTK_SIGNAL_FUNC (callback_step_number), &view_step_freq);
  gtk_widget_set_usize (stepnumber, 70, -2);
  gtk_tooltips_set_tip (view_tooltips, stepnumber, "Change period (ms) between steps when walking. Remember to press return after entering a new value", NULL);
                              
  button_multi = gtk_button_new_with_label (_("Continue"));
  gtk_widget_ref (button_multi);
  gtk_widget_show (button_multi);
  gtk_box_pack_start (GTK_BOX (hbox), button_multi, FALSE, FALSE, 0);
  gtk_signal_connect (GTK_OBJECT (button_multi), "clicked",
                      GTK_SIGNAL_FUNC (callback_button_continue),NULL);
  gtk_widget_add_accelerator (button_multi, "clicked", accel_group,
                              GDK_F10, 0, GTK_ACCEL_VISIBLE);
  gtk_tooltips_set_tip (view_tooltips, button_multi, "Continue execution [F10]", NULL);
  
  view_step_number=1;
  view_step_freq=1000;
  
  gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);
  hbox = gtk_hbox_new (FALSE, 4);
  gtk_widget_ref (hbox);
  gtk_widget_show (hbox);
 
  cbutton_break = gtk_check_button_new_with_label ("Breakpoints");
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(cbutton_break),TRUE);
  gtk_widget_ref (cbutton_break);
  gtk_widget_show (cbutton_break);
  gtk_box_pack_start (GTK_BOX (hbox), cbutton_break, FALSE, FALSE, 0);
  gtk_signal_connect (GTK_OBJECT (cbutton_break), "toggled",
                      GTK_SIGNAL_FUNC (callback_start_toggle), GINT_TO_POINTER(0x10));
  gtk_tooltips_set_tip (view_tooltips, cbutton_break, "Activate breakpoints", NULL);

  cbutton_break = gtk_check_button_new_with_label ("Watchpoints");
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(cbutton_break),TRUE);
  gtk_widget_ref (cbutton_break);
  gtk_widget_show (cbutton_break);
  gtk_box_pack_start (GTK_BOX (hbox), cbutton_break, FALSE, FALSE, 0);
  gtk_signal_connect (GTK_OBJECT (cbutton_break), "toggled",
                      GTK_SIGNAL_FUNC (callback_start_toggle), GINT_TO_POINTER(0x20));
  gtk_tooltips_set_tip (view_tooltips, cbutton_break, "Activate watchpoints", NULL);

  label = gtk_label_new("Service:");
  gtk_widget_ref (label);   gtk_widget_show (label);
  gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 0);

  cbutton_swi = gtk_check_button_new_with_label ("SWI");
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(cbutton_swi),FALSE);
  gtk_widget_ref (cbutton_swi);
  gtk_widget_show (cbutton_swi);
  gtk_box_pack_start (GTK_BOX (hbox), cbutton_swi, FALSE, FALSE, 0);
  gtk_signal_connect (GTK_OBJECT (cbutton_swi), "toggled",
                      GTK_SIGNAL_FUNC (callback_start_toggle), GINT_TO_POINTER(0x4));
  gtk_tooltips_set_tip (view_tooltips, cbutton_swi, "Enter software interrupt code", NULL);

  cbutton_proc = gtk_check_button_new_with_label ("BL");
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(cbutton_proc),FALSE);
  gtk_widget_ref (cbutton_proc);
  gtk_widget_show (cbutton_proc);
  gtk_box_pack_start (GTK_BOX (hbox), cbutton_proc, FALSE, FALSE, 0);
  gtk_signal_connect (GTK_OBJECT (cbutton_proc), "toggled",
                      GTK_SIGNAL_FUNC (callback_start_toggle), GINT_TO_POINTER(0x2));
  gtk_tooltips_set_tip (view_tooltips, cbutton_proc, "Enter sub-procedure code", NULL);
  
  cbutton_proc = gtk_check_button_new_with_label ("Abort");
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(cbutton_proc),FALSE);
  gtk_widget_ref (cbutton_proc);                    gtk_widget_show (cbutton_proc); 
  gtk_box_pack_start (GTK_BOX (hbox), cbutton_proc, FALSE, FALSE, 0);
  gtk_signal_connect (GTK_OBJECT (cbutton_proc), "toggled",
                      GTK_SIGNAL_FUNC (callback_start_toggle), GINT_TO_POINTER(0x8));
  gtk_tooltips_set_tip (view_tooltips, cbutton_proc, "Enter Bad Memory access exception code", NULL);
  
  label = gtk_label_new("Active:");
  gtk_widget_ref (label);   gtk_widget_show (label);
  gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 0);


  cbutton_proc = gtk_check_button_new_with_label ("IRQ");
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(cbutton_proc),FALSE);
  gtk_widget_ref (cbutton_proc);
  gtk_widget_show (cbutton_proc);
  gtk_box_pack_start (GTK_BOX (hbox), cbutton_proc, FALSE, FALSE, 0);
  gtk_signal_connect (GTK_OBJECT (cbutton_proc), "toggled",
                      GTK_SIGNAL_FUNC (callback_rtf_toggle), GINT_TO_POINTER(0x2));
  gtk_tooltips_set_tip (view_tooltips, cbutton_proc, "Activate automatic execution of interrupt code", NULL);
  
  cbutton_proc = gtk_check_button_new_with_label ("FIQ");
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(cbutton_proc),FALSE);
  gtk_widget_ref (cbutton_proc);                    gtk_widget_show (cbutton_proc); 
  gtk_box_pack_start (GTK_BOX (hbox), cbutton_proc, FALSE, FALSE, 0);
  gtk_signal_connect (GTK_OBJECT (cbutton_proc), "toggled",
                      GTK_SIGNAL_FUNC (callback_rtf_toggle), GINT_TO_POINTER(0x1));
  gtk_tooltips_set_tip (view_tooltips, cbutton_proc, "Activate automatic execution of Fast interrupt code", NULL);
  
  cbutton_proc = gtk_toggle_button_new_with_label ("Refresh");
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(cbutton_proc),FALSE);
  gtk_widget_ref (cbutton_proc);                    gtk_widget_show (cbutton_proc);
  gtk_box_pack_start (GTK_BOX (hbox), cbutton_proc, FALSE, FALSE, 0);
  gtk_signal_connect (GTK_OBJECT (cbutton_proc), "toggled",
                      GTK_SIGNAL_FUNC (callback_refresh_toggle), NULL);
  gtk_tooltips_set_tip (view_tooltips, cbutton_proc, "Reguraly refresh screen", NULL);
  view_refreshbutton = cbutton_proc;

  
  
  
  
  
#ifndef SIMPLE_INTERFACE
  gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);
#endif


  hbox = gtk_hbox_new (FALSE, 4);
  gtk_widget_ref (hbox);
  gtk_widget_show (hbox);
 
#ifndef SIMPLE_INTERFACE
  button_start = gtk_button_new_with_label ("Ping");
  gtk_widget_ref (button_start);
  gtk_widget_show (button_start);
  gtk_box_pack_start (GTK_BOX (hbox), button_start, FALSE, FALSE, 0);
  gtk_signal_connect (GTK_OBJECT (button_start), "clicked",
                      GTK_SIGNAL_FUNC (callback_button_ping),NULL);
  gtk_tooltips_set_tip (view_tooltips, button_start, "Ping board and refresh display", NULL);
                      
  button_start = gtk_button_new_with_label ("Reset");
  gtk_widget_ref (button_start);
  gtk_widget_show (button_start);
  gtk_box_pack_start (GTK_BOX (hbox), button_start, FALSE, FALSE, 0);
  gtk_signal_connect (GTK_OBJECT (button_start), "clicked",
                      GTK_SIGNAL_FUNC (callback_button_reset),NULL);
  gtk_tooltips_set_tip (view_tooltips, button_start, "Reset board", NULL);
#endif
                      
                      
   
      
      
                      
  breakpoint_mask=0;
  button_start = gtk_button_new_with_label ("Breakpoints");
  gtk_widget_ref (button_start);
#ifndef SIMPLE_INTERFACE
  gtk_widget_show (button_start);
#endif

  gtk_box_pack_start (GTK_BOX (hbox), button_start, FALSE, FALSE, 0);
  view_breakwindow[0][0] = create_breakwindow();
  gtk_widget_ref (view_breakwindow[0][0]);
//  gtk_signal_connect_object(GTK_OBJECT (button_start), "clicked", gtk_widget_show ,GTK_OBJECT (view_breakwindow[0][0]));
  gtk_signal_connect_object(GTK_OBJECT (button_start), "clicked", callback_window_raise ,GTK_OBJECT (view_breakwindow[0][0]));

  gtk_tooltips_set_tip (view_tooltips, button_start, "Open Breakpoints window", NULL);
  gtk_signal_connect(GTK_OBJECT(GTK_MENU_SHELL(gtk_option_menu_get_menu(GTK_OPTION_MENU(gtk_object_get_data (GTK_OBJECT(view_breakwindow[0][0]),"optionaddress"))))), "selection-done",GTK_SIGNAL_FUNC(breakpoint_toggled),GINT_TO_POINTER(breakpoint_mask|0x4));
  gtk_signal_connect(GTK_OBJECT(GTK_MENU_SHELL(gtk_option_menu_get_menu(GTK_OPTION_MENU(gtk_object_get_data (GTK_OBJECT(view_breakwindow[0][0]),"optiondata"))))), "selection-done",GTK_SIGNAL_FUNC(breakpoint_toggled),GINT_TO_POINTER(breakpoint_mask|0x1));
  
   {
    int temp;
    char *startdata[] = {"","Address A","<X<","Address B","Data A","<X<","Data B","other"};
    GtkWidget* clist = gtk_object_get_data (GTK_OBJECT(view_breakwindow[0][0]),"clist");
    for (temp=0;temp < 32;temp++) gtk_clist_append(GTK_CLIST(clist),startdata);
    gtk_widget_set_style(clist,fixed_style);
   }
  breakpoint_line[0][0]=0;
  breakpoint_select( GTK_CLIST(gtk_object_get_data (GTK_OBJECT(view_breakwindow[0][0]),"clist")),breakpoint_line[0][0],0,NULL,NULL);
  

  
  breakpoint_mask=0x100000;
  
#ifndef SIMPLE_INTERFACE
  button_start = gtk_button_new_with_label ("Simple-Breakpoints");
#endif

#ifdef SIMPLE_INTERFACE
  button_start = gtk_button_new_with_label ("Breakpoints");
#endif

  gtk_widget_ref (button_start);
  gtk_widget_show (button_start);
  gtk_box_pack_start (GTK_BOX (hbox), button_start, FALSE, FALSE, 0);
  view_breakwindow[1][0] = create_simplebreakwindow();
  gtk_widget_ref (view_breakwindow[1][0]);
//  gtk_signal_connect_object(GTK_OBJECT (button_start), "clicked", gtk_widget_show ,GTK_OBJECT (view_breakwindow[1][0]));
  gtk_signal_connect_object(GTK_OBJECT (button_start), "clicked", callback_window_raise ,GTK_OBJECT (view_breakwindow[1][0]));
  gtk_tooltips_set_tip (view_tooltips, button_start, "Open Simplified Breakpoints window", NULL);

   {
    int temp;
    char *startdata[] = {"","Address"};
    GtkWidget* clist = gtk_object_get_data (GTK_OBJECT(view_breakwindow[1][0]),"clist");
    for (temp=0;temp < 32;temp++) gtk_clist_append(GTK_CLIST(clist),startdata);
    gtk_widget_set_style(clist,fixed_style);
   }
  breakpoint_line[1][0]=0;
  breakpoint_refresh (0);
  breakpoint_select( GTK_CLIST(gtk_object_get_data (GTK_OBJECT(view_breakwindow[1][0]),"clist")),breakpoint_line[1][0],0,NULL,NULL);
  
  
  
  
  
  


  breakpoint_mask=0x10000;
  button_start = gtk_button_new_with_label ("Watchpoints");
  gtk_widget_ref (button_start);
#ifndef SIMPLE_INTERFACE
  gtk_widget_show (button_start);
#endif
  gtk_box_pack_start (GTK_BOX (hbox), button_start, FALSE, FALSE, 0);
  view_breakwindow[0][1] = create_breakwindow();
  gtk_window_set_title (GTK_WINDOW(view_breakwindow[0][1]),"Watchpoints");
//  gtk_signal_connect_object(GTK_OBJECT (button_start), "clicked", gtk_widget_show ,GTK_OBJECT (view_breakwindow[0][1]));
  gtk_signal_connect_object(GTK_OBJECT (button_start), "clicked", callback_window_raise ,GTK_OBJECT (view_breakwindow[0][1]));
  gtk_tooltips_set_tip (view_tooltips, button_start, "Open Watchpoints window", NULL);
  gtk_signal_connect(GTK_OBJECT(GTK_MENU_SHELL(gtk_option_menu_get_menu(GTK_OPTION_MENU(gtk_object_get_data (GTK_OBJECT(view_breakwindow[0][1]),"optionaddress"))))), "selection-done",GTK_SIGNAL_FUNC(breakpoint_toggled),GINT_TO_POINTER(breakpoint_mask|0x4));
  gtk_signal_connect(GTK_OBJECT(GTK_MENU_SHELL(gtk_option_menu_get_menu(GTK_OPTION_MENU(gtk_object_get_data (GTK_OBJECT(view_breakwindow[0][1]),"optiondata"))))), "selection-done",GTK_SIGNAL_FUNC(breakpoint_toggled),GINT_TO_POINTER(breakpoint_mask|0x1));
   {
    int temp;
    char *startdata[] = {"","Address A","<X<","Address B","Data A","<X<","Data B","other"};
    GtkWidget* clist = gtk_object_get_data (GTK_OBJECT(view_breakwindow[0][1]),"clist");
    for (temp=0;temp < 32;temp++) gtk_clist_append(GTK_CLIST(clist),startdata);
    gtk_widget_set_style(clist,fixed_style);
   }
  breakpoint_line[0][1]=0;
  breakpoint_select( GTK_CLIST(gtk_object_get_data (GTK_OBJECT(view_breakwindow[0][1]),"clist")),breakpoint_line[0][1],0,NULL,NULL);
  
  
  breakpoint_mask=0x110000;
#ifndef SIMPLE_INTERFACE
  button_start = gtk_button_new_with_label ("Simple-Watchpoints");
#endif

#ifdef SIMPLE_INTERFACE
  button_start = gtk_button_new_with_label ("Watchpoints");
#endif
  gtk_widget_ref (button_start);
  gtk_widget_show (button_start);
  gtk_box_pack_start (GTK_BOX (hbox), button_start, FALSE, FALSE, 0);
  view_breakwindow[1][1] = create_simplebreakwindow();
  gtk_widget_ref (view_breakwindow[1][1]);
  gtk_window_set_title (GTK_WINDOW(view_breakwindow[1][1]),"Simple-Watchpoints");
//  gtk_signal_connect_object(GTK_OBJECT (button_start), "clicked", gtk_widget_show ,GTK_OBJECT (view_breakwindow[1][1]));
  gtk_signal_connect_object(GTK_OBJECT (button_start), "clicked", callback_window_raise ,GTK_OBJECT (view_breakwindow[1][1]));

  gtk_tooltips_set_tip (view_tooltips, button_start, "Open Simplified Watchpoints window", NULL);

   {
    int temp;
    char *startdata[] = {"","Address"};
    GtkWidget* clist = gtk_object_get_data (GTK_OBJECT(view_breakwindow[1][1]),"clist");
    for (temp=0;temp < 32;temp++) gtk_clist_append(GTK_CLIST(clist),startdata);
    gtk_widget_set_style(clist,fixed_style);
   }
  breakpoint_line[1][1]=0;
  breakpoint_refresh (1);
  breakpoint_select( GTK_CLIST(gtk_object_get_data (GTK_OBJECT(view_breakwindow[1][0]),"clist")),breakpoint_line[1][1],0,NULL,NULL);


  view_enqlabel = gtk_label_new("KMD started spacer spacer spacer");
  gtk_widget_ref (view_enqlabel);   gtk_widget_show (view_enqlabel);
  gtk_box_pack_start (GTK_BOX (hbox), view_enqlabel, FALSE, FALSE, 0);
  
  view_steplabel = gtk_label_new(NULL);
  gtk_widget_ref (view_steplabel);   gtk_widget_show (view_steplabel);
  gtk_box_pack_start (GTK_BOX (hbox), view_steplabel, FALSE, FALSE, 0);
  
  
  gtk_window_add_accel_group (GTK_WINDOW (view_mainwindow), accel_group);
  gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);
  
  
  return vbox;
}

GtkWidget* view_create_memory_clist (void)
{
  
  GtkWidget *clist;
  GtkWidget *scrolledwindow;           /*create memwindow*/
  GtkWidget *label;
  GtkWidget *hbox;
  GtkWidget *vbox;
  GtkWidget *hbox1;
  GtkWidget *hbox2;
  GtkWidget *vbox1;
  GtkWidget *entry;
  
  GtkWidget *optionmenu_length;
  GtkWidget *optionmenu_isa;
  GtkWidget *optionmenu_menu;
  GtkWidget *menuitem;
  GtkObject *listsize_adj;
  GtkWidget *listsize;
  GtkWidget *cbutton;
  GtkWidget *vscale;
  GtkObject *vscale_adj;
  char *startdata[] = {"Address","Hex","Hex","Hex","Hex","ASCII","DISS"};
  char *slidelabeldata[] = {"-1000","-100","-10","0","+10","+100","+1000"};
  int temp;
  DefinitionStack* isa_list;
  
  
  
  mem_window *memwindow = g_new(mem_window,1);
  mem_window_list **memwindowlist = &view_memwindowlist;
  
  while (NULL != *memwindowlist) memwindowlist = &((*memwindowlist)->next);
  *memwindowlist = g_new(mem_window_list,1);
  (*memwindowlist)->mem_data_ptr = memwindow;
  (*memwindowlist)->next = NULL;
  
  hbox = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox);   gtk_widget_show (hbox);
  gtk_object_set_data (GTK_OBJECT (hbox), "mem_window", memwindow);
  
  vbox = gtk_vbox_new (FALSE, 0);
  gtk_widget_ref (vbox);
  gtk_widget_show (vbox);
  gtk_box_pack_start (GTK_BOX (hbox), vbox, TRUE, TRUE, 0);
  
  memwindow->address= g_new0(uchar,4);
  memwindow->regoffset = board_nulreg;
  memwindow->count=46;
  memwindow->width=4;
  memwindow->gran=4;
//  memwindow->wait=100;
//  memwindow->timer=0;
  
  vscale_adj = gtk_adjustment_new (0, -3.25, 3.25, 3, 3, 0);
  vscale = gtk_vscale_new (GTK_ADJUSTMENT (vscale_adj));
  gtk_widget_ref (vscale);  gtk_widget_show (vscale);
  gtk_box_pack_start (GTK_BOX (hbox), vscale, FALSE, FALSE, 0);
  gtk_scale_set_draw_value (GTK_SCALE (vscale), FALSE);
  gtk_scale_set_digits(GTK_SCALE (vscale), 2);
  gtk_range_set_update_policy (GTK_RANGE (vscale), GTK_UPDATE_CONTINUOUS);
  gtk_signal_connect (GTK_OBJECT (vscale_adj), "value_changed",
                      GTK_SIGNAL_FUNC (callback_memwindow_scrollmove), NULL);
  gtk_signal_connect (GTK_OBJECT (vscale), "button-release-event",
                      GTK_SIGNAL_FUNC (callback_memwindow_scrollrelease), NULL);
  gtk_signal_connect_after (GTK_OBJECT (vscale), "key-press-event",
                      GTK_SIGNAL_FUNC (callback_memwindow_scrollrelease), NULL);
  gtk_object_set_data (GTK_OBJECT (vscale_adj), "mem_window", memwindow);
  memwindow->scroll = vscale;
  
  vbox1 = gtk_vbox_new (TRUE, 0);
  gtk_widget_ref (vbox1);
  gtk_widget_show (vbox1);
  gtk_box_pack_start (GTK_BOX (hbox), vbox1, FALSE, FALSE, 0);
  
for (temp=0;temp<7;temp++){
    label = gtk_label_new (slidelabeldata[temp]);
    gtk_widget_ref (label);
  gtk_widget_show (label);
    gtk_box_pack_start (GTK_BOX (vbox1), label, FALSE, FALSE, 0);
    }

  hbox1 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox1);
  gtk_widget_show (hbox1);
  gtk_box_pack_start (GTK_BOX (vbox), hbox1, FALSE, FALSE, 0);
  
  hbox2 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox2);
  gtk_widget_show (hbox2);
  gtk_box_pack_start (GTK_BOX (vbox), hbox2, FALSE, FALSE, 0);
    
  optionmenu_length = gtk_option_menu_new();
  gtk_widget_ref (optionmenu_length);
  gtk_widget_show (optionmenu_length);
  optionmenu_menu = gtk_menu_new();
  gtk_widget_ref (optionmenu_menu);

  menuitem = gtk_menu_item_new_with_label (_("Byte"));
  gtk_widget_show (menuitem);
  gtk_menu_append (GTK_MENU (optionmenu_menu), menuitem);
  gtk_signal_connect (GTK_OBJECT(menuitem), "activate",
                   GTK_SIGNAL_FUNC (callback_memwindow_length),(gpointer)0x11);

#ifndef SIMPLE_INTERFACE
  menuitem = gtk_menu_item_new_with_label (_("Byte Byte"));
  gtk_widget_show (menuitem);
  gtk_menu_append (GTK_MENU (optionmenu_menu), menuitem);
  gtk_signal_connect (GTK_OBJECT(menuitem), "activate",
                   GTK_SIGNAL_FUNC (callback_memwindow_length),(gpointer)0x12);
#endif

#ifndef SIMPLE_INTERFACE
  menuitem = gtk_menu_item_new_with_label ("Byte Byte Byte Byte");
  gtk_widget_show (menuitem);
  gtk_menu_append (GTK_MENU (optionmenu_menu), menuitem);
  gtk_signal_connect (GTK_OBJECT(menuitem), "activate",
                   GTK_SIGNAL_FUNC (callback_memwindow_length),(gpointer)0x14);
#endif

  menuitem = gtk_menu_item_new_with_label (_("Half"));
  gtk_widget_show (menuitem);
  gtk_menu_append (GTK_MENU (optionmenu_menu), menuitem);
  gtk_signal_connect (GTK_OBJECT(menuitem), "activate",
                   GTK_SIGNAL_FUNC (callback_memwindow_length),(gpointer)0x22);


#ifndef SIMPLE_INTERFACE
  menuitem = gtk_menu_item_new_with_label (_("Half Half"));
  gtk_widget_show (menuitem);
  gtk_menu_append (GTK_MENU (optionmenu_menu), menuitem);
  gtk_signal_connect (GTK_OBJECT(menuitem), "activate",
                   GTK_SIGNAL_FUNC (callback_memwindow_length),(gpointer)0x24);
#endif

#ifndef SIMPLE_INTERFACE
  menuitem = gtk_menu_item_new_with_label (_("Half Half Half Half"));
  gtk_widget_show (menuitem);
  gtk_menu_append (GTK_MENU (optionmenu_menu), menuitem);
  gtk_signal_connect (GTK_OBJECT(menuitem), "activate",
                   GTK_SIGNAL_FUNC (callback_memwindow_length),(gpointer)0x28);
#endif

  menuitem = gtk_menu_item_new_with_label (_("Word"));
  gtk_widget_show (menuitem);
  gtk_menu_append (GTK_MENU (optionmenu_menu), menuitem);
  gtk_signal_connect (GTK_OBJECT(menuitem), "activate",
                   GTK_SIGNAL_FUNC (callback_memwindow_length),(gpointer)0x44);

#ifndef SIMPLE_INTERFACE
  menuitem = gtk_menu_item_new_with_label ("Word Word");
  gtk_widget_show (menuitem);
  gtk_menu_append (GTK_MENU (optionmenu_menu), menuitem);
  gtk_signal_connect (GTK_OBJECT(menuitem), "activate",
                   GTK_SIGNAL_FUNC (callback_memwindow_length),(gpointer)0x48);
#endif

  menuitem = gtk_menu_item_new_with_label ("Double");
  gtk_widget_show (menuitem);
  gtk_menu_append (GTK_MENU (optionmenu_menu), menuitem);
  gtk_signal_connect (GTK_OBJECT(menuitem), "activate",
                   GTK_SIGNAL_FUNC (callback_memwindow_length),(gpointer)0x88);




  gtk_option_menu_set_menu (GTK_OPTION_MENU (optionmenu_length),
                                             optionmenu_menu);
                                             
#ifdef SIMPLE_INTERFACE
  gtk_option_menu_set_history     (GTK_OPTION_MENU (optionmenu_length), 2);
#endif

#ifndef SIMPLE_INTERFACE
  gtk_option_menu_set_history     (GTK_OPTION_MENU (optionmenu_length), 6);
#endif

  gtk_box_pack_start (GTK_BOX (hbox1), optionmenu_length, TRUE, TRUE, 0);
  gtk_object_set_data (GTK_OBJECT (optionmenu_menu), "mem_window", memwindow);






  optionmenu_isa = gtk_option_menu_new();
  gtk_widget_ref (optionmenu_isa);
  gtk_widget_show (optionmenu_isa);
  optionmenu_menu = gtk_menu_new();
  gtk_widget_ref (optionmenu_menu);
  
  isa_list = board_asm_tables;
  while (isa_list){
    menuitem = gtk_menu_item_new_with_label (isa_list->string);
    gtk_widget_show (menuitem);
    gtk_menu_prepend (GTK_MENU (optionmenu_menu), menuitem);
    gtk_signal_connect (GTK_OBJECT(menuitem), "activate",
                      GTK_SIGNAL_FUNC (callback_memwindow_isa),(gpointer)isa_list->rules);
    memwindow->isa = isa_list->rules;
    isa_list=isa_list->next;
    }


  gtk_option_menu_set_menu (GTK_OPTION_MENU (optionmenu_isa),
                                             optionmenu_menu);
  gtk_box_pack_start (GTK_BOX (hbox1), optionmenu_isa, TRUE, TRUE, 0);
  gtk_object_set_data (GTK_OBJECT (optionmenu_menu), "mem_window", memwindow);





#ifndef SIMPLE_INTERFACE
  listsize_adj = gtk_adjustment_new (46, 0, 40, 1, 1, 1);
  listsize = gtk_spin_button_new (GTK_ADJUSTMENT (listsize_adj), 1, 0);
  gtk_widget_ref (listsize);
  gtk_widget_show (listsize);
  gtk_box_pack_start (GTK_BOX (hbox1), listsize, TRUE, TRUE, 0);
  gtk_signal_connect (GTK_OBJECT (listsize), "changed",
                      GTK_SIGNAL_FUNC (callback_memwindow_listsize), 0);
  
#endif

  cbutton = gtk_check_button_new_with_label (_("ASCII"));
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(cbutton),TRUE);
  gtk_widget_ref (cbutton);
  gtk_widget_show (cbutton);
  gtk_box_pack_start (GTK_BOX (hbox1), cbutton, FALSE, FALSE, 0);
  gtk_signal_connect (GTK_OBJECT(cbutton), "toggled",
                   GTK_SIGNAL_FUNC (callback_memwindow_ascii_toggle),NULL);

  cbutton = gtk_check_button_new_with_label (_("Disassembly"));
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(cbutton),TRUE);
  gtk_widget_ref (cbutton);
  gtk_widget_show (cbutton);
  gtk_box_pack_start (GTK_BOX (hbox1), cbutton, FALSE, FALSE, 0);
  gtk_signal_connect (GTK_OBJECT(cbutton), "toggled",
                   GTK_SIGNAL_FUNC (callback_memwindow_dis_toggle),NULL);
  
  
  
  
  
  
  entry = gtk_entry_new_with_max_length (40);
  memwindow->address_entry=entry;
  gtk_widget_ref (entry);
  gtk_widget_show (entry);
  gtk_box_pack_start (GTK_BOX (hbox2), entry, FALSE, TRUE, 0);
  gtk_widget_set_usize (entry, 107, -2);
  gtk_widget_set_style(entry,fixed_style);
  gtk_signal_connect (GTK_OBJECT(entry), "activate",
                   GTK_SIGNAL_FUNC (callback_memwindow_address),NULL);

  entry = gtk_entry_new_with_max_length (64);
  memwindow->hex_entry=entry;
  gtk_widget_ref (entry);
  gtk_widget_show (entry);
  gtk_box_pack_start (GTK_BOX (hbox2), entry, FALSE, TRUE,0);
  gtk_widget_set_usize (entry, 200, -2);
  gtk_widget_set_style(entry,fixed_style);
  gtk_signal_connect_after (GTK_OBJECT(entry), "activate",
                  GTK_SIGNAL_FUNC (callback_memwindow_hex),NULL);

  entry = gtk_entry_new_with_max_length (30);
  memwindow->ascii_entry=entry;
  gtk_widget_ref (entry);
  gtk_widget_show (entry);
  gtk_box_pack_start (GTK_BOX (hbox2), entry, FALSE, TRUE, 0);
  gtk_widget_set_usize (entry, 87, -2);
  gtk_widget_set_style(entry,fixed_style);
  gtk_signal_connect_after (GTK_OBJECT(entry), "activate",
                  GTK_SIGNAL_FUNC (callback_memwindow_ascii),NULL);

  entry = gtk_entry_new_with_max_length (200);
  memwindow->dis_entry=entry;
  gtk_widget_ref (entry);
  gtk_widget_show (entry);
  gtk_box_pack_start (GTK_BOX (hbox2), entry, FALSE, TRUE, 0);
  gtk_widget_set_usize (entry, 257, -2);
  gtk_widget_set_style(entry,fixed_style);
  gtk_signal_connect_after (GTK_OBJECT(entry), "activate",
                  GTK_SIGNAL_FUNC (callback_memwindow_dis),NULL);

  entry = gtk_label_new (_("  "));
  gtk_widget_ref (entry);  gtk_widget_show (entry);
  gtk_box_pack_start (GTK_BOX (hbox2), entry, FALSE, TRUE, 0);
 
  
  
  
  scrolledwindow = gtk_scrolled_window_new (NULL, NULL);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow),
                                  GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);
  gtk_widget_show (scrolledwindow);
  gtk_box_pack_end (GTK_BOX (vbox), scrolledwindow, TRUE, TRUE, 0);

  clist = gtk_clist_new (7);
  memwindow->clist_ptr = clist;
  for (temp=0;temp < memwindow->count;temp++)
                        gtk_clist_append(GTK_CLIST(clist),startdata);

  gtk_clist_set_selection_mode (GTK_CLIST (clist), GTK_SELECTION_BROWSE);
  gtk_signal_connect (GTK_OBJECT(clist), "select-row",
                   GTK_SIGNAL_FUNC (callback_memwindow_clist),NULL);
  gtk_widget_show (clist);
  gtk_container_add (GTK_CONTAINER (scrolledwindow), clist);
  gtk_clist_set_column_width (GTK_CLIST (clist), 0, 100);
  gtk_clist_set_column_width (GTK_CLIST (clist), 1, 193);
  gtk_clist_set_column_width (GTK_CLIST (clist), 2, 200);
  gtk_clist_set_column_width (GTK_CLIST (clist), 3, 200);
  gtk_clist_set_column_width (GTK_CLIST (clist), 4, 200);
  gtk_clist_set_column_width (GTK_CLIST (clist), 5, 80);
  gtk_clist_set_column_width (GTK_CLIST (clist), 6, 250);
  gtk_clist_column_titles_show (GTK_CLIST (clist));

  temp=7;
  while(temp--) gtk_clist_set_column_resizeable (GTK_CLIST (clist), temp, FALSE);
  for (temp=4;temp>1;temp--)
    gtk_clist_set_column_visibility (GTK_CLIST (clist), temp, FALSE);
  gtk_clist_set_column_visibility (GTK_CLIST (clist), 5, TRUE);
  gtk_clist_set_column_visibility (GTK_CLIST (clist), 6, TRUE);
  

  
  label = gtk_label_new (_("Address"));
  gtk_widget_show (label);
  gtk_clist_set_column_widget (GTK_CLIST (clist), 0, label);
  label = gtk_label_new (_("Hex"));     gtk_widget_show (label);
  gtk_clist_set_column_widget (GTK_CLIST (clist), 1, label);
  label = gtk_label_new (_("Hex"));     gtk_widget_show (label);
  gtk_clist_set_column_widget (GTK_CLIST (clist), 2, label);
  label = gtk_label_new (_("Hex"));     gtk_widget_show (label);
  gtk_clist_set_column_widget (GTK_CLIST (clist), 3, label);
  label = gtk_label_new (_("Hex"));     gtk_widget_show (label);
  gtk_clist_set_column_widget (GTK_CLIST (clist), 4, label);
  label = gtk_label_new (_("ASCII"));   gtk_widget_show (label);
  gtk_clist_set_column_widget (GTK_CLIST (clist), 5, label);
  label = gtk_label_new (_("Disassembly"));   gtk_widget_show (label);
  gtk_clist_set_column_widget (GTK_CLIST (clist), 6, label);  
  
  gtk_widget_set_style(clist,fixed_style);
  callback_memwindow_length (GTK_MENU_ITEM(menuitem), (gpointer)0x44);
//  view_updatememwindow(memwindow); 
  return hbox;
}

GtkWidget* view_create_register_clist (int regbanknumber)  /*create a registerbank window*/
{
  GtkWidget *clist;
  GtkWidget *scrolledwindow;
  GtkWidget *labela;
  GtkWidget *labelb;
  GtkWidget *vbox;
  GtkWidget *hbox1;
  GtkWidget *hbox2;
  GtkWidget *hbox3;
  GtkWidget *entrya;
  GtkWidget *entryh;
  GtkWidget *frame;
  
  
  char *startdata[] = {"RegName","Value"};      /*all self explaining stuff*/
  int temp;

  reg_window *regwindow = g_new(reg_window,1);
  reg_window_list **regwindowlist = &view_regwindowlist;

  regwindow->regbank_no = regbanknumber;
  while (NULL != *regwindowlist) regwindowlist = &((*regwindowlist)->next);
  *regwindowlist = g_new(reg_window_list,1);
  (*regwindowlist)->reg_data_ptr = regwindow;
  (*regwindowlist)->next = NULL;
  
  frame = gtk_frame_new (board_reg_banks[regwindow->regbank_no].name);
  gtk_widget_ref (frame);
  gtk_widget_show (frame);
  
  vbox = gtk_vbox_new (FALSE, 0);
  gtk_widget_ref (vbox);
  gtk_widget_show (vbox);
  gtk_object_set_data (GTK_OBJECT (vbox), "reg_window", regwindow);
  regwindow->wait=100;
  regwindow->timer=0;
  gtk_container_add (GTK_CONTAINER (frame), vbox);

  hbox1 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox1);  gtk_widget_show (hbox1);
  gtk_box_pack_start (GTK_BOX (vbox), hbox1, FALSE, FALSE, 0);

  hbox2 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox2);  gtk_widget_show (hbox2);
  gtk_box_pack_start (GTK_BOX (vbox), hbox2, FALSE, FALSE, 0);

  hbox3 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox3);  gtk_widget_show (hbox3);
  gtk_box_pack_start (GTK_BOX (vbox), hbox3, FALSE, FALSE, 0);

  
  entrya = gtk_entry_new_with_max_length (5);
  regwindow->address_entry=entrya;
  gtk_widget_ref (entrya);
  gtk_widget_show (entrya);
  gtk_box_pack_start (GTK_BOX (hbox2), entrya, FALSE, TRUE, 0);
  gtk_widget_set_usize (entrya, 37, -2);
  gtk_widget_set_style(entrya,fixed_style);

  entryh = gtk_entry_new_with_max_length
		  (board_reg_banks[regwindow->regbank_no].width*2+3);
  regwindow->hex_entry=entryh;
  gtk_widget_ref (entryh);
  gtk_widget_show (entryh);
  gtk_box_pack_start (GTK_BOX (hbox2), entryh, FALSE, TRUE, 0);
  gtk_widget_set_usize (entryh, 
            board_reg_banks[regwindow->regbank_no].width * 12+23, -2);
  gtk_widget_set_style(entryh,fixed_style);

  gtk_signal_connect (GTK_OBJECT(entryh), "activate",
                   GTK_SIGNAL_FUNC (callback_regwindow_hex),NULL);

  scrolledwindow = gtk_scrolled_window_new (NULL, NULL);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow),
                                  GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);
  gtk_widget_show (scrolledwindow);
  gtk_box_pack_end (GTK_BOX (vbox), scrolledwindow, TRUE, TRUE, 0);
  clist = gtk_clist_new (2);
  regwindow->clist_ptr  = clist;
  for (temp=0;temp < (board_reg_banks[regwindow->regbank_no]).number;temp++)
                        gtk_clist_append(GTK_CLIST(clist),startdata);
  gtk_clist_set_selection_mode (GTK_CLIST (clist), GTK_SELECTION_BROWSE);
  
  gtk_signal_connect (GTK_OBJECT(clist), "select-row",
                   GTK_SIGNAL_FUNC (callback_regwindow_clist),NULL);
  gtk_widget_show (clist);
  gtk_container_add (GTK_CONTAINER (scrolledwindow), clist);
  gtk_clist_set_column_width (GTK_CLIST (clist), 0, 30);
  gtk_clist_set_column_width (GTK_CLIST (clist), 1, 
		  board_reg_banks[regwindow->regbank_no].width * 12+10);
  gtk_clist_column_titles_show (GTK_CLIST (clist));

  labela = gtk_label_new (_("Reg"));
  gtk_widget_show (labela);
  gtk_clist_set_column_widget (GTK_CLIST (clist), 0, labela);
  labelb = gtk_label_new (_("Val"));
  gtk_widget_show (labelb);
  gtk_clist_set_column_widget (GTK_CLIST (clist), 1, labelb);
  view_updateregwindow(regwindow);
  gtk_widget_set_style(clist,fixed_style);
  if (board_reg_banks[regwindow->regbank_no].pointer) board_reg_banks[regwindow->regbank_no].pointer++;
  callback_regwindow_clist(GTK_CLIST(clist), 1, 1, NULL, NULL);
  return frame;
}

#ifdef GTK2
GtkWidget* view_create_console (void)  /*create a console window*/
{
  GtkWidget *scrolledwindow;
  GtkWidget *view;
  GtkTextBuffer *buffer;

  scrolledwindow = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_ref (scrolledwindow);
  gtk_widget_show (scrolledwindow);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow), GTK_POLICY_NEVER, GTK_POLICY_ALWAYS);

  view = gtk_text_view_new ();
  gtk_widget_ref (view);
  gtk_widget_show (view);
  gtk_text_view_set_wrap_mode (GTK_TEXT_VIEW (view),GTK_WRAP_WORD);
  gtk_text_view_set_editable(GTK_TEXT_VIEW (view),FALSE);
  
  buffer = gtk_text_view_get_buffer (GTK_TEXT_VIEW (view));
  gtk_container_add (GTK_CONTAINER (scrolledwindow), view);
  gtk_text_buffer_set_text (buffer, "Log Window\n", -1);
  view_console = buffer;
  
  return scrolledwindow;
}
#endif

#ifndef GTK2
GtkWidget* view_create_console (void)  /*create a console window*/
{
  GtkWidget *scrolledwindow;
  GtkWidget *text;

  scrolledwindow = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_ref (scrolledwindow);
  gtk_widget_show (scrolledwindow);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow), GTK_POLICY_NEVER, GTK_POLICY_ALWAYS);
  text = gtk_text_new (NULL, NULL);
  gtk_text_set_word_wrap(GTK_TEXT(text), TRUE);
  gtk_text_set_editable(GTK_TEXT(text), FALSE);
  gtk_widget_show (text);
  gtk_container_add (GTK_CONTAINER (scrolledwindow), text);
  gtk_text_insert (GTK_TEXT (text), NULL, NULL, NULL,
                   "Log Window\n", -1);
  view_console = text;
  return scrolledwindow;
}
#endif





GtkWidget* view_parse_list(void)        /*make the subwindows*/
{
  GtkWidget* ret;
  int tempint;
 switch (*(view_window_display_list++)){
   case '!':
     ret = view_create_h_mov_split();
     gtk_paned_pack1 (GTK_PANED (ret),view_parse_list() , FALSE, FALSE);
     gtk_paned_pack2 (GTK_PANED (ret),view_parse_list() , FALSE, FALSE);
	 return ret;
   case '~':
     ret = view_create_v_mov_split();
     gtk_paned_pack1 (GTK_PANED (ret),view_parse_list() , FALSE, FALSE);
     gtk_paned_pack2 (GTK_PANED (ret),view_parse_list() , FALSE, FALSE);
	 return ret;
   case '|':
     ret = gtk_hbox_new (FALSE, 4);
     gtk_widget_ref (ret);
     gtk_widget_show (ret);
     do gtk_box_pack_start (GTK_BOX (ret), view_parse_list(), TRUE, TRUE, 0);
	 while (','==*(view_window_display_list++));
     view_window_display_list--;
	 return ret;
   case '-':
     ret = gtk_vbox_new (FALSE, 4);
     gtk_widget_ref (ret);
     gtk_widget_show (ret);
     do gtk_box_pack_start (GTK_BOX (ret), view_parse_list(), TRUE, TRUE, 0);
	 while (','==(*(view_window_display_list++)));
     view_window_display_list--;
	 return ret;
   case 'N':
     ret = gtk_notebook_new ();
     gtk_notebook_set_tab_pos (GTK_NOTEBOOK (ret), GTK_POS_LEFT);
     gtk_widget_ref (ret);
  gtk_widget_show (ret);
     tempint=0;
     do   { char* temp =view_window_display_list;
            GtkWidget *label;
            while ('.' != *view_window_display_list) view_window_display_list++;
            *(view_window_display_list++) = '\0';
            gtk_container_add (GTK_CONTAINER (ret), label=view_parse_list());
            gtk_container_set_border_width (GTK_CONTAINER (label),4);
            label = gtk_label_new (temp);
            gtk_widget_ref (label);gtk_widget_show (label);
            gtk_notebook_set_tab_label (GTK_NOTEBOOK (ret), 
                    gtk_notebook_get_nth_page (GTK_NOTEBOOK (ret), tempint++), label);
            }
	 while ('.'==(*(view_window_display_list++)));
     view_window_display_list--;
	 return ret;
   
   case 'R':
	 return view_create_register_clist (*(view_window_display_list++)-0x30);
   case 'M':
	 return view_create_memory_clist ();
   case 'C':
	 return view_create_console ();
   case 'S':
	 return view_create_source ();
   }
   if (VERBOSE) g_print("Write a proper window line!");
   return NULL;
}

GtkWidget* view_parse_list2(GList* parselist)        /*make the subwindows*/
{
 GtkWidget* ret;
 char* type;
 int temp;
 static StringMatch strings[] = { {"memory",1}, {"register",2}, {"comms",3}, {"source",4}, {"vbox",5}, {"hbox",6}, {"vpane",7}, {"hpane",8}, {"notepad",9}, {NULL,0}};
 
 if (!SCAN_IS_SYMBOL(SCAN_LIST_FIRST(parselist))) {
    g_print ("line:%d position:%d  Windows list is errrmm... wrong\n",    
        	((PtrSCANNode) parselist->data)->line, ((PtrSCANNode) parselist->data)->position);
    return NULL;
    }
 type = SCAN_STRING(SCAN_LIST_FIRST(parselist));
 temp=0;
 while (strcmp (strings[temp].string, type)){
    temp++;
    if (!strings[temp].string){
        g_print ("line:%d position:%d  '%s' is an unknown window type\n",    
        	((PtrSCANNode) parselist->data)->line, ((PtrSCANNode) parselist->data)->position, type);
        }
    }
 parselist = SCAN_LIST_REST(parselist);
 temp=strings[temp].number;
 
 switch (temp) {
   case 1:
     return view_create_memory_clist ();
   case 2:
	 return view_create_register_clist (ScanfindSymbolNumber (parselist,"number", 0));
   case 3:
	 return view_create_console ();
   case 4:
	 return view_create_source ();
   case 5:
     ret = gtk_vbox_new (FALSE, 4);
     gtk_widget_ref (ret);
     gtk_widget_show (ret);

     do gtk_box_pack_start (GTK_BOX (ret), view_parse_list2(SCAN_LIST(SCAN_LIST_FIRST(parselist))), TRUE, TRUE, 0);
	 while ((parselist = SCAN_LIST_REST(parselist)));
	 return ret;
   case 6:
     ret = gtk_hbox_new (FALSE, 4);
     gtk_widget_ref (ret);
     gtk_widget_show (ret);
     do gtk_box_pack_start (GTK_BOX (ret), view_parse_list2(SCAN_LIST(SCAN_LIST_FIRST(parselist))), TRUE, TRUE, 0);
	 while ((parselist = SCAN_LIST_REST(parselist)));
	 return ret;
   case 7:
     ret = gtk_vpaned_new ();
     gtk_widget_show (ret);
     gtk_paned_set_gutter_size (GTK_PANED (ret), 10);
     gtk_paned_pack1 (GTK_PANED (ret),view_parse_list2(SCAN_LIST(SCAN_LIST_FIRST(parselist))) , FALSE, FALSE);
     gtk_paned_pack2 (GTK_PANED (ret),view_parse_list2(SCAN_LIST(SCAN_LIST_FIRST(SCAN_LIST_REST(parselist)))) , FALSE, FALSE);
     temp = ScanfindSymbolNumber (parselist,"position", -1);
     if (temp >= 0)
            gtk_paned_set_position(GTK_PANED (ret), temp);
	 return ret;
   
   case 8:
     ret = gtk_hpaned_new ();
     gtk_widget_show (ret);
     gtk_paned_set_gutter_size (GTK_PANED (ret), 10);
     gtk_paned_pack1 (GTK_PANED (ret),view_parse_list2(SCAN_LIST(SCAN_LIST_FIRST(parselist))) , FALSE, FALSE);
     gtk_paned_pack2 (GTK_PANED (ret),view_parse_list2(SCAN_LIST(SCAN_LIST_FIRST(SCAN_LIST_REST(parselist)))) , FALSE, FALSE);
	 return ret;
   
   case 9:
     ret = gtk_notebook_new ();
     gtk_notebook_set_tab_pos (GTK_NOTEBOOK (ret), GTK_POS_LEFT);
     gtk_widget_ref (ret);
     gtk_widget_show (ret);
     temp=0;
     do {
        GtkWidget *label;
        gtk_container_add (GTK_CONTAINER (ret), label=view_parse_list2(SCAN_LIST_REST(SCAN_LIST(SCAN_LIST_FIRST(parselist)))));
        gtk_container_set_border_width (GTK_CONTAINER (label),4);
        label = gtk_label_new (SCAN_STRING(SCAN_LIST_FIRST(SCAN_LIST(SCAN_LIST_FIRST(parselist)))));         
        gtk_widget_ref (label);gtk_widget_show (label);
        gtk_notebook_set_tab_label (GTK_NOTEBOOK (ret), 
        gtk_notebook_get_nth_page (GTK_NOTEBOOK (ret), temp++), label);
        }
	 while ((parselist = SCAN_LIST_REST(parselist)));
	 return ret;
   default:
     g_print("ah crap\n");
	 return NULL;
    }
 
 return NULL;
}
