#ifndef VIEW_H
#define VIEW_H
#include <glib.h>
#include <gtk/gtk.h>
#include "interface.h"
#define _(String) (String)
#define uchar unsigned char


typedef struct mem_window_name{
 GtkWidget* clist_ptr;
 GtkWidget* address_entry;
 GtkWidget* hex_entry;
 GtkWidget* ascii_entry;
 GtkWidget* dis_entry;
 GtkWidget* scroll; 
 unsigned char* address;
 unsigned char* regoffset;
 int count;
 int width;
 int gran;
// int wait;
// gint timer;
 GList* isa;
} mem_window;

typedef struct mem_window_list_name{
 mem_window* mem_data_ptr;
 struct mem_window_list_name* next;
} mem_window_list;

typedef struct reg_window_name{
 GtkWidget* clist_ptr;
 GtkWidget* address_entry;
 GtkWidget* hex_entry;
 int regbank_no;
 int wait;
 gint timer;
} reg_window;

typedef struct reg_window_list_name{
 reg_window* reg_data_ptr;
 struct reg_window_list_name* next;
} reg_window_list;

typedef struct dat_window_name{
 GtkWidget* clist_ptr;
 GtkWidget* address_entry;
 GtkWidget* hex_entry;
 GtkWidget* ascii_entry;
 GtkWidget* dis_entry;
 GtkWidget* scroll; 
 unsigned char* address;
 unsigned char* regoffset;
 int count;
 int width;
 int gran;
} dat_window;

typedef struct dat_window_list_name{
 mem_window* dat_data_ptr;
 struct dat_window_list_name* next;
} dat_window_list;

// char* view_dis_arm(uchar*, uchar*);
// char* view_dis_thumb(uchar*, uchar*);
char* view_dis(uchar*, uchar*,int, GList*);
		
int view_updatememwindow(mem_window*);
int view_updateregwindow(reg_window*);
mem_window* view_getmemwindowptr(GtkWidget* widget);
reg_window* view_getregwindowptr(GtkWidget* widget);
void view_create_mainwindow (void);
GtkWidget* view_create_filebar (void);
GtkWidget* create_featurewindow (void);
GtkWidget* create_xfpgasegment (void);
GtkWidget* create_splashwindow (void);
int view_show_pointer(GtkWidget* aboutwindow);
GtkWidget* create_aboutwindow (void);
GtkWidget* view_create_prog_ctrl (void);
GtkWidget* view_create_h_mov_split (void);
GtkWidget* view_create_v_mov_split (void);
GtkWidget* view_create_memory_clist (void);
GtkWidget* view_create_register_clist (int);
GtkWidget* view_create_console (void);
GtkWidget* view_create_comms (feature*);
GtkWidget* view_create_source (void);
GtkWidget* view_parse_list(void);
GtkWidget* view_parse_list2(GList*);


gpointer view_console;
gpointer view_comms;

char* view_window_display_list;
GList* view_window_display_list2;

mem_window_list* view_memwindowlist;
reg_window_list* view_regwindowlist;
dat_window_list* view_datwindowlist;

GtkWidget* view_mainwindow;
GtkWidget* view_maincontainer;
GtkWidget* view_progressbar;
GtkWidget* view_enqlabel;
GtkWidget* view_steplabel;
GtkWidget* view_breakwindow[2][4];
GtkWidget* view_fileerror;
GtkWidget* view_refreshbutton;
GtkWidget* view_binary_load_address;
GtkWidget* view_load_centry;
GtkWidget* view_compile_centry;

int view_step_number;
int view_step_freq;

GdkPixmap* view_chump_pixmap;
GdkBitmap* view_chump_bitmap;
GdkPixmap* view_tick_pixmap;
GdkBitmap* view_tick_bitmap;
GdkPixmap* view_mulogo_pixmap;
GdkBitmap* view_mulogo_bitmap;
GdkPixmap* view_komodologo_pixmap;
GdkBitmap* view_komodologo_bitmap;
GdkPixmap* view_komodotitle_pixmap;
GdkBitmap* view_komodotitle_bitmap;
GdkPixmap* view_komodoicon_pixmap;
GdkBitmap* view_komodoicon_bitmap;
GdkPixmap* view_break_pixmap;
GdkBitmap* view_break_bitmap;
GdkPixmap* view_break_inactive_pixmap;
GdkBitmap* view_break_inactive_bitmap;

GdkColor view_greycolour;
GdkColor view_redcolour;
GdkColor view_blackcolour;


GtkTooltips* view_tooltips;

gint view_global_refresh_timer;
#endif
