/***************************************************************************
                          msnnotificationconnection.h  -  description
                             -------------------
    begin                : Thu Jan 23 2003
    copyright            : (C) 2003 by Mike K. Bennett
    email                : mkb137b@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef MSNNOTIFICATIONCONNECTION_H
#define MSNNOTIFICATIONCONNECTION_H

#include <qobject.h>
#include <qptrlist.h>
#include <qtimer.h>

#include "msnconnection.h"

// Forward declarations
class ChatInformation;
class Contact;
class ContactList;
class KConfig;
class KMessTest;
class MimeMessage;
class SslLoginHandler;

/**
 * The connection to the msn notification server,
 * which handles login and contact list type functions.
 *
 * @author Mike K. Bennett
 */
class MsnNotificationConnection : public MsnConnection
{
  Q_OBJECT

  friend class KMessTest;

  public:

    // The constructor
                         MsnNotificationConnection();
    // The destructor
                        ~MsnNotificationConnection();
    // Request a change in the user's status
    void                 changeStatus( const QString& newStatus );
    // Close the connection with the server
    void                 closeConnection();
    // Return the contact list
    const ContactList*   getContactList() const;
    // Initialize the object
    bool                 initialize();
    // Open a connection to the server
    bool                 openConnection();
    // Save contact list properties
    void                 saveProperties(KConfig *config);

  public slots: // Public slots
    // Add an existing contact to the friends list
    void                 addExistingContact(QString handle);
    // Add a new contact to the list
    void                 addNewContact(QString handle);
    // Adds the given contact to the allow list.
    void                 allowContact(QString handle);
    // Add a new group
    void                 addGroup(QString name);
    // Block the given contact
    void                 blockContact(QString handle);
    // The msn object has required, requires a notification message
    void                 changedMsnObject();
    // Change a contact or the user's friendly name
    void                 changeFriendlyName( QString handle, QString newName );
    // Move the contact to another group.
    void                 moveContact(QString handle, QString fromGroupId, QString toGroupId);
    // Request a chat with a contact
    void                 requestChat(QString handle);
    // Rename a group
    void                 renameGroup(QString id, QString newName);
    // Remove a contact from the contact list completely
    void                 removeContact(QString handle, bool block = true);
    // Remove a group
    void                 removeGroup(QString id);
    // Unblock the given contact
    void                 unblockContact(QString handle);

  protected: // Protected methods
    // Show a message that the proxy failed
    void                 proxyFailed();

  protected slots: // Protected slots
    // The socket connected, so send the version command.
    void                 connectionSuccess();

  private: // Private methods
    // Add a contact to the given list or, if applicable, group
    void                 addContact(QString handle, QString list, QString groupId = "");
    // Create the SSL login handler
    SslLoginHandler     *createLoginHandler();
    // Show a .net status message.
    void                 dotNetMessage(QString message);
    // Go online
    void                 goOnline();
    // Received the addition of a contact to a list or list and group
    void                 gotAdd(const QStringList& command);
    // Received the addition of a group
    void                 gotAdg(const QStringList& command);
    // Received confirmation of the user's status change
    void                 gotChg(const QStringList& command);
    // Received a challenge from the server
    void                 gotChl(const QStringList& command);
    // Received a version update from the server
    void                 gotCvr(const QStringList& command);
    // Received notice that a contact went offline
    void                 gotFln(const QStringList& command);
    // Received notice that a contact is already online
    void                 gotIln(const QStringList& command);
    // Received authentication protocols
    void                 gotInf(const QStringList& command);
    // Received group information
    void                 gotLsg(const QStringList& command);
    // Received contact information
    void                 gotLst(const QStringList& command);
    // Received notice that a contact has changed status
    void                 gotNln(const QStringList& command);
    // Received notice of disconnetion from the server
    void                 gotOut(const QStringList& command);
    // Received confirmation of the user's or a contact's renaming
    void                 gotRea(const QStringList& command);
    // Received confirmation of change in a group's name
    void                 gotReg(const QStringList& command);
    // Received confirmation of a conact's removal from list or list and group
    void                 gotRem(const QStringList& command);
    // Received confirmation of a group's removal
    void                 gotRmg(const QStringList& command);
    // Received a chat request from a contact
    void                 gotRng(const QStringList& command);
    // Received synchronization information
    void                 gotSyn(const QStringList& command);
    // Received the folder and command info for Hotmail's inbox or compose
    void                 gotUrl(const QStringList& command);
    // Received user authentication information
    void                 gotUsr(const QStringList& command);
    // Received version information
    void                 gotVer(const QStringList& command);
    // Received server transfer information
    void                 gotXfr(const QStringList& command);
    // Send the version command
    void                 putVer();
    // Parse a regular command
    void                 parseCommand(const QStringList& command);
    // Parse a message command
    void                 parseMessage(const QStringList& command, const MimeMessage &message);
    // Remove a contact from the given list or, if applicable, group
    void                 removeContact(QString handle, QString list, QString groupId = "");

  private slots: // Private slots
    // Check whether login was successful within time limit
    void                 checkLogin();
    // The SSL login was aborted because an internal error occured
    void                 sslLoginFailed();
    // The SSL login failed, username/password was incorrect
    void                 sslLoginIncorrect();
    // The SSL login succeeded
    void                 sslLoginSucceeded(QString authentication);

  private: // Private attributes
    // A pointer to the list of contacts
    ContactList         *contactList_;
    // Whether or not the object was initialized
    bool                 initialized_;
    // A timer to timeout the user's logon
    QTimer               loginTimer_;
    // A list of chats which haven't yet been given servers
    QPtrList<ChatInformation> openChats_;
    // Temporary storage for ACK of REM command (for moving operation)
    int                  movingAck_;
    // Temporary storage for moving-source group (for moving operation)
    int                  movingSource_;
    // The number of contact read in
    int                  noContacts_;
    // The object than handles the SSL part of the login
    SslLoginHandler     *sslLoginHandler_;
    // The duration in milliseconds before an unsuccessful connection attempt is cancelled
    static const int     timeoutDuration_ = 60000; //(60 seconds)
    // The total number of contacts in the contact list
    int                  totalNoContacts_;

  signals: // Public signals
    // Signal that the connection has been made sucessfully
    void                 connected();
    // Signal that a contact added you
    void                 contactAddedUser(const Contact *contact);
    // Signal that a new email has been received
    void                 newEmail(QString sender, QString subject, bool inInbox, QString command, QString folder, QString url);
    // Start a chat with a contact
    void                 startChat( ChatInformation *chatInfo );
};

#endif
