/***************************************************************************
                          chatmessageview.h -  description
                             -------------------
    begin                : Sat Nov 8 2005
    copyright            : (C) 2005 by Diederik van der Boor
    email                : "vdboor" --at-- "codingdomain.com"
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CHATMESSAGEVIEW_H
#define CHATMESSAGEVIEW_H

#include <khtml_part.h>
#include <kparts/browserextension.h>

class QStringList;


/**
 * This class is used to display chat messages.
 * A KHTMLPart is used for this because unlike QTextBrowser, KHTML has support for CSS.
 *
 * @author Diederik van der Boor
 */
class ChatMessageView : public KHTMLPart
{
  Q_OBJECT

  public:  // public methods

    // The constructor
                         ChatMessageView(QWidget *parent, const char *name);
    // The destructor
    virtual             ~ChatMessageView();

    // Add the given html to the chat browser and scroll to the end
    void                 addHtmlMessage(const QString &text);
    // Return the HTML source of the page.
    QString              getHtml() const;
    // Whether or not the message area is empty
    bool                 isEmpty() const;
    // Replace the last message with a new contents.
    void                 replaceLastMessage(const QString &text);
    // Replace the entire contents with new HTML code
    void                 setHtml(const QString &htmlRoot, const QString &htmlBody);
    // Replace the body contents with new HTML
    void                 setStandardHtml(const QString &htmlBody, const QString &cssFile = QString::null, const QString &baseFolder = QString::null);
    void                 updateCustomEmoticon( const QString &code, const QString &replacement,
                                               const QString &handle, const QStringList &pendingEmoticonTagIds );


  public slots:
    // Finds the links to add a custom emoticon, and remove them because we've already added that emoticon
    void                 addedEmoticon( QString shortcut );
    // Scroll to the bottom of the chat browser
    void                 scrollChatToBottom();

  private:  // private methods
    // Initialize the widget
    void                 initialize();

  private:  // private properties
    // Whether or not the chat message area is empty
    bool                 isEmpty_;
    // The last message id, for replaceLastMessage()
    int                  lastMessageId_;

  signals:
    // Signal that there's an application command
    void                 appCommand(QString cookie, QString contact, QString method);
    // Signal a click on an URL
    void                 openURLRequest( const KURL &url, const KParts::URLArgs &urlArgs );
};

#endif

