/***************************************************************************
                          passivepopup.h - KMess' Notification Popup
                             -------------------
    begin                : Tuesday April 10 2007
    copyright            : (C) 2007 by Valerio Pilo
    email                : amroth@coldshock.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef PASSIVEPOPUP_H
#define PASSIVEPOPUP_H

#include "passivepopupview.h"
#include "passivepopupwidget.h"



/**
  * @brief KMess' passive popup class for events notification
  *
  * Implements a customized popup balloon to be used with notifications.
  * The actual layout is defined in the passivepopupinterface.ui file.
  *
  * @author Valerio Pilo <amroth@coldshock.net>
  */
class PassivePopup : public QObject
{
  Q_OBJECT

  public:  // Public properties
    struct PopupProperties
    {
      // Handle of the contact which caused the popup to open
      QString source;
      // Contact icon
      QString icon;
      // Message to display
      QString message;
      // Name of the contact status icon
      QString status;
      // Timeout after which the popup must disappear
      int timeout;
      // Position at which it must appear
      QPoint position;
      // Object to call when the popup is clicked
      QObject *destObject;
      // Messages to send when the popup is clicked
      QStringList destMessages;
    };


  public:  // Public methods
    // Class constructor
    PassivePopup( QWidget *parent, PopupProperties props );
    // Change the popup's properties's
    bool change( PopupProperties newProps );
    // Obtain the current popup position
    QPoint getPosition();
    // Display the popup
    void show();

  signals:
    // Activate the event triggered via a left-click on the popup balloon
    void activate( QStringList strings, QObject *object );
    // Emitted when it's being destroyed, to remove the popup from the stack
    void dying( QString source );

  private slots:
    // Called when it's being destroyed, to remove the popup from the stack
    void forwardDeath();
    // Called when the popup gets left-clicked with the mouse; emits the activate() signal
    void leftClicked();
    // Called when the popup gets right-clicked with the mouse; does no actions
    void rightClicked();

  private:  // Private properties
    // The actual popup balloons widget
    PassivePopupWidget   *popup_;
    // The properties of this popup
    PopupProperties       properties_;
    // Layout of the popup balloon
    PassivePopupView     *viewWidget_;
};

#endif
