/***************************************************************************
 *   Copyright (C) 2004 by Spiros Georgaras                                *
 *   sngeorgaras@otenet.gr                                                 *
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Lesser Public License as published by   *
 *   the Free Software Foundation; either version 2.1 of the License, or   *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU Lesser Public License for more details.                           *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser Public License      *
 *   along with this library; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <grp.h>
#include <pwd.h>
#include <stdlib.h>

#include <iostream>
#include <kmimetype.h>
#include <ksharedptr.h>
#include <kmdcodec.h>
#include <kmessagebox.h>
#include <klocale.h>
#include <ktempdir.h>
#include <kstandarddirs.h>
#include <krun.h>
#include <qdatastream.h>
#include <qtextstream.h>
#include <qdir.h>
#include <qregexp.h>
#include <kdebug.h>

#include <kmhtmlarchive.h>
#include <qglobal.h>
/*================================
================================*/
/*KmhtmlArchive::KmhtmlArchive(){
	item=0;
	status=0;
	isDOS=FALSE;
	parts=0;
	controlChars[0].sprintf("%c",13);
	controlChars[1].sprintf("%c",10);
	controlChars[2].sprintf("%c",9);
}
*/
/*================================
================================*/
KmhtmlArchive::KmhtmlArchive(const QString &mhtArchive){
	item=0;
	status=0;
	isEML=FALSE;
	isSimple=TRUE;
	isMarkupFromText=FALSE;
	m_showInfo=FALSE;
	m_showAttachments=FALSE;
	mhtFileName=mhtArchive;
	if(mhtFileName.endsWith(".eml",FALSE) || mhtFileName.find(".eml/",0,FALSE)!=-1){
		isEML=TRUE;
		m_showInfo=TRUE;
		m_showAttachments=TRUE;
	}
	isDOS=FALSE;
	parts=-1;
	controlChars[0].sprintf("%c",13);
	controlChars[1].sprintf("%c",10);
	hasMarkup=FALSE;
// 	charsetCretiria=0;
// 	charsetCretiriaCalculated=false;
}
/*================================
================================*/
KmhtmlArchive::~ KmhtmlArchive(){
	status=0;
	items=0;
	for(int i=0;i<items;i++) delete [] item[i].data;
	delete [] item;
	if(parts>=0) delete [] partHeader;
}
 /*================================
================================*/
void KmhtmlArchive::reset(){
	//kdDebug()<<"Reseting"<<endl;
	status=0;
	items=0;
	for(int i=0;i<items;i++) delete [] item[i].data;
	delete [] item;
	if(parts>=0) delete [] partHeader;
	allocItems=-1;
	parts=-1;
	f="";
}
/*================================
================================*/
bool KmhtmlArchive::open(int mode){
	if(mode==IO_ReadOnly){
		//kdDebug() << "[KmhtmlArchive::open()]: mhtFileName = " << mhtFileName << endl;
		file.setName(mhtFileName);
		if(!file.open( mode )){
			emit errorAppeared(1);
			status=1;
			//kdDebug() << "[KmhtmlArchive::open()]: Error opening file" << endl;
			return FALSE;
		}else emit archiveOpened();
		m_size=(uint) file.size();
		//kdDebug()<<"[KmhtmlArchive::open()]: file size="<<m_size<<endl;
		if(!m_size){
			emit errorAppeared(3);
			status=3;
			return FALSE;
		}
		uint flsize=m_size/10;
		if(!flsize){
			status=3;
			emit errorAppeared(3);
			return FALSE;
		}
		QDataStream stream( &file );  // read the data serialized from the file
		char* c;
		c=(char*)malloc(sizeof(char)*(flsize + 1));
		c[flsize]='\0';
		while(!stream.atEnd()){
			stream.readRawBytes(c,flsize);
			f+=c;
		}
		free(c);
		file.close();
		f.resize(m_size);
		if(isDOS) f.append(controlChars[0]);
		f.append(controlChars[1]);
		if(!readPartHeader()){
			//kdDebug() << "[KmhtmlArchive::open()]: Error reading header" << endl;
			emit errorAppeared(2);
			status=2;
			return FALSE;
		}
		if(!readItems()){
			status=3;
			emit errorAppeared(3);
			//kdDebug() << "[KmhtmlArchive::open()]: Error reading items" << endl;
			return FALSE;
		}
		//kdDebug() << "[KmhtmlArchive::open()]: done" << endl;
		//return FALSE; //test case
		// read time,user,group,access
		struct stat statbuf;
		::stat( QFile::encodeName( mhtFileName ), &statbuf );
		m_mtime = statbuf.st_mtime;
		struct passwd* pwp;
		pwp=getpwuid(statbuf.st_uid);
		m_user=QString(pwp->pw_name);
		struct group* grp;
		grp = getgrgid(statbuf.st_gid);
		m_group=grp->gr_name;
		//m_permissions=statbuf.st_mode & 07777;
		m_permissions=statbuf.st_mode;
		return TRUE;
	}else if(mode==IO_WriteOnly){
		return FALSE;
	}else return FALSE;
}
/*================================
================================*/
void KmhtmlArchive::setFileName(const QString &fileName){
	mhtFileName=fileName;
}
/*================================
================================*/
bool KmhtmlArchive::readItems(){
	int i=0;
	items=0;
	int it; // will have the final number of items
	int newItems;
	delete [] item;
	item=new elm[5];
	for(int o=0;o<5;o++){
		item[o].data=0;
		item[o].fixed=FALSE;
		item[o].level=0;
	}
	allocItems=5;
	if(!readItemsHeader(&f,0)){
		//kdDebug()<<"[KmhtmlArchive::readItems()]: error in readItemsHeader"<<endl;
		return FALSE;
	}
	//kdDebug()<< "[KmhtmlArchive::readItems()]: items="<<items<<endl;
	// search for nested parts
	it=items;
	for(i=0;i<items;i++){
		//break; // test case
		if(item[i].header.find("multipart/")!=-1){
			//kdDebug()<< " ---------- [KmhtmlArchive::readItems()]: found nested block in item " << i << endl;
			item[i].isInvalid=TRUE;
			it--;
		}else{
			item[i].isInvalid=FALSE;
			//kdDebug()<< "[KmhtmlArchive::readItems()]: item["<<i<<"] header= "<<item[i].header<<endl;
		}
	}
	// if nested parts found add them to the partsHeader
	if(it!=items){
		// reallocate partHeader
		struct HEADER* tmp;
		tmp=new HEADER[parts+items-it];
		for(i=0;i<parts;i++){
			tmp->start=partHeader->start;
			tmp->end=partHeader->end;
			tmp->itStart=partHeader->itStart;
			tmp->header=partHeader->header;
			tmp->contenttype=partHeader->contenttype;
			tmp->contentLocation=partHeader->contentLocation;
			tmp->type=partHeader->type;
			tmp->boundary=partHeader->boundary;
		}
		delete [] partHeader;
		partHeader=tmp;
		int l=0;
		for(i=0;i<items;i++){
			if(item[i].isInvalid){
				partHeader[parts+l].header=item[i].header;
				partHeader[parts+l].start=item[i].start;
				partHeader[parts+l].end=item[i].end;
				partHeader[parts+l].itStart=item[i].itStart;
				//kdDebug()<< "[KmhtmlArchive::readItems()]: parts=" << parts << endl;
				l++;
			}
		}
		//kdDebug()<< "[KmhtmlArchive::readItems()]: items=" << items << endl;
		//kdDebug()<< "[KmhtmlArchive::readItems()]: it=" << it << endl;
		newItems=items-it;
		//kdDebug()<< "[KmhtmlArchive::readItems()]: newItems=" << newItems << endl;
		parts=parts+newItems;
		//kdDebug()<< "[KmhtmlArchive::readItems()]: parts=" << parts << endl;
/*
		for(i=0;i<parts;i++){
			//kdDebug()<< "[KmhtmlArchive::readItems()]" << endl;
			//kdDebug()<< "[KmhtmlArchive::readItems()]" << endl;
			//kdDebug()<< "[KmhtmlArchive::readItems()]" << endl;
			//kdDebug()<< "[KmhtmlArchive::readItems()]" << endl;
			//kdDebug()<< "[KmhtmlArchive::readItems()]" << endl;
			//kdDebug()<< "[KmhtmlArchive::readItems()]: start=" << partHeader[i].start << endl;
			//kdDebug()<< "[KmhtmlArchive::readItems()]: itStart=" << partHeader[i].itStart << endl;
			//kdDebug()<< "[KmhtmlArchive::readItems()]: end=" << partHeader[i].end << endl;
			//kdDebug()<< "[KmhtmlArchive::readItems()]" << endl;
			//kdDebug()<< "[KmhtmlArchive::readItems()]" << endl;
			//kdDebug()<< "[KmhtmlArchive::readItems()]: part " << i << " header" << endl;
			//kdDebug()<< partHeader[i].header << endl;
			//kdDebug()<< "[KmhtmlArchive::readItems()]" << endl;
			//kdDebug()<< "[KmhtmlArchive::readItems()]" << endl;
			//kdDebug()<< "[KmhtmlArchive::readItems()]" << endl;
			//kdDebug()<< "[KmhtmlArchive::readItems()]" << endl;
			//kdDebug()<< "[KmhtmlArchive::readItems()]" << endl;
		}
*/
		// remove them from items
		struct elm* tmp1;
		if(it>0){
			tmp1=new elm[it];
			allocItems=it;
		}else{
			tmp1=new elm[5];
			allocItems=5;
		}
		int o=0;
		for(i=0;i<items;i++){
			if(!item[i].isInvalid){
				tmp1[o].start=item[i].start;
				tmp1[o].end=item[i].end;
				tmp1[o].itStart=item[i].itStart;
				tmp1[o].header=item[i].header;
				tmp1[o].level=item[i].level;
				tmp1[o].isInvalid=FALSE;
 				//kdDebug()<< "[KmhtmlArchive::readItems()]: copying to item " << o << ": " << item[i].header<<endl;
				o++;
			}
		}
		delete [] item;
		item=tmp1;
		items=it;
 		//kdDebug()<< "[KmhtmlArchive::readItems()]: items=" << items << endl;
		// read new part headers
		for(i=parts-newItems;i<parts;i++){
			//kdDebug()<<"i="<<i<<", parts="<<parts<<endl;
			if(!readPartHeader(i)){
				//kdDebug() << "[KmhtmlArchive::open()]: Error reading header" << endl;
				status=2;
				return FALSE;
			}
		}
		// find new items in the nested parts
		//kdDebug() << "[KmhtmlArchive::readItems()]: parts=" << parts << " newItems=" << newItems << " diff=" << parts-newItems << endl;
		for(i=parts-newItems;i<parts;i++){
			//kdDebug()<< "[KmhtmlArchive::readItems()]: counting = " << i << endl;
			//kdDebug()<< "[KmhtmlArchive::readItems()]: items before reading= " << items << endl;
			QCString inner=f.mid(partHeader[i].start,partHeader[i].end-partHeader[i].start);
			if(!readItemsHeader(&inner,i)) return FALSE;
			//kdDebug()<< "[KmhtmlArchive::readItems()]: items after reading= " << items << endl;
		}
	}
	//kdDebug()<< "[KmhtmlArchive::readItems()]: total items = " << items << endl;
	for(i=0;i<items;i++){
		if(item[i].level>0){
			//kdDebug()<<"[KmhtmlArchive::readItems()]: level=" << item[i].level << " i="<< i << " item[i].level" <<item[i].level << " partHeader[item[i].level].start=" << partHeader[item[i].level].start << endl;
			item[i].start+=partHeader[item[i].level].start;
			item[i].itStart+=partHeader[item[i].level].start;
			item[i].end+=partHeader[item[i].level].start;
		}
		if(item[i].itStart>item[i].end) item[i].itStart=item[i].end+1;
		//kdDebug() << "[KmhtmlArchive::readItems()] -----------------" << endl << "item[" << i << "] with start "<< item[i].start << ", itStart "<< item[i].itStart <<", end "<< item[i].end<< " and level=" << item[i].level << endl; // << item[i].header << endl;
		//kdDebug() << "-----------------" << endl;
		evalItemHeader(i);
	}
	// decode items
	for(int i=0;i<items;i++){
		QCString fContents;
		//kdDebug() << "[KmhtmlArchive::readItems()]: item[i].itStart=" << item[i].itStart << ", i=" << i << endl;
		//if(item[i].itStart!=item[i].end)
		fContents=f.mid(item[i].itStart,item[i].end-item[i].itStart+1);
		QByteArray exC(100);
		QCString exContents=fContents;
		QByteArray inC(100);
		//kdDebug() << "[KmhtmlArchive::readItems()]: item[i].encoding=" << item[i].encoding << endl;
		switch(item[i].encoding){
		case 0: // quoted printable
			if(item[i].mimeType=="text/html"|| item[i].mimeType=="text/xml" || item[i].mimeType=="application/xhtml+xml"){
				exContents=removeControlChars(KCodecs::quotedPrintableDecode(fContents));
				fixFileName(fContents,i);
				item[i].data=exContents;
				item[i].decodedSize=exContents.length();
			}else{
				inC.setRawData( fContents.data(), fContents.length() );
				KCodecs::quotedPrintableDecode( inC, exC );
				inC.resetRawData( fContents.data(), fContents.length() );
				fixFileName(exC,i);
				item[i].data=exC;
				item[i].decodedSize=exC.size();
			}
			break;;
		case 1: // base64
			inC.setRawData( fContents.data(), fContents.length() );
 			KCodecs::base64Decode( inC, exC );
			inC.resetRawData( fContents.data(), fContents.length() );
			fixFileName(exC,i);
			item[i].data=exC;
			item[i].decodedSize=exC.size();
			//kdDebug()<<"item[i].decodedSize="<<item[i].decodedSize<<endl;
			break;;
		case 2: // uuencode
			inC.setRawData( fContents.data(), fContents.length() );
 			KCodecs::uudecode( inC, exC );
			inC.resetRawData( fContents.data(), fContents.length() );
			fixFileName(exC,i);
			item[i].data=exC;
			item[i].decodedSize=exC.size();
			break;;
		case 3: // 7-bit
		case 4: // 8-bit
			item[i].data=removeControlChars(fContents);
			item[i].data.resize(item[i].data.size()-1);
			item[i].decodedSize=fContents.length();
			break;;
		}
	}
	for(int i=0;i<items;i++) if(item[i].mimeType=="text/html"|| item[i].mimeType=="text/xml" || item[i].mimeType=="application/xhtml+xml"){
		hasMarkup=TRUE;
		break;
	}
	// get a valid filename for text only eml files
	//if(isEML && !hasMarkup){
	if(!hasMarkup){
		for(int i=0;i<items;i++){
			if(item[i].name.isEmpty()){
				item[i].name="Alternative text.txt";
				item[i].alias="Alternative text.txt";
				item[i].hasExtension=TRUE;
				if(item[i].encoding==-1) item[i].encoding=3;
				if(item[i].mimeType.isEmpty()) item[i].mimeType=="text/plain";
			}
			if(item[i].alias=="Alternative text.txt" && !hasMarkup){
				// convert to html
				QCString tmp;
				tmp=item[i].data;
				int charSelect;
				int insPoint=0;
				if(isDOS) charSelect=0;
				else charSelect=1;
				while((insPoint=tmp.find(controlChars[charSelect],insPoint))!=-1){
					tmp.insert((uint)insPoint,"<br>");
					insPoint+=5;
				}
				if(isDOS) tmp.prepend(controlChars[0]);
				tmp.prepend(controlChars[1]);
				tmp.prepend("<body bgcolor=\"#FFFFFF\">");
				//kdDebug()<< "[KmhtmlArchive::readItems()]: isSimple=" << isSimple << endl;
				if(isSimple && !partHeader[0].charset.isEmpty()){
					//kdDebug()<< "[KmhtmlArchive::readItems()]: fixxing html charset" << endl;
					if(isDOS) tmp.prepend(controlChars[0]);
					tmp.prepend(controlChars[1]);
					tmp.prepend("<head><meta http-equiv=\"Content-Type\" content=\"text/html; charset=" + partHeader[0].charset + "\"></head>");
					if(isDOS) tmp.prepend(controlChars[0]);
					tmp.prepend(controlChars[1]);
				}
				tmp.prepend("<html>");
				if(isDOS) tmp.append(controlChars[0]);
				tmp.append(controlChars[1]);
				tmp.append("<br><br></body></html>");
				item[i].data=tmp;
				item[i].name="index.html";
				item[i].alias="index.html";
				item[i].mimeType="text/html";
				item[i].hasExtension=TRUE;
				isMarkupFromText=TRUE;
				hasMarkup=TRUE;
			}
		}
	}
	// get main doc filename
	for(int i=0;i<items;i++){
		//if(item[i].mimeType==type){
			if(item[i].mimeType=="text/html") item[i].alias="index.html";
			else if (item[i].mimeType=="text/xml") item[i].alias="index.xml";
			else if (item[i].mimeType=="application/xhtml+xml") item[i].alias="index.xhtml";
		//}
	}
	// create alias
	for(int i=0;i<items;i++){
		if(item[i].alias.isEmpty()) item[i].alias=item[i].fixedName;
		if(item[i].alias.isEmpty()) item[i].alias=item[i].name;
		if(item[i].alias=="text.txt") item[i].alias="Alternative text.txt";
		//kdDebug()<< "[KmhtmlArchive::readData]: alias for "<< i << " " << item[i].name << "," << item[i].fixedName << "," << item[i].alias << endl;
	}
		for(int i=0;i<items;i++){
		if(item[i].alias.isEmpty()){
			//kdDebug()<< "[KmhtmlArchive::readData]: found empty alias, i="<<i<<endl;
			//kdDebug()<< "[KmhtmlArchive::readData]: mimeType="<<item[i].mimeType<<endl;
			//kdDebug()<< "[KmhtmlArchive::readData]: encoding="<<item[i].encoding<<endl;
			//kdDebug()<< "[KmhtmlArchive::readData]: contentLocation="<<item[i].contentLocation<<endl;
			//kdDebug()<< "[KmhtmlArchive::readData]: charset="<<item[i].charset<<endl;
			if(item[i].mimeType=="text/plain" || item[i].mimeType.isEmpty()) item[i].alias="Alternative text.txt";
			//kdDebug()<< "[KmhtmlArchive::readData]: hacked alias for "<< i << " " << item[i].name << "," << item[i].fixedName << "," << item[i].alias << endl;
		}
		//kdDebug()<< "[KmhtmlArchive::readData]: alias for "<< i << " " << item[i].name << "," << item[i].fixedName << "," << item[i].alias << endl;
	}
	for(i=0;i<items;i++){
		int cr=1;
		for(int y=i+1;y<items;y++){
			if(item[i].alias==item[y].alias){
				int l=item[y].alias.find(".");
				QString g;
				g.setNum(cr);
				g.prepend(item[y].alias.left(l));
				g.append(item[y].alias.mid(l));
				item[y].alias=g;
				cr++;
			}
		}
	}
	// find type
	for(int i=0;i<items;i++){
		if(item[i].mimeType=="text/html" || item[i].mimeType=="text/xml" || item[i].mimeType=="application/xhtml+xml"){
			type=item[i].mimeType;
			//kdDebug() << "type=" << type << endl;
			break;
		}
	}
	//if type="" fall back to text/*
	if(type.isEmpty()){
		for(int i=0;i<items;i++){
			if(item[i].mimeType.startsWith("text/")){
				type=item[i].mimeType;
				//kdDebug() << "type=" << type << " - fall back" << endl;
				break;
			}
		}
	}
	outItems=items;
	// check for empty "Alternative text.txt"
	for(int i=0;i<items;i++){
		if(item[i].alias=="Alternative text.txt" && items>1 && item[i].data.isEmpty()){
			//kdDebug()<<"------------- Empty txt detected at " << i << " -------------"<<endl;
			if(i!=items-1){
				for(int l=i;l<items-1;l++){
					item[l].start=item[l+1].start;
					item[l].end=item[l+1].end;
					item[l].itStart=item[l+1].itStart;
					item[l].encodedSize=item[l+1].encodedSize;
					item[l].decodedSize=item[l+1].decodedSize;
					item[l].header=item[l+1].header;
					item[l].contentLocation=item[l+1].contentLocation;
					item[l].contentID=item[l+1].contentID;
					item[l].contentDisposition=item[l+1].contentDisposition;
					item[l].dispFileName=item[l+1].dispFileName;
					item[l].startPart=item[l+1].startPart;
					item[l].encoding=item[l+1].encoding;
					item[l].charset=item[l+1].charset;
					item[l].mimeType=item[l+1].mimeType;
					item[l].base=item[l+1].base;
					item[l].hasExtension=item[l+1].hasExtension;
					item[l].fixed=item[l+1].fixed;
					item[l].isInvalid=item[l+1].isInvalid;
					item[l].level=item[l+1].level;
					item[l].name=item[l+1].name;
					item[l].fixedName=item[l+1].fixedName;
					item[l].alias=item[l+1].alias;
					item[l].data=item[l+1].data;
				}
			}
			outItems--;items--;
		}
	}
	
	// check for mixed part
// 	for(int y=0;y<parts;y++){
// 		if(partHeader[y].contenttype=="multipart/mixed"){
// 			//kdDebug()<< "[KmhtmlArchive::readData]: multipart/mixed found at " << y << endl;
// 			// if multipart/mixed, combine html files....
// 			int indx[5];
// 			int ind=-1;
// 			for(int i=0;i<items;i++){
// 				if(item[i].level>y && (item[i].mimeType==type || item[i].mimeType=="text/plain")){
// 					ind++;
// 					indx[ind]=i;
// 				}
// 			}
// 			kdDebug()<< "[KmhtmlArchive::readData]: ind="<<ind<<endl;
// 			for(int i=0;i<=ind;i++) kdDebug()<< "[KmhtmlArchive::readData]: indx[ind]="<<indx[i]<<endl;
// 
// 			break;
// 		}
// 	}
	
	emit foundFilesInArchive(outItems);
	//kdDebug()<< "[KmhtmlArchive::readData]: items=" << items << endl;
	m_entries.clear();
	for(i=0;i<outItems;i++) m_entries.insert(m_entries.end(),item[i].alias);
	//return FALSE; // test case
	return TRUE;
}
/*================================
================================*/
bool KmhtmlArchive::readItemsHeader(QCString* cont,int count){
	int i=0;
	int j=0;
	int prevItems=items;
	QCString b=partHeader[count].boundary;
	if(b.isEmpty()){
		//kdDebug()<< "[KmhtmlArchive::readItemsHeader()]: b.isEmpty(), count =" << count << endl;
		items=1;
		item[0].start=0;
		item[0].header=partHeader[count].header;
		i=item[0].header.length();
		while(cont->mid(i,1)==controlChars[0] || cont->mid(i,1)==controlChars[1]) i++;
		item[0].itStart=i;
		//kdDebug()<< "[KmhtmlArchive::readItemsHeader()]: (b.isEmpty()) item[0].itStart = " << item[0].itStart << endl;
		item[0].end=cont->length();
	}else{
		while((j=cont->find(b.data(),j))!=-1){
			//kdDebug()<< "[KmhtmlArchive::readItemsHeader()]: j="<<j<<endl;
			if((uint)j>cont->length()) break;
			items++;
			j+=b.length();
			i=j;
		}
		uint lastBoundary=i;
		items-=2; // don't count the header and the last instance
		//kdDebug()<< "[KmhtmlArchive::readItemsHeader()]: items=" << items << " count="<<count<< endl;
		if(!items) return FALSE;
		//kdDebug()<< "[KmhtmlArchive::readItemsHeader()]: items=" << items << endl;
		// reallocate items
		if(items>allocItems){
			// reallocate item
			struct elm* tpmItem;
			tpmItem=new elm[items];
			for(int o=0;o<prevItems;o++){
				tpmItem[o].start=item[o].start;
				tpmItem[o].end=item[o].end;
				tpmItem[o].itStart=item[o].itStart;
				tpmItem[o].header=item[o].header;
				tpmItem[o].level=item[o].level;
				tpmItem[o].isInvalid=FALSE;
				// addition
				tpmItem[o].encodedSize=item[o].encodedSize;
				tpmItem[o].decodedSize=item[o].decodedSize;
				tpmItem[o].contentLocation=item[o].contentLocation;
				tpmItem[o].contentID=item[o].contentID;
				tpmItem[o].dispFileName=item[o].dispFileName;
				tpmItem[o].encoding=item[o].encoding;
				tpmItem[o].charset=item[o].charset;
				tpmItem[o].mimeType=item[o].mimeType;
				tpmItem[o].hasExtension=item[o].hasExtension;
				tpmItem[o].fixed=item[o].fixed;
				tpmItem[o].name=item[o].name;
				tpmItem[o].fixedName=item[o].fixedName;
				tpmItem[o].alias=item[o].alias;
				tpmItem[o].data=item[o].data;
			}
			for(int o=0;o<items;o++){
				tpmItem[o].data=0;
				tpmItem[o].fixed=FALSE;
				//tpmItem[o].level=0;
			}
			delete [] item;
			item=tpmItem;
			allocItems=items;
		}

		//kdDebug()<< "[KmhtmlArchive::readItemsHeader()]: i+length = " << i << ", file length = " << cont->length() << endl;
		//kdDebug()<< "-------------- [KmhtmlArchive::readItemsHeader()]: items = " << items << endl;

	/*
		//check end of file
		// After the last found boundary I can accept --
		QCString a;
		a.sprintf("%c",0x2d);
		if(cont->mid(i,1)!=a || cont->mid(i+1,1)!=a){
			//kdDebug()<< "[KmhtmlArchive::readItemsHeader()]: " << cont->mid(i,1) << ", " << cont->mid(i+1,1)<< endl;
			emit errorAppeared(2); //FIX ?
			status=2;
			//kdDebug()<< "[KmhtmlArchive::readItemsHeader()]: invalid end of file" << endl;
			return FALSE;
		}
		*/

		i=cont->find(b);
		// find item start
		for(j=prevItems;j<items;j++){
			i=cont->find(b,i+1);
			item[j].start=i+b.length();
			if(isDOS) item[j].start+=2;
			else item[j].start++;
			if(j>prevItems && j<items){
				item[j-1].end=item[j].start-b.length();
				//kdDebug() << "[KmhtmlArchive::readItemsHeader()]: item "  << j-1 << " end = " << (uint)item[j-1].end << endl;
				if(cont->mid(item[j-1].end,1)!=controlChars[0] && cont->mid(item[j-1].end,1)!=controlChars[1]){
					item[j-1].end--;
					while(cont->mid(item[j-1].end,1)!=controlChars[0] && cont->mid(item[j-1].end,1)!=controlChars[1]){
						item[j-1].end--;
						//kdDebug()<<" ! item[j-1].end="<<(uint)item[j-1].end<<endl;
					}
				}
				while(cont->mid(item[j-1].end,1)==controlChars[0] || cont->mid(item[j-1].end,1)==controlChars[1]){
					item[j-1].end--;
					//kdDebug()<<"   item[j-1].end="<<(uint)item[j-1].end<<endl;
				}
				//kdDebug() << "[KmhtmlArchive::readItemsHeader()]: item "  << j-1 << " start=" << (uint)item[j-1].start << " itStart=" << (uint)item[j-1].itStart << " end = " << (uint)item[j-1].end << endl;
			}
			//kdDebug() << "[KmhtmlArchive::readItemsHeader()]: item "  << j << " start = " << (uint)item[j].start << endl;
		}
		item[items-1].end=lastBoundary-b.length();
		item[items-1].end=cont->findRev(10,item[items-1].end);
		while(cont->mid(item[items-1].end,1)==controlChars[0] || cont->mid(item[items-1].end,1)==controlChars[1]) item[items-1].end--;
		//kdDebug() << "[KmhtmlArchive::readItemsHeader()]: item "  << items-1 << " end = " << (uint)item[items-1].end << endl;
		//kdDebug() << "[KmhtmlArchive::readItemsHeader()]: item "  << j-1 << " end = " << (uint)item[j-1].end << endl;
		for(i=prevItems;i<items;i++){
			item[i].level=count;
			//kdDebug()<<"[KmhtmlArchive::readItemsHeader]: item[" << i << "] level = " << count << endl;
			j=item[i].start;
			if(isDOS){
				bool found=FALSE;
				while(!found){
					//kdDebug() << "[KmhtmlArchive::readItemsHeader()]: before j="  << j << endl;
					j=cont->find(10,j+1);
					//if(j>item[i].end) found=TRUE;
					//kdDebug() << "[KmhtmlArchive::readItemsHeader()]: after j="  << j << endl;
					if(cont->mid(j+1,1)==controlChars[0] && cont->mid(j+2,1)==controlChars[1]){
						item[i].header=removeControlChars(cont->mid(item[i].start,j+2-item[i].start));
						found=TRUE;
						item[i].itStart=j+2;
						//kdDebug() << "[KmhtmlArchive::readItemsHeader()]: itStart ="  << item[i].itStart << endl;
					}
				}
			}else{
				//kdDebug()<< "[KmhtmlArchive::readItemsHeader()]: ! isDOS" << endl;
				bool found=FALSE;
				while(!found){
					//kdDebug() << "[KmhtmlArchive::readItemsHeader()]: before j="  << j << endl;
					j=cont->find(10,j+1);
					//kdDebug() << "[KmhtmlArchive::readItemsHeader()]: after j="  << j << endl;
					if(cont->mid(j+1,1)==controlChars[1]){
						//kdDebug() << "[KmhtmlArchive::readItemsHeader()] found!!!" << endl;
						//kdDebug() << "item[i].start=" << item[i].start << " j=" << j << endl;
						//kdDebug() <<removeControlChars(cont->mid(item[i].start,j+2-item[i].start))<< endl;
						item[i].header=removeControlChars(cont->mid(item[i].start,j+2-item[i].start));
						//kdDebug() << "[KmhtmlArchive::readItemsHeader()] header set!!!" << endl;
						found=TRUE;
						item[i].itStart=j+2;
						//kdDebug() << "[KmhtmlArchive::readItemsHeader()]: itStart ="  << item[i].itStart << endl;
					}
				}
			}
		}
	}
	// return FALSE; // test case
	return TRUE;
}
/*================================
================================*/
QDateTime KmhtmlArchive::datetime() const{
	QDateTime d;
	d.setTime_t( m_mtime );
	return d;
}
/*================================
================================*/
void KmhtmlArchive::fixFileName(const QByteArray &exC,int i){
	QString ext=QString::null;
	QString tmp=item[i].name;
	if(tmp.isEmpty()){
		// if no name candidate found, fall back to mimetype
		int c=item[i].mimeType.find("/");
		tmp=item[i].mimeType.left(c);
		//kdDebug() << "[KmhtmlArchive::fixFileName]: tmp=" << tmp << endl;
	}
	if(item[i].mimeType=="application/octet-stream"){
		int accuracy=0;
		KMimeType::Ptr mt = KMimeType::findByContent(exC, &accuracy );
		if(mt->name().startsWith("text")) item[i].mimeType=mt->name();
	}
	KMimeType::Ptr ptr;
	ptr= KMimeType::mimeType(item[i].mimeType );
	//kdDebug() << "[KmhtmlArchive::fixFileName]: ptr=" << ptr->name() << endl;
	if(ptr->name()=="application/octet-stream"){
		int accuracy=0;
		ptr = KMimeType::findByContent(exC, &accuracy );
		//kdDebug() << "[KmhtmlArchive::fixFileName]: fixxed ptr=" << ptr->name() << endl;
	}
	QStringList patterns=ptr->patterns();
	for ( QStringList::Iterator it = patterns.begin(); it != patterns.end(); ++it ) {
		if(ext.isNull()){
			ext=*it;
			ext=ext.mid(2);
		}
		//kdDebug() << "[KmhtmlArchive::fixFileName]: ext=" << ext << endl;
		if(!ext.isNull() && ext.length()>3){
			QString text=(*it).mid(2);
			//kdDebug() << "[KmhtmlArchive::fixFileName]: text=" << text << endl;
			if(text.length()<4){
				ext=text;
				break;
			}
		}
	}
	ext=ext.lower();
	//kdDebug() << "[KmhtmlArchive::fixFileName]: extension=" << ext << " item=" << i << " name="  << tmp << endl;
	if(!item[i].hasExtension){
		tmp=tmp.append("." +ext);
		item[i].hasExtension=TRUE;
	}else{
		if(!ext.isEmpty() && !tmp.endsWith(".css",FALSE) && !tmp.endsWith(".js",FALSE)){
			int c=tmp.findRev(".");
			tmp=tmp.left(c+1)+ext;
		}
	}
	ptr= KMimeType::mimeType(item[i].mimeType );
	item[i].fixedName=tmp;
	//kdDebug() << "[KmhtmlArchive::fixFileName]: alias=" << item[i].alias << endl;
}
/*================================
================================*/
bool KmhtmlArchive::readPartHeader(int it){
	QString tmp;
	QString resTmp;
	QString smsg;

	bool errorFound=FALSE;
	int i=0;
	int j;
	if(it==-1){
		parts=0;
		partHeader=new HEADER[1];
		isDOS=findLineEnd();
		int l=-1;
		int c=0;
		bool found=FALSE;
		while(!found){
			i=f.find(10,i+1);
			if(c==0) l=i;
			else{
				if(l==i){
					emit errorAppeared(3);
					status=3;
					return FALSE;
				}
			}
			c++;
			if(isDOS && f.mid(i+1,1)==controlChars[0] && f.mid(i+1,1)==controlChars[0]) found=TRUE;
			else if(!isDOS && f.mid(i+1,1)==controlChars[1]) found=TRUE;
		}
		while(f.mid(i,1)==controlChars[0] || f.mid(i,1)==controlChars[1]) i--;
		partHeader->header=f.mid(0,i+1);
		//kdDebug() << "[KmhtmlArchive::readPartHeader]: header=" << partHeader->header << endl;
		parts++;
		//kdDebug() << "[KmhtmlArchive::readPartHeader]: parts=" << parts << endl;
		it=parts-1;
		// read message info
		#define MSG_INFO_NUM 6
		int info_ind[MSG_INFO_NUM][3]={{0,0,6},{1,0,4},{2,0,9},{3,0,4},{4,0,4},{5,0,6}};
		// 0	From: { (id) , index in header, field length }
		// 1	To: { (id) , index in header, field length }
		// 2	Subject: { (id) , index in header, field length }
		// 3	Cc: { (id) , index in header, field length }
		// 4	Bcc: { (id) , index in header, field length }
		// 5	Date: { (id) , index in header, field length }
		for(j=0;j<MSG_INFO_NUM;j++) info_ind[j][0]=j;
		//info_ind[0][2]=6;info_ind[0][2]=6;
		info_ind[0][1]=partHeader->header.find("From:",0,FALSE);
		if(info_ind[0][1]!=-1 && info_ind[0][1]!=0){
			// make sure this is the From: field and not a xxxx-From:
			while(!(partHeader->header.mid(info_ind[0][1]-1,1)==controlChars[0] || partHeader->header.mid(info_ind[0][1]-1,1)==controlChars[1]) && info_ind[0][1]!=-1){
				info_ind[0][1]=partHeader->header.find("From:",info_ind[0][1]+1,FALSE);
			}
		}
		info_ind[1][1]=partHeader->header.find("To:",0,FALSE);
		if(info_ind[1][1]!=-1){
			// make sure this is the To: field and not a xxxx-To:
			while(!(partHeader->header.mid(info_ind[1][1]-1,1)==controlChars[0] || partHeader->header.mid(info_ind[1][1]-1,1)==controlChars[1]) && info_ind[1][1]!=-1){
				info_ind[1][1]=partHeader->header.find("To:",info_ind[1][1]+1,FALSE);
			}
		}
		info_ind[2][1]=partHeader->header.find("Subject:",0,FALSE);
		info_ind[3][1]=partHeader->header.find("Cc:",0,FALSE);
		info_ind[4][1]=partHeader->header.find("Bcc:",0,FALSE);
		info_ind[5][1]=partHeader->header.find("Date:",0,FALSE);
		// sort array
		int temp0;
		int temp1;
		int temp2;
		for (i = (MSG_INFO_NUM - 1); i >= 0; i--){
			for (j = 1; j <= i; j++){
				if (info_ind[j-1][1] > info_ind[j][1]){
					temp0 = info_ind[j-1][0];
					temp1 = info_ind[j-1][1];
					temp2 = info_ind[j-1][2];
					info_ind[j-1][0] = info_ind[j][0];
					info_ind[j-1][1] = info_ind[j][1];
					info_ind[j-1][2] = info_ind[j][2];
					info_ind[j][0] = temp0;
					info_ind[j][1] = temp1;
					info_ind[j][2] = temp2;
				}
			}
		}
		for(i=0;i<MSG_INFO_NUM;i++){
			if(info_ind[i][1]!=-1){
				tmp=partHeader->header.mid(info_ind[i][1]);
				// cut unwanted headers
				int otherHeader=tmp.find('\n');
				otherHeader=tmp.find(":",otherHeader+1);
				if(otherHeader!=-1){
					int trunc=tmp.findRev('\n',otherHeader);
					tmp=tmp.left(trunc);
				}
				// unfold
				tmp.replace(controlChars[0],"");
				tmp.replace(controlChars[1],"");
				QString mptQString=decodeRFC2047Phrase(QString::fromLocal8Bit(tmp.mid(info_ind[i][2])));
				switch(info_ind[i][0]){
				case 0:	// From:
					mSender=mptQString;
// 				//kdDebug()<< "[KmhtmlArchive::readPartHeader]: From=" << mSender << endl;
					break;;
				case 1:	// To:
					mRecipient=mptQString;
// 				//kdDebug()<< "[KmhtmlArchive::readPartHeader]: To=" << mRecipient << endl;
					break;;
				case 2:	// Subject:
					mSubject=mptQString;
 					//kdDebug()<< "[KmhtmlArchive::readPartHeader]: Subject=" << mSubject << endl;
					break;;
				case 3:	// Cc:
					mCopyTo=mptQString;
// 					//kdDebug()<< "[KmhtmlArchive::readPartHeader]: Cc=" << mCopyTo << endl;
					break;;
				case 4:	// Bc:
					mBlindCopyTo=mptQString;
//					//kdDebug()<< "[KmhtmlArchive::readPartHeader]: Bcc=" << mBlindCopyTo << endl;
					break;;
				case 5:	// Date:
					mDate=mptQString;
//  					//kdDebug()<< "[KmhtmlArchive::readPartHeader]: Date=" << mDate << endl;
					;;
				}
			}
		}
	}
	//kdDebug(  ) << "[KmhtmlEntry::readPartHeader]" << endl << partHeader[it].header << endl;
	if(errorFound){
			//kdDebug(  ) << "[KmhtmlEntry::readHeader]: errorFound" << endl;
			emit errorAppeared(2);
			status=2;
			return FALSE;
	}
	//read boundary
	QCString msg="boundary=";
	i=partHeader[it].header.find(msg);
	if(i==-1){
		partHeader[it].boundary="";
	}else{
		if(it==-1) isSimple=FALSE;
		i=partHeader[it].header.find('"',i);i++;
		int j=partHeader[it].header.find('"',i);
		partHeader[it].boundary=partHeader[it].header.mid(i,j-i);
		if(it==0){
			int h=f.length()-1;
			while(f.mid(h,1)==controlChars[0] || f.mid(h,1)==controlChars[1]) h--;
			if(!f.mid(h,1)==controlChars[0] || !f.mid(h,1)==controlChars[1]){
				emit errorAppeared(3);
				status=3;
				return FALSE;
			}
		}
	}
	//kdDebug()<<"[KmhtmlEntry::readPartHeader]: part="<<it<<" header="<<partHeader[it].header<<endl;
	msg="Content-Type:"; // --------------- read Content-Type
	i=partHeader[it].header.find(msg,0,FALSE);
	if(i==-1) partHeader[it].contenttype="";
	else{
		i++; // to include space ": "
		i+=msg.length();
		int k=partHeader[it].header.find(":",i);
// 		//kdDebug(  ) << "[KmhtmlEntry::readPartHeader]: k=" << k << endl;
		k=partHeader[it].header.findRev(controlChars[1],k);
// 		//kdDebug(  ) << "[KmhtmlEntry::readPartHeader]: k=" << k << endl;
// 		//kdDebug(  ) << "[KmhtmlEntry::readPartHeader] "<< endl << partHeader[it].header.mid(k) << endl;
		QCString tmp=partHeader[it].header.mid(i,k-i);
		tmp.replace(controlChars[0],"");
		tmp.replace(controlChars[1],"");
		//kdDebug(  ) << "[KmhtmlEntry::readPartHeader]: tmp=" << tmp << endl;
		int l=tmp.find(';');
		if(l!=-1){
			partHeader[it].contenttype=tmp.left(l);
			l=tmp.find("type=");
			if(l==-1){
			//kdDebug(  ) << "[KmhtmlEntry::readPartHeader]: type not found" << endl;
				partHeader[it].type="";
			}else{
				//kdDebug(  ) << "[KmhtmlEntry::readPartHeader]: type found" << partHeader[it].charset << endl;
				partHeader[it].type=tmp.mid(l+6);
				partHeader[it].type.remove("\"");
				l=partHeader[it].type.find(",");
				if(l==-1) l=partHeader[it].type.find(" ");
				if(l!=-1) partHeader[it].type=partHeader[it].type.left(l);
				//partHeader[it].type=partHeader[it].type.left(partHeader[it].type.length()-1);
			}
			// added for EML FIX ?
			l=tmp.find("charset=");
			if(l==-1) partHeader[it].charset="";
			else{
				//kdDebug(  ) << "[KmhtmlEntry::readPartHeader]: charset found" << partHeader[it].charset << endl;
				partHeader[it].charset=tmp.mid(l+8);
				//kdDebug(  ) << "[KmhtmlEntry::readPartHeader]: charset=" << partHeader[it].charset << endl;
				partHeader[it].charset.replace("\"","");
				l=partHeader[it].charset.find(",");
				if(l==-1) l=partHeader[it].charset.find(" ");
				if(l!=-1) partHeader[it].charset=partHeader[it].charset.left(l);
			}
		}else{
			//kdDebug(  ) << "[KmhtmlEntry::readPartHeader]: ; not found" << partHeader[it].charset << endl;
			partHeader[it].contenttype=tmp;
			partHeader[it].type="";
			partHeader[it].charset="";
		}
	}
	//kdDebug(  ) << "[KmhtmlEntry::readPartHeader]: contenttype=" << partHeader[it].contenttype << endl;
	//kdDebug(  ) << "[KmhtmlEntry::readPartHeader]: type=" << partHeader[it].type << endl;
	//kdDebug(  ) << "[KmhtmlEntry::readPartHeader]: charset=" << partHeader[it].charset << endl;
	if(it==parts-1){
		// find start etc. for message header
		partHeader->start=0;
		partHeader->end=f.length();
		partHeader->itStart=partHeader->header.length();
		while(f.mid(partHeader->itStart,1)==QCString("-") || f.mid(partHeader->itStart,1)==controlChars[0] || f.mid(partHeader->itStart,1)==controlChars[1]) partHeader->itStart++;
		partHeader->itStart+=partHeader->boundary.length();
		while(f.mid(partHeader->itStart,1)==controlChars[0] || f.mid(partHeader->itStart,1)==controlChars[1]) partHeader->itStart++;
		//kdDebug() << "[KmhtmlArchive::readPartHeader]: partHeader->start=" << partHeader->start << endl;
		//kdDebug() << "[KmhtmlArchive::readPartHeader]: partHeader->end=" << partHeader->end << endl;
		//kdDebug() << "[KmhtmlArchive::readPartHeader]: partHeader->itStart=" << partHeader->itStart << endl;

	}
	//kdDebug() << "[KmhtmlArchive::readPartHeader]: boundary=" << partHeader[it].boundary << endl;
	//kdDebug() << "[KmhtmlArchive::readPartHeader]: contenttype=" << partHeader[it].contenttype << endl;
	//kdDebug() << "[KmhtmlArchive::readPartHeader]: type=" << partHeader[it].type << endl;
	return TRUE;
}
/*================================
================================*/
bool KmhtmlArchive::findLineEnd(){
	if(f.find(13)!=-1) return TRUE;
	return FALSE;
}
/*================================
================================*/
QCString KmhtmlArchive::removeControlChars(const QCString &msg){
	int en;
	int st=0;
	if(msg.isEmpty()) return msg;
	while(msg.mid(st,1)==controlChars[0] || msg.mid(st,1)==controlChars[1]) st++;
	en=msg.length()-1;
	while(msg.mid(en,1)==controlChars[0] || msg.mid(en,1)==controlChars[1] || msg.mid(en,1)==0) en--;
	return msg.mid(st,en-st+1);
}

/*================================
================================*/
void KmhtmlArchive::evalItemHeader(int id){
	#define ITEM_NUM 5
	QCString msg;
	QCString tmp;
	QCString resTmp;
	int i;
	int j;
	int ind[ITEM_NUM][3]={
		{0,0,14},	// 0	Content-Type:
		{1,0,18},	// 1	Content-Location:
		{2,0,27},	// 2	Content-Transfer-Encoding:
		{3,0,13},	// 3	Content-ID: (length+1)
		{4,0,21},	// 4	Content-Disposition:
	};
	// 0	Content-Type:
	// 1	Content-Location:
	// 2	Content-Transfer-Encoding:
	// 3	Content-ID:
	// 4	Content-Disposition:
	//for(j=0;j<ITEM_NUM;j++) ind[j][0]=j;
	ind[0][1]=item[id].header.find("Content-Type:",0,TRUE);
	ind[1][1]=item[id].header.find("Content-Location:",0,TRUE);
	ind[2][1]=item[id].header.find("Content-Transfer-Encoding:",0,TRUE);
	ind[3][1]=item[id].header.find("Content-ID:",0,TRUE);
	ind[4][1]=item[id].header.find("Content-Disposition:",0,TRUE);
	// sort array
	int temp0;
	int temp1;
	int temp2;
	for (i = (ITEM_NUM - 1); i >= 0; i--){
		for (j = 1; j <= i; j++){
			if (ind[j-1][1] > ind[j][1]){
				temp0 = ind[j-1][0];
				temp1 = ind[j-1][1];
				temp2 = ind[j-1][2];
				ind[j-1][0] = ind[j][0];
				ind[j-1][1] = ind[j][1];
				ind[j-1][2] = ind[j][2];
				ind[j][0] = temp0;
				ind[j][1] = temp1;
				ind[j][2] = temp2;
			}
		}
	}
	for(i=0;i<ITEM_NUM;i++){
		if(ind[i][1]!=-1){
			if(i==ITEM_NUM-1){
				tmp=trim(removeControlChars(item[id].header.mid(ind[i][1])));
			}else{
				tmp=trim(removeControlChars(item[id].header.mid(ind[i][1],ind[i+1][1]-ind[i][1])));
			}
			//kdDebug()<<"[KmhtmlArchive::evalItemHeader()]: tpm="<<tmp<<endl;
			int otherHeader=tmp.find(":");
			// cut unwanted headers
			otherHeader=tmp.find(":",otherHeader+1);
			//kdDebug()<<"[KmhtmlArchive::evalItemHeader()]: otherHeader="<<otherHeader<<endl;
			if(otherHeader!=-1){
				int trunc=tmp.findRev(controlChars[1],otherHeader);
				tmp=tmp.left(trunc);
				//kdDebug()<<"[KmhtmlArchive::evalItemHeader()]:"<<endl<<endl<<endl<<endl;
				//kdDebug()<<"[KmhtmlArchive::evalItemHeader()]: fixed tpm="<<tmp<<endl;
				//kdDebug()<<"[KmhtmlArchive::evalItemHeader()]:"<<endl<<endl<<endl<<endl;
			}
			// unfold
			tmp.replace(controlChars[0],"");
			tmp.replace(controlChars[1],"");
			//kdDebug()<<"[KmhtmlArchive::evalItemHeader()]:"<<endl<<endl<<endl<<endl;
			//kdDebug()<<"[KmhtmlArchive::evalItemHeader()]: after replace tpm="<<tmp<<endl;
			//kdDebug()<<"[KmhtmlArchive::evalItemHeader()]:"<<endl<<endl<<endl<<endl;
			resTmp=tmp.mid(ind[i][2]);
			//kdDebug()<<"[KmhtmlArchive::evalItemHeader()]:resTmp="<<resTmp<<endl;
			switch(ind[i][0]){
			case 0: //	Content-Type:
				if(tmp.right(1)==";"){
					item[id].mimeType=resTmp.left(resTmp.length()-1);
				}else{
					int questionmark=resTmp.find(";");
					item[id].mimeType=resTmp.left(questionmark);
					// find charset
					int charsetP=resTmp.find("charset=",questionmark);
					if(charsetP!=-1){
						item[id].charset=resTmp.mid(charsetP+8);
						questionmark=item[id].charset.find(";",charsetP+8);
						if(questionmark!=-1) item[id].charset=item[id].charset.left(questionmark);
					}
					// find start
					int startP=resTmp.find("start=");
					if(startP!=-1){
						item[id].startPart=resTmp.mid(startP+8);
						item[id].startPart=item[id].startPart.left(item[id].startPart.length()-2);
						//kdDebug() << "[KmhtmlArchive::evalItemHeader()]: startPart=" << item[id].startPart << endl;
					}
					// find name (for eml files)
					int nameP=resTmp.find("name=");
					if(nameP!=-1){
						item[id].dispFileName=QString::fromLocal8Bit(resTmp.mid(nameP+6));
						item[id].dispFileName=item[id].dispFileName.left(item[id].dispFileName.length()-1);
						//kdDebug() << "[KmhtmlArchive::evalItemHeader()]: name=" << item[id].dispFileName << endl;
					}
				}
				item[id].mimeType=item[id].mimeType.lower();
				//kdDebug() << "[KmhtmlArchive::evalItemHeader()]: mimeType=" << item[id].mimeType << endl;
				//kdDebug() << "[KmhtmlArchive::evalItemHeader()]: charset=" << item[id].charset << endl;
				//if(item[id].mimeType!=type) item[id].fixed=TRUE;
				break;;
			case 1: //	Content-Location:
				item[id].contentLocation=QString::fromLocal8Bit(resTmp);
				j=item[id].contentLocation.findRev("/");
				if(j!=-1) item[id].base=item[id].contentLocation.left(j);
				//if(j!=-1) item[id].base=item[id].contentLocation.left(j+1); // include '/'
				//kdDebug() << "[KmhtmlArchive::evalItemHeader()]: base=" << item[id].base << endl;
				break;;
			case 2: //	Content-Transfer-Encoding:
				if(resTmp.left(16)==QCString("quoted-printable")) item[id].encoding=0;
				else if(resTmp.left(6)==QCString("base64")) item[id].encoding=1;
				else if(resTmp.left(8)==QCString("uuencode")) item[id].encoding=2;
				else if(resTmp.left(4)==QCString("7bit") || resTmp.left(5)==QCString("7-bit")) item[id].encoding=3;
				else if(resTmp.left(4)==QCString("8bit") || resTmp.left(5)==QCString("8-bit")) item[id].encoding=4;
				else item[id].encoding=-1;
				//kdDebug()<<"[KmhtmlArchive::evalItemHeader()]:encoding="<<item[id].encoding<<endl;
				break;;
			case 3: //	Content-ID:
				item[id].contentID=resTmp.left(resTmp.length()-1);
				//kdDebug() << "[KmhtmlArchive::evalItemHeader()]: Content-ID=" << item[id].contentID << endl;
				break;;
			case 4: //	Content-Disposition:
				int questionmark=resTmp.find(";");
				item[id].contentDisposition=resTmp.left(questionmark);
				questionmark=resTmp.find("filename=");
				if(resTmp.mid(questionmark+9,1)=="\"") questionmark++;
				item[id].dispFileName=QString::fromLocal8Bit(resTmp.mid(questionmark+9));
				if(item[id].dispFileName.endsWith("\""))  item[id].dispFileName=item[id].dispFileName.left(item[id].dispFileName.length()-1);
				item[id].dispFileName=decodeRFC2047Phrase(item[id].dispFileName);
				item[id].alias=item[id].dispFileName;
// 				kdDebug() << "[KmhtmlArchive::evalItemHeader()]: Content-Disposition=" << item[id].contentDisposition << endl;
// 				kdDebug() << "[KmhtmlArchive::evalItemHeader()]: dispFileName=" << item[id].dispFileName << endl;
// 				kdDebug() << "[KmhtmlArchive::evalItemHeader()]: alias=" << item[id].alias << endl;
// kdDebug() << "[KmhtmlArchive::evalItemHeader()]: id=" << id << endl;
				break;;
				
			}
		}else{
			if(ind[i][0]==2) item[id].encoding=-1;
		}
	}

// 	//kdDebug() << "[KmhtmlArchive::evalItemHeader()]"<< endl;
// 	//kdDebug() << "[KmhtmlArchive::evalItemHeader()]"<< endl;
// 	//kdDebug() << "[KmhtmlArchive::evalItemHeader()]"<< endl;
// 	//kdDebug() << "[KmhtmlArchive::evalItemHeader()]"<< endl;
// 	//kdDebug() << "[KmhtmlArchive::evalItemHeader()]: encoding="<< item[id].encoding << endl;
// 	//kdDebug() << "[KmhtmlArchive::evalItemHeader()]: mimeType"<< item[id].mimeType << endl;
// 	//kdDebug() << "[KmhtmlArchive::evalItemHeader()]: contentLocation="<< item[id].contentLocation << endl;
// 	//kdDebug() << "[KmhtmlArchive::evalItemHeader()]: base=" << item[id].base << endl;
// 	//kdDebug() << "[KmhtmlArchive::evalItemHeader()]: contentID="<< item[id].contentID << endl;
// 	//kdDebug() << "[KmhtmlArchive::evalItemHeader()]: contentDisposition=" << item[id].contentDisposition << endl;
// 	//kdDebug() << "[KmhtmlArchive::evalItemHeader()]: dispFileName="<< item[id].dispFileName << endl;
// 	//kdDebug() << "[KmhtmlArchive::evalItemHeader()]"<< endl;
// 	//kdDebug() << "[KmhtmlArchive::evalItemHeader()]"<< endl;
// 	//kdDebug() << "[KmhtmlArchive::evalItemHeader()]"<< endl;
// 	//kdDebug() << "[KmhtmlArchive::evalItemHeader()]"<< endl;

	// check header
	//kdDebug() << "[KmhtmlArchive::evalItemHeader()]: level="<<item[id].level<<endl;
	//kdDebug() << "[KmhtmlArchive::evalItemHeader()]"<<endl<<item[id].mimeType<<endl<<partHeader[item[id].level].type<<endl<<item[id].charset<<endl<<partHeader[item[id].level].charset<<endl;



	if(item[id].mimeType.isEmpty() && !partHeader[item[id].level].type.isEmpty()) item[id].mimeType=partHeader[item[id].level].type;
	if(item[id].charset.isEmpty() && !partHeader[item[id].level].charset.isEmpty()) item[id].charset=partHeader[item[id].level].charset;



/*
Somehow dispFileName loses its value when an attachment with
filename is set. This is a dirty hack
*/
if(!item[id].alias.isEmpty()) item[id].dispFileName=item[id].alias;


	//if(item[id].encoding==-1 && item[id].mimeType.isEmpty() && item[id].contentLocation.isEmpty() && item[id].contentID.isEmpty() && item[id].dispFileName.isEmpty()){

	if(item[id].encoding==-1 && item[id].mimeType.isEmpty() && item[id].contentID.isEmpty() && item[id].dispFileName.isEmpty() && item[id].charset.isEmpty()){
		// this is the alternative text for brousers without mhtml support
		if(item[id].contentLocation.isEmpty() && id>0){
			item[id].header="";
			item[id].itStart=item[id].start;
			//kdDebug() << "[KmhtmlArchive::evalItemHeader()]: reseting contents..."<< endl;
		}
		item[id].encoding=3;
		item[id].mimeType="text/plain";
		item[id].name="Alternative text.txt";
		item[id].alias="Alternative text.txt";
		item[id].hasExtension=TRUE;
	}else if(item[id].encoding==3 && item[id].mimeType=="text/plain" && item[id].contentLocation.isEmpty() && item[id].contentID.isEmpty() && item[id].dispFileName.isEmpty()){
		item[id].name="Alternative text.txt";
		item[id].alias="Alternative text.txt";
		item[id].hasExtension=TRUE;
	}else{
		// I don't know what it is... display as is
		if(item[id].encoding==-1) item[id].encoding=3;
		// extract file name
		item[id].hasExtension=FALSE;
		
		if(!item[id].dispFileName.isEmpty()){
// 			kdDebug() << "[KmhtmlArchive::evalItemHeader()]: here I am" << endl;
// 			kdDebug() << "[KmhtmlArchive::evalItemHeader()]: dispFileName(1)="<< item[id].dispFileName << endl;
			item[id].name=item[id].dispFileName;
			item[id].alias=item[id].dispFileName;
			item[id].hasExtension=TRUE;
		}else{
// 			kdDebug() << "[KmhtmlArchive::evalItemHeader()]: here I am again" << endl;
			//kdDebug() << "[KmhtmlArchive::evalItemHeader()]: alias="<< item[id].alias << endl;
			item[id].alias="";
			//kdDebug() << "[KmhtmlArchive::evalItemHeader()]: alias="<< item[id].alias << endl;
			if(!item[id].contentLocation.isEmpty()){
				int c=item[id].contentLocation.findRev("/");
				if(c!=-1) item[id].name=item[id].contentLocation.right(item[id].contentLocation.length()-c-1);
				else item[id].name=item[id].contentLocation;
				//kdDebug() << "[KmhtmlArchive::evalItemHeader()]: item=" << id << " name=" << item[id].name << endl;
				c=item[id].contentLocation.findRev(QChar(0x5c));
				if(c!=-1) item[id].name=item[id].contentLocation.right(item[id].contentLocation.length()-c-1);
				//kdDebug() << "[KmhtmlArchive::evalItemHeader()]: item=" << id << " name=" << item[id].name << endl;
//				c=-1;
// 				while ((c=item[id].name.find("?",c+1))!=-1) item[id].name=item[id].name.right(item[id].name.length()-c-1);
				c=item[id].name.find("?");
				if(c!=-1) item[id].name=item[id].name.left(c);
				//kdDebug() << "[KmhtmlArchive::evalItemHeader()]: item=" << id << " name=" << item[id].name << endl;
				c=-1;
				while ((c=item[id].name.find("=",c+1))!=-1) item[id].name=item[id].name.right(item[id].name.length()-c-1);
				//kdDebug()<< "[KmhtmlArchive::readItems()]: item[id].name = " << item[id].name << endl;
				c=item[id].name.find(".");
				if(c!=-1) item[id].hasExtension=TRUE;
			}else if(!item[id].contentID.isEmpty()){
				int papaki=item[id].contentID.find("@");
				int dot=item[id].contentID.find(".");
				if(dot<papaki && dot!=-1) item[id].fixedName=item[id].contentID.left(dot);
			}
			// Calculate item size
			item[id].encodedSize=item[id].end-item[id].itStart;
			if(item[id].name.endsWith(".js",FALSE)) item[id].mimeType="text/plain";
		}
// 		kdDebug() << "[KmhtmlArchive::evalItemHeader()]: item=" << id << " name=" << item[id].name << endl;
// 		kdDebug() << "[KmhtmlArchive::evalItemHeader()]: item=" << id << " fixedName=" << item[id].fixedName << endl;
// 		kdDebug() << "[KmhtmlArchive::evalItemHeader()]: item=" << id << " alias=" << item[id].alias << endl;
	}
}
/*================================
================================*/
QCString KmhtmlArchive::trim(const QCString &tmp){
	int st=0;
	int en=0;
	for(uint i=0;i<tmp.length();i++){
		if(tmp.mid(i,1)==" " || tmp.mid(i,1)=="\t") st++;
		else break;
	}
	for(uint i=tmp.length()-1;i<=0;i--){
		if(tmp.mid(i,1)==" " || tmp.mid(i,1)=="\t") en++;
		else break;
	}
	return tmp.mid(st,tmp.length()-st-en);
}
// KmhtmlEntry
/*================================
================================*/
// KmhtmlEntry::KmhtmlEntry(){
// 	archive=0;
// 	it=-1;
// 	//onlyfname="";
// 	m_exists=FALSE;
// }
/*================================
================================*/
KmhtmlEntry::KmhtmlEntry(KmhtmlArchive* arch,const QString &fileName){
	charsetCretiria=0;
	charsetCretiriaCalculated=false;
	if(arch){
		archive=arch;
		fname=fileName;
		//kdDebug() << "[KmhtmlEntry::KmhtmlEntry()]: findItemByName" << endl;
		if(!findItemByName()){
			//kdDebug() << "[KmhtmlEntry::KmhtmlEntry()]: does not exist!!! " << fname << endl;
			m_exists=FALSE;
			//kdDebug() << "[KmhtmlEntry::KmhtmlEntry()]: return" << endl;
			return;
		}
		else m_exists=TRUE;
		//kdDebug() << "[KmhtmlEntry::KmhtmlEntry()]: exists!!!" << endl;
	}else{
		archive=0;
		it=-1;
		fname="";
		m_exists=FALSE;
	}
}
/*================================
================================*/
KmhtmlEntry::KmhtmlEntry(KmhtmlArchive* arch, int item){
	charsetCretiria=0;
	charsetCretiriaCalculated=false;
	if(arch){
		archive=arch;
		it=item;
		if(!findItemById()){
			m_exists=FALSE;
			return;
		}
		else m_exists=TRUE;
		//kdDebug()<< "KmhtmlEntry::KmhtmlEntry(KmhtmlArchive* arch, int item): it = " << it << endl;
	}else{
		archive=0;
		it=-1;
		fname="";
	}
}
/*================================
================================*/
KmhtmlEntry::~KmhtmlEntry(){
}
/*================================
================================*/
QDateTime KmhtmlEntry::datetime() const{
	QDateTime d;
	d.setTime_t( archive->m_mtime );
	return d;
}
/*================================
================================*/
bool KmhtmlEntry::findItemById(){
	fname="";
	if(it>=0 && it<archive->items) fname=archive->item[it].name;
	else return FALSE;
	return TRUE;
}
/*================================
================================*/
bool KmhtmlEntry::findItemByName(){
	it=-1;
	if(fname.isEmpty()) return FALSE;
	else{
		for(int i=0;i<archive->items;i++)
			if(fname==archive->item[i].name || fname==archive->item[i].alias) it=i;
		if(it==-1) return FALSE;
	}
	return TRUE;
}
// /*================================
// ================================*/
// void KmhtmlEntry::fixName(){
// 	int c=-1;
// 	c=fname.findRev("/");
// 	if(c==-1) onlyfname=fname;
// 	else onlyfname=fname.mid(c+1);
// }
// /*================================
// ================================*/
// QString KmhtmlEntry::name(){
// 	int c=falias.findRev("/");
// 	//kdDebug()<<"[KmhtmlEntry::name()]: falias=" << falias << endl;
// 	//kdDebug()<<"[KmhtmlEntry::name()]: item[i].alias=" << archive->item[it].alias << endl;
// 	if(c==-1) return falias;
// 	else return falias.mid(c+1);
// }
/*================================
================================*/
QString KmhtmlEntry::escapeString(const QString &str) const{
	QString ret( str );
	const QString escape_me( "\\/()[]{}$^" );
	for (int i=ret.length()-1; i>=0; --i) {
		if (escape_me.find(ret[i]) != -1)
			ret.insert(i,'\\');
	}
	return ret;
}
/*================================
================================*/
QByteArray* KmhtmlEntry::data(){
	if(!archive->item[it].fixed && (archive->item[it].mimeType=="text/html" || archive->item[it].mimeType=="text/xml" || archive->item[it].mimeType=="application/xhtml+xml")){
		QCString str;
		//kdDebug()<< "[KmhtmlEntry::data]: str=" << str <<endl;
		str=archive->item[it].data;
		// find base URL
		QRegExp findBase;
		findBase.setCaseSensitive(FALSE);
		findBase.setMinimal(TRUE);
		findBase.setWildcard(FALSE);
		findBase.setPattern("<base.*href.*=(.*)>");
		int pos = findBase.search( QString(str) );
		//kdDebug()<<"[KmhtmlEntry::data()]: pos="<< pos <<endl;
		if ( pos > -1 ) {
				QString tmp=findBase.cap(1);
				tmp=tmp.stripWhiteSpace();
				if(tmp.startsWith("\"")) tmp=tmp.mid(1,tmp.length()-2);
				//kdDebug()<<"base url="<<tmp<<endl;
				archive->item[it].base=tmp;
				str.remove(pos,findBase.matchedLength());
		}
		QRegExp findReg;
		findReg.setCaseSensitive(TRUE);
		findReg.setMinimal(TRUE);
		findReg.setWildcard(FALSE);
		for(int j=0;j<archive->count();j++){
			KmhtmlEntry arcF(archive, j);
			if(arcF.mimeType()!=archive->Type()){
				// fix links
				if(!arcF.contentLocation().isEmpty()){
					QString loc=escapeString(arcF.contentLocation());
					if(!loc.isEmpty()){
						findReg.setPattern("\"" + loc + "\"");
						str.replace(findReg,arcF.name());
						int sl=arcF.contentLocation().findRev("/");
						if(sl!=-1){
							loc=escapeString(arcF.contentLocation().mid(sl+1));
							if(!loc.isEmpty()){
								findReg.setPattern("\"" + loc + "\"");
								str.replace(findReg,arcF.name().local8Bit());
							}
						}
					}
				}
				QString arcFname=escapeString(arcF.name());
				//kdDebug()<< "arcFname=" << arcFname << endl;
				if(!arcF.originalName().isEmpty()){
					QString arcForiginalName=escapeString(arcF.originalName());
					//kdDebug()<< "arcForiginalName=" << arcForiginalName << endl;
					if(arcF.originalName()!=arcF.name()){
						int found=0;
						while(found!=-1){
							found=str.find(arcF.originalName().local8Bit(),found+1);
							if(found!=-1){
								int endFound=found;
								endFound+=arcF.originalName().length();
								if(str.mid(endFound,1)==QCString(">")
									|| str.mid(endFound,1)==QCString(" ")
									|| str.mid(endFound,1)==QCString("\'")
									|| str.mid(endFound,1)==QCString("\"")
									|| str.mid(endFound,1)==QCString("\r")
									|| str.mid(endFound,1)==QCString("\n")
									|| str.mid(endFound,1)==QCString("\t")) {
									str.replace(found,endFound-found,arcF.name().local8Bit());
									//kdDebug()<<"replacing "<<arcF.originalName() << " with " << arcF.name() <<endl;
								}
							}
						}
						//str.replace(findReg,arcF.name());
					}
					findReg.setPattern(QString("http://[^ ]*") + arcFname );
					str.replace(findReg,arcF.name());
					findReg.setPattern(QString("file://.*") + arcFname );
					str.replace(findReg,arcF.name());
					findReg.setPattern(QString("ftp://.*") + arcFname );
					str.replace(findReg,arcF.name().local8Bit());
				}
				if(!archive->item[j].contentID.isEmpty()){
					QString contID=escapeString(archive->item[j].contentID);
					contID.prepend("cid:");
					findReg.setPattern( contID );
					str.replace(findReg,arcF.name().local8Bit());
				}
			}
		}
		//kdDebug()<<"[KmhtmlEntry::data()]: isEML="<<archive->isEML<<endl;
// 		if(archive->isEML){
			// make links
			if(archive->isMarkupFromText){
				// create colored >> fields
				gtEl=new struct GT_ELEMENTS[5];
				struct GT_ELEMENTS *tmpEl;
				int gtElCount=5;
				int curGtEl=-1;
				int find=0;
				int gtCount;
				while((find=str.find("\n> ",find))!=-1){
					//kdDebug()<<"find="<<find<<endl;
					curGtEl++;
					if(curGtEl==gtElCount){
						// realloc
						gtElCount+=5;
						tmpEl=new struct GT_ELEMENTS[gtElCount];
						for(int i=0;i<=curGtEl;i++){
							tmpEl[i].start=gtEl[i].start;
							tmpEl[i].end=gtEl[i].end;
							tmpEl[i].level=gtEl[i].level;
						}
						delete gtEl;
						gtEl=tmpEl;
					}
					gtEl[curGtEl].start=find+1;
					int end=0;
					find++;
					if(archive->isDOS) end=str.find("\r",find);
					else end=str.find("\n",find);
					//kdDebug()<<"end="<<end<<endl;
					//kdDebug()<<"\""<<str.mid(gtEl[curGtEl].start,10)<<"\""<<endl;
					gtEl[curGtEl].end=end;
					
					// calculate level
					int tmp=0;
					int oldTmp=0;
					gtEl[curGtEl].level=-1;
					QCString oneLine=str.mid(gtEl[curGtEl].start,gtEl[curGtEl].end-gtEl[curGtEl].start);
					while((tmp=oneLine.find("> ",tmp))!=-1){
						if(tmp-oldTmp-2>0) break;
						gtEl[curGtEl].level++;
						oldTmp=tmp;
						tmp++;
					}
					gtEl[curGtEl].level=gtEl[curGtEl].level%3;
					//kdDebug()<<oneLine<<endl;
					//kdDebug()<<"gtEl["<<curGtEl<<"].level="<<gtEl[curGtEl].level<<endl;
					find=end;
				}
				// create part to be added
				QCString ins[5];
				for(int i=0;i<3;i++){
					ins[i]="<font ";
					//face=\"
					if(KC.quotedFontName(i)!=KC.bodyFontName() || KC.quotedFontName(i).isEmpty()){
						ins[i].append("color=\"");
					}else{
						ins[i].append("face=\"");
						ins[i].append(KC.quotedFontName(i));
						ins[i].append("\" color=\"");
					}
					ins[i].append(KC.quotedFontColor(i));
					ins[i].append("\">");
					if(KC.isQuotedFontBold(i)) ins[i].append("<b>");
					if(KC.isBQuotedFontItalics(i)) ins[i].append("<i>");
				}
				
				
				
				
				// add font tags
				for(int i=curGtEl;i>=0;i--){
					QCString enTag("</font>");
					//if(fonts[gtEl[i].level]==fonts[4] && !fonts[4].isEmpty()) enTag="";
					if(KC.isFontItalics(gtEl[i].level)) enTag.append("</i>");
					if(KC.isFontBold(gtEl[i].level)) enTag.append("</b>");
					str.insert(gtEl[i].end,enTag);
					str.insert(gtEl[i].start,ins[gtEl[i].level]);
				}
				// insert level 0 color in lines
				// that contain only a >
				QCString onlyGt;
				if(archive->isDOS) onlyGt="\n><br>\r";
				else onlyGt="\n><br>\n";
				// insert font tags for level 0 color 
				// in lines that contain only a >
				find=0;
				while((find=str.find(onlyGt,find))!=-1){
					str.insert(find+2,"</font>");
					str.insert(find+1,ins[0]);
				}
				delete gtEl;
				
				
				
				// fix body font
				find=str.find("<body ",0);
				//kdDebug()<<"find="<<find<<endl;
				if(find!=-1 && !KC.bodyFontName().isEmpty()){
					find+=6;
					QCString body="style=\"font-family : ";
					body.append(KC.bodyFontName());
					if(!KC.bodyFontSize().isEmpty()){
						body.append("; font-size : ");
						body.append(KC.bodyFontSize());
						body.append("pt;\" ");
					}else{
						body.append(";\" ");
					}
					str.insert(find,body);
				}
// 				while((find=str.find("\n",find))!=-1){
// // 					kdDebug()<<"find="<<find<<endl;
// // 					kdDebug()<<str.mid(find+1,6)<<endl;
// 					if(str.mid(find+1,6)!="<font "){
// 						str.insert(find+1,cols[3]);
// 						find+=cols[3].length();
// 						int closeFont=str.find("\n",find+1);
// 						kdDebug()<<"closeFont="<<closeFont<<endl;
// 						kdDebug()<<str.mid(closeFont+1,6)<<endl;
// 						if(closeFont!=-1) str.insert(closeFont,"</font>");
// 					}else find++;
// 				}
				
				
				
				
				// convert links to html
				#define LINKS 3
				char s[LINKS][15]={
				{"http://[^ ]*\0"},
				{"ftp://[^ ]*\0"},
				{"https://[^ ]*\0"}
				};
				QRegExp findLinks;
				findLinks.setCaseSensitive(FALSE);
				findLinks.setMinimal(TRUE);
				findLinks.setWildcard(FALSE);
				for(int i=0;i<LINKS;i++){
					findLinks.setPattern(s[i]);
					int find=0;
					while((find=str.find(findLinks,find))!=-1){
						int end=str.find("<",find); //might end with <br>
 						if(end==-1) end=str.find(" ",find); // middle of line
 						if(end==-1){
							end=str.find(10,find); // end of line
 							if(archive->isDOS) end--;
						}
						// Does it have a space?
						int space=str.findRev(' ',end);
						while(space!=-1){
							if(space<find) break;
							end=space;
							space=str.findRev(' ',end-1);
						}
						while(str.mid(end-1,1)==QCString(" ") || str.mid(end-1,1)==QCString(".") || str.mid(end-1,1)==QCString(",") || str.mid(end-1,1)==QCString(")")) end--;
						str.insert((uint)end,"</a>");
						QCString toIns("<a href=\"");
						toIns.append(str.mid(find,end-find));
						toIns.append("\" target=\"_blank\">");
						str.insert((uint)find,toIns);
						find=2*end-find+30;
					}
				}


				// convert mail to html
				//kdDebug()<<
				find=0;
				while((find=str.find('@',find))!=-1){
					int st=find-1;
					QCString ff=str.mid(st,1);
					while(ff!="'" && 
							ff!="\"" && 
							ff!=">" &&
							ff!="<" &&
							ff!=" " &&
							ff!="&" &&
							ff!=";" &&
							ff!=QCString("\t\0") &&
							ff!=QCString("\r\0") &&
							ff!=QCString("\n\0")
							){
						st--;
						ff=str.mid(st,1);
					}
					st++;
					//kdDebug()<<"find="<<find<<endl;
					//kdDebug()<<"st="<<st<<endl;
					if(find-st>2){
						int en=find+1;
						ff=str.mid(en,1);
						while(ff!="'" && 
								ff!="\"" && 
								ff!=">" &&
								ff!="<" &&
								ff!=" " &&
								ff!="&" &&
								ff!=";" &&
								ff!=QCString("\t\0") &&
								ff!=QCString("\r\0") &&
								ff!=QCString("\n\0")
								){
							en++;
							ff=str.mid(en,1);
						}
						//kdDebug()<<"en="<<en<<endl;
						//kdDebug()<<"\""<<str.mid(st,en-st)<<"\""<<endl;
						QCString temp=str.mid(st,en-st);
						temp.insert(0,"<a href=\"mailto:");
						temp.append("\">");
						str.insert(en,"</a>");
						str.insert(st,temp);
						//find=find+en+20;
						find=en+2+temp.length();
					}else find++;
				}
			}
			// make info table
			//kdDebug()<<"[KmhtmlEntry::data()]: m_showInfo="<<archive->m_showInfo<<endl;
			if(archive->m_showInfo){
				int insertPoint=str.find("<body ",0,FALSE);
				if(insertPoint==-1){
					insertPoint=str.find("</head>",0,FALSE);
					if(insertPoint==-1) insertPoint=str.find("<html",0,FALSE);
				}
				if(insertPoint!=-1) insertPoint=str.find('>',insertPoint)+1;
				else insertPoint=0;
				QCString ins=createEmlInfo();
				str.insert(insertPoint,ins.data());
			}
			// make attachements table
			//kdDebug()<<"[KmhtmlEntry::data()]: m_showAttachments="<<archive->m_showAttachments<<endl;
			if(archive->m_showAttachments){
				int insertPoint=str.find("</body>",0,FALSE);
				if(insertPoint==-1) insertPoint=str.find("</html>",0,FALSE);
				if(insertPoint==-1) insertPoint=0;
				QCString ins="";
				ins=createEmlAttachments();
				if(!ins.isEmpty()){
					if(insertPoint!=0) str.insert(insertPoint,ins.data());
					else str.append(ins);
				}
			}
// 		}
		// find links like img src="/image/pix1.jpg"
		for(int j=0;j<archive->count();j++){
			int found=0;
			while((found=str.find(archive->item[j].alias.local8Bit(),found))!=-1){
				if(str.mid(found-1,1)!="=" && str.mid(found-1,1)!="\"" && str.mid(found-1,1)=="/"){
					int st=str.findRev("=",found);
					//kdDebug()<< "[KmhtmlEntry::data()]: st=" << st << ", alias=" << archive->item[j].alias<< endl;
					if(str.mid(st+1,1)=="\"") st++;
					st++;
					str.remove(st,found-st);
				}
				found++;
			}
		}
		//kdDebug(  ) << "[mhtmlProtocol::data]: done!!!" << endl;
		QByteArray result;
		result=str;
		result.resize(result.size()-1);
		archive->item[it].decodedSize=result.size();
		archive->item[it].data=result;
		archive->item[it].fixed=TRUE;
	}
	//kdDebug()<< "[KmhtmlEntry::data()]: return normal" << endl;
	archive->item[it].decodedSize=archive->item[it].data.size();
	return &archive->item[it].data;
}
/*================================
================================*/
QString KmhtmlEntry::mailToHTML(const QString &msg){
	QString ret;
	QString tmp;
	if(msg.isEmpty()) return msg;
	if(msg.find(",")==-1) ret=addressToHTML(msg); // simple address
	else{
		QString retTmp;
		int comma=msg.find(",");
		int st=0;
		while(comma!=-1){
			tmp=msg.mid(st,comma-st);
			tmp=tmp.stripWhiteSpace();
			retTmp=addressToHTML(tmp);
			retTmp.append("</nobr>, <nobr>");
			st=comma+1;
			comma=msg.find(",",st);
			ret+=retTmp;
		}
		st=msg.findRev(",")+1;
		tmp=msg.mid(st);
		tmp=tmp.stripWhiteSpace();
		retTmp=addressToHTML(tmp);
		ret+=retTmp;
	}
	ret.append("</nobr>");
	ret.prepend("<nobr>");
	return ret;
}
/*================================
================================*/
QString KmhtmlEntry::addressToHTML(const QString &msg){
	QString ret;
	QString tmp;
	if(msg.isEmpty()) return msg;
	tmp=msg;
	if(tmp.startsWith("<")){
		tmp=tmp.mid(1);
		if(tmp.endsWith(">")) tmp=tmp.left(tmp.length()-1);
	}
	tmp.replace(QString("\""),QString("&#034;"));
	ret=tmp;
	ret.replace(QString("<"),QString("&#060;"));
	ret.replace(QString(">"),QString("&#062;"));
	ret.prepend("<a href=\"mailto:" + tmp + "\">");
	ret.append("</a>");
	return ret;
}
/*================================
================================*/
QCString KmhtmlEntry::createEmlInfo(){
	// write HTML code
	QCString ins="<!-- section inserted by kio_mhtml -->";
	if(archive->isDOS) ins.append(archive->controlChars[0]);
	ins.append(archive->controlChars[1]);
	ins.append("<table align=\"center\"  border=\"0\" bgcolor=\"");
	// Border color
	ins.append("Black");
	ins.append("\" width=\"100%\" cellpadding=\"0\" cellspacing=\"1\" style=\"margin: 0px; margin-top: 5px; margin-bottom: 10px; font-family: ");
	if(KC.usesSystemFonts()) ins.append(KC.standardFontName());
	else ins.append(KC.standardBodyFontName());
	ins.append("; font-size: ");
	if(KC.usesSystemFonts()) ins.append(KC.standardFontSize());
	else ins.append(KC.standardBodyFontSize());
	ins.append("pt;\">");
	if(archive->isDOS) ins.append(archive->controlChars[0]);
	ins.append(archive->controlChars[1]);
	ins.append("<tr><td>");
	if(archive->isDOS) ins.append(archive->controlChars[0]);
	ins.append(archive->controlChars[1]);
	ins.append("<table border=\"0\" bgcolor=\"");
	// Subject background color
	ins.append(KC.subjectBgColor());
	//kdDebug()<<"KC.subjectBgColor()="<<KC.subjectBgColor().local8Bit()<<endl;
	ins.append("\" width=\"100%\">");
	if(archive->isDOS) ins.append(archive->controlChars[0]);
	ins.append(archive->controlChars[1]);
	ins.append("<TR><TD>");
	if(archive->isDOS) ins.append(archive->controlChars[0]);
	ins.append(archive->controlChars[1]);
	// Subject
	ins.append("<b><font color=\"");
	// Subject foreground color
	ins.append(KC.tableForeColor());
	//kdDebug()<<"KC.tableForeColor()="<<KC.tableForeColor().local8Bit()<<endl;
	ins.append("\"><nobr>");
	//kdDebug()<<"charset= "<< archive->item[it].charset << endl;
	if(archive->mSubject.isNull()) ins.append(trForInfo("No subject"));
	else ins.append(textForInfo(archive->mSubject));
	ins.append("</nobr></font></b>");
	if(archive->isDOS) ins.append(archive->controlChars[0]);
	ins.append(archive->controlChars[1]);
	// End subject
	ins.append("</TD></TR></table>");
	if(archive->isDOS) ins.append(archive->controlChars[0]);
	ins.append(archive->controlChars[1]);
	ins.append("</td></tr>");
	if(archive->isDOS) ins.append(archive->controlChars[0]);
	ins.append(archive->controlChars[1]);
	ins.append("<tr><td>");
	if(archive->isDOS) ins.append(archive->controlChars[0]);
	ins.append(archive->controlChars[1]);
	ins.append("<table border=\"0\" bgcolor=\"");
	// Others background color
	ins.append(KC.ItemsBgColor());
	//kdDebug()<<"KC.ItemsBgColor()="<<KC.ItemsBgColor().local8Bit()<<endl;
	ins.append("\" width=\"100%\">");
	if(archive->isDOS) ins.append(archive->controlChars[0]);
	ins.append(archive->controlChars[1]);
	ins.append("<TR><TD>");
	if(archive->isDOS) ins.append(archive->controlChars[0]);
	ins.append(archive->controlChars[1]);
	//From
	ins.append("<TR><td width=\"5px\"></td>");
	if(archive->isDOS) ins.append(archive->controlChars[0]);
	ins.append(archive->controlChars[1]);
	ins.append("<TD width=\"1%\" align=\"right\" valign=\"top\">");
	if(archive->isDOS) ins.append(archive->controlChars[0]);
	ins.append(archive->controlChars[1]);
	ins.append("<b><font color=\"Black\"><nobr>");
	ins.append(trForInfo("From:"));
	//trForInfo("From:");
	ins.append("</nobr></font></b></td>");
	if(archive->isDOS) ins.append(archive->controlChars[0]);
	ins.append(archive->controlChars[1]);
	ins.append("<td>");
	if(archive->mSender.isNull()){
		ins.append("<nobr>");
		ins.append(trForInfo("No sender"));
		ins.append("</nobr>");
	}else ins.append(textForInfo(mailToHTML(archive->mSender)));
	//ins.append(mailToHTML(archive->mSender.local8Bit()));
	
	ins.append("</td></tr>");
	if(archive->isDOS) ins.append(archive->controlChars[0]);
	ins.append(archive->controlChars[1]);
	//To
	ins.append("<TR><td width=\"5px\"></td>");
	if(archive->isDOS) ins.append(archive->controlChars[0]);
	ins.append(archive->controlChars[1]);
	ins.append("<TD width=\"1%\" align=\"right\" valign=\"top\">");
	if(archive->isDOS) ins.append(archive->controlChars[0]);
	ins.append(archive->controlChars[1]);
	ins.append("<b><font color=\"Black\"><nobr>");
	ins.append(trForInfo("To:"));
	ins.append("</nobr></font></b></td>");
	if(archive->isDOS) ins.append(archive->controlChars[0]);
	ins.append(archive->controlChars[1]);
	ins.append("<td>");
	if(archive->mRecipient.isNull()){
		ins.append("<nobr>");
		ins.append(trForInfo("No recipient"));
		ins.append("</nobr>");
	}else ins.append(textForInfo(mailToHTML(archive->mRecipient)));
	//ins.append(mailToHTML(archive->mRecipient.local8Bit()));
	
	ins.append("</td></tr>");
	if(archive->isDOS) ins.append(archive->controlChars[0]);
	ins.append(archive->controlChars[1]);
	//CC
	if(!archive->mCopyTo.isEmpty()){
		ins.append("<TR><td width=\"5px\"></td>");
		if(archive->isDOS) ins.append(archive->controlChars[0]);
		ins.append(archive->controlChars[1]);
		ins.append("<TD width=\"1%\" align=\"right\" valign=\"top\">");
		if(archive->isDOS) ins.append(archive->controlChars[0]);
		ins.append(archive->controlChars[1]);
		ins.append("<b><font color=\"Black\"><nobr>");
		ins.append(trForInfo("CC:"));
		ins.append("</nobr></font></b></td>");
		if(archive->isDOS) ins.append(archive->controlChars[0]);
		ins.append(archive->controlChars[1]);
		ins.append("<td>");
		ins.append(textForInfo(mailToHTML(archive->mCopyTo)));
		//ins.append(mailToHTML(archive->mCopyTo.local8Bit()));
		
		ins.append("</td></tr>");
		if(archive->isDOS) ins.append(archive->controlChars[0]);
		ins.append(archive->controlChars[1]);
	}
	//BCC
	if(!archive->mBlindCopyTo.isEmpty()){
		ins.append("<TR><td width=\"5px\"></td>");
		if(archive->isDOS) ins.append(archive->controlChars[0]);
		ins.append(archive->controlChars[1]);
		ins.append("<TD width=\"1%\" align=\"right\" valign=\"top\">");
		if(archive->isDOS) ins.append(archive->controlChars[0]);
		ins.append(archive->controlChars[1]);
		ins.append("<b><font color=\"Black\"><nobr>");
		ins.append(trForInfo("BCC:"));
		ins.append("</nobr></font></b></td>");
		if(archive->isDOS) ins.append(archive->controlChars[0]);
		ins.append(archive->controlChars[1]);
		ins.append("<td>");
		ins.append(textForInfo(mailToHTML(archive->mBlindCopyTo)));
		//ins.append(mailToHTML(archive->mBlindCopyTo.local8Bit()));
		
		ins.append("</td></tr>");
		if(archive->isDOS) ins.append(archive->controlChars[0]);
		ins.append(archive->controlChars[1]);
	}
	//Date
	ins.append("<TR><td width=\"5px\"></td>");
	if(archive->isDOS) ins.append(archive->controlChars[0]);
	ins.append(archive->controlChars[1]);
	ins.append("<TD width=\"1%\" align=\"right\" valign=\"top\">");
	if(archive->isDOS) ins.append(archive->controlChars[0]);
	ins.append(archive->controlChars[1]);
	ins.append("<b><font color=\"Black\"><nobr>");
	ins.append(trForInfo("Date:"));
	ins.append("</nobr></font></b></td>");
	if(archive->isDOS) ins.append(archive->controlChars[0]);
	ins.append(archive->controlChars[1]);
	ins.append("<td><font color=\"Black\"><nobr>");
//	ins.append(archive->mDate);
	
	ins.append(translateDate(archive->mDate));
	ins.append("</nobr></font></td></tr>");
	if(archive->isDOS) ins.append(archive->controlChars[0]);
	ins.append(archive->controlChars[1]);
	ins.append("</TD></TR></table>");
	if(archive->isDOS) ins.append(archive->controlChars[0]);
	ins.append(archive->controlChars[1]);
	ins.append("</td></tr></tbody></table>");
	if(archive->isDOS) ins.append(archive->controlChars[0]);
	ins.append(archive->controlChars[1]);
	ins.append("<!-- end of inserted section by kio_mhtml -->");
	ins.prepend(archive->controlChars[1]);
	if(archive->isDOS) ins.prepend(archive->controlChars[0]);
	return ins;
}
/*================================
================================*/
QCString KmhtmlEntry::textForInfo(QString msg){
		if(archive->item[it].charset.contains("utf-8",false)==1) return msg.utf8();
		else return msg.local8Bit();
		return QCString("\0");
}
/*================================
================================*/
void KmhtmlEntry::calculateCharsetCretiria(){
	KLocale loc("KDE_LANG");
	QString locStr(loc.encoding());
	//kdDebug()<<e.local8Bit()<<endl;
	locStr.replace(" ","-");
	//kdDebug()<<e<<endl;
	QStringList locStrList(locStr);
	// start populate aliases
	locStrList.clear();
	if(locStr.lower()=="iso-8859-2" || locStr.lower()=="windows-1250"){
		locStrList.append("windows-1250");
		locStrList.append("iso-8859-2");
	}else if(locStr.lower()=="iso-8859-5" || locStr.lower()=="windows-1251" || locStr.lower()=="koi8-u"){
		locStrList.append("koi8-u");
		locStrList.append("windows-1251");
		locStrList.append("iso-8859-5");
	}else if(locStr.lower()=="iso-8859-6" || locStr.lower()=="windows-1256"){
		locStrList.append("windows-1256");
		locStrList.append("iso-8859-6");
	}else if(locStr.lower()=="iso-8859-7" || locStr.lower()=="windows-1253"){
		locStrList.append("windows-1253");
		locStrList.append("iso-8859-7");
	}else if(locStr.lower()=="iso-8859-8" || locStr.lower()=="windows-1255"){
		locStrList.append("windows-1255");
		locStrList.append("iso-8859-8");
	}else if(locStr.lower()=="iso-8859-9" || locStr.lower()=="windows-1254"){
		locStrList.append("windows-1254");
		locStrList.append("iso-8859-9");
	}else if(locStr.lower()=="iso-8859-13" || locStr.lower()=="windows-1257"){
		locStrList.append("windows-1257");
		locStrList.append("iso-8859-13");
	}
	//end populate aliases
	for(QStringList::Iterator iter = locStrList.begin();iter != locStrList.end(); ++iter ) {
		if(archive->item[it].charset.contains(*iter,false)==1) charsetCretiria++; // local
	}
	if(charsetCretiria==0) charsetCretiria=2; // use untraslated
	charsetCretiriaCalculated=true;
}

/*================================
================================*/
QCString KmhtmlEntry::trForInfo(QString msg){
		//int charsetCretiria=0; //utf
		if(archive->item[it].charset.contains("utf-8",false)!=1){
			if(!charsetCretiriaCalculated) calculateCharsetCretiria();
		}
		//kdDebug()<<"charsetCretiria= "<<enc<<endl;
		if(msg=="From:"){
			if(charsetCretiria==0) return i18n("From:").utf8();
			else if(charsetCretiria==1) return i18n("From:").local8Bit();
			else return QCString("From:");
		}else if(msg=="To:"){
			if(charsetCretiria==0) return i18n("To:").utf8();
			else if(charsetCretiria==1) return i18n("To:").local8Bit();
			else return QCString("To:");
		}else if(msg=="CC:"){
			if(charsetCretiria==0) return i18n("CC:").utf8();
			else if(charsetCretiria==1) return i18n("CC:").local8Bit();
			else return QCString("CC:");
		}else if(msg=="BCC:"){
			if(charsetCretiria==0) return i18n("BCC:").utf8();
			else if(charsetCretiria==1) return i18n("BCC:").local8Bit();
			else return QCString("BCC:");
		}else if(msg=="Date:"){
			if(charsetCretiria==0) return i18n("Date:").utf8();
			else if(charsetCretiria==1) return i18n("Date:").local8Bit();
			else return QCString("Date:");
		}else if(msg=="Attachments"){
			if(charsetCretiria==0) return i18n("Attachments").utf8();
			else if(charsetCretiria==1) return i18n("Attachments").local8Bit();
			else return QCString("Attachments");
		}else if(msg=="No subject"){
			if(charsetCretiria==0) return i18n("No subject").utf8();
			else if(charsetCretiria==1) return i18n("No subject").local8Bit();
			else return QCString("No subject");
		}else if(msg=="No sender"){
			if(charsetCretiria==0) return i18n("No sender").utf8();
			else if(charsetCretiria==1) return i18n("No sender").local8Bit();
			else return QCString("No sender");
		}else if(msg=="No recipient"){
			if(charsetCretiria==0) return i18n("No recipient").utf8();
			else if(charsetCretiria==1) return i18n("No recipient").local8Bit();
			else return QCString("No recipient");
		}else if(msg=="size: "){
			if(charsetCretiria==0) return i18n("size: ").utf8();
			else if(charsetCretiria==1) return i18n("size: ").local8Bit();
			else return QCString("size: ");
		}else if(msg=="type: "){
			if(charsetCretiria==0) return i18n("type: ").utf8();
			else if(charsetCretiria==1) return i18n("type: ").local8Bit();
			else return QCString("type: ");
		}else if(msg=="Sun"){
			if(charsetCretiria==0) return i18n("Sunday","Sun").utf8();
			else if(charsetCretiria==1) return i18n("Sunday","Sun").local8Bit();
			else return QCString("Sun");
		}else if(msg=="Mon"){
			if(charsetCretiria==0) return i18n("Monday","Mon").utf8();
			else if(charsetCretiria==1) return i18n("Monday","Mon").local8Bit();
			else return QCString("Mon");
		}else if(msg=="Tue"){
			if(charsetCretiria==0) return i18n("Tuesday","Tue").utf8();
			else if(charsetCretiria==1) return i18n("Tuesday","Tue").local8Bit();
			else return QCString("Tue");
		}else if(msg=="Wed"){
			if(charsetCretiria==0) return i18n("Wednesday","Wed").utf8();
			else if(charsetCretiria==1) return i18n("Wednesday","Wed").local8Bit();
			else return QCString("Wed");
		}else if(msg=="Thu"){
			if(charsetCretiria==0) return i18n("Thursday","Thu").utf8();
			else if(charsetCretiria==1) return i18n("Thursday","Thu").local8Bit();
			else return QCString("Thu");
		}else if(msg=="Fri"){
			if(charsetCretiria==0) return i18n("Friday","Fri").utf8();
			else if(charsetCretiria==1) return i18n("Friday","Fri").local8Bit();
			else return QCString("Fri");
		}else if(msg=="Sat"){
			if(charsetCretiria==0) return i18n("Saturday","Sat").utf8();
			else if(charsetCretiria==1) return i18n("Saturday","Sat").local8Bit();
			else return QCString("Sat");
		}else if(msg=="Jan"){
			if(charsetCretiria==0) return i18n("January","Jan").utf8();
			else if(charsetCretiria==1) return i18n("January","Jan").local8Bit();
			else return QCString("Jan");
		}else if(msg=="Feb"){
			if(charsetCretiria==0) return i18n("February","Feb").utf8();
			else if(charsetCretiria==1) return i18n("February","Feb").local8Bit();
			else return QCString("Feb");
		}else if(msg=="Mar"){
			if(charsetCretiria==0) return i18n("March","Mar").utf8();
			else if(charsetCretiria==1) return i18n("March","Mar").local8Bit();
			else return QCString("Mar");
		}else if(msg=="Apr"){
			if(charsetCretiria==0) return i18n("April","Apr").utf8();
			else if(charsetCretiria==1) return i18n("April","Apr").local8Bit();
			else return QCString("Apr");
		}else if(msg=="May"){
			if(charsetCretiria==0) return i18n("May short","May").utf8();
			else if(charsetCretiria==1) return i18n("May short","May").local8Bit();
			else return QCString("May");
		}else if(msg=="Jun"){
			if(charsetCretiria==0) return i18n("June","Jun").utf8();
			else if(charsetCretiria==1) return i18n("June","Jun").local8Bit();
			else return QCString("Jun");
		}else if(msg=="Jul"){
			if(charsetCretiria==0) return i18n("July","Jul").utf8();
			else if(charsetCretiria==1) return i18n("July","Jul").local8Bit();
			else return QCString("Jul");
		}else if(msg=="Aug"){
			if(charsetCretiria==0) return i18n("August","Aug").utf8();
			else if(charsetCretiria==1) return i18n("August","Aug").local8Bit();
			else return QCString("Aug");
		}else if(msg=="Sep"){
			if(charsetCretiria==0) return i18n("September","Sep").utf8();
			else if(charsetCretiria==1) return i18n("September","Sep").local8Bit();
			else return QCString("Sep");
		}else if(msg=="Oct"){
			if(charsetCretiria==0) return i18n("October","Oct").utf8();
			else if(charsetCretiria==1) return i18n("October","Oct").local8Bit();
			else return QCString("Oct");
		}else if(msg=="Nov"){
			if(charsetCretiria==0) return i18n("November","Nov").utf8();
			else if(charsetCretiria==1) return i18n("November","Nov").local8Bit();
			else return QCString("Nov");
		}else if(msg=="Dec"){
			if(charsetCretiria==0) return i18n("December","Dec").utf8();
			else if(charsetCretiria==1) return i18n("December","Dec").local8Bit();
			else return QCString("Dec");
		}
		return QCString(msg);
}
/*================================
================================*/
QString KmhtmlEntry::createEmlAttachments(){
	int att=0;
	int curAtt=0;
	for(int i=0;i<archive->items;i++) if(archive->item[i].contentDisposition.lower()=="attachment") att++;
	if(att==0) return "";
	QCString ins;
	if(archive->isDOS) ins=archive->controlChars[0];
	ins.append(archive->controlChars[1]);
	ins.append("<!-- section inserted by kio_mhtml -->");
	if(archive->isDOS) ins.append(archive->controlChars[0]);
	ins.append(archive->controlChars[1]);
	ins.append("<br><br>_______________________________________________<br>");
	if(archive->isDOS) ins.append(archive->controlChars[0]);
	ins.append(archive->controlChars[1]);
	ins.append("<table width=\"100%\" cellspacing=\"0\" border=\"0\" cellpadding=\"0\" align=\"left\" style=\"font-family: ");
	if(KC.usesSystemFonts()) ins.append(KC.standardFontName());
	else ins.append(KC.standardBodyFontName());
	ins.append("; font-size: ");
	if(KC.usesSystemFonts()) ins.append(KC.standardFontSize());
	else ins.append(KC.standardBodyFontSize());
	ins.append("pt;\">");
	if(archive->isDOS) ins.append(archive->controlChars[0]);
	ins.append(archive->controlChars[1]);
	ins.append("<tbody><tr valign=\"top\">");
	if(archive->isDOS) ins.append(archive->controlChars[0]);
	ins.append(archive->controlChars[1]);
// 	if(att==1) ins.append("<td width=\"10\" align=\"left\"><b>Attachment</b></td>");
// 	else ins.append("<td width=\"10\" align=\"left\"><b>Attachments</b></td>");
	ins.append("<td width=\"10\" align=\"left\"><b>");
	ins.append(trForInfo("Attachments"));
	ins.append("</b></td>");
	if(archive->isDOS) ins.append(archive->controlChars[0]);
	ins.append(archive->controlChars[1]);
	ins.append("<td></td></tr>");
	if(archive->isDOS) ins.append(archive->controlChars[0]);
	ins.append(archive->controlChars[1]);
	for(int i=0;i<archive->items;i++){
		if(archive->item[i].contentDisposition.lower()=="attachment"){
			curAtt+=1;
			ins.append("<tr valign=\"top\"><td width=\"10\" align=\"left\"><nobr>&#160;&#160;<A href=\"");
			ins.append(archive->item[i].alias.local8Bit());
			// RHP.doc
			ins.append("\">");
			ins.append(archive->item[i].alias.local8Bit());
			// RHP.doc
			ins.append("</A></nobr></td>");
			if(archive->isDOS) ins.append(archive->controlChars[0]);
			ins.append(archive->controlChars[1]);
			ins.append("<td>&#160;&#160;");
			ins.append(trForInfo("size: "));
			QCString size;
			size.setNum(archive->item[i].decodedSize);
			ins.append(size);
			//180KB
			ins.append(" Bytes, ");
			ins.append(trForInfo("type: "));
			ins.append(archive->item[i].mimeType);
			if(att==curAtt) ins.append("<br><br>");
			ins.append("</td></tr>");
		}
	}
	ins.append("</tbody></table>");
	if(archive->isDOS) ins.append(archive->controlChars[0]);
	ins.append(archive->controlChars[1]);
	ins.append("<!-- end of inserted section by kio_mhtml -->");
	if(archive->isDOS) ins.append(archive->controlChars[0]);
	ins.append(archive->controlChars[1]);
	return ins;
}
/*================================
================================*/
QString KmhtmlArchive::decodeRFC2047String(const QString &msg){
	QString charset;
	QString encoding;
	QString notEncodedText;
	QString encodedText;
	QString decodedText;
	int encEnd=0;
	if(msg.startsWith("=?") && (encEnd=msg.findRev("?="))!=-1){
		notEncodedText=msg.mid(encEnd+2);
		encodedText=msg.left(encEnd);
		encodedText=encodedText.mid(2,encodedText.length()-2);
		//kdDebug()<<"[KmhtmlArchive::decodeRFC2047String]: encodedText="<< encodedText << endl;
		int questionMark=encodedText.find('?');
		if(questionMark==-1) return msg;
		charset=encodedText.left(questionMark).lower();
		//kdDebug()<<"[KmhtmlArchive::decodeRFC2047String]: charset="<< charset << endl;
		encoding=encodedText.mid(questionMark+1,1).lower();
		//kdDebug()<<"[KmhtmlArchive::decodeRFC2047String]: encoding="<< encoding << endl;
		if(encoding!="b" && encoding!="q") return msg;
		encodedText=encodedText.mid(questionMark+3);
		if(charset.find(" ")!=-1 && encodedText.find(" ")!=-1) return msg;
		QCString tmpIn;
		QCString tmpOut;
		tmpIn = (const char*)encodedText;
		if(encoding=="q")tmpOut=KCodecs::quotedPrintableDecode(tmpIn);
		else tmpOut=KCodecs::base64Decode(tmpIn);
		if(charset!="us-ascii"){
			QTextCodec *codec = QTextCodec::codecForName(charset);
			if(!codec) return msg;
			decodedText=codec->toUnicode(tmpOut);
 			decodedText=decodedText.replace("_"," ");
			//kdDebug()<<"[KmhtmlArchive::decodeRFC2047String]: decodedText="<< decodedText << endl;
		}else decodedText=tmpOut.replace("_"," ");
		return decodedText + notEncodedText;
	}else return msg;
}
/*================================
================================*/
QString KmhtmlArchive::decodeRFC2047Phrase(const QString &msg, bool removeLessGreater){
	int st=msg.find("=?");
	int en=-1;
	QString msgCopy=msg;
 	//kdDebug()<<"[KmhtmlArchive::decodeRFC2047Phrase]: msg="<< msg << endl;
// 	//kdDebug()<<"[KmhtmlArchive::decodeRFC2047Phrase]: msgCopy="<< msgCopy << endl;
	QString decodedText=msgCopy.left(st);
	QString encodedText=msgCopy.mid(st);
	st=encodedText.find("=?");
	while(st!=-1){
		en=encodedText.find("?=");
		while(encodedText.mid(en+2,2)!="\" " && encodedText.mid(en+2,1)!=" " && en+2<(int)encodedText.length()) en=encodedText.find("?=",en+1);
		//while(encodedText.mid(en+2,1)!=" " && en+2<(int)encodedText.length()) en=encodedText.find("?=",en+1);
		if(en==-1) break;
		decodedText+=encodedText.left(st);
		QString tmp=encodedText.mid(st,en-st+2);
		encodedText=encodedText.mid(en+2);
		decodedText+=decodeRFC2047String(tmp);
		st=encodedText.find("=?");
		//st=encodedText.find("=?",st+1);
	}
	decodedText += encodedText;
// 	//kdDebug()<<"[KmhtmlArchive::decodeRFC2047Phrase]: decodedText="<< decodedText << endl;
	// remove unwanted '<' and '>'
	if(removeLessGreater){
		if(decodedText.stripWhiteSpace().startsWith("<") && decodedText.stripWhiteSpace().endsWith(">")){
			QString tmp=decodedText.stripWhiteSpace();
			tmp=tmp.mid(1,tmp.length()-2);
			decodedText=tmp;
		}else{
			QString dec=decodedText;
			QString tmp;

			st=decodedText.find("<");
			while(st!=-1){
				st=dec.find("<",st);
				if(st==0 || (st!=0 && (dec.mid(st-2,2)==", "))){
					en=dec.find(">",st);
					if(en==-1 && dec.find(",",st)<en){
						st++;
						continue;
					}
					dec=dec.left(st)+dec.mid(st+1,en-st-1)+dec.mid(en+1);
				}else if(st!=-1) st++;
			}
			decodedText=dec;
		}
	}
 	//kdDebug()<<"[KmhtmlArchive::decodeRFC2047Phrase]: decodedText="<< decodedText << endl;
	return decodedText;
}
/*================================
================================*/
QCString KmhtmlEntry::translateDate(QString mDate){
	QString day;
	QString month;
	int left=0;
	day=mDate.left(3);
	QCString ret=trForInfo(day);
	if(mDate.mid(6,1)==" "){
		ret.append(mDate.mid(3,4));
		month=mDate.mid(7,3);
		left=10;
		//kdDebug()<<"month(1)="<<month<<endl;
	}else{
		ret.append(mDate.mid(3,5));
		month=mDate.mid(8,3);
		left=11;
		//kdDebug()<<"month(2)="<<month<<endl;
	}
	ret.append(trForInfo(month));
	ret.append(mDate.mid(left));
	return ret;
}

#include <kmhtmlarchive.moc>
