/***************************************************************************
 *   Copyright (C) 2009 by Spiros Georgaras                                *
 *   sng@hellug.gr                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

 #include <MHT.h>
/*================================
================================*/
MHT::MHT(){
	outFolder="";
	TempFolder="";
	boundary="";
	status=0;
	m_tarBall=0;
	onlyViewWarFile=FALSE;
	dontCreateWarFile=FALSE;
	beSilent=FALSE;
	doUseGui=TRUE;
	created=FALSE;
}
/*================================
================================*/
MHT::~ MHT(){
	if(!dontCreateWarFile && created){
		for(int i=0;i<arc->count();i++){
			KmhtmlEntry entry(arc,i);
			QFile delFile(TempFolder + entry.name());
			if(delFile.exists()) delFile.remove();
		}
		QDir delDir(TempFolder);
		if(delDir.exists()) delDir.remove(TempFolder,TRUE);
	}
//	delete [] item;
	delete arc;
	arc=0;
 }
/*================================
================================*/
void MHT::reset(){
//	inputFile="";
	outFolder="";
	TempFolder="";
	boundary="";
	onlyViewWarFile=FALSE;
	dontCreateWarFile=FALSE;
	beSilent=FALSE;
	doUseGui=TRUE;
	showed=FALSE;
	created=FALSE;
	status=0;
	m_tarBall=0;
	//if(arc) arc->reset();
	delete arc;
	arc=0;
}
/*================================
================================*/
bool MHT::setFile(QString fileName,QString outDir, bool hInfo, bool hAttachments){
	showed=FALSE;
	created=FALSE;
	outFolder=outDir;
	mhtFileName=fileName;
	arc=new KmhtmlArchive(fileName);
	connect( arc, SIGNAL (archiveOpened()), this, SIGNAL (archiveOpened()));
	connect( arc, SIGNAL(foundFilesInArchive(int)), this, SIGNAL(foundFilesInArchive(int)));
	connect( arc, SIGNAL (errorAppeared(int)), this, SIGNAL (errorAppeared(int)));
	if(hInfo) arc->setShowInfo(FALSE);
	if(hAttachments) arc->setShowAttachments(FALSE);
	if(!arc->open(IO_ReadOnly)){
		status=arc->status;
		//kdDebug()<<"[MHT::setFile]: Error opening file"<<endl;
		return FALSE;
	}
	return TRUE;
}
/*================================
================================*/
QCString MHT::getFileContents(int id){
	if(arc->count()==0 || id>arc->count()) return QCString("");
	KmhtmlEntry entry(arc,id);
	return QCString(*entry.data());
}
/*================================
================================*/
uint MHT::getEncodedSize(int id){
	KmhtmlEntry entry(arc,id);
	return entry.encodedSize();

	//return item[id].encodedSize;
}
/*================================
================================*/
uint MHT::getDecodedSize(int id){
	KmhtmlEntry entry(arc,id);
	return entry.decodedSize();
}
/*================================
================================*/
bool MHT::extractAllFiles(){
	getAllNames();
	if(!extractFiles()) return FALSE;
	if(dontCreateWarFile) emit archiveCreated(TempFolder);
	return TRUE;
}
/*================================
================================*/
bool MHT::extractFiles(){
	for(int i=0;i<arc->count();i++){
		KmhtmlEntry entry(arc,i);
		QByteArray exC=*entry.data();
		emit fileExtraced(entry.name());
		if(!doUseGui && !beSilent) std::cout << "  " << i18n(QString("Extracting file: ")).local8Bit() << entry.name() << " .... ";
		QString exName=TempFolder + "/" + entry.name();
		//QCString fContents=getFileContents(i);
		QFile file( exName );
		if(!file.open( IO_WriteOnly )){
			emit errorAppeared(5);
			status=5;
			if(!doUseGui && !beSilent) std::cout << std::endl << i18n(QString("Error extracting file")).local8Bit() << std::endl;
			return FALSE;
		}
		QTextStream stream(&file);
		//fix for binary file creation from text
		//stream.writeRawBytes(exC,exC.size()-1);
		stream.writeRawBytes(exC,exC.size());

		//stream.writeRawBytes(*entry.data(),*entry.data().size());
		file.close();
		if(!doUseGui && !beSilent) std::cout << i18n(QString("done")).local8Bit() << std::endl;
	}
	return TRUE;
}
/*================================
================================*/
void MHT::getAllNames(){
	QString tmp,d;
	int c=-1;
	tmp=mhtFileName.mid(mhtFileName.findRev("/")+1);
	//kdDebug()<<"tmp="<<tmp<<endl;
	tmp=tmp.left(tmp.findRev("."));
	//kdDebug()<<"tmp="<<tmp<<endl;
	if(onlyViewWarFile){
		KTempDir tDir=KTempDir(locateLocal("tmp", "kmhtconvert-"));
		tDir.setAutoDelete(FALSE);
		TempFolder=tDir.name();
		// make sure it exists
		QDir tmpDir(TempFolder);
		if(!tmpDir.exists(TempFolder,TRUE)) tmpDir.mkdir(TempFolder,TRUE);
		TempFolder=TempFolder.left(TempFolder.length()-1);
		c=-1;
		while ((c=TempFolder.find("/",c+1))!=-1) outFolder=TempFolder.left(c);
		//kdDebug()<<"tmp="<<tmp<<endl;
		//kdDebug()<<"outFolder="<<outFolder<<endl;
		outFolder=outFolder + "/" + tmp;
		//kdDebug()<<"warFileName="<<warFileName<<endl;
		warFileName=outFolder + ".war";
		//kdDebug()<<"warFileName="<<warFileName<<endl;
		dontCreateWarFile=FALSE;
	}else if(dontCreateWarFile){
		onlyViewWarFile=FALSE;
		if(outFolder.isEmpty()){
			c=-1;
			while ((c=mhtFileName.find("/",c+1))!=-1) TempFolder=mhtFileName.left(c);
		}else{
			if(outFolder.right(1)=="/") TempFolder=outFolder.left(outFolder.length()-1);
			else TempFolder=outFolder;
		}
		TempFolder=TempFolder + "/" + tmp;
		//qWarning("MHT::getAllNames() - TempFolder = %s",TempFolder.latin1());
		createDir();
	}else{
		KTempDir tDir=KTempDir(locateLocal("tmp", "kmhtconvert-"));
		TempFolder=tDir.name();
		TempFolder=TempFolder.left(TempFolder.length()-1);
		if(outFolder.isEmpty()){
			c=-1;
			while ((c=mhtFileName.find("/",c+1))!=-1) warFileName=mhtFileName.left(c);
		}else{
			if(outFolder.right(1)=="/") warFileName=outFolder.left(outFolder.length()-1);
			else warFileName=outFolder;
		}
		//kdDebug()<<"warFileName="<<warFileName<<endl;
		//kdDebug()<<"tmp="<<tmp<<endl;
		warFileName=warFileName + "/" + tmp + ".war";
		//kdDebug()<<"warFileName="<<warFileName<<endl;
	}
}
/*================================
================================*/
bool MHT::createDir(){
	QDir d;
	d.setPath(TempFolder);
	if(d.exists()) return TRUE;
	return d.mkdir(TempFolder);
}
/*================================
================================*/
bool MHT::openWarFile(QString fileName){
	m_tarBall = new KTar(fileName,"application/x-gzip");
	if (!m_tarBall->open(IO_WriteOnly)) {
	  status=6;
	  emit  errorAppeared(6);
	  return FALSE;
   }
	return TRUE;
}
/*================================
================================*/
bool MHT::addFileToWarArchive(int id){
	if(id<0 || id>=arc->count()) return FALSE;
	KmhtmlEntry entry(arc,id);
	QFile file(TempFolder + "/" + entry.name());
	if(!file.open(IO_ReadOnly)){
		kdDebug()<<"file="<<file.name()<<endl;
		kdDebug()<<"Open out file"<<endl;
		return FALSE;
	}
	m_tarBall->writeFile(entry.name(), QString::null, QString::null, file.size(), file.readAll());
	file.close();
	return TRUE;
}
/*================================
================================*/
bool MHT::createWarArchive(){
	if(created) return TRUE;
	if(!openWarFile(warFileName)){
		kdDebug()<<"nok"<<endl;
		return FALSE;
	}
	for(int i=0;i<arc->count();i++) if(!addFileToWarArchive(i)){
		m_tarBall->close();
		return FALSE;
	}
	created=TRUE;
	m_tarBall->close();
	emit archiveCreated(warFileName);
	return TRUE;
}
/*================================
================================*/
bool MHT::showWarFile(){
	if(showed) return TRUE;
	if(warFileName.isEmpty()) return FALSE;
	//if(onlyViewWarFile) KRun::runURL("tar:" + warFileName + "/index.html","text/html",FALSE);
	if(onlyViewWarFile) KRun::runCommand(QString("kfmclient openURL \"tar:" + warFileName + "/index.html\""));
	showed=TRUE;
	return TRUE;
}
/*================================
================================*/
void MHT::setViewWarFile(bool view){
	if(created) return;
	onlyViewWarFile=view;
	if(view) dontCreateWarFile=FALSE;
}
/*================================
================================*/
void MHT::setNoSaveWarFile(bool noSave){
	if(created) return;
	dontCreateWarFile=noSave;
	if(noSave) onlyViewWarFile=FALSE;
}
#include <MHT.moc>
