/***************************************************************************
 *   Copyright (C) 2009 by Spiros Georgaras                                *
 *   sng@hellug.gr                                                 *
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Lesser Public License as published by   *
 *   the Free Software Foundation; either version 2.1 of the License, or   *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU Lesser Public License for more details.                           *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser Public License      *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef _MHTML_H
#define _MHTML_H
#include <kmhtmlarchive.h>
#include <kio/slavebase.h>
#include <sys/types.h>
#include <string.h>

class mhtmlProtocol : public KIO::SlaveBase{
public:
	mhtmlProtocol( const QCString &pool, const QCString &app );
	virtual ~mhtmlProtocol();
	virtual void listDir( const KURL & url );
	virtual void stat( const KURL & url );
	virtual void get( const KURL & url );

protected:
	void createUDSEntry( KmhtmlEntry* archFile, KIO::UDSEntry & entry );
	void createUDSEntry( KIO::UDSEntry & entry );
	bool checkNewFile( const KURL & url, QString & path );
	QByteArray fixHtmlFile(KmhtmlArchive* arc, QByteArray* htmlData);
	QString escapeString(QString str);
	KmhtmlArchive * m_mhtmlFile;
	QString m_mhtmlName;
	time_t m_mtime;
};

#endif
