/* -*- c++ -*-
 *
 * systemtray.h
 *
 * Copyright (C) 2004, 2007 Sebastian Sauer <mail@dipe.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 */

#include "systemtray.h"

//#include <qtooltip.h>
//#include <klocale.h>
#include <QMenu>
//#include <kurl.h>
//#include <kurldrag.h>
//#include <kapplication.h>
//#include <kiconloader.h>
//#include <kicontheme.h>
//#include <kdeversion.h>
#include <kxmlguifactory.h>

//#include <donkeyprotocol.h>

SystemTray::SystemTray(QWidget* parent)
    : KSystemTrayIcon("kmldonkey", parent)
{
#if 0
    setAcceptDrops(true);
#endif
    QMenu *popup = dynamic_cast<QMenu*>( KMLDonkey::App->factory()->container("systemtray_actions", KMLDonkey::App) );
    if (popup)
        contextMenu()->addActions( popup->actions() );
}

SystemTray::~SystemTray()
{
}

bool SystemTray::event(QEvent *event)
{
    if( event->type() == QEvent::ToolTip ) {
        QHelpEvent *helpEvent = static_cast<QHelpEvent*>(event);
        QToolTip::showText(helpEvent->globalPos(), QString("<b>KMLDonkey</b><br>%1").arg(tooltip));
        //QToolTip::hideText();
     }
     return KSystemTrayIcon::event(event);
}

#if 0
void SystemTray::dragEnterEvent(QDragEnterEvent* event)
{
    event->accept(QUriDrag::canDecode(event));
}

void SystemTray::dropEvent(QDropEvent* event)
{
    KURL::List uri;
    if (KURLDrag::decode(event, uri)) {
        QValueListConstIterator<KURL> it;
        for (it = uri.begin(); it != uri.end(); ++it)
            KMLDonkey::App->donkey->submitURL((*it).url());
    }
}
#endif

#include "systemtray.moc"
