/* -*- c++ -*-
 *
 * searchtabresult.h
 *
 * Copyright (C) 2003-2004 Petter E. Stokke <gibreel@kmldonkey.org>
 * Copyright (C) 2003-2004 Sebastian Sauer <mail@dipe.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

#ifndef __kmldonkey_searchtabresult_h__
#define __kmldonkey_searchtabresult_h__

#include "infolist.h"
#include "searchtabiface.h"

#include <qvbox.h>
#include <qintdict.h>
#include <qstringlist.h>
#include <qtooltip.h>

#include <kdeversion.h>

class QLabel;
class KListView;
class KComboBox;
class KLineEdit;
class KSqueezedTextLabel;

class SearchResultItem : public InfoItem
{
public:
    SearchResultItem(KListView *parent, int num, const ResultInfo *searchinfo);
    ~SearchResultItem();

    virtual double numeric(int col) const;
    virtual bool isNumeric(int col) const;
    void paintCell(QPainter* p, const QColorGroup& cg, int col, int w, int align);

    QString xtext( int column ) const;

    int getNum() const;
    const QString& getName() const;
    const QStringList& getNames() const;
    int64 getSize() const;
    const QString& getEd2kHash() const;
    const QStringList& getUids() const;

private:
    int number;
    QString name, nwName, format, comment, md4;
    QStringList names, uids;
    int64 filesize;
    int32 availability;
    bool alreadydone;
};

class SearchResultView : public InfoList, QToolTip
{
    Q_OBJECT
public:
    SearchResultView(QWidget *parent = 0, const char *name = 0);

protected:
    virtual void maybeTip(const QPoint&);
};

class SearchResult : public SearchTabInterface
{
    Q_OBJECT
public:
    SearchResult(QWidget *parent, const QString &tablabel, int sno);
    ~SearchResult();

    int searchNo();
    const QString& getTabLabel();
    void setSearchLabel(const QString &text);
    void setListFont(const QFont& font);

    void AddItem(const ResultInfo* searchinfo);
    void DownloadSelectedItems(bool force, bool askForFilename);

    SearchResultView *resultView;

private:
    int visibleCount;

    QHBox *statusBox;
    QStringList filters;
    KLineEdit *filterEdit;
    QTimer *filterTimer;
    KSqueezedTextLabel *searchLabel;
    QLabel *statusLabel;

    void setStatusLabel();
    bool filterItem(SearchResultItem *item);

protected slots:
    void filterChanged();
    void filterTimerDone();
    void contextSearchResult(KListView*,QListViewItem*,const QPoint&);
    void doubleClick(QListViewItem*);
};

#endif // __kmldonkey_searchtabresult_h__
