/* -*- c++ -*-
*
* setupwizard.h
*
* Copyright (C) 2004 Petter E. Stokke <gibreel@kmldonkey.org>
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*
*/

#ifndef __kmldonkey_setupwizard_h__
#define __kmldonkey_setupwizard_h__

#include <kwizard.h>

class KMLWizardPage;
class FileSelector;
class QButtonGroup;
class KLineEdit;

class SetupWizard : public KWizard
{
    Q_OBJECT
public:
    SetupWizard(QWidget *parent = 0, const char *name = 0);
    ~SetupWizard();

protected slots:
    void slotCoreSelected();
    void slotWorkingDirSelected();
    void slotNameChanged(const QString&);
    virtual void accept();

private:
    KMLWizardPage *introPage, *mldonkeyDownloadPage, *coreSelectionPage,
                  *workingDirPage, *startupModePage, *namePage, *endPage;
    FileSelector *coreSelector, *workingDirSelector;
    QButtonGroup *startupModeSelector;
    KLineEdit *nameEntry;
};

#endif
