/***************************************************************************
 *   Copyright (C) 2004 by Marco Gulino                                    *
 *   marco.gulino@gmail.com                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "threadedgsm.h"
// #include "threadwin.moc"
#include <iostream>
using namespace std;
#include <kglobal.h>

#include "gsm.h"
extern GSM* d_gsm;
#include "c_config.h"
extern c_config* Config;

void threadedGSM::run()
{
	paused=false;
// 	cout << Config->getDevice() << endl;
	delQueue.clear();
	active=true;
	while ( d_gsm==NULL) { msleep(250); }
	initPhoneBookFlag=false;
	d_gsm->getPhoneStatus();
	d_gsm->initSMSList();
	QStringList pbSlots;
	int i=0;
	while(active)
	{
		while(paused)
		{
			pausedStatus=true;
			msleep(250);
		}
		pausedStatus=false;
		for(QStringList::iterator it=delQueue.begin(); it!=delQueue.end(); ++it)
			d_gsm->removeSMS( *it );
		delQueue.clear();
		d_gsm->getPhoneStatus();
		if(initPhoneBookFlag)
		{
			d_gsm->setAbInited(false);
			pbSlots=Config->getPbMemUsed();
			for(QStringList::iterator it=pbSlots.begin(); it!=pbSlots.end(); ++it)
				d_gsm->initPhoneBook( *it );
			initPhoneBookFlag=false;
			d_gsm->setAbInited(true);
		}
		if(i==2)
		{
			d_gsm->initSMSList( Config->getSMSMemUsed() );
			i=0;
		}
		msleep(400);
		i++;
	}
}
