/***************************************************************************
                          kmfruleeditcustomopt.cpp  -  description
                             -------------------
    begin                : Mon Apr 21 2003
    copyright            : (C) 2003 by animal
    email                : animal@shit
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kmfruleeditcustomopt.h"

// KDE includes
#include <kdebug.h>
#include <kapplication.h>

// QT includes
#include <qpushbutton.h>
#include <qlineedit.h>
#include <qlabel.h>
#include <qstring.h>
#include <qcheckbox.h>

// Project includes
#include "../core/iptrule.h"
#include "../core/iptchain.h"
#include "../core/iptable.h"

KMFRuleEditCustomOpt::KMFRuleEditCustomOpt(QWidget *parent, const char *name ) : KMyFirewallRuleEditorCustomRule(parent,name) {
  c_options->setChecked(false);
  c_target_options->setChecked(false);
	t_target->clear();
	t_target_options->clear();
	t_options->clear();
}

KMFRuleEditCustomOpt::~KMFRuleEditCustomOpt(){

}
void KMFRuleEditCustomOpt::loadRule( IPTRule * rule ){
	kdDebug() << "void KMFRuleEditIP::loadRule( IPTRule * rule )" << endl;
  if ( rule == 0 )
		return;
  
	curr_rule = rule;
	t_target->clear();
  t_target->setText( curr_rule->target() );
	t_target_options->clear();
	t_options->clear();
	QPtrList<QPtrList<QString> > opt_list = curr_rule->ruleOptions();
	for ( uint j = 0;j < opt_list.count();j++ ) {
		QPtrList<QString> *options = new QPtrList<QString>;
		options = opt_list.at( j );
		if ( options->count() > 1 ) {
			QString * opt = options->at( 0 );
			QString* cmd = options->at( 1 );
			if ( *opt == "custom_option" ) {
        c_options->setChecked(true);
				t_options->setText( *cmd );
			} 
		}
	}

	QPtrList<QString>* curr_opt = new QPtrList<QString>;
	QPtrList<QPtrList<QString> > options = curr_rule->ruleTargetOptions();
	for ( uint i = 0;i < options.count();i++ ) {
		curr_opt = options.at( i );
		if ( *curr_opt->at( 0 ) == "custom_option" ) {
			c_target_options->setChecked(true);
			t_target_options->setText( *curr_opt->at( 1 ) );
		}
  }
	return ;
	
}

void KMFRuleEditCustomOpt::accept() {
	QString target = "";
	target =  t_target->text();
	QString option = "";
  if ( c_options->isChecked() )
		option = t_options->text();
	QString target_option = "";
  if ( c_target_options->isChecked() )
		target_option = t_target_options->text();

	kdDebug() << "target: " << target << endl;
	kdDebug() << "option: " << option << endl;
	kdDebug() << "target_option: " << target_option << endl;


  
	
  QString * del = new QString( "custom_option" );
	//     curr_rule->delRuleOption(*del);
	emit sigDelRuleOpt( del );
	emit sigDelTargetOpt( del );

  if ( !c_options->isChecked() && ! c_target_options->isChecked() ) {
		curr_rule->setCustomRule(false);
		emit sigDocumentChanged();
		return;
	}
	
	curr_rule->setCustomRule(true);
  if ( target != "" )
		curr_rule->setTarget( *(new QString(target)) );

	QString* op = new QString( "custom_option" );
	QPtrList<QString>* values = new QPtrList<QString>;
  if ( option != "" ) {
		QString *opt = new QString( option );
		values->append( opt );
		emit sigAddRuleOpt( op, values );
	}
	values->clear();
	if ( target_option != "" ) {
		QString *tg_opt = new QString( target_option );
		values->append( tg_opt );
		emit sigAddTargetOpt( op, values );
	}
	emit sigDocumentChanged();
}

void KMFRuleEditCustomOpt::slotHelp() {
	kdDebug() << "void KMFRuleEditIP::slotHelp()" << endl;
	kapp->invokeHelp( "custom_rules" );
}

void KMFRuleEditCustomOpt::reject() {
	kdDebug() << "void KMFRuleEditCustomOpt::reject()" << endl;
	emit sigHideMe();
}



#include "kmfruleeditcustomopt.moc"
