/***************************************************************************
   begin                : Fri Feb 21 2003
   copyright            : (C) 2003 by Christian Hubinger
   email                : chubinger@gmail.com
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


// QT includes
#include <qlabel.h>
#include <qpainter.h>
#include <qfont.h>
#include <qwidget.h>

// KDE includes
#include <kstandarddirs.h>
#include <kdebug.h>
#include <kglobalsettings.h>
#include <kurl.h>
#include <kfiledialog.h>
// Project includes
#include "kmfapp.h"
#include "../version.h"


KMFApp::KMFApp() {}
KMFApp::~KMFApp() {}

static QLabel *splash = 0;

void set_splash_status( const QString& msg ) {
	if ( !splash )
		return ;
	splash->repaint( FALSE );
	QPainter p( splash );
	QFont f( KGlobalSettings::generalFont().family(), 8, QFont::Bold );
	p.setFont( f );
	p.setPen( Qt::white );
	p.drawText( splash->width() / 2 - splash->fontMetrics().width( msg ) / 2, 265, msg );
	QApplication::flush();
}

void showSplash() {
	QRect screen = QApplication::desktop() ->screenGeometry();
	QRect mainRect;
	screen = QApplication::desktop() ->screenGeometry( QApplication::desktop() ->screenNumber( mainRect.center() ) );

	bool show = true;
	if ( show ) {
		KStandardDirs std_dir;
		QString dir = std_dir.findResource( "data", "kmyfirewall/pics/splash.png" );
		kdDebug() << "\nFound Splashscreen at: " << dir << endl;

		QPixmap pic = QPixmap::fromMimeSource( dir );
		QFont f( KGlobalSettings::generalFont().family(), 8, QFont::Bold );
		if ( pic.isNull() )
			return ;
		QPainter p( &pic );
		p.setFont( f );
		p.setPen( Qt::white );
		p.drawText( 280, 93, QString( "Version %1" ).arg( KMYFIREWALL_VERSION ) );
		splash = new QLabel( 0, "splash", QWidget::WDestructiveClose | QWidget::WStyle_Customize | QWidget::WStyle_NoBorder | QWidget::WX11BypassWM | QWidget::WStyle_StaysOnTop );
		splash->setFrameStyle( QFrame::WinPanel | QFrame::Raised );
		splash->setPixmap( pic );
		splash->adjustSize();
		splash->setFixedSize( splash->sizeHint() );
		splash->move( screen.center() - QPoint( splash->width() / 2, splash->height() / 2 ) );
		splash->repaint( FALSE );
		splash->show();
		set_splash_status( "Initializing..." );
		QApplication::flush();
	}
}

void closeSplash() {
	if ( splash ) {
		splash->close();
		splash = 0;
	}
}



