//
//
// C++ Implementation: $MODULE$
//
// Description:
//
//
// Author: Christian Hubinger <chubinger@gmail.com>, (C) 2003
//
// Copyright: See COPYING file that comes with this distribution
//
//
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include "kmfgenericinterfacenat.h"


// QT includes
#include <qstring.h>
#include <qstringlist.h>
#include <qcheckbox.h>
#include <qlistview.h>

// KDE includes
#include <kdebug.h>
#include <klocale.h>
#include <kcombobox.h>
#include <knuminput.h>
#include <klistview.h>

// Project includes
#include "../core/kmfgenericdoc.h"
#include "../core/kmfconfig.h"

KMFGenericInterfaceNat::KMFGenericInterfaceNat( QWidget *parent, const char *name, WFlags f )
		: KMyFirewallGenericInterfaceNATWidget( parent, name, f ) {

connect( m_c_enable_nat, SIGNAL( toggled( bool ) ),
	this, SLOT( slotNatEnabled( bool ) ) );
connect( m_c_use_masquerade, SIGNAL( toggled( bool ) ),
	this, SLOT( slotMasqueradeEnabled( bool ) ) );


connect( m_sb_addr_1, SIGNAL( valueChanged( const QString& ) ),
	this, SLOT( slotAddressChanged( const QString& ) ) );
connect( m_sb_addr_2, SIGNAL( valueChanged( const QString& ) ),
	this, SLOT( slotAddressChanged( const QString& ) ) );
connect( m_sb_addr_3, SIGNAL( valueChanged( const QString& ) ),
	this, SLOT( slotAddressChanged( const QString& ) ) );
connect( m_sb_addr_4, SIGNAL( valueChanged( const QString& ) ),
	this, SLOT( slotAddressChanged( const QString& ) ) );

connect( m_cb_external_interface, SIGNAL(  activated( const QString& ) ),
	this, SLOT( slotExternalInterfaceChanged( const QString& ) ) );
}


KMFGenericInterfaceNat::~KMFGenericInterfaceNat() {}

/*!
    \fn KMFGenericInterfaceNat::slotUpdateView()
 */
void KMFGenericInterfaceNat::slotUpdateView() {
	kdDebug() << "void KMFGenericInterfaceNat::slotUpdateView()" << endl;
	m_c_enable_nat->setChecked( m_doc->useNat() );
	m_c_use_masquerade->setChecked( m_doc->useMasquerade() );
// 	m_c_restrict_nat->setChecked( m_doc->restrictNat() );
	m_sb_addr_1->blockSignals( true );
	m_sb_addr_2->blockSignals( true );
	m_sb_addr_3->blockSignals( true );
	m_sb_addr_4->blockSignals( true );
	m_sb_addr_1->setValue( m_doc->natAddress()->getDigit( 0 ) );
	m_sb_addr_2->setValue( m_doc->natAddress()->getDigit( 1 ) );
	m_sb_addr_3->setValue( m_doc->natAddress()->getDigit( 2 ) );
	m_sb_addr_4->setValue( m_doc->natAddress()->getDigit( 3 ) );
	kdDebug() << "Setting Address Fields to: " << m_doc->natAddress()->getDigit( 0 ) << "." <<
					 m_doc->natAddress()->getDigit( 1 ) << "." << m_doc->natAddress()->getDigit( 2 ) << "." <<
					  m_doc->natAddress()->getDigit( 3 ) << endl;
	m_sb_addr_1->blockSignals( false );
	m_sb_addr_2->blockSignals( false );
	m_sb_addr_3->blockSignals( false );
	m_sb_addr_4->blockSignals( false );

	QStringList interfaces =  KMFConfig::interfaces();
	m_cb_external_interface->clear();
	m_cb_external_interface->insertStringList( interfaces );

	QString interf = m_doc->outgoingInterface();

	interf = m_doc->outgoingInterface();
	bool found = false;
	int i = 0;
	for ( QStringList::Iterator it = interfaces.begin(); it != interfaces.end() && ! found; ++it ) {
		if ( *it == interf ) {
			m_cb_external_interface->setCurrentItem( i );
		}
		i++;
    }

}

/*!
    \fn KMFGenericInterfaceNat::loadDoc( KMFGenericDoc* )
 */
void KMFGenericInterfaceNat::loadDoc( KMFGenericDoc* doc ) {
	kdDebug() << "void KMFGenericInterfaceNat::loadDoc( KMFGenericDoc* )" << endl;
	m_doc = doc;
	slotUpdateView();
}


/*!
    \fn KMFGenericInterfaceNat::slotNatEnabled( bool )
 */
void KMFGenericInterfaceNat::slotNatEnabled( bool onoff ) {
	m_doc->setUseNat( onoff );
}

/*!
    \fn KMFGenericInterfaceNat::slotMasqueradeEnabled( bool )
 */
void KMFGenericInterfaceNat::slotMasqueradeEnabled( bool onoff ) {
	m_doc->setUseMasquerade( onoff );
}


/*!
    \fn KMFGenericInterfaceNat::slotAddressChanged( const QString& )
 */
void KMFGenericInterfaceNat::slotAddressChanged( const QString& ) {
	QString address = "" + m_sb_addr_1->text() + "." +  m_sb_addr_2->text() + "." +  m_sb_addr_3->text() + "." +  m_sb_addr_4->text();
	kdDebug() << "Updating NAT external address to: " << address << endl;

	m_doc->natAddress()->setAddress( m_sb_addr_1->value(),
														m_sb_addr_2->value(),
														m_sb_addr_3->value(),
														m_sb_addr_4->value() );

}
/*!
    \fn KMFGenericInterfaceNat::slotOutgoingInterfaceChanged( const QString& )
 */
void KMFGenericInterfaceNat::slotExternalInterfaceChanged( const QString& str ) {
	m_doc->setOutgoingInterface( str );
/*	QStringList interfaces =  Config().m_interfaces;
	for ( QStringList::Iterator it = interfaces.begin(); it != interfaces.end(); ++it ) {
		m_doc->delAllowedIncomingInterface( *it );
    }*/
	slotUpdateView();
}


#include "kmfgenericinterfacenat.moc"
