/***************************************************************************
  begin                : Fri Nov 1 2002
  copyright            : (C) 2002 by Christian Hubinger
  email                : chubinger@gmail.com
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kmfportwidget.h"

#include <qstring.h>
#include <qcheckbox.h>
#include <qspinbox.h>
#include <qlabel.h>

#include <kcombobox.h>
#include <klocale.h>
#include <kdebug.h>

#include "../core/kmferror.h"


KMFPortWidget::KMFPortWidget( QWidget *parent, const char *name ) : KMyFirewallPortWidget( parent, name ) {
	m_err = new KMFError();
	m_err->setErrType( KMFError::OK );
	m_err->setErrMsg( "" );

	cb_port_name->clear();
	cb_port_name->insertItem( "tcpmux" );
	cb_port_name->insertItem( "echo" );
	cb_port_name->insertItem( "discard" );
	cb_port_name->insertItem( "systat" );
	cb_port_name->insertItem( "daytime" );
	cb_port_name->insertItem( "netstat" );
	cb_port_name->insertItem( "qotd" );
	cb_port_name->insertItem( "msp" );
	cb_port_name->insertItem( "chargen" );
	cb_port_name->insertItem( "ftp-data" );
	cb_port_name->insertItem( "ftp" );
	cb_port_name->insertItem( "fsp" );
	cb_port_name->insertItem( "ssh" );
	cb_port_name->insertItem( "telnet" );
	cb_port_name->insertItem( "smtp" );
	cb_port_name->insertItem( "time" );
	cb_port_name->insertItem( "rlp" );
	cb_port_name->insertItem( "nameserver" );
	cb_port_name->insertItem( "whois" );
	cb_port_name->insertItem( "re-mail-ck" );
	cb_port_name->insertItem( "domain" );
	cb_port_name->insertItem( "mtp" );
	cb_port_name->insertItem( "bootps" );
	cb_port_name->insertItem( "bootpc" );
	cb_port_name->insertItem( "tftp" );
	cb_port_name->insertItem( "gopher" );
	cb_port_name->insertItem( "rje" );
	cb_port_name->insertItem( "finger" );
	cb_port_name->insertItem( "www" );
	cb_port_name->insertItem( "link" );
	cb_port_name->insertItem( "kerberos" );
	cb_port_name->insertItem( "supdup" );
	cb_port_name->insertItem( "hostnames" );
	cb_port_name->insertItem( "iso-tsap" );
	cb_port_name->insertItem( "csnet-ns" );
	cb_port_name->insertItem( "rtelnet" );
	cb_port_name->insertItem( "pop2" );
	cb_port_name->insertItem( "pop3" );
	cb_port_name->insertItem( "sunrpc" );
	cb_port_name->insertItem( "auth" );
	cb_port_name->insertItem( "sftp" );
	cb_port_name->insertItem( "uucp-path" );
	cb_port_name->insertItem( "nntp" );
	cb_port_name->insertItem( "ntp" );
	cb_port_name->insertItem( "pwdgen" );
	cb_port_name->insertItem( "netbios-ns" );
	cb_port_name->insertItem( "netbios-dgm" );
	cb_port_name->insertItem( "netbios-ssn" );
	cb_port_name->insertItem( "imap2" );
	cb_port_name->insertItem( "snmp" );
	cb_port_name->insertItem( "snmp-trap" );
	cb_port_name->insertItem( "cmip-man" );
	cb_port_name->insertItem( "cmip-agent" );
	cb_port_name->insertItem( "mailq" );
	cb_port_name->insertItem( "xdmcp" );
	cb_port_name->insertItem( "nextstep" );
	cb_port_name->insertItem( "bgp" );
	cb_port_name->insertItem( "prospero" );
	cb_port_name->insertItem( "irc" );
	cb_port_name->insertItem( "smux" );
	cb_port_name->insertItem( "at-rtmp" );
	cb_port_name->insertItem( "at-rtmp" );
	cb_port_name->insertItem( "at-nbp" );
	cb_port_name->insertItem( "at-echo" );
	cb_port_name->insertItem( "at-zis" );
	cb_port_name->insertItem( "qmtp" );
	cb_port_name->insertItem( "z3950" );
	cb_port_name->insertItem( "ipx" );
	cb_port_name->insertItem( "imap3" );
	cb_port_name->insertItem( "pawserv" );
	cb_port_name->insertItem( "zserv" );
	cb_port_name->insertItem( "fatserv" );
	cb_port_name->insertItem( "rpc2portmap" );
	cb_port_name->insertItem( "codaauth2" );
	cb_port_name->insertItem( "ulistserv" );
	cb_port_name->insertItem( "ldap" );
	cb_port_name->insertItem( "https" );
	cb_port_name->insertItem( "snpp" );
	cb_port_name->insertItem( "saft" );
	cb_port_name->insertItem( "npmp-local" );
	cb_port_name->insertItem( "npmp-gui" );
	cb_port_name->insertItem( "hmmp-ind" );
	cb_port_name->insertItem( "ipp" );
	cb_port_name->insertItem( "exec" );
	cb_port_name->insertItem( "biff" );
	cb_port_name->insertItem( "login" );
	cb_port_name->insertItem( "who" );
	cb_port_name->insertItem( "shell" );
	cb_port_name->insertItem( "syslog" );
	cb_port_name->insertItem( "printer" );
	cb_port_name->insertItem( "talk" );
	cb_port_name->insertItem( "ntalk" );
	cb_port_name->insertItem( "route" );
	cb_port_name->insertItem( "timed" );
	cb_port_name->insertItem( "tempo" );
	cb_port_name->insertItem( "courier" );
	cb_port_name->insertItem( "conference" );
	cb_port_name->insertItem( "netnews" );
	cb_port_name->insertItem( "netwall" );
	cb_port_name->insertItem( "gdomap" );
	cb_port_name->insertItem( "gdomap" );
	cb_port_name->insertItem( "uucp" );
	cb_port_name->insertItem( "klogin" );
	cb_port_name->insertItem( "kshell" );
	cb_port_name->insertItem( "afpovertcp" );
	cb_port_name->insertItem( "remotefs" );
	cb_port_name->insertItem( "nntps" );
	cb_port_name->insertItem( "submission" );
	cb_port_name->insertItem( "ldaps" );
	cb_port_name->insertItem( "tinc" );
	cb_port_name->insertItem( "silc" );
	cb_port_name->insertItem( "kerberos-adm" );
	cb_port_name->insertItem( "webster" );
	cb_port_name->insertItem( "rsync" );
	cb_port_name->insertItem( "ftps-data" );
	cb_port_name->insertItem( "ftps" );
	cb_port_name->insertItem( "telnets" );
	cb_port_name->insertItem( "imaps" );
	cb_port_name->insertItem( "ircs" );
	cb_port_name->insertItem( "pop3s" );
	cb_port_name->insertItem( "socks" );
	cb_port_name->insertItem( "mysql" );
	cb_port_name->insertItem( "jabber-client" );
	cb_port_name->insertItem( "jabber-server" );
	cb_port_name->insertItem( "postgres" );
	cb_port_name->insertItem( "x11" );
	cb_port_name->insertItem( "x11-1" );
	cb_port_name->insertItem( "x11-2" );
	cb_port_name->insertItem( "x11-3" );
	cb_port_name->insertItem( "x11-4" );
	cb_port_name->insertItem( "x11-5" );
	cb_port_name->insertItem( "x11-6" );
	cb_port_name->insertItem( "x11-7" );
	cb_port_name->insertItem( "font-service" );
	cb_port_name->insertItem( "kerberos4" );
	cb_port_name->insertItem( "kerberos_master" );
	cb_port_name->insertItem( "passwd_server" );
	cb_port_name->insertItem( "krb_prop" );
	cb_port_name->insertItem( "krbupdate" );
	cb_port_name->insertItem( "kpasswd" );
	cb_port_name->insertItem( "swat" );
	cb_port_name->insertItem( "kpop" );
	cb_port_name->insertItem( "knetd" );
	cb_port_name->insertItem( "zephyr-srv" );
	cb_port_name->insertItem( "zephyr-clt" );
	cb_port_name->insertItem( "zephyr-hm" );
	cb_port_name->insertItem( "eklogin" );
	cb_port_name->insertItem( "linuxconf" );
	cb_port_name->insertItem( "poppassd" );
	sb_port1->setMaxValue( 65535 );
	sb_port2->setMaxValue( 65535 );
	sb_port1->setMinValue( 1 );
	sb_port2->setMinValue( 1 );
}

KMFPortWidget::~KMFPortWidget() {}

KMFError* KMFPortWidget::getPortString( QString* value ) {
	QString port1 = "";
	QString port2 = "";
	QString portname = "";
	QString ddot = ":";
	if ( c_port_name->isChecked() ) {
		portname = cb_port_name->currentText();
		kdDebug() << "Found portname: " << portname << endl;
		value->append( portname );
		kdDebug() << "Return portname: " << *value << endl;
		m_err->setErrType( KMFError::OK );
		m_err->setErrMsg( "" );
		return m_err;
	} else {
		port1 = port1.setNum( sb_port1->value() );
		value->append( port1 );
		if ( c_portrange->isChecked() ) {
			port2 = port2.setNum( sb_port2->value() );
			value->append( ddot );
			value->append( port2 );
		}

		if ( c_inv->isChecked() ) {
			value->prepend( "! " );
		}
		m_err->setErrType( KMFError::OK );
		m_err->setErrMsg( "" );
		return m_err;
	}
	return m_err;
}

void KMFPortWidget::loadPortString( QString& port ) {
	kdDebug() << "void KMFPortWidget::loadPortString(QString&)" << endl;
	kdDebug() << "Try to load PortString: " << port << endl;
	setEnabled( true );
	if ( port.startsWith( "! " ) ) {
		port = port.right( port.length() - 2 );
		c_inv->setChecked( true );
	}

	int pos = -1;
	pos = port.find( ":" );
	if ( pos > -1 ) {
		c_port_name->setChecked( false );
		c_portrange->setChecked( true );
		sb_port2->setEnabled( true );
		l_to->setEnabled( true );
		c_port_name->setEnabled( false );

		QString port1 = port.left( pos );
		QString port2 = port.right( port.length() - pos - 1 );
		kdDebug() << "Found Ports: " << port1 << " and " << port2 << endl;
		int p1, p2;
		bool bp1, bp2;
		p1 = port1.toInt( &bp1, 10 );
		p2 = port2.toInt( &bp2, 10 );
		if ( p1 )
			sb_port1->setValue( p1 );
		if ( p2 )
			sb_port2->setValue( p2 );
	} else {
		kdDebug() << "Found Port: " << port << endl;
		int p;
		bool ok;
		p = port.toInt( &ok, 10 );
		if ( ok ) {
			sb_port1->setValue( p );
		} else {
			c_port_name->setChecked( true );
			
// 			for ( uint i = 0; i < c_port_name->count(); i++ ) {
// 				QString tmp_item = c_port_name->text( i );
// 				if ( tmp_item == port ) {
// 					c_port_name->setCurrentItem( i );
// 				}
// 			}

			
			cb_port_name->setCurrentText( port );
			
		}
	}
}

void KMFPortWidget::reset() {
	c_portrange->setChecked( false );
	c_inv->setChecked( false );
	l_to->setEnabled( false );
	c_port_name->setChecked( false );
	cb_port_name->setCurrentItem( 0 );
	sb_port1->setValue( 0 );
	sb_port2->setValue( 0 );
}

#include "kmfportwidget.moc"
