/***************************************************************************
 begin                : Thu Aug 29 2002
 copyright            : (C) 2002 by Christian Hubinger
 email                : chubinger@gmail.com.orphi.iki
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kmfruleedittargetmark.h"

// QT includes
#include <qstring.h>
#include <qcheckbox.h>
#include <qspinbox.h> 
// KDE includes
#include <kdebug.h>
#include <kapplication.h>

// MY includes
#include "../../core/iptrule.h"
#include "../../core/iptruleoption.h"
#include "../../core/iptchain.h"
#include "../../core/iptable.h"
#include "../../core/kmfdoc.h"
#include "../../core/kmfiptdoc.h"


KMFRuleEditTargetMark::KMFRuleEditTargetMark( QWidget *parent, const char *name, WFlags fl ) : KMyFirewallRuleEditorTargetMark( parent, name, fl ) {}
KMFRuleEditTargetMark::~KMFRuleEditTargetMark() {}

void KMFRuleEditTargetMark::loadRule( IPTRule* rule ) {
	kdDebug() << "void KMFRuleEditTargetMark::loadRule(IPTRule* rule)" << endl;
	if ( rule == 0 ) {
		kdDebug() << "void KMFRuleEditTargetMark::loadRule(IPTRule* rule)\nrule == 0\nThis is a bug ;-)" << endl;
		return ;
	}
	m_rule = rule;
	IPTRuleOption *opt = m_rule->getOptionForName( "target_mark_opt" );
	QStringList vals = opt->getValues();
	QString val = "";
	val = *vals.at(0);
	if ( val != "UNDEFINED" && !val.isEmpty() && val != "bool:off" ) {
		c_use_mark->setChecked( true );
		int num = val.toInt();
		sb_mark->setValue( num );
	} else {
		c_use_mark->setChecked( false );
	}
}
void KMFRuleEditTargetMark::accept() {
	m_rule->chain()->table()->kmfDoc()->startTransaction();
	m_rule->saveState();
	kdDebug() << "void KMFRuleEditTargetMark::accept()" << endl;
	QPtrList<QString>* options = new QPtrList<QString>;
	QString* name = new QString( "target_mark_opt" );
	if ( c_use_mark->isChecked() ) {
		int mark = sb_mark->value();
		kdDebug() << "Will set mark" << mark << endl;
		QString* opt = new QString( "" );
		QString val = val.setNum( mark );
		opt->append( val );
		options->append( opt );
	}
	emit sigAddTargetOpt( name, options );
	m_rule->chain()->table()->kmfDoc()->endTransaction();
	emit sigDocumentChanged();
	//	QDialog::accept();
}

void KMFRuleEditTargetMark::slotHelp() {
	kdDebug() << "void KMFRuleEditTargetMark::slotHelp()" << endl;
	kapp->invokeHelp( "targets" );
}
void KMFRuleEditTargetMark::reject() {
	kdDebug() << "void KMFRuleEditTargetMark::reject()" << endl;
	loadRule(m_rule);
	emit sigHideMe();
}

#include "kmfruleedittargetmark.moc"
