//
// C++ Interface: kmfiptablescompiler
//
// Description:
//
//
// Author: Christian Hubinger <chubinger@irrsinnig.org>, (C) 2003
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef KMFIPTABLESCOMPILER_H
#define KMFIPTABLESCOMPILER_H

#include "../../core/kmfcompilerinterface.h"

/**
@author Christian Hubinger
*/

// QT includes
#include <qstring.h>
#include <qobject.h>

// KDE includes
#include <kparts/part.h>
#include <kparts/plugin.h>
#include <kparts/factory.h>
#include <kxmlgui.h>

// Project includes
#include "../../core/kmfplugin.h"
#include "../../core/kmfcompilerinterface.h"

class QTabWidget;
class KInstance;

namespace KMF {
class KMFListView;
class KMFGenericDoc;
class KMFIPTDoc;
class KMFErrorHandler;

class KMFIPTablesCompiler :  public KMFPlugin, public virtual KMFCompilerInterface {
	Q_OBJECT
public:
	KMFIPTablesCompiler( QObject* parent, const char* name );
	~KMFIPTablesCompiler();
	void compile();
	const QString& compile( KMFGenericDoc* );
	const QString& compile( KMFIPTDoc* );
	const QString& osName();
	const QString& osGUIName();
	const QString& backendName();
	const QString& backendGUIName();

private slots:
	void slotConvertToIPTDoc();
	void slotExportIPT();
// 	void slotShowIPTScript();

private:
	KMFErrorHandler *m_errorHandler;
	QTabWidget *m_iptWidget;
	KMFListView *m_iptViewFilter, *m_iptViewNat, *m_iptViewMangle;
	QString m_osName;
	QString m_osGUIName;
	QString m_backendName;
	QString m_backendGUIName;
	KMFIPTDoc *m_iptdoc;
};




class KMFIPTablesCompilerFactory : public KLibFactory {
	Q_OBJECT
public:
	KMFIPTablesCompilerFactory( QObject *parent = 0, const char *name = 0 );
	virtual ~KMFIPTablesCompilerFactory() {
/* 		delete s_instance; */
	};
	virtual QObject* createObject( QObject* parent = 0, const char* pname = 0,
	                               const char* name = "QObject",
	                               const QStringList &args = QStringList() );
	/*     static KInstance* instance(); */

/*private:
	static KInstance* s_instance;*/
};
}


#endif
