//
// C++ Interface: kmfprotocolcategory
//
// Description: 
//
//
// Author: Christian Hubinger <chubinger@irrsinnig.org>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef KMFPROTOCOLCATEGORY_H
#define KMFPROTOCOLCATEGORY_H

#include "netfilterobject.h"

// QT includes
#include <qstringlist.h>
#include <qstring.h>
#include <qguardedptr.h>
#include <qvaluelist.h>
#include <qmap.h>
#include <quuid.h>
#include <qobject.h>

// KDE includes
#include <kdemacros.h>
#include <kurl.h>

namespace KMF {
class KMFProtocol;

/**
	@author Christian Hubinger <chubinger@irrsinnig.org>
*/

class KDE_EXPORT KMFProtocolCategory : public NetfilterObject
{
Q_OBJECT
public:
	static KMFProtocolCategory* createCategory( const QString& name );
	
	
	static KMFProtocolCategory* getCustomCategory();
	
private:	
	static const QUuid& customCategoryUuid();
	static const QUuid& miscCategoryUuid();
	
public:
   
   ~KMFProtocolCategory();
	KMFProtocol* createProtocol( const QString& name );
	
	QValueList< KMFProtocol* >& protocols() const;

	
	
	KMFProtocol* findProtocolByUuid( const QUuid& name ) const;
	
	virtual int type();
	virtual void clear();
	virtual const QDomDocument& getDOMTree();
	virtual void loadXML(const QDomDocument&, QStringList& errors );
	virtual void loadXML( QDomNode, QStringList& errors );
	
	void delProtocol( KMFProtocol*, bool destructive /* = false */);
	
public slots:
	void slotOnProtocolDeleted( QObject* protocol );
	
private:
	KMFProtocol* findProtocolByName( const QString& name ) const;
	
	KMFProtocol* addProtocol( KMFProtocol* );
	

private: // DATA
	KMFProtocolCategory( NetfilterObject* parent, const char* name );
	QString m_icon;
	QValueList< KMFProtocol* > m_protocols;


};
}
#endif
