//
// C++ Implementation:
//
// Description:
//
//
// Author: Christian Hubinger <e9806056@student.tuwien.ac.at>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//


#include "kmfselectactivetarget.h"

// QT includes
#include <qstring.h>
#include <qcheckbox.h>
#include <qfile.h>
#include <qdir.h>
#include <qdom.h>
#include <qstring.h>
#include <qstringlist.h>
#include <qlistview.h>
#include <qradiobutton.h>
#include <qpushbutton.h>
#include <qlineedit.h>
#include <qtextedit.h>
#include <qlabel.h>
#include <qbuttongroup.h>
#include <qgroupbox.h>
#include <qspinbox.h>

// KDE includes
#include <klocale.h>
#include <kdebug.h>
#include <kstandarddirs.h>
#include <klocale.h>
#include <kio/netaccess.h>
#include <kio/job.h>
#include <ktrader.h>
#include <klibloader.h>
#include <klistview.h>
#include <klistbox.h>
#include <knuminput.h>
#include <kpushbutton.h>
#include <kmessagebox.h>
#include <ktempfile.h>

// Project includes
#include "kmflistviewitem.h"
#include "../version.h"
#include "../core/kmfnetwork.h"
#include "../core/kmfdoc.h"
#include "../core/kmftarget.h"


//##### static stuff
namespace KMF {
KMFTarget * KMFSelectActiveTarget::selectTarget( KMFNetwork* network, const QString& msg ) {
	kdDebug() << "KMFTarget * KMFSelectActiveTarget::selectTarget( KMFNetwork* network, const QString& " << msg << " )" << endl;
	QPtrList<KMFTarget> *list = new QPtrList<KMFTarget>;
	network->netzone()->getAllTargets( network->netzone(), list );
	if ( list->count() == 1 ) {
		return network->currentTarget();
	}
	
	
	
	KMFSelectActiveTarget *selTG = new KMFSelectActiveTarget( 0, "KMFSelectActiveTarget",
	   QWidget::WType_Dialog | QWidget::WShowModal 
	 );
	selTG->setMessage( msg  );
	selTG->loadNetwork( network );
	selTG->exec();
	KMFTarget *tg = selTG->selectedTarget();
	if ( tg ) {
		kdDebug() << "Selected Target: " << tg->guiName() << endl;
		return tg;
	}
	return 0;

}

//##### end static

KMFSelectActiveTarget::KMFSelectActiveTarget ( QWidget* parent, const char* name, bool modal, WFlags fl )
		: KMyFirewallSelectActiveTarget ( parent,name,modal,fl )
{
	m_cmd_ok->setEnabled( false );	
	
	connect( m_lv_zones, SIGNAL( pressed( QListViewItem* ) ) ,
		 this, SLOT( slotNewItemSelected( QListViewItem* ) ) );
	
	connect( m_lv_zones, SIGNAL( doubleClicked ( QListViewItem *, const QPoint &, int ) ) ,
		 this, SLOT( slotNewItemDBLClicked( QListViewItem*, const QPoint &, int  ) ) );	 
	
	connect( m_cmd_cancel, SIGNAL( clicked() ) ,
		 this, SLOT( slotCancel() ) );	 
	connect( m_cmd_ok, SIGNAL( clicked() ) ,
		 this, SLOT( slotOk() ) );
		 
	adjustSize();
}

KMFSelectActiveTarget::~KMFSelectActiveTarget()
{}

/*$SPECIALIZATION$*/


void KMFSelectActiveTarget::loadNetwork( KMFNetwork* net ) {
	kdDebug() << "KMFSelectActiveTarget::loadNetwork( KMFNetwork* )" << endl;
	if ( ! net ) {
		return;
	}
	m_network = net;
	m_lv_zones->clear();
	KMFListViewItem *it = new KMFListViewItem( m_lv_zones, 0, m_network->netzone() );
	it->setupZoneView();
}
void KMFSelectActiveTarget::setMessage( const QString& msg ) {
	kdDebug() << "KMFSelectActiveTarget::setMessage( const QString& )" << endl;
	m_lbl_message->setText( msg );
}
void KMFSelectActiveTarget::slotTargetSelected() {
	kdDebug() << "KMFSelectActiveTarget::slotTargetSelected()" << endl;
	
	
}

void KMFSelectActiveTarget::slotNewItemDBLClicked( QListViewItem* item, const QPoint &, int  ) {
	slotNewItemSelected( item );
	if ( m_target ) {
		slotOk();
	}
}

void KMFSelectActiveTarget::slotNewItemSelected( QListViewItem* item ) {
	kdDebug() << "void KMFMyNetworkWidget::slotNewItemSelected( QListViewItem* item )" << endl;
	if ( ! item )
		return ;
	m_target = 0;
	
	m_lv_zones->blockSignals( true );
	m_lv_zones->clearSelection();
	m_lv_zones->setSelected( item, true );
	m_lv_zones->blockSignals( false );
		
	m_cmd_ok->setEnabled( false );	
		
	KMFListViewItem* kmfitem = dynamic_cast<KMFListViewItem*> ( item );
	
	if ( ! kmfitem ) {
		kdDebug() << "No Item Selected!" << endl;	
		return;
	}
	
	if ( kmfitem != 0 && kmfitem->netfilterObject()->type() == NetfilterObject::KMFTARGET ) {
		m_target = kmfitem->target();
		m_lbl_currentTarget->setText( m_target->guiName() );
		kdDebug() << "Selected Target: " << m_target->guiName() << endl;
		m_cmd_ok->setEnabled( true );	
	} else {
		m_lbl_currentTarget->setText( i18n( "No Target Selected" ) );
		kdDebug() << "No Target Selected" << endl;
		m_cmd_ok->setEnabled( false );	
	}
	kdDebug() << "Laving slotNewItemSelected()" << endl;
}

void KMFSelectActiveTarget::slotCancel() {
	kdDebug() << "KMFSelectActiveTarget::slotCancel()" << endl;
	m_target = 0;
	QDialog::reject();
}
void KMFSelectActiveTarget::slotOk() {
	kdDebug() << "KMFSelectActiveTarget::slotOk()" << endl;
	QDialog::accept();
}

KMFTarget *KMFSelectActiveTarget::selectedTarget() {
	kdDebug() << "KMFSelectActiveTarget::slectedTarget()" << endl;
	return m_target;
}

}

#include "kmfselectactivetarget.moc"

