# Find Gwenhywfar
#
#  GWENHYWFAR_FOUND - system has Gwenhywfar with the minimum version needed
#  GWENHYWFAR_INCLUDE_DIRS - the Gwenhywfar include directories
#  GWENHYWFAR_LIBRARIES - The libraries needed to use Gwenhywfar
#  GWENHYWFAR_VERSION = The version of Gwenhywfar as defined in version.h

set(GWENHYWFAR_FOUND FALSE)

if(NOT GWENHYWFAR_MIN_VERSION)
  set(GWENHYWFAR_MIN_VERSION "3.10.1")
endif(NOT GWENHYWFAR_MIN_VERSION)

if(GWENHYWFAR_INCLUDE_DIRS AND GWENHYWFAR_LIBRARIES)
  # Already in cache, be silent
  set(GWENHYWFAR_FIND_QUIETLY TRUE)
endif(GWENHYWFAR_INCLUDE_DIRS AND GWENHYWFAR_LIBRARIES)

PKG_CHECK_MODULES(GWENHYWFAR gwenhywfar>=${GWENHYWFAR_MIN_VERSION})

if(${GWENHYWFAR_FOUND})
  find_library(GWENHYWFAR_GUI_LIBRARY NAMES gwengui-qt4 libgwengui-qt4
    HINTS ${GWENHYWFAR_LIBRARY_DIRS})
  if(GWENHYWFAR_GUI_LIBRARY STREQUAL "GWENHYWFAR_GUI_LIBRARY-NOTFOUND")
    set(GWENHYWFAR_GUI_LIBRARY "")
  endif(GWENHYWFAR_GUI_LIBRARY STREQUAL "GWENHYWFAR_GUI_LIBRARY-NOTFOUND")
  set(GWENHYWFAR_LIBRARIES ${GWENHYWFAR_LIBRARIES} ${GWENHYWFAR_GUI_LIBRARY})
endif(${GWENHYWFAR_FOUND})

mark_as_advanced(GWENHYWFAR_INCLUDE_DIRS GWENHYWFAR_LIBRARIES)
