/***************************************************************************
                          mymoneybanking.h
                             -------------------
    begin                : Thu Aug 26 2004
    copyright            : (C) 2004 Martin Preuss
    email                : aquamaniac@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef MYMONEYBANKING_H
#define MYMONEYBANKING_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// ----------------------------------------------------------------------------
// QT Includes

// ----------------------------------------------------------------------------
// KDE Includes

class KAction;
class QBanking;
class KMyMoneyBanking;
class KBAccountSettings;

// ----------------------------------------------------------------------------
// Project Includes

#include "kbanking.h"
#include <kmymoney/kmymoneyplugin.h>
#include <kmymoney/mymoneyaccount.h>
#include <kmymoney/mymoneykeyvaluecontainer.h>

/**
  * This class represents the KBanking plugin towards KMymoney.
  * All GUI related issues are handled in this object.
  */
class KBankingPlugin : public KMyMoneyPlugin::Plugin, public KMyMoneyPlugin::OnlinePlugin
{
  friend class KMyMoneyBanking;

  Q_OBJECT
public:
  KBankingPlugin(QObject* parent, const char* name, const QStringList&);
  virtual ~KBankingPlugin();

  bool importStatement(const MyMoneyStatement& s);

  const MyMoneyAccount& account(const QString& key, const QString& value) const;

  void setAccountOnlineParameters(const MyMoneyAccount& acc, const MyMoneyKeyValueContainer& kvps) const;

  void protocols(QStringList& protocolList) const;

private:
  /**
    * creates the job view and hooks it into the main view
    */
  void createJobView(void);

  /**
    * creates the action objects available through the application menus
    */
  void createActions(void);

  /**
    * creates the context menu
    */
  void createContextMenu(void);

  /**
    * checks whether a given KMyMoney account with id @p id is
    * already mapped or not.
    *
    * @param acc reference to KMyMoney account object
    * @retval false account is not mapped to an AqBanking account
    * @retval true account is mapped to an AqBanking account
    */
  const bool accountIsMapped(const MyMoneyAccount& acc);

  /**
   * sets up the reference string consisting out of BLZ and account number
   * in the KMyMoney object so that we can find it later on when importing data.
   */
  void setupAccountReference(const MyMoneyAccount& acc, AB_ACCOUNT* ab_acc);

  /**
   * Returns the value of the parameter @a s with all leading 0's stripped.
   */
  QString stripLeadingZeroes(const QString& s) const;

  /**
   * Prefills the protocol conversion list to allow mapping
   * of AqBanking internal names to external names
   */
  void loadProtocolConversion(void);

  /**
   * Creates an additional tab widget for the account edit dialog
   * to represent the necessary parameters for online banking
   * through AqBanking.
   */
  QWidget* accountConfigTab(const MyMoneyAccount& acc, QString& name);

  /**
   * Stores the configuration data kept in the widgets created
   * in accountConfigTab() and returns them in a key value container
   * The current settings are accessible through the reference to
   * @a current.
   */
  MyMoneyKeyValueContainer onlineBankingSettings(const MyMoneyKeyValueContainer& current);

  /**
    * Called by the application to map the KMyMoney account @a acc
    * to an AqBanking account. Calls KBanking to set up AqBanking mappings.
    * Returns the necessary settings for the plugin in @a settings and
    * @a true if the mapping was successful.
    */
  bool mapAccount(const MyMoneyAccount& acc, MyMoneyKeyValueContainer& settings);

  /**
    * Called by the application framework to update the
    * KMyMoney account @a acc with data from the online source.
    */
  bool updateAccount(const MyMoneyAccount& acc);

protected slots:
  void slotSettings(void);
  void slotImport(void);

private:
  MyMoneyAccount        m_account;
  KAction*              m_configAction;
  KAction*              m_importAction;
  KMyMoneyBanking*      m_kbanking;
  QMap<QString,QString> m_protocolConversionMap;
  KBAccountSettings*	m_accountSettings;
};

/**
  * This class is the special implementation to glue the KBanking class
  * with the KMyMoneyPlugin structure.
  */
class KMyMoneyBanking : public KBanking
{

public:
  KMyMoneyBanking(KBankingPlugin* parent, const char* appname, const char* fname = 0);
  virtual ~KMyMoneyBanking() {};

  bool importAccountInfo(AB_IMEXPORTER_ACCOUNTINFO *ai, uint32_t flags);

protected:
  const AB_ACCOUNT_STATUS* _getAccountStatus(AB_IMEXPORTER_ACCOUNTINFO *ai);
  void _xaToStatement(MyMoneyStatement &ks,
                      const MyMoneyAccount&,
                      const AB_TRANSACTION *t);

private:
  KBankingPlugin* m_parent;
  QMap<QString, bool> m_hashMap;
};

#endif
