/**
 * a class that processes incoming connections to 
 * get info on them and work out the type of connection that they are.
 */
#include "incomingconnection.h"
#include <iostream>
using namespace std;
#include "support_funcs.h"

#include <ksock.h>
#include <unistd.h>

IncomingConnection::IncomingConnection(int _sock)
   : EZThread()
{
  type = CONNECTION_UNKNOWN;
  this->sock = _sock;
}   
IncomingConnection::~IncomingConnection()
{

}
/** 
 * the things to run
 */
void IncomingConnection::run_method()
{
   ConnectionType tmp_type = CONNECTION_UNKNOWN;

   cerr << "IncomingConnection::run_method(): started\n";

   if(send(sock, "1", 1, 0)<=0) 
   {         // ??????***** WAS \n
      cerr<<"IncomingConnection::run_method():: error sending initial '1'\n";

      close(sock);
      return;
   }

   char buffer[4096+2];
   int n;
   // TODO force the getting of 3-4 bytes!!!
   // 
   n=recv(sock,buffer,4,0);           // action GET or SEND
   if(n<=0) 
   {
      cerr<<"IncomingConnection::run_method(): error reading c4dl 4 byte action\n";
      close(sock);
      return;
   }
   buffer[n]='\0';

   cerr << "IncomingConnection::run_method(): type = " << buffer << endl;

   // SEND - someone is sending us a file
   // GET - someone wants a file
   if(strncmp(buffer,"GET",3)==0)
   {
      tmp_type = CONNECTION_UPLOAD;
   } 
   else if(strncmp(buffer,"SEND",4)==0)
   {
      tmp_type = CONNECTION_DOWNLOAD;
   }
   else
      tmp_type = CONNECTION_INVALID; 

   if(tmp_type != CONNECTION_INVALID) // we have a connection here
   {
      int n = recv(sock,buffer,4096,0);  

      if(n<=-1) 
      {
	 cerr<<"IncomingConnection::run_method():error reading new header\n";
	 close(sock);
	 return;
      }
      else if(n==0) 
      {
	 cerr<<"IncomingConnection::run_method(): connection closed whilst in new header\n";
	 close(sock);
	 return;
      }
      buffer[n]='\0';

      cerr<<"IncomingConnection::run_method(): got a incoming dl header of: "<<buffer<<endl;

      QString str = buffer;
      //      QString user = extractString(str);
      //      QString filename = extractString(str);
      //      QString sz = extractString(str);
      //      unsigned long filesize = sz.toULong();

      songinfo.user = extractString(str);
      songinfo.filename = extractString(str);
      QString sz = extractString(str);
      songinfo.size = sz.toLong();
   }

   // TODO remove this
   //close(sock);
   down();
     type = tmp_type;
   up();
   cerr << "IncomingConnection::run_method(): ended\n";
}

IncomingConnection::ConnectionType IncomingConnection::getType()
{
   ConnectionType t; 

   down();
     t = type;
   up();

   return t;
}
