/***************************************************************************
 *   Copyright (C) 2005 by yodor   *
 *   yodor@developer.bg   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "knetdockapp.h"

#include <kmessagebox.h>
#include <kpopupmenu.h>
#include <khelpmenu.h>

#include <kconfig.h>


KNetDockApp::KNetDockApp ()
  : KUniqueApplication (true, true, true)
{
	
}

KNetDockApp::~KNetDockApp()
{
	
}
void KNetDockApp::setAboutData(KAboutData *aboutdata)
{
	about=aboutdata;
}
int KNetDockApp::newInstance ()
{
	mydock *dock = (mydock *)mainWidget();
	if (!dock)
	{
		KConfig *cfg = new KConfig("knetdockapprc");
		cfg->setGroup("Instances");
		int numInstances = cfg->readNumEntry("number",1);
		if (numInstances>16)
		{
			numInstances=16;
		}
		dock = new mydock();
		setMainWidget(dock);		
		KHelpMenu *mHelpMenu = new KHelpMenu( dock,about );
		KPopupMenu *help = mHelpMenu->menu();
		dock->contextMenu()->insertItem("&Help",help);
		dock->start();
		
		
		if (numInstances>1)
		{
			for (int a=1;a<numInstances;a++)
			{
				insertDockInstance();
			}
		}
		
	}
	else
	{
		
		insertDockInstance();
		//KMessageBox::messageBox(dock,KMessageBox::Error,"KNetDockApp is already running");
	}
	dock->show();
	
	return 0;
}
void KNetDockApp::insertDockInstance()
{
	mydock *d = new mydock();
		
	d->show();
	KHelpMenu *mHelpMenu = new KHelpMenu( d,about );
	KPopupMenu *help = mHelpMenu->menu();
	d->contextMenu()->insertItem("&Help",help);
	d->contextMenu()->insertItem("&Hide", d, SLOT(hideInstance()) );
	d->start();
}


