/***************************************************************************
 *   Copyright (C) 2005 by yodor   *
 *   yodor@developer.bg   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "netsettingsdialog.h"

#include <qlabel.h>
#include <qevent.h>
#include <qpainter.h>
#include <qlcdnumber.h>
#include <netsettings.h>
#include <math.h>

#include <qframe.h>
#include <qlayout.h>
#include <qprogressbar.h>

QString abv[] = {"Kilo","Mega","Giga","Tera","Peta","Exa","Zetta","Yotta"};

NetSettingsDialog::NetSettingsDialog(QWidget *parent, const char *name) : NetSettings(parent, name)
{
	init();
	cframe = new ChartFrame(chartframe,"chartframe");
	cframe->setGeometry(0,0,chartframe->width(),chartframe->height());
	cframe->init();
	cframe->clearChart();
	setCaption("KNetDockApp");
	
}

NetSettingsDialog::~NetSettingsDialog()
{}
void NetSettingsDialog::ifaceChange()
{
	cframe->clearChart();
}
void NetSettingsDialog::init()
{
    installEventFilter(this);
}
void NetSettingsDialog::resizeEvent(QResizeEvent *e)
{
	int nw = chartframe->width();
	cframe->setGeometry(0,0,nw,chartframe->height());
	
	
cframe->resize(nw);
	
}

void NetSettingsDialog::updateInfo(const AddrStat *astat)
{
	lblMask->setText(astat->mask);
	lblIP->setText(astat->ip);
	lblMAC->setText(astat->mac);
}

void NetSettingsDialog::updateWiFi(const WiFiStat *wstat)
{
	prgQual->setProgress(wstat->link_qual);
	prgNoise->setProgress(wstat->noise_level);
	prgLevel->setProgress(wstat->signal_level);
	lblESSID->setText(wstat->essid);
}

void NetSettingsDialog::updateStats(const net_device_stats *stats, const IfStat *total)
{

	cframe->setValue(cframe->nextValue(),total->speed);

	if (isShown())
	{
		QString c="";
		double ret;

		ret = getScaleString(total->speed,&c);
		lcdSpeed->display(ret);
		lblSpeed->setText(c+" B/s");

		c="";
		ret=getScaleString(total->bytes_in,&c);
		lblBytesIN->setText(QString("%1").arg(ret,0,'f',2)+c);
		c="";
		ret=getScaleString(total->bytes_out,&c);
		lblBytesOUT->setText(QString("%1").arg(ret,0,'f',2)+c);
		c="";
		ret=getScaleString(total->speed_in,&c);
		lblSpeedIn->setText(QString("%1").arg(ret,0,'f',2)+c);
		c="";
		ret=getScaleString(total->speed_out,&c);
		lblSpeedOut->setText(QString("%1").arg(ret,0,'f',2)+c);


		lblPacketsIN->setText(QString("%1").arg(stats->rx_packets));
		lblPacketsOUT->setText(QString("%1").arg(stats->tx_packets));
		lblErrorsIN->setText(QString("%1").arg(stats->rx_errors));
		lblErrorsOUT->setText(QString("%1").arg(stats->tx_errors));
		lblDropIN->setText(QString("%1").arg(stats->rx_dropped));
		lblDropOUT->setText(QString("%1").arg(stats->tx_dropped));
		lblCompressedIN->setText(QString("%1").arg(stats->rx_compressed));
		lblCompressedOUT->setText(QString("%1").arg(stats->tx_compressed));
		
		
		cframe->updateChart();
	}
	
}
void NetSettingsDialog::clearStats()
{
	lblBytesIN->setText("0");
	lblBytesOUT->setText("0");
	lblPacketsIN->setText("0");
	lblPacketsOUT->setText("0");
	lblErrorsIN->setText("0");
	lblErrorsOUT->setText("0");
	lblDropIN->setText("0");
	lblDropOUT->setText("0");
	lblCompressedIN->setText("0");
	lblCompressedOUT->setText("0");
	lblSpeedIn->setText("0");
	lblSpeedOut->setText("0");

	lcdSpeed->display("0");
	lblSpeed->setText("B/s");
}

void NetSettingsDialog::clearInfo()
{
	lblMask->setText(QString("N/A"));
	lblIP->setText(QString("N/A"));
	lblMAC->setText("N/A");
}

void NetSettingsDialog::clearWiFi()
{
	prgQual->setProgress(0);
	prgNoise->setProgress(0);
	prgLevel->setProgress(0);
}


double NetSettingsDialog::getScaleString(const unsigned long long int value, QString *c)
{
	double ret=(long long)value;
	int i=10;

	while (i<90)
	{
		double cs = pow(2,i);
		double cr = value / cs;
		if (cr > pow(2,10))
		{
			i+=10;
		}
		else
		{
			ret=cr;
			break;
		}
	}
	if (ret == 0)
	{
		*c=" ";
	}
	else
	{
		*c=" "+abv[(i/10)-1];
	}
	return ret;
}

bool NetSettingsDialog::eventFilter(QObject *,QEvent *)
{
	if (windowState()==Qt::WindowMinimized)
	{
	    hide();
	    return TRUE;
	}
	else
	{
		return FALSE;
    }
}

void NetSettingsDialog::fontChange(const QFont & f)
{
	
	adjustSize();
	repaint();
}
void NetSettingsDialog::paletteChange( const QPalette & oldPalette )
{
	
	adjustSize();
	
	setPalette(palette());
	repaint();
}
void NetSettingsDialog::styleChange( const QStyle & oldStyle )
{
	
	adjustSize();
	
	repaint();
}
#include "netsettingsdialog.moc"
