/***************************************************************************
 *   Copyright (C) 2007 by Todor Gyumyushev   *
 *   yodor@developer.bg   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef QUERYDEV_H
#define QUERYDEV_H


#include <qobject.h>
#include <qdict.h>
#include <qmutex.h>
#define NL_BUFSIZE 8192
#include "knetdockif.h"


class QueryDev : public QObject
{
Q_OBJECT

public:
	QueryDev(QObject *parent = 0);
	~QueryDev();
	KNetDockIf* update(const QString& dev_name);
	KNetDockIf* device(const QString& dev_name);
	
public slots:

	DeviceList getDeviceList();
	void queryDevices();
	void wifiScan(const QString& dev_name, WifiNetworkList& list);

signals:
	void devAdded(const QString& dev_name);
	void devRemoved(const QString& dev_name);
	void devUpdated(const QString& dev_name);
	
private:
	int fdsock;
	int nlsock;
	int msgSeq;
	DeviceList dev_list;

	int readSock(int, char*, int, int);
	void update();

	void initDevice(const QString& if_name, KNetDockIf *);
	
	void removeDevice(const QString& dev_name);
	
	QMutex mutex;
	
	char msgBuf[NL_BUFSIZE];
	char rngbuf[sizeof(struct iw_range) * 2];


};
#endif
