// ****************************************************************************
// copyright (c) 2000-2005 Horst Knorr <hk_classes@knoda.org>  
// This file is part of knoda -Knorr's Datenbank.
// This file may be distributed and/or modified under the terms of the
// GNU General Public License version 2 as published by the Free Software
// Foundation and appearing in the file COPYING included in the
// packaging of this file.
// This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
// ****************************************************************************
//$Revision: 1.32 $
#include "knodamaindockwindow.h"
#include "hk_kdedblistview.h"
#include "hk_kdecsvimportdialog.h"
#include "hk_kdecsvexportdialog.h"
#include "hk_kdexmlexportdialog.h"
#include "hk_kdedatabasesetting.h"
#include "hk_kdeobjecthandler.h"
#include "hk_kdepreferencesdialog.h"
#include "hk_kdetablepartwidget.h"
#include "hk_kdequerypartwidget.h"
#include "hk_kdeformpartwidget.h"
#include "hk_kdereportpartwidget.h"
#include "hk_kdenewdatabase.h"

#include <hk_connection.h>
#include <hk_drivermanager.h>

#include <qlayout.h>
#include <qclipboard.h>
#include <qtoolbutton.h>
#include <qcombobox.h>
#include <qspinbox.h>
#include <qlineedit.h>
#include <kcombobox.h>
#include <klocale.h>
#include <kparts/genericfactory.h>
#include <kiconloader.h>

knodamaindockwindow::knodamaindockwindow(
        struct_commandlinefields* commandline,
 	QWidget* parent,const char* name, WFlags f,
	const QString& dbname,const QString& form):knodamaindockwindowbase(commandline,parent,name,f)
{
  if (p_listview)
  connect(p_listview,SIGNAL(currentChanged(QListViewItem*)),this,SLOT(slot_selection_changed()));
  clipboarddata_has_changed();
  
  if (!dbname.isEmpty()&& p_databasecombobox)
   {
      int c=p_databasecombobox->count();
      int count=0;
      bool found=false;      
      while (count<c && !found)
      {
       QString s=p_databasecombobox->text(count);
       if (!s.isEmpty())
        {
	   if (s==dbname) 
	   {
	    p_databasecombobox->setCurrentItem(count);
	    slot_database_selected(count);
	    found=true;
	   }
	}
       ++count;
      }
   if (!form.isEmpty())
   {
   slot_viewmode_form(form);
   
   }
      
   }
   else
   {
     if (p_database)
     {//automatically start "Autoform" when --strongruntime is set
       if (p_database->form_exists(autoform.local8Bit().data()))
       slot_viewmode_form(autoform);
     }

   }
   slot_selection_changed();
  if (commandline)
  {
    if (commandline->form.size()>0)
      slot_viewmode_form(QString::fromLocal8Bit(commandline->form.c_str()));
  }
}	

knodamaindockwindow::~knodamaindockwindow()
{
}

void knodamaindockwindow::slot_childClosed(QWidget* w)
{
 cerr <<"slot_childClosed(QWidget* w)"<<endl;
 if (!w) 
 {
   cerr<<"knodamaindockwindow::slot_childClosed\nWARNING! w==NULL"<<endl;
   return;
 }
 KMdiChildView* v=dynamic_cast<KMdiChildView*>(w->parent());
 if (!v)
   {
    cerr <<"knodamaindockwindow::slot_childClosed\nWARNING! parent is not a KMdiChildView!"<<endl;
    return;
   }
 v->activate();
 closeWindow(v);
}
  
 void knodamaindockwindow::slot_childClosed(KMdiChildView* /*c*/)
 {
  cerr <<"knodamaindockwindow::slot_childClosed(KMdiChildView* c)"<<endl;
   
   
   
   
  cerr <<"knodamaindockwindow::slot_childClosed(KMdiChildView* c) ENDE"<<endl;
 }
  

  void knodamaindockwindow::slot_new_database(void)
  {
    if (!p_connection->server_supports(hk_connection::SUPPORTS_NEW_DATABASE)) 
        return;
        hk_string r=hk_kdenewdatabase::show_dialog(p_connection->server_supports(hk_connection::SUPPORTS_LOCAL_FILEFORMAT));
	r=trim(r);
        if (r.size()>0)
        {
            if (!p_connection->create_database(r))
	    {
	      show_warningmessage(hk_translate("Database could not be created"));
	    }
	    set_databases();
        }
  }
  
  void knodamaindockwindow::slot_delete_database(const QString& t)
  {
    if (!p_connection->server_supports(hk_connection::SUPPORTS_DELETE_DATABASE)) 
        return;
    if (p_database && p_database->name()==t.local8Bit().data()) 
        p_database=NULL;	
    if (p_connection->delete_database(t.local8Bit().data()))
    {
    set_databases();
    }
  }
  
  
  void knodamaindockwindow::slot_new_table(void)
  {
   hk_kdetablepartwidget* o=new_table();
   hk_datasource* d=p_database->new_table();
   if (o)
   {
   o->set_datasource(d);
   o->set_designmode();
   }
  }
  
  void knodamaindockwindow::slot_delete_table(const QString& t)
  {
   p_database->delete_table(t.local8Bit().data());

  }
  
  void knodamaindockwindow::slot_designmode_table(const QString& t)
  {
   
   hk_kdetablepartwidget* o=new_table();
   hk_datasource* d=p_database->new_table();
   if (d)d->set_name(t.local8Bit().data());
   if (o)
   {
   o->set_datasource(d);
   o->set_designmode();
   }
  }
 
  
  void knodamaindockwindow::slot_viewmode_table(const QString& t)
  {
   
   hk_kdetablepartwidget* o=new_table();
   hk_datasource* d=p_database->new_table();
   if (d)d->set_name(t.local8Bit().data());
   if (o)
   {
   o->set_datasource(d);
   o->set_viewmode();
   }
  }

  
  
  void knodamaindockwindow::slot_new_query(void)
  {
   hk_kdequerypartwidget* o=new_query(false);
   hk_datasource* d=p_database->new_resultquery();
   if (o)
   {
   o->set_datasource(d);
   o->set_designmode();
   }
  }
  
  void knodamaindockwindow::slot_delete_query(const QString& t)
  {
     p_database->delete_file(t.local8Bit().data(),ft_query);
  }
  
  void knodamaindockwindow::slot_designmode_query(const QString&t)
  {
   hk_kdequerypartwidget* o=new_query(false);
   hk_datasource* d=p_database->new_resultquery();
   if (d)d->set_name(t.local8Bit().data());
   if (o)
   {
   o->set_datasource(d);
   o->load_query();
   o->set_designmode();
   }
}
  void knodamaindockwindow::slot_viewmode_query(const QString&t)
  {
   hk_kdequerypartwidget* o=new_query(false);
   hk_datasource* d=p_database->new_resultquery();
   if (d)d->set_name(t.local8Bit().data());
   if (o)
   {
   o->set_datasource(d);
   o->load_query();
   o->set_viewmode();
   }
}

  
  
  
  
  
  
  
  
  
    void knodamaindockwindow::slot_new_view(void)
  {
   hk_kdequerypartwidget* o=new_query(true);
   hk_datasource* d=p_database->new_view();
   if (o)
   {
   o->set_datasource(d);
   o->set_designmode();
   }
  }
  
  
  void knodamaindockwindow::slot_delete_view(const QString& t)
  {
     p_database->delete_view(t.local8Bit().data());
  }
  
  
  void knodamaindockwindow::slot_designmode_view(const QString&t)
  {
   hk_kdequerypartwidget* o=new_query(true);
   hk_datasource* d=p_database->new_view();
   if (d)d->set_name(t.local8Bit().data());
   if (o)
   {
   o->set_datasource(d);
   o->set_use_qbe(false,false);
   o->set_designmode();
   }
}
  
  void knodamaindockwindow::slot_viewmode_view(const QString&t)
  {
   hk_kdequerypartwidget* o=new_query(true);
   hk_datasource* d=p_database->new_view();
   if (d)d->set_name(t.local8Bit().data());
   if (o)
   {
   o->set_datasource(d);
   o->set_use_qbe(false,false);
   o->set_viewmode();
   }
}


  
  
  
  
  
  
  
  
  
  
  
  
  void knodamaindockwindow::slot_new_form(void)
  {
    if (!p_database) return; 
    hk_kdeformpartwidget* w=new_form();
    if (w)
    {
    w->set_database(p_database);
    w->set_designmode();
    }
 }
  
  void knodamaindockwindow::slot_delete_form(const QString& t)
  {
      p_database->delete_file(t.local8Bit().data(),ft_form);
  }
  
  void knodamaindockwindow::slot_designmode_form(const QString& t)
 {
    if (!p_database) return; 
    hk_kdeformpartwidget* w=new_form();
    if (!w)return;
    w->set_database(p_database);
    w->load_form(t.local8Bit().data());
    w->set_designmode();
}
  void knodamaindockwindow::slot_viewmode_form(const QString& t)
 {
    if (!p_database) return; 
    hk_kdeformpartwidget* w=new_form();
    if (!w)return;
    w->set_database(p_database);
    w->load_form(t.local8Bit().data());
    w->set_viewmode();
}

  void knodamaindockwindow::slot_new_report(void)
  {
    if (!p_database) return; 
    hk_kdereportpartwidget* w=new_report();
    if (!w)return;
    w->set_database(p_database);
    w->set_designmode();
  }
  
  void knodamaindockwindow::slot_delete_report(const QString& t)
  {
      p_database->delete_file(t.local8Bit().data(),ft_report);

  }
  
  
  void knodamaindockwindow::slot_designmode_report(const QString&t)
  {
    if (!p_database) return; 
     hk_kdereportpartwidget* w=new_report();
    if (!w)return;
     w->set_database(p_database);
     w->load_report(t.local8Bit().data());
     w->set_designmode();
  
  }
  
  void knodamaindockwindow::slot_viewmode_report(const QString& t)
  {
     hk_kdereportpartwidget* w=new_report();
    if (!w)return;
     w->set_database(p_database);
     w->load_report(t.local8Bit().data());
     w->set_viewmode();

  }

  
  
  
  
  hk_kdetablepartwidget* knodamaindockwindow::new_table(void)
  {
  
   KMdiChildView* dock=new KMdiChildView(i18n("Table"),(mdiMode()==KMdi::ToplevelMode)?0L:this);
   (new QHBoxLayout(dock))->setAutoAdd(true);
    
    KLibFactory* p_factory= KLibLoader::self()->factory( "libhk_kdetablepart" );
    KParts::ReadWritePart* p_part=(KParts::ReadWritePart*) p_factory->create (dock, "hk_kdetablepart", "KParts::ReadWritePart");
    if (!p_part)
    {
     show_warningmessage(hk_translate("Fatal error! Table part could not be loaded!\nThis is a installation error. Check your installation!\
 Did you install knoda into the correct directory? Program will exit now...")); 
     exit(1);
    } 
     hk_kdetablepartwidget* table = (hk_kdetablepartwidget*)p_part->widget();
     if (!table) 
      {
        show_warningmessage(hk_translate("Warning! Tablepartwiget could not be created!"));
	return NULL;
      
      }
      KIconLoader* loader=KGlobal::iconLoader();
      loader->addAppDir("hk_kdeclasses");

     dock->setIcon(loader->loadIcon("view_text",KIcon::Small));
     p_partmanager->addPart(p_part);
   connect(table,SIGNAL(signal_closed(QWidget*))
          ,this,SLOT(slot_childClosed(QWidget*)));
   connect(dock,SIGNAL(childWindowCloseRequest(KMdiChildView*))
          ,this,SLOT(slot_childClosed(KMdiChildView*)));
   addWindow(dock);
   return table;
  
  }
  
  
  
  hk_kdequerypartwidget* knodamaindockwindow::new_query(bool as_view)
  {
   KMdiChildView* dock=new KMdiChildView(i18n("Query"),(mdiMode()==KMdi::ToplevelMode)?0L:this);
   (new QHBoxLayout(dock))->setAutoAdd(true);
    
    KLibFactory* p_factory= KLibLoader::self()->factory( "libhk_kdequerypart" );
    KParts::ReadWritePart* p_part=(KParts::ReadWritePart*) p_factory->create (dock, "hk_kdequerypart", "KParts::ReadWritePart");
    if (!p_part)
    {
     show_warningmessage(hk_translate("Fatal error! Query part could not be loaded!\nThis is a installation error. Check your installation!\
 Did you install knoda into the correct directory? Program will exit now...")); 
     exit(1);
    } 
     hk_kdequerypartwidget* query = (hk_kdequerypartwidget*)p_part->widget();
     if (!query) 
      {
        show_warningmessage(hk_translate("Warning! Querypartwiget could not be created!"));
	return NULL;
      
      }
      KIconLoader* loader=KGlobal::iconLoader();
      loader->addAppDir("hk_kdeclasses");

     dock->setIcon(loader->loadIcon(as_view?"mail_find":"filefind",KIcon::Small));
     p_partmanager->addPart(p_part);
   connect(query,SIGNAL(signal_closed(QWidget*))
          ,this,SLOT(slot_childClosed(QWidget*)));
   connect(dock,SIGNAL(childWindowCloseRequest(KMdiChildView*))
          ,this,SLOT(slot_childClosed(KMdiChildView*)));
   addWindow(dock);
   return query;
  }
  
  
    hk_kdeformpartwidget* knodamaindockwindow::new_form(void)
  {
   KMdiChildView* dock=new KMdiChildView(i18n("Form"),(mdiMode()==KMdi::ToplevelMode)?0L:this);
   (new QHBoxLayout(dock))->setAutoAdd(true);
    
    KLibFactory* p_factory= KLibLoader::self()->factory( "libhk_kdeformpart" );
    KParts::ReadWritePart* p_part=(KParts::ReadWritePart*) p_factory->create (dock, "hk_kdeformpart", "KParts::ReadWritePart");
    if (!p_part)
    {
     show_warningmessage(hk_translate("Fatal error! Form part could not be loaded!\nThis is a installation error. Check your installation!\
 Did you install knoda into the correct directory? Program will exit now...")); 
     exit(1);
    } 
     hk_kdeformpartwidget* form = (hk_kdeformpartwidget*)p_part->widget();
     if (!form) 
      {
        show_warningmessage(hk_translate("Warning! Formpartwiget could not be created!"));
	return NULL;
      
      }
      KIconLoader* loader=KGlobal::iconLoader();
      loader->addAppDir("hk_kdeclasses");

     dock->setIcon(loader->loadIcon("openterm",KIcon::Small));
     p_partmanager->addPart(p_part);
   connect(form,SIGNAL(signal_closed(QWidget*))
          ,this,SLOT(slot_childClosed(QWidget*)));
   connect(dock,SIGNAL(childWindowCloseRequest(KMdiChildView*))
          ,this,SLOT(slot_childClosed(KMdiChildView*)));
   addWindow(dock);
   return form;
  }
  
  hk_kdereportpartwidget* knodamaindockwindow::new_report(void)
  {
   KMdiChildView* dock=new KMdiChildView(i18n("Report"),(mdiMode()==KMdi::ToplevelMode)?0L:this);
   (new QHBoxLayout(dock))->setAutoAdd(true);
    
    KLibFactory* p_factory= KLibLoader::self()->factory( "libhk_kdereportpart" );
    KParts::ReadWritePart* p_part=(KParts::ReadWritePart*) p_factory->create (dock, "hk_kdereportpart", "KParts::ReadWritePart");
    if (!p_part)
    {
     show_warningmessage(hk_translate("Fatal error! Report part could not be loaded!\nThis is a installation error. Check your installation!\
 Did you install knoda into the correct directory? Program will exit now...")); 
     exit(1);
    } 
     hk_kdereportpartwidget* report = (hk_kdereportpartwidget*)p_part->widget();
     if (!report) 
      {
        show_warningmessage(hk_translate("Warning! Reportpartwiget could not be created!"));
	return NULL;
      
      }
      KIconLoader* loader=KGlobal::iconLoader();
      loader->addAppDir("hk_kdeclasses");

     dock->setIcon(loader->loadIcon("fileprint",KIcon::Small));
     p_partmanager->addPart(p_part);
   connect(report,SIGNAL(signal_closed(QWidget*))
          ,this,SLOT(slot_childClosed(QWidget*)));
   connect(dock,SIGNAL(childWindowCloseRequest(KMdiChildView*))
          ,this,SLOT(slot_childClosed(KMdiChildView*)));
   addWindow(dock);
   return report;
  }
  

void knodamaindockwindow::rename_clicked()
{
if (!p_listview) return;
if (!p_listview->currentItem()||p_listview->is_headeritem())
return;



hk_string newname=trim(show_stringvaluedialog(hk_translate("Enter new name:")));
if (newname.size()==0) return;
    filetype f;
    if (p_listview->is_tableitem())
       f=ft_table;
    else
    if (p_listview->is_queryitem())
       f=ft_query;
    else
    if (p_listview->is_formitem())
       f=ft_form;
    else
       f=ft_report;


    if (!p_database->rename_file(p_listview->currentItem()->text(0).local8Bit().data()
    ,newname,f))
    show_warningmessage(hk_translate("Could not rename object!"));
    
}

void knodamaindockwindow::importcsv_clicked()
{
    if (p_database==NULL) return;
    hk_kdecsvimportdialog* i= new hk_kdecsvimportdialog(0,0,true);
    hk_datasource* ds=p_database->new_table();
//   ds->wanna_debug(true);
    i->set_datasource(ds);
    i->exec();
    delete i;
}

void knodamaindockwindow::exportcsv_clicked()
{
    if (p_database==NULL||!p_listview) return;
    hk_kdecsvexportdialog* e =new hk_kdecsvexportdialog(p_listview->currentItem()->text(0),0,0,true);
    e->set_database(p_database);
    if (p_listview->is_viewitem())e->set_useviewlist();
    else
    if (p_listview->is_queryitem())e->set_usequerylist();
    else
    e->set_usetablelist();
    e->exec();
    delete e;
}

void knodamaindockwindow::exportxml_clicked()
{
    if (p_database==NULL||!p_listview) return;
hk_kdexmlexportdialog* e =new hk_kdexmlexportdialog(p_listview->currentItem()->text(0),0,0,true);
    e->set_database(p_database);
    if (p_listview->is_viewitem())e->set_useviewlist();
    else
    if (p_listview->is_queryitem())e->set_usequerylist();
    else
    e->set_usetablelist();
    e->exec();
    delete e;
}

void knodamaindockwindow::newpassworddialog_selected(void)
{
    if (p_connection!=NULL) p_connection->show_newpassworddialog();
}

void knodamaindockwindow::copy_clicked(void)
{
if (p_listview)p_listview->copy();
}

void knodamaindockwindow::paste_clicked(void)
{
if (p_listview)p_listview->paste();
}

void knodamaindockwindow::clipboarddata_has_changed(void)
{
 p_copyaction->setEnabled(p_connection&&p_listview&&(!p_listview->is_headeritem()
                        ||p_listview->is_databaseitem()));
 p_pasteaction->setEnabled(hk_dbviewerdrag::canDecode(QApplication::clipboard()->data(QClipboard::Clipboard)));
}

void knodamaindockwindow::slot_selection_changed(void)
{  
 if (!p_connection) return;
 p_newaction->setEnabled(!runtime_only()
 && p_database&& p_database->name().size()>0&&p_listview && (p_listview->is_databaseitem()&&p_connection->server_supports(hk_connection::SUPPORTS_NEW_DATABASE)
 ||p_listview->is_tableitem(true)&&p_connection->server_supports(hk_connection::SUPPORTS_NEW_TABLE) ||p_listview->is_viewitem(true)&&p_connection->server_supports(hk_connection::SUPPORTS_NEW_VIEW) 
 ||p_listview->is_queryitem(true)||p_listview->is_formitem(true)||p_listview->is_reportitem(true)
 ));
 if (newbutton)newbutton->setEnabled(p_newaction->isEnabled());
 bool e=!runtime_only() && p_database&& p_database->name().size()>0;
 p_newdatabaseaction->setEnabled(!runtime_only()&&p_connection->server_supports(hk_connection::SUPPORTS_NEW_DATABASE));
 p_newtableaction->setEnabled(e&&p_connection->server_supports(hk_connection::SUPPORTS_NEW_TABLE));
 p_newqueryaction->setEnabled(e);
 p_newviewaction->setEnabled(e&&p_connection->server_supports(hk_connection::SUPPORTS_NEW_VIEW));
 p_newformaction->setEnabled(e);
 p_newreportaction->setEnabled(e);

 p_alteraction->setEnabled(p_listview&&!p_listview->is_headeritem() &&!runtime_only()); 
 if (alterbutton)alterbutton->setEnabled(p_alteraction->isEnabled());
 p_startaction->setEnabled(p_listview &&!p_listview->is_headeritem());
 if (startbutton)startbutton->setEnabled(p_startaction->isEnabled());
p_deleteaction->setEnabled(p_listview &&(!p_listview->is_headeritem()
 			    || p_listview->is_databaseitem()
 		           ) &&!runtime_only()&&p_database&& p_database->name().size()>0
			   );
 if (deletebutton) deletebutton->setEnabled(p_deleteaction->isEnabled());
 p_renameaction->setEnabled(
    p_listview &&(p_listview->is_databaseitem() && p_connection->server_supports(hk_connection::SUPPORTS_RENAME_DATABASE)
    ||p_listview->is_tableitem() && p_connection->server_supports(hk_connection::SUPPORTS_RENAME_TABLE)
    ||(p_listview->is_queryitem()||p_listview->is_formitem() ||p_listview->is_reportitem() 
    )&&!runtime_only()
    
    )
 );
 p_exportaction->setEnabled(p_listview &&(p_listview->is_tableitem()
 					||p_listview->is_queryitem()
					||p_listview->is_viewitem()));
 p_exportcsvaction->setEnabled(p_listview &&(p_listview->is_tableitem()||p_listview->is_queryitem()||p_listview->is_viewitem()));
 p_exportxmlaction->setEnabled(p_listview &&(p_listview->is_tableitem()||p_listview->is_queryitem()||p_listview->is_viewitem()));
 p_importaction->setEnabled(!runtime_only());
 p_importcsvaction->setEnabled(!runtime_only());
 p_databasesettingaction->setEnabled(p_database&&!runtime_only());
 p_passwordaction->setEnabled(p_listview &&(p_listview->database()!=NULL));
 clipboarddata_has_changed();
}

void knodamaindockwindow::slot_listbox_popup(QListViewItem* item,const QPoint&point)
{
 if (!item) return;
QPopupMenu * popup=(QPopupMenu *) factory()->container("popup", this);
    if (popup)
        popup->exec( point );


}

void knodamaindockwindow::databasesettings_clicked(void)
{
hk_kdedatabasesetting* setting=new hk_kdedatabasesetting(p_database);
 if (setting->exec()==QDialog::Accepted) 
    {
      if (p_listview)p_listview->reload_lists();
    }
 p_objecthandleraction->setEnabled(p_database&& p_database->has_centralstoragetable()&&!runtime_only());
delete setting;
}

void knodamaindockwindow::objecthandler_clicked(void) 
{
  hk_kdeobjecthandler* h=new hk_kdeobjecthandler(p_database);
  h->exec();
 
  delete h;
}


void knodamaindockwindow::newwindow_clicked(void)
{
  knodamaindockwindow* w=new knodamaindockwindow();
  w->show();
}



void knodamaindockwindow::show_drivers()
{
  KPopupMenu* menu= p_newconnectionaction->popupMenu();
  menu->clear();
    vector<hk_string>* drv=hk_drivermanager::driverlist();
    vector<hk_string>::iterator it;
    int di=0;
    for(it=drv->begin();it!=drv->end();it++)
    {
        menu->insertItem(QString::fromLocal8Bit((*it).c_str()),this,SLOT(driver_selected(int)),0,di);
        di++;
    }


}



void knodamaindockwindow::settings_clicked()
{
    hk_kdepreferencesdialog* p_dialog= new hk_kdepreferencesdialog(0,0,true);
    p_dialog->timefield->setText(QString::fromLocal8Bit(hk_class::defaulttimeformat().c_str())),
    p_dialog->datefield->setText(QString::fromLocal8Bit(hk_class::defaultdateformat().c_str())),
    p_dialog->datetimefield->setText(QString::fromLocal8Bit(hk_class::defaultdatetimeformat().c_str()));
    p_dialog->localefield->setText(QString::fromLocal8Bit(hk_class::locale().c_str()));
    p_dialog->printcommandfield->setText(QString::fromLocal8Bit(hk_report::printcommand().c_str()));
    p_dialog->driverpathfield->setText(QString::fromLocal8Bit(hk_drivermanager::path().c_str()));
    p_dialog->bepedanticfield->setCurrentItem(hk_class::showpedantic()?0:1);
    p_dialog->maximizedfield->setCurrentItem(hk_visible::open_maximized_windows()?0:1);
    p_dialog->fontfield->setEditText(QString::fromLocal8Bit(hk_font::defaultfontname().c_str()));
    p_dialog->fontsizefield->setValue(hk_font::defaultfontsize());
    p_dialog->precisionfield->setValue(hk_dsdatavisible::defaultprecision());
    p_dialog->separatorfield->setCurrentItem(hk_dsdatavisible::defaultuse_numberseparator()?0:1);
    p_dialog->sizetypefield->setCurrentItem(hk_presentation::defaultsizetype()==hk_presentation::relative?0:1);
    p_dialog->measurefield->setCurrentItem(hk_class::measuresystem()==hk_class::cm?0:1);
    p_dialog->snap2gridxfield->setValue(hk_presentation::snap2gridx());
    p_dialog->snap2gridyfield->setValue(hk_presentation::snap2gridy());
    vector<hk_string>* drv=hk_drivermanager::driverlist();
    vector<hk_string>::iterator it;
    int di=0;
    for(it=drv->begin();it!=drv->end();it++)
    {
        p_dialog->defaultdriverfield->insertItem(QString::fromLocal8Bit((*it).c_str()));
        if ((*it)==hk_class::defaultdriver())
            p_dialog->defaultdriverfield->setCurrentItem(di);
        di++;
    }

    list<hk_string>* encodelist =hk_report::fontencodinglist();
    p_dialog->encodingfield->clear();
    list<hk_string>::iterator eit=encodelist->begin();
    int i=0;
    while (eit!=encodelist->end())
    {
        p_dialog->encodingfield->insertItem(QString::fromLocal8Bit((*eit).c_str()));
        if ((*eit)==hk_report::fontencodingstring()) p_dialog->encodingfield->setCurrentItem(i);
        eit++;
        i++;
    }

    switch (hk_visible::defaulttextalignment())
    {
        case hk_visible::aligncenter: i=1;break;
        case hk_visible::alignright: i=2;break;
        default: i=0;
    }
    p_dialog->textalignmentfield->setCurrentItem(i);

    switch (hk_visible::defaultnumberalignment())
    {
        case hk_visible::aligncenter: i=1;break;
        case hk_visible::alignright: i=2;break;
        default: i=0;
    }
    p_dialog->numberalignmentfield->setCurrentItem(i);

    int res=p_dialog->exec();

    if (res==QDialog::Accepted)
    {
        hk_class::set_defaultdatetimeformat(
            p_dialog->timefield->text().local8Bit().data(),
            p_dialog->datefield->text().local8Bit().data(),
            p_dialog->datetimefield->text().local8Bit().data()
            );
	 hk_class::set_locale(p_dialog->localefield->text().local8Bit().data());
        hk_class::set_showpedantic( p_dialog->bepedanticfield->currentItem()==0);
        hk_visible::set_open_maximized_windows(p_dialog->maximizedfield->currentItem()==0);
        hk_report::set_fontencoding(p_dialog->encodingfield->currentText().local8Bit().data());
        hk_report::set_printcommand(p_dialog->printcommandfield->text().local8Bit().data());
        hk_drivermanager::set_path(p_dialog->driverpathfield->text().local8Bit().data());
        hk_font::set_defaultfont(p_dialog->fontfield->currentText().local8Bit().data(),p_dialog->fontsizefield->value());
	hk_presentation::set_snap2gridx(p_dialog->snap2gridxfield->value());
	hk_presentation::set_snap2gridy(p_dialog->snap2gridyfield->value());
        hk_visible::alignmenttype a=hk_visible::alignleft;
        switch (p_dialog->textalignmentfield->currentItem())
        {
            case 1: a=hk_visible::aligncenter;break;
            case 2: a=hk_visible::alignright;break;
            default:;
        }
        hk_visible::set_defaulttextalignment(a);
    hk_presentation::set_defaultsizetype(p_dialog->sizetypefield->currentItem()==0?hk_presentation::relative:hk_presentation::absolute);
    hk_class::set_measuresystem(p_dialog->measurefield->currentItem()==0?hk_class::cm:hk_class::inch);

        a=hk_visible::alignleft;
        switch (p_dialog->numberalignmentfield->currentItem())
        {
            case 1: a=hk_visible::aligncenter;break;
            case 2: a=hk_visible::alignright;break;
            default:;
        }
        hk_visible::set_defaultnumberalignment(a);
        hk_dsdatavisible::set_defaultnumberformat(p_dialog->separatorfield->currentItem()==0,p_dialog->precisionfield->value());
        hk_class::set_defaultdriver(p_dialog->defaultdriverfield->currentText().local8Bit().data());

        hk_class::save_preferences();
        
    }

    delete p_dialog;

}


void knodamaindockwindow::setCaption(const QString& c)
{
  
  if (p_connection)
    {
        hk_string s=p_connection->drivername()+" "+p_connection->user()+"@"+p_connection->host()+":"+ulongint2string(p_connection->tcp_port());
        knodamaindockwindowbase::setCaption(QString::fromLocal8Bit(s.c_str()));
  
    }
    else knodamaindockwindowbase::setCaption(c);

  

}


