// ****************************************************************************
// copyright (c) 2000-2004 Horst Knorr <hk_classes@knoda.org>  
// This file is part of the hk_classes library.
// This file may be distributed and/or modified under the terms of the
// GNU Library Public License version 2 as published by the Free Software
// Foundation and appearing in the file COPYING included in the
// packaging of this file.
// This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
// ****************************************************************************
#include "hk_kdeform.h"
#include "hk_kdequery.h"
#include "hk_kdetable.h"
#include "hk_kdereport.h"
#include "hk_kdesimplereport.h"
#include "hk_kdesimpleform.h"
#include "hk_kdeform.h"
#include "hk_kdeproperty.h"
#include "hk_kdebutton.h"

#include <hk_database.h>
#include <hk_report.h>
#include <hk_presentation.h>
#include <hk_interpreter.h>

#include <kmdichildview.h>

#include <qwidget.h>
#include <qapplication.h>

#include <X11/X.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>

hk_kdebutton::hk_kdebutton(QWidget* wid,hk_form* form)
:QPushButton(wid),
hk_button(form)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdebutton::hk_kdebutton");
#endif

    QColor qcolor=paletteBackgroundColor();
    hk_colour colour(qcolor.red(),qcolor.green(),qcolor.red());
    set_backgroundcolour(colour,false,true);
    qcolor=paletteForegroundColor();
    colour.set_colour(qcolor.red(),qcolor.green(),qcolor.red());
    set_foregroundcolour(colour,false,true);

    QObject::connect(this,SIGNAL(clicked()),this,SLOT(button_clicked()));
}


hk_kdebutton::~hk_kdebutton()
{
#ifdef HK_DEBUG
    hkdebug("hk_kdebutton::~hk_kdebutton");
#endif

}


bool hk_kdebutton::widget_specific_coordinates(uint px,uint py,uint pwidth,uint pheight)
{
    blockSignals(true);
    setGeometry(px,py,pwidth,pheight);
    blockSignals(false);
    return true;
}


bool hk_kdebutton::widget_specific_open_form(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdebutton::widget_specific_open_form");
#endif
    hk_kdeform* w=find_existing_form();
    if (w)
    {
    
      KMdiChildView* view= dynamic_cast<KMdiChildView*>(w->parent());
      if (view)
        {
	 view->activate();
         return true; 
	} 
    }
    
    
    if (w==NULL)                                  // not open yet
    {
         if (p_presentation!=NULL)w=((hk_kdesimpleform*)p_presentation->database()->new_formvisible())->kdeform();
        if (p_presentation!=NULL)w->set_database(p_presentation->database());
        else w->set_database(database());
        w->load_form(object());
        w->set_viewmode();
    }
    else
    {
      w->hide();
    }
        if (show_maximized())w->showMaximized();
        else w->show();
    return true;
}


bool hk_kdebutton::widget_specific_close_form(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdebutton::widget_specific_close_form");
#endif
   if (object().size()==0)
   {
      QWidget* w=parentWidget();
      if (w) // first check if the parent is hk_kdeform and then close it
      {
	QWidget* p=w;

     while (p)
     {
	hk_kdeform* f=dynamic_cast<hk_kdeform*>(p);
	p=p->parentWidget();
		if (f)
		{
		f->close();
		return true;
		}

     }

      }
      if (w)
      {
       w->close();
      return true;
      }
      else return false;
   }

    hk_kdeform* w=find_existing_form();

    if (w==NULL) return false;

    w->close();
    return true;
}


void hk_kdebutton::button_clicked(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdebutton::button_clicked");
#endif

   push_action();

}


void    hk_kdebutton::widget_specific_label_changed(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdebutton::widget_specific_label_changed");
#endif
    setText(QString::fromLocal8Bit (label().c_str()));
}


void hk_kdebutton::resizeEvent ( QResizeEvent * event )
{
#ifdef HK_DEBUG
    hkdebug("hk_kdebutton::resizeEvent");
#endif
    QPushButton::resizeEvent(event);
    reposition();

}


void  hk_kdebutton::moveEvent ( QMoveEvent * event)
{
#ifdef HK_DEBUG
    hkdebug("kdebutton::resizeEvent");
#endif
    QPushButton::moveEvent(event);
    reposition();
}


void hk_kdebutton::reposition(void)
{
#ifdef HK_DEBUG
    hkdebug("kdebutton::reposition");
#endif
    if (p_presentation==NULL ||p_setcoordinates==true) return;
    p_setwidgetcoordinates=true;
    unsigned int ppx=p_presentation->sizetype()==hk_presentation::relative?p_presentation->horizontal2relativ(QWidget::x()):QWidget::x();
    unsigned int ppy=p_presentation->sizetype()==hk_presentation::relative?p_presentation->vertical2relativ(QWidget::y()):QWidget::y();
    unsigned int pph=p_presentation->sizetype()==hk_presentation::relative?p_presentation->vertical2relativ(QWidget::height()):QWidget::height();
    unsigned int ppw=p_presentation->sizetype()==hk_presentation::relative?p_presentation->horizontal2relativ(QWidget::width()):QWidget::width();
    set_size(ppx,ppy,ppw,pph);
    p_setwidgetcoordinates=false;
}


void hk_kdebutton::widget_specific_font_changed(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdebutton::widget_specific_font_changed");
#endif
    setFont(QFont(QString::fromLocal8Bit (hk_button::font().fontname().c_str())
                  ,hk_button::font().fontsize(),hk_button::font().bold()?QFont::Bold:QFont::Normal,
		   hk_button::font().italic()));
}


hk_kdeform* hk_kdebutton::find_existing_form(void)
{
    hk_kdeform* w = NULL;
    if (p_presentation->database()!=NULL)         // is the form already open?
    {
        QWidget* sf=dynamic_cast<QWidget*>
            (p_presentation->database()->existing_presentation(object(),hk_presentation::form));
        while (sf!=NULL && w==NULL)
        {
            sf=sf->parentWidget();
            w= dynamic_cast <hk_kdeform*> (sf);
        }
    }
    return w;
}


hk_kdereport* hk_kdebutton::find_existing_report(void)
{
    hk_kdereport* w = NULL;
    if (p_presentation->database()!=NULL)         // is the form already open?
    {
        QWidget* sf=dynamic_cast<QWidget*>
            (p_presentation->database()->existing_presentation(object(),hk_presentation::report));
	    cerr <<"sf="<<sf<<endl;
        while (sf!=NULL && w==NULL)
        {
            sf=sf->parentWidget();
            w= dynamic_cast <hk_kdereport*> (sf);
        }
    }cerr <<"w="<<w<<endl;
    return w;
}


bool hk_kdebutton::widget_specific_open_table(void)
{
    if (p_presentation==NULL) return false;
    if (p_presentation->database()!=NULL)
    {
        hk_kdetable* w=((hk_kdetable*)p_presentation->database()->new_tablevisible());
        hk_datasource* d=p_presentation->database()->new_table(object());
        w->set_datasource(d);
        if (show_maximized())w->showMaximized();
        else w->show();
        w->set_viewmode();
    }
    return true;
}


bool hk_kdebutton::widget_specific_open_query(void)
{
    if (p_presentation==NULL) return false;
    if (p_presentation->database()!=NULL)
    {
        hk_kdequery* w=((hk_kdequery*)p_presentation->database()->new_queryvisible());
        hk_datasource* d=p_presentation->database()->new_resultquery();
        d->set_name(object());
        w->set_datasource(d);
        w->load_query();
        if (show_maximized())w->showMaximized();
        else w->show();
        w->set_viewmode();
    }
    return true;
}


bool    hk_kdebutton::widget_specific_preview_report(void)
{
    hk_kdereport* w=find_existing_report();
    if (w)
    {
    
      KMdiChildView* view= dynamic_cast<KMdiChildView*>(w->parent());
      if (view)
        {
	 view->activate();
        w->set_designmode();
        hk_string c=parsed_condition();
        if (c.size()>0&&w->simplereport()->datasource())
        {
            w->simplereport()->datasource()->set_internalfilter(c);
            w->simplereport()->datasource()->set_use_internalfilter(true);
        }
        w->set_viewmode();
         return true; 
	} 
    }
    

    if (w==NULL)                                  // not open yet
    {
        w=((hk_kdesimplereport*)p_presentation->database()->new_reportvisible())->kdereport();
        if (!w)
	{
              show_warningmessage("w==NULL!");
	      return false;
	}
        if (p_presentation!=NULL)w->set_database(p_presentation->database());
        else w->set_database(database());
        w->load_report(object());
        hk_string c=parsed_condition();
        if (c.size()>0&&w->simplereport()->datasource())
        {
            w->simplereport()->datasource()->set_internalfilter(c);
            w->simplereport()->datasource()->set_use_internalfilter(true);
        }
        w->set_viewmode();
    }
    else
    {
        w->hide();
    }
        if (show_maximized())w->showMaximized();
        else w->show();
    return true;
}


void    hk_kdebutton::widget_specific_backgroundcolour_changed(const hk_colour&)
{
    hk_colour c=backgroundcolour();
    QColor newcolour(c.red(),c.green(),c.blue());
    setPaletteBackgroundColor(newcolour);

}


void    hk_kdebutton::widget_specific_foregroundcolour_changed(const hk_colour& )
{
    hk_colour c=foregroundcolour();
    QColor newcolour(c.red(),c.green(),c.blue());
    setPaletteForegroundColor(newcolour);

}




void  hk_kdebutton::mouseDoubleClickEvent(QMouseEvent* event)
{
   QPushButton::mouseDoubleClickEvent(event);
   if (p_presentation && p_presentation->mode()==hk_presentation::viewmode
       && event->button()== LeftButton)
           action_on_doubleclick();
}


