// ****************************************************************************
// copyright (c) 2000-2004 Horst Knorr <hk_classes@knoda.org>  
// This file is part of the hk_kdeclasses library.
// This file may be distributed and/or modified under the terms of the
// GNU Library Public License version 2 as published by the Free Software
// Foundation and appearing in the file LGPL included in the
// packaging of this file.
// This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
// ****************************************************************************
//$Revision: 1.12 $
#include "hk_kdedblistview.h"
#include <klocale.h>
#include <kapplication.h>
#include <kstandarddirs.h>
#include <kglobalsettings.h>
#include <kiconloader.h>
#include <qprogressdialog.h>
#include <qpushbutton.h>
#include <qradiobutton.h>
#include <qlayout.h>
#include <qvariant.h>
#include <qtooltip.h>
#include <qwhatsthis.h>
#include <qbuttongroup.h>
#include <qlabel.h>
#include <qclipboard.h>
#include <hk_database.h>
#include <hk_connection.h>
#include <hk_drivermanager.h>

bool hk_kdedblistview::p_cancelcopying=false;
QProgressDialog* hk_kdedblistview::p_progressdialog=NULL;




 
hk_dbviewerdrag::hk_dbviewerdrag(objecttype type,const QString& object,hk_database* db,QWidget* dragsource)
   :QStoredDrag("application/x-hk_filecopy",dragsource)
{
  create_draginfo(type,object,db);
}
bool hk_dbviewerdrag::canDecode(const QMimeSource* s)
    {
    const char* f;
    for (int i=0; (f=s->format(i)); i++) 
    {   
	if ( 0==qstrnicmp(f,"application/x-hk_filecopy",25) ) 
	{
	    return true;
	}
    }
    return FALSE;
}

const char* hk_dbviewerdrag::format(int i) const
{
  if (i==0) return "application/x-hk_filecopy";
  --i;
  return QStoredDrag::format(i);

}


void hk_dbviewerdrag::create_draginfo(objecttype type,const QString& object,hk_database* db)
{
    hk_string mystring="<NAME>";
    mystring+=object.local8Bit().data();
    mystring+="</NAME>\n<TYPE>";
    switch (type)
    {
      case ot_database:mystring+="DATABASE";break;
      case ot_table:mystring+="TABLE";break;
      case ot_query:mystring+="QUERY";break;
      case ot_form:mystring+="FORM";break;
      case ot_report:mystring+="REPORT";break;
    }
    mystring+="</TYPE>\n<DIRECTORY>";
    mystring+=db->database_path()+"/</DIRECTORY>\n<SERVER>";
    mystring+=db->connection()->drivername()+"</SERVER>\n<HOST>";
    mystring+=db->connection()->host()+"</HOST>\n<TCP>";
    mystring+=longint2string(db->connection()->tcp_port())+"</TCP>\n<USER>";
    mystring+=db->connection()->user()+"</USER>\n<DBNAME>";
    mystring+=db->name()+"</DBNAME>";
    setEncodedData((QCString)(mystring.c_str()));

}



// hk_dbviewerdrag END 





hk_kdeschemadialog::hk_kdeschemadialog( QWidget* parent,  const char* name, bool modal, WFlags fl )
: QDialog( parent, name, modal, fl )
{
    if ( !name )
        setName( "hk_kdeschemadialog" );
    resize( 253, 100 );
    setCaption( i18n( "Please select" ) );
    setSizeGripEnabled( TRUE );
    hk_kdeschemadialogLayout = new QHBoxLayout( this, 11, 6, "hk_kdeschemadialogLayout");

    ButtonGroup1 = new QButtonGroup( this, "ButtonGroup1" );
    ButtonGroup1->setColumnLayout(0, Qt::Vertical );
    ButtonGroup1->layout()->setSpacing( 6 );
    ButtonGroup1->layout()->setMargin( 11 );
    ButtonGroup1Layout = new QVBoxLayout( ButtonGroup1->layout() );
    ButtonGroup1Layout->setAlignment( Qt::AlignTop );

    schemaonlyfield = new QRadioButton( ButtonGroup1, "schemaonlyfield" );
    schemaonlyfield->setChecked( TRUE );
    ButtonGroup1Layout->addWidget( schemaonlyfield );

    datafield = new QRadioButton( ButtonGroup1, "datafield" );
    ButtonGroup1Layout->addWidget( datafield );
    hk_kdeschemadialogLayout->addWidget( ButtonGroup1 );

    Layout2 = new QVBoxLayout( 0, 0, 6, "Layout2");

    buttonOk = new QPushButton( this, "buttonOk" );
    buttonOk->setText( i18n( "&OK" ) );
    buttonOk->setAccel( 0 );
    buttonOk->setAutoDefault( TRUE );
    buttonOk->setDefault( TRUE );
    Layout2->addWidget( buttonOk );

    buttonCancel = new QPushButton( this, "buttonCancel" );
    buttonCancel->setText( i18n( "&Cancel" ) );
    buttonCancel->setAccel( 0 );
    buttonCancel->setAutoDefault( TRUE );
    Layout2->addWidget( buttonCancel );
    QSpacerItem* spacer = new QSpacerItem( 20, 20, QSizePolicy::Minimum, QSizePolicy::Expanding );
    Layout2->addItem( spacer );
    hk_kdeschemadialogLayout->addLayout( Layout2 );

// signals and slots connections
    connect( buttonOk, SIGNAL( clicked() ), this, SLOT( accept() ) );
    connect( buttonCancel, SIGNAL( clicked() ), this, SLOT( reject() ) );
}


hk_kdeschemadialog::~hk_kdeschemadialog()
{
}





class hk_kdedblistviewprivate
{
public:
hk_kdedblistviewprivate()
	{
	p_databaseitem=NULL;
	p_tableitem=NULL;
	p_queryitem=NULL;
	p_formitem=NULL;
	p_reportitem=NULL;
	p_schemadialog=NULL;
	p_dragging=false;
	p_showmode=hk_kdedblistview::sm_all;
	}
KListViewItem* p_databaseitem;
KListViewItem* p_tableitem;
KListViewItem* p_queryitem;
KListViewItem* p_formitem;
KListViewItem* p_reportitem;
hk_kdeschemadialog* p_schemadialog;
hk_kdedblistview::enum_showmode p_showmode;
void clearList(KListViewItem*);      
bool p_dragging;
objecttype otype;

QPoint p_dragstartposition;
                                                  //decoded drag&dropvalues
hk_string xname,xtype,xdirectory,xserver,xhost,xtcp,xuser,xdbname;
};


void hk_kdedblistviewprivate::clearList(KListViewItem* item)
{
QListViewItem * child = item->firstChild();
        while( child )
	 {
	    delete child;
	    child=item->firstChild();
         }
}


hk_kdedblistview::hk_kdedblistview (QWidget* parent, const char* name):
KListView(parent,name), hk_dbvisible()
{
  p_private=new hk_kdedblistviewprivate;
    p_private->p_schemadialog= new hk_kdeschemadialog();
    p_private->p_schemadialog->schemaonlyfield->setText(i18n("&Schema only"));
    p_private->p_schemadialog->datafield->setText(i18n("Schema and &data"));

  addColumn(i18n("Active database:"),500);
  setRootIsDecorated(true);
  init_listview();
  connect(this, SIGNAL(executed(QListViewItem*)),this,SLOT(item_clicked(QListViewItem*)));
  connect(this, SIGNAL(doubleClicked(QListViewItem*,const QPoint&,int)),this,SLOT(item_doubleclicked(QListViewItem*)));
  connect(this, SIGNAL(dropped(QDropEvent*,QListViewItem*)),this,SLOT(slot_drop(QDropEvent*)));
  setAcceptDrops(true);
  setDragEnabled(true);


}




hk_kdedblistview::~hk_kdedblistview()
{
 delete p_private->p_schemadialog;
 delete p_private;

}


void hk_kdedblistview::init_listview()
{
  KIconLoader* loader=KGlobal::iconLoader();
  loader->addAppDir("hk_kdeclasses");
  clear();
  setSortColumn(-1);
  p_private->p_databaseitem=new KListViewItem(this,i18n("<No database>"));
  p_private->p_databaseitem->setPixmap(0,loader->loadIcon("contents",KIcon::Small));
  
  p_private->p_reportitem=new KListViewItem(p_private->p_databaseitem,i18n("Reports"));
  p_private->p_reportitem->setPixmap(0,loader->loadIcon("fileprint",KIcon::Small));
  
  p_private->p_formitem=new KListViewItem(p_private->p_databaseitem,i18n("Forms"));
  p_private->p_formitem->setPixmap(0,loader->loadIcon("openterm",KIcon::Small));

  p_private->p_queryitem=new KListViewItem(p_private->p_databaseitem,i18n("Queries"));
  p_private->p_queryitem->setPixmap(0,loader->loadIcon("filefind",KIcon::Small));
  
  if (p_private->p_showmode==hk_kdedblistview::sm_all)
  {
  p_private->p_tableitem=new KListViewItem(p_private->p_databaseitem,i18n("Tables"));
  p_private->p_tableitem->setPixmap(0,loader->loadIcon("viewtext",KIcon::Small));
  } 
  else p_private->p_tableitem=NULL;
  p_private->p_databaseitem->setOpen(true);
}




objecttype hk_kdedblistview::current_objecttype()
{
   if (is_databaseitem(currentItem())) return ot_database;
    else
    if (is_tableitem(currentItem())) return ot_table;
        else
        if (is_queryitem(currentItem())) return ot_query;
            else
            if (is_formitem(currentItem())) return ot_form;
                else return ot_report;
 
}



void hk_kdedblistview::set_database(hk_database* db)
{
  hk_dbvisible::set_database(db);
  set_databasename();
  


}




void hk_kdedblistview::set_databasename(void)
{
if (p_database && p_database->name().size()>0) 
    p_private->p_databaseitem->setText(0,QString::fromLocal8Bit(p_database->name().c_str()));
    else
    p_private->p_databaseitem->setText(0,i18n("<No database>"));
set_tables();
set_queries();
set_forms();
set_reports();
}

void hk_kdedblistview::set_tables(void)
{
  
  if (!p_database||p_private->p_showmode!=hk_kdedblistview::sm_all) return;
  p_private->clearList(p_private->p_tableitem);
  vector<hk_string>* tb=p_database->tablelist();
  vector<hk_string>::reverse_iterator it;
  if (tb!=NULL)
  {
      for(it=tb->rbegin();it!=tb->rend();it++)
       new KListViewItem(p_private->p_tableitem,QString::fromLocal8Bit((*it).c_str()));
  }
  p_private->p_tableitem->sortChildItems(0,true);
}


void hk_kdedblistview::set_queries(void)
{
  QString text=i18n("Queries");
  if (p_database&& 
      ((p_database->loadmode(ft_query)==hk_database::central && p_private->p_showmode==sm_all)
      ||(p_private->p_showmode==sm_central)
      )  
     )
     text+=i18n(" (Central)");
  p_private->p_queryitem->setText(0,text);

  p_private->clearList(p_private->p_queryitem);
  if (!p_database) return;
  vector<hk_string>* tb;
  switch (p_private->p_showmode)
  {
    case hk_kdedblistview::sm_central: tb=p_database->central_filelist(ft_query);break;
    case hk_kdedblistview::sm_local: tb=p_database->local_filelist(ft_query);break;
    default: tb=p_database->querylist();
  }
  
  
  vector<hk_string>::reverse_iterator it;
  if (tb!=NULL)
  {
      for(it=tb->rbegin();it!=tb->rend();it++)
       new KListViewItem(p_private->p_queryitem,QString::fromLocal8Bit((*it).c_str()));
  }
  p_private->p_queryitem->sortChildItems(0,true);
}




void hk_kdedblistview::set_forms(void)
{
  QString text=i18n("Forms");
  if (p_database&& 
      ((p_database->loadmode(ft_form)==hk_database::central && p_private->p_showmode==sm_all)
      ||(p_private->p_showmode==sm_central)
      )  
     )
     text+=i18n(" (Central)");
  p_private->p_formitem->setText(0,text);

 p_private->clearList(p_private->p_formitem);
  if (!p_database) return;
  vector<hk_string>* tb;
  switch (p_private->p_showmode)
  {
    case hk_kdedblistview::sm_central: tb=p_database->central_filelist(ft_form);break;
    case hk_kdedblistview::sm_local: tb=p_database->local_filelist(ft_form);break;
    default: tb=p_database->formlist();
  }
  vector<hk_string>::reverse_iterator it;
  if (tb!=NULL)
  {
      it=tb->rbegin();
      while(it!=tb->rend())
       {
        new KListViewItem(p_private->p_formitem,QString::fromLocal8Bit((*it).c_str()));
        it++;
       }
  }
  p_private->p_queryitem->sortChildItems(0,true);
}



void hk_kdedblistview::set_reports(void)
{
  QString text=i18n("Reports");
  if (p_database&& 
      ((p_database->loadmode(ft_report)==hk_database::central && p_private->p_showmode==sm_all)
      ||(p_private->p_showmode==sm_central)
      )  
     )
     text+=i18n(" (Central)");
  p_private->p_reportitem->setText(0,text);

 p_private->clearList(p_private->p_reportitem);
  if (!p_database) return;
  vector<hk_string>* tb;
  switch (p_private->p_showmode)
  {
    case hk_kdedblistview::sm_central: tb=p_database->central_filelist(ft_report);break;
    case hk_kdedblistview::sm_local: tb=p_database->local_filelist(ft_report);break;
    default: tb=p_database->reportlist();
  }
  vector<hk_string>::reverse_iterator it;
  if (tb!=NULL)
  {
      for(it=tb->rbegin();it!=tb->rend();it++)
       new KListViewItem(p_private->p_reportitem,QString::fromLocal8Bit((*it).c_str()));
  }
 p_private->p_queryitem->sortChildItems(0,true);
}


void hk_kdedblistview::item_clicked(QListViewItem* item)
{
  if (!item) return;
      
}

void hk_kdedblistview::item_doubleclicked(QListViewItem* item)
{
  if (!item) return;
  if (item->parent()==p_private->p_tableitem) 
      emit signal_viewmode_table(item->text(0));
  else
  if (item->parent()==p_private->p_queryitem) 
      emit signal_viewmode_query(item->text(0));
else
  if (item->parent()==p_private->p_formitem) 
      emit signal_viewmode_form(item->text(0));
else
  if (item->parent()==p_private->p_reportitem) 
      emit signal_viewmode_report(item->text(0));
else
  if (item==p_private->p_tableitem&& !runtime_only() &&p_database&& p_database->name().size()>0) 
      emit signal_new_table();
  else
  if (item==p_private->p_queryitem&& !runtime_only()&&p_database&& p_database->name().size()>0) 
      emit signal_new_query();
else
  if (item==p_private->p_formitem&& !runtime_only()&&p_database&& p_database->name().size()>0) 
      emit signal_new_form();
else
  if (item==p_private->p_reportitem&& !runtime_only()&&p_database&& p_database->name().size()>0) 
      emit signal_new_report();
else
  if (item==p_private->p_databaseitem&& !runtime_only()&&p_database) 
      emit signal_new_database();
      
}





bool hk_kdedblistview::is_tableitem(QListViewItem*item,bool includingheader)
{
  if (!item) return false;
  if (includingheader && item==p_private->p_tableitem) return true;
  if (item->parent()==p_private->p_tableitem) return true;
  return false;
}

bool hk_kdedblistview::is_queryitem(QListViewItem*item,bool includingheader)
{
  if (!item) return false;
  if (includingheader && item==p_private->p_queryitem) return true;
  if (item->parent()==p_private->p_queryitem) return true;
  return false;
}

bool hk_kdedblistview::is_formitem(QListViewItem*item,bool includingheader)
{
  if (!item) return false;
  if (includingheader && item==p_private->p_formitem) return true;
  if (item->parent()==p_private->p_formitem) return true;
  return false;
}

bool hk_kdedblistview::is_reportitem(QListViewItem*item,bool includingheader)
{
  if (!item) return false;
  if (includingheader && item==p_private->p_reportitem) return true;
  if (item->parent()==p_private->p_reportitem) return true;
  return false;
}

bool hk_kdedblistview::is_databaseitem(QListViewItem* item)
{
  if (!item) return false;
  return (item==p_private->p_databaseitem) ;
}

bool hk_kdedblistview::is_headeritem(QListViewItem* item)
{
  if (!item) return false;
  return (item==p_private->p_databaseitem ||
          item==p_private->p_tableitem ||
	  item==p_private->p_queryitem ||
	  item==p_private->p_formitem ||
	  item==p_private->p_reportitem 
	 );
}

bool hk_kdedblistview::is_tableitem(bool includeheader)
{
return is_tableitem(currentItem(),includeheader);
}

bool hk_kdedblistview::is_queryitem(bool includeheader)
{
return is_queryitem(currentItem(),includeheader);

}

bool hk_kdedblistview::is_formitem(bool includeheader)
{
return is_formitem(currentItem(),includeheader);

}

bool hk_kdedblistview::is_reportitem(bool includeheader)
{
return is_reportitem(currentItem(),includeheader);

}

bool hk_kdedblistview::is_databaseitem(void)
{
return is_databaseitem(currentItem());

}

bool hk_kdedblistview::is_headeritem(void)
{
return is_headeritem(currentItem());

}






void hk_kdedblistview::new_clicked()
{ 
    if (is_tableitem(currentItem(),true)) emit signal_new_table();
    else
    if (is_queryitem(currentItem(),true)) emit signal_new_query();
    else
    if (is_formitem(currentItem(),true)) emit signal_new_form();
    else
    if (is_reportitem(currentItem(),true)) emit signal_new_report();
    else
    if (is_databaseitem(currentItem())) emit signal_new_database();
    

}



void hk_kdedblistview::alter_clicked()
{
    if (is_tableitem(currentItem())) emit signal_designmode_table(currentItem()->text(0));
    else
    if (is_queryitem(currentItem())) emit signal_designmode_query(currentItem()->text(0));
    else
    if (is_formitem(currentItem())) emit signal_designmode_form(currentItem()->text(0));
    else
    if (is_reportitem(currentItem())) emit signal_designmode_report(currentItem()->text(0));
}

void hk_kdedblistview::delete_clicked()
{
    if (is_tableitem(currentItem(),true)) emit signal_delete_table(currentItem()->text(0));
    else
    if (is_queryitem(currentItem(),true)) emit signal_delete_query(currentItem()->text(0));
    else
    if (is_formitem(currentItem(),true)) emit signal_delete_form(currentItem()->text(0));
    else
    if (is_reportitem(currentItem(),true)) emit signal_delete_report(currentItem()->text(0));
    else
    if (is_databaseitem(currentItem())) emit signal_delete_database(currentItem()->text(0));
    

}


void hk_kdedblistview::start_clicked()
{
    if (is_tableitem(currentItem())) emit signal_viewmode_table(currentItem()->text(0));
    else
    if (is_queryitem(currentItem())) emit signal_viewmode_query(currentItem()->text(0));
    else
    if (is_formitem(currentItem())) emit signal_viewmode_form(currentItem()->text(0));
    else
    if (is_reportitem(currentItem())) emit signal_viewmode_report(currentItem()->text(0));

}

void    hk_kdedblistview::list_changes(listtype type)
{
   switch (type)
    {
        case lt_query : set_queries();
        break;
        case lt_form : set_forms();
        break;
        case lt_report : set_reports();
        break;
        default : set_tables();

    }

}




bool hk_kdedblistview::acceptDrag(QDropEvent* event) const
{
     bool cancreate=true;
   hk_string xtype;
    if (!event) return false; 
    if (!event->encodedData("application/x-hk_filecopy") ) 
      {
         cerr <<"event->encodedData ==NULL!!!"<<endl;
	 return false;
      }
    hk_string result=event->encodedData("application/x-hk_filecopy").data();
    hk_class::get_tagvalue(result,"TYPE",xtype);
     if (xtype=="TABLE"
        && !(database()->connection()&&database()->connection()->server_supports(hk_connection::SUPPORTS_NEW_TABLE)))
        cancreate=false;
    else
    if (xtype=="DATABASE"
        && !(database()->connection()&&database()->connection()->server_supports(hk_connection::SUPPORTS_NEW_DATABASE)))
        cancreate=false;
   return (event->provides("application/x-hk_filecopy")&&event->source()!=this && cancreate);
}


void hk_kdedblistview::slot_drop(QDropEvent* event)
{
    if(decode_action(event)) 
       {
       execute_action();
       event->accept();
       }
}


bool hk_kdedblistview::decode_action(QMimeSource* event)
{
    if (!event) return false;
    if (!event->encodedData("application/x-hk_filecopy").data())return false;
    hk_string result=event->encodedData("application/x-hk_filecopy").data();

    if (!(
        hk_class::get_tagvalue(result,"NAME",p_private->xname)
        &&hk_class::get_tagvalue(result,"TYPE",p_private->xtype)
        &&hk_class::get_tagvalue(result,"DIRECTORY",p_private->xdirectory)
        &&hk_class::get_tagvalue(result,"SERVER",p_private->xserver)
        &&hk_class::get_tagvalue(result,"HOST",p_private->xhost)
        &&hk_class::get_tagvalue(result,"TCP",p_private->xtcp)
        &&hk_class::get_tagvalue(result,"USER",p_private->xuser)
        &&hk_class::get_tagvalue(result,"DBNAME",p_private->xdbname)
        )
        )
    {
        show_warningmessage("Error in drag&drop protocol");
        cerr <<result<<endl;
        return false;
    }
    if (p_private->xtype=="REPORT")
    {
        p_private->otype=ot_report;
    }
    else
    if (p_private->xtype=="QUERY")
    {
        p_private->otype=ot_query;
    }
    else
    if (p_private->xtype=="FORM")
    {
        p_private->otype=ot_form;
    }
    else
    if (p_private->xtype=="TABLE")
    {
        p_private->otype=ot_table;
    }
    else
    {
        p_private->otype=ot_database;
    }

    return true;

}



bool hk_kdedblistview::execute_action(void)
{
    switch (p_private->otype)
    {
        case ot_table:
        {
            copy_table();
            break;
        }
        case ot_database:
        {
            copy_database();
            break;
        }
        default: copy_presentationfile();
    }
    return true;

}

bool hk_kdedblistview::copy_presentationfile(void)
{
    if (!database()) return false;
    hk_connection* con=find_connection();
    hk_connection* newcon=database()->connection()->drivermanager()->new_connection(p_private->xserver);
    newcon->set_host(p_private->xhost);
    newcon->set_tcp_port(localestring2uint(p_private->xtcp));
    newcon->set_user(p_private->xuser);
    if (con) newcon->set_password(con->password());
    newcon->connect();
    if (!newcon->is_connected())
    {
        delete newcon;
        return false;
    }
    hk_database* db=newcon->new_database(p_private->xdbname);
    hk_string input=db->load(p_private->xname,(filetype)p_private->otype);
    
      database()->save(input,p_private->xname,(filetype)p_private->otype,true,true);
    
   return true;    
}




bool hk_kdedblistview::copy_table(void)
{
    if (!database()) return false;
    hk_connection* con=find_connection();
    hk_connection* newcon=database()->connection()->drivermanager()->new_connection(p_private->xserver);
    newcon->set_host(p_private->xhost);
    newcon->set_tcp_port(localestring2uint(p_private->xtcp));
    newcon->set_user(p_private->xuser);
    if (con) newcon->set_password(con->password());
    newcon->connect();
    if (!newcon->is_connected())
    {
        delete newcon;
        return false;
    }
    hk_database* db=newcon->new_database(p_private->xdbname);
    hk_datasource* ds=NULL;
    if (db)ds= db->new_table(p_private->xname);
    bool data=true;
    int i=p_private->p_schemadialog->exec();

    if (p_private->p_schemadialog->schemaonlyfield->isChecked())data=false;
    p_private->p_schemadialog->hide();
    if (i==QDialog::Rejected)return false;
    p_cancelcopying=false;
    p_progressdialog= new  QProgressDialog();
    p_progressdialog->resize(300,p_progressdialog->height());
    connect(p_progressdialog,SIGNAL(cancelled()),this,SLOT(copying_cancelled()));
    p_progressdialog->show();
    qApp->processEvents();
    bool result= database()->copy_table(ds,data,true,true,&hk_kdedblistview::set_progress);
    delete ds;
    delete p_progressdialog;
    p_progressdialog=NULL;
    newcon->disconnect();
    delete newcon;
    return result;
}


void hk_kdedblistview::copying_cancelled()
{
    p_cancelcopying=true;
}


bool hk_kdedblistview::set_progress(long int position,long int total,const hk_string&txt)
{
    if (p_progressdialog)
    {

        p_progressdialog->setCaption(QString::fromLocal8Bit(txt.c_str()));
        p_progressdialog->setTotalSteps(total);
        p_progressdialog->setProgress(position);
        qApp->processEvents();
    }
    return p_cancelcopying;
}


bool hk_kdedblistview::copy_database(void)
{
    if (!database()) return false;
    hk_connection* con=find_connection();
    hk_connection* newcon=database()->connection()->drivermanager()->new_connection(p_private->xserver);
    newcon->set_host(p_private->xhost);
    newcon->set_tcp_port(localestring2uint(p_private->xtcp));
    newcon->set_user(p_private->xuser);
    if (con) newcon->set_password(con->password());
    newcon->connect();
    if (!newcon->is_connected())
    {
        delete newcon;
        return false;
    }
    hk_database* db=newcon->new_database(p_private->xdbname);
    bool data=true;
    int i=p_private->p_schemadialog->exec();
    if (p_private->p_schemadialog->schemaonlyfield->isChecked())data=false;
    p_private->p_schemadialog->hide();
    if (i==QDialog::Rejected)return false;
    p_cancelcopying=false;
    p_progressdialog= new  QProgressDialog();
    p_progressdialog->resize(300,p_progressdialog->height());
    connect(p_progressdialog,SIGNAL(cancelled()),this,SLOT(copying_cancelled()));
    p_progressdialog->show();
    qApp->processEvents();
    bool result= database()->connection()->copy_database(db,data,true,&hk_kdedblistview::set_progress);
    delete p_progressdialog;
    p_progressdialog=NULL;
    newcon->disconnect();
    delete newcon;
    emit signal_reload_databases();
    return result;
}


hk_connection* hk_kdedblistview::find_connection(void)
{
    return database()->connection()->drivermanager()->find_existing_connection(p_private->xserver,p_private->xhost,localestring2uint(p_private->xtcp),p_private->xuser);
}


QDragObject* hk_kdedblistview::dragObject()
{ 
    return new hk_dbviewerdrag(current_objecttype(),currentItem()->text(0),database(),this);
}

void hk_kdedblistview::copy(void)
{
  hk_dbviewerdrag* d=new hk_dbviewerdrag(current_objecttype(),currentItem()->text(0),database());
  QApplication::clipboard()->setData(d);

}

void hk_kdedblistview::paste(void)
{
  if(decode_action(QApplication::clipboard()->data(QClipboard::Clipboard))
    ) execute_action();
  
}
void hk_kdedblistview::reload_lists()
{
   list_changes(lt_table);
   list_changes(lt_query);
   list_changes(lt_form);
   list_changes(lt_report);
   
}


void hk_kdedblistview::set_showmode(enum_showmode sm)
{
  p_private->p_showmode=sm;
  setAcceptDrops(sm==sm_all);
  setDragEnabled(sm==sm_all);
  init_listview();
  set_databasename();
}

hk_kdedblistview::enum_showmode hk_kdedblistview::showmode(void) const
{
   return p_private->p_showmode;
}

