// ****************************************************************************
// copyright (c) 2000-2004 Horst Knorr <hk_classes@knoda.org>  
// This file is part of the hk_kdeclasses library.
// This file may be distributed and/or modified under the terms of the
// GNU Library Public License version 2 as published by the Free Software
// Foundation and appearing in the file LGPL included in the
// packaging of this file.
// This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
// ****************************************************************************
 //$Revision: 1.6 $

#ifndef HK_KDEDBLISTVIEW_H
#define HK_KDEDBLISTVIEW_H
#include <klistview.h>
#include <qdialog.h>
#include <qdragobject.h>

#include <hk_dbvisible.h>

class hk_kdedblistviewprivate;
class QProgressDialog;
class hk_kdeschemadialog;
class QVBoxLayout;
class QHBoxLayout;
class QGridLayout;
class QButtonGroup;
class QLabel;
class QPushButton;
class QRadioButton;
class KAction;
class KActionMenu;
class QPopupMenu;




class hk_dbviewerdrag : public QStoredDrag
{
public:

hk_dbviewerdrag(objecttype type,const QString& object,hk_database* db,QWidget* dragsource=0);
static  bool canDecode(const QMimeSource* s);
const char* format(int i) const;

private:
void create_draginfo(objecttype type,const QString& object,hk_database* db);
};


class hk_kdedblistview: public KListView, public hk_dbvisible
{
Q_OBJECT
public:
hk_kdedblistview (QWidget* parent=0L, const char* name=0L);
virtual ~hk_kdedblistview();
void set_database(hk_database*);
bool is_tableitem(QListViewItem*,bool includingheader=false);
bool is_queryitem(QListViewItem*,bool includingheader=false);
bool is_formitem(QListViewItem*,bool includingheader=false);
bool is_reportitem(QListViewItem*,bool includingheader=false);
bool is_databaseitem(QListViewItem*);
bool is_headeritem(QListViewItem*);
bool is_tableitem(bool includingheader=false);
bool is_queryitem(bool includingheader=false);
bool is_formitem(bool includingheader=false);
bool is_reportitem(bool includingheader=false);
bool is_databaseitem(void);
bool is_headeritem(void);
bool cancel(void){return p_cancelcopying;}
void reload_lists(void);
enum enum_showmode {sm_all,sm_central,sm_local};

void set_showmode(enum_showmode);
enum_showmode showmode(void) const;

signals:

 void signal_new_database(void);
 void signal_delete_database(const QString&);
 void signal_reload_databases(void);
 
 void signal_new_table(void);
 void signal_delete_table(const QString&);
 void signal_designmode_table(const QString&);
 void signal_viewmode_table(const QString&);

 void signal_new_query(void);
 void signal_delete_query(const QString&);
 void signal_designmode_query(const QString&);
 void signal_viewmode_query(const QString&);

 void signal_new_form(void);
 void signal_delete_form(const QString&);
 void signal_designmode_form(const QString&);
 void signal_viewmode_form(const QString&);

 void signal_new_report(void);
 void signal_delete_report(const QString&);
 void signal_designmode_report(const QString&);
 void signal_viewmode_report(const QString&);


public slots:
virtual void new_clicked();
virtual void start_clicked();
virtual void alter_clicked();
virtual void delete_clicked();
        void copy(void);
        void paste(void);
        void copying_cancelled();
        

protected slots:

 void item_clicked(QListViewItem*);
void item_doubleclicked(QListViewItem*);
void slot_drop(QDropEvent*);
protected:
static  bool set_progress(long int,long int,const hk_string&);
        QDragObject* dragObject ();

virtual void list_changes(listtype type);
 
// virtual void contentsmouseReleaseEvent(QMouseEvent*);
// virtual void contentsmouseMoveEvent(QMouseEvent*);
 virtual bool acceptDrag(QDropEvent*) const;
 //void dragEnterEvent(QDragEnterEvent*);
 
 bool decode_action(QMimeSource* event);
 bool copy_presentationfile(void);
 bool copy_table(void);
 bool copy_database(void);
 hk_connection* find_connection(void);

private:
objecttype current_objecttype();
void init_listview(void);
void set_databasename(void);
void set_tables(void);
void set_queries(void);
void set_forms(void);
void set_reports(void);
bool execute_action(void);
hk_kdedblistviewprivate* p_private;
static QProgressDialog* p_progressdialog;
static bool p_cancelcopying;
};

class hk_kdeschemadialog : public QDialog
{
    Q_OBJECT

        public:
        hk_kdeschemadialog( QWidget* parent = 0, const char* name = 0, bool modal = FALSE, WFlags fl = 0 );
        ~hk_kdeschemadialog();

        QButtonGroup* ButtonGroup1;
        QRadioButton* schemaonlyfield;
        QRadioButton* datafield;
        QPushButton* buttonOk;
        QPushButton* buttonCancel;

    protected:
        QHBoxLayout* hk_kdeschemadialogLayout;
        QVBoxLayout* ButtonGroup1Layout;
        QVBoxLayout* Layout2;
};


#endif //HK_KDEDBLISTVIEW_H
