// ****************************************************************************
// copyright (c) 2000-2004 Horst Knorr <hk_classes@knoda.org>  
// This file is part of the hk_kdeclasses library.
// This file may be distributed and/or modified under the terms of the
// GNU Library Public License version 2 as published by the Free Software
// Foundation and appearing in the file LGPL included in the
// packaging of this file.
// This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
// ****************************************************************************
//$Revision: 1.61 $

#include "hk_kdeform.h"
#include "hk_kdeform.moc"
#include "hk_kdetoolbar.h"

#include <qbuttongroup.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <kstatusbar.h>
#include <qstatusbar.h>
#include <hk_kdesimpleform.h>
#include <qtoolbutton.h>
#include <qlayout.h>
#include <qvariant.h>
#include <qtooltip.h>
#include <qscrollview.h>
#include <qwhatsthis.h>
#include <qimage.h>
#include <qpixmap.h>
#include <kglobal.h>
#include <kiconloader.h>
#include <qpushbutton.h>
#include <hk_kderowselector.h>
#include "../hk_kdegridpart/hk_kdegridpart.h"
#include <hk_class.h>
#include <hk_database.h>
#include <hk_dsvisible.h>
#include <hk_visible.h>
#include <hk_dsdatavisible.h>
#include <hk_datasource.h>
#include <hk_connection.h>

#include <kmenubar.h>
#include <kaction.h>
#include <kstdaction.h>
#include <kstandarddirs.h>
#include <klocale.h>
#include <kmdichildview.h>


/*
 *  Constructs a hk_kdeform which is a child of 'parent', with the
 *  name 'name' and widget flags set to 'f'
 */
hk_kdeform::hk_kdeform( QWidget* parent,  const char* name, WFlags fl )
: KParts::DockMainWindow( parent, name, fl ) ,hk_class()
{
#ifdef HK_DEBUG
    hkclassname("Hauptformular");
    hkdebug("hk_kdeform::hk_kdeform");
#endif
    KIconLoader* loader=KGlobal::iconLoader();
    loader->addAppDir("hk_kdeclasses");
    setXMLFile(locate("data","hk_kdeclasses/hk_kdeform.rc"));
    if ( !name )
        setName( "hk_kdeform" );
    setCaption( i18n( "Form"  ) );
    resize( 800, 600 );
    QPixmap p;
    KDockWidget* maindock=createDockWidget("",p,0,"");
    maindock->setEnableDocking(KDockWidget::DockNone);
    maindock->setDockSite(KDockWidget::DockCorner);
    setView(maindock);
    setMainDockWidget(maindock);
    p_scrollview = new QScrollView(maindock);
    maindock->setWidget(p_scrollview);
    p_form = new hk_kdesimpleform( p_scrollview->viewport() );
    p_scrollview->addChild(p_form);
    p_form->set_kdeform(this);
    QWidget* wid= new QWidget(statusBar());
    QHBoxLayout* l=new QHBoxLayout(wid);
    p_rowselector = new hk_kderowselector( wid ,p_form);
    p_rowselector->set_neverregisterchange(true);
    l->addWidget(p_rowselector);
#ifdef HK_DEBUG
    p_rowselector->hkclassname("hkkdeform->p_rowselector");
#endif
    int hbheight= 20;
    p_rowselector->setMaximumHeight(hbheight);
    p_rowselector->setMaximumWidth(240);
    p_rowselector->setMinimumHeight(hbheight);
    QSpacerItem* spacer = new QSpacerItem( 20, 20, QSizePolicy::Expanding ,QSizePolicy::Minimum );
    l->addItem( spacer );

    statusBar()->addWidget(wid);
    QSizePolicy fixedpolicy(QSizePolicy::Fixed,QSizePolicy::Fixed);
//   QSizePolicy labelpolicy(QSizePolicy::Expanding,QSizePolicy::Fixed);
    p_rowselector->setSizePolicy( fixedpolicy );
    setFocusPolicy(ClickFocus);
    p_designaction=new KRadioAction(i18n("&Design mode"),"edit",0,this,SLOT(designbutton_clicked()),actionCollection(),"designmode");
    p_designaction->setEnabled(!runtime_only());
    p_viewaction=new KRadioAction(i18n("&View mode"),"exec",0,this,SLOT(formbutton_clicked()),actionCollection(),"viewmode");
    p_closeaction=new KAction(i18n("&Close"),loader->loadIcon("exit",KIcon::User),0,this,SLOT(close_form()),actionCollection(),"closeform");
    p_saveaction=new KAction(i18n("&Save"),"filesave",0,this,SLOT(save_form()),actionCollection(),"saveform");
    p_saveaction->setEnabled(!runtime_only());
    p_saveasaction=new KAction(i18n("Save &as"),"filesaveas",0,this,SLOT(saveas_form()),actionCollection(),"saveas");
    p_saveasaction->setEnabled(!runtime_only());

    p_designaction->setExclusiveGroup("mode");
    p_viewaction->setExclusiveGroup("mode");
    p_designaction->setChecked(true);

    p_lineeditaction=new KRadioAction("Lineedit",loader->loadIcon("edit",KIcon::User),0,this,SLOT(fieldbutton_clicked()),actionCollection(),"lineedit");
    p_pointeraction=new KRadioAction("Pointer",loader->loadIcon("pfeil",KIcon::User),0,this,SLOT(fieldbutton_clicked()),actionCollection(),"pointer");
    p_labelaction=new KRadioAction("Label",loader->loadIcon("label",KIcon::User),0,this,SLOT(fieldbutton_clicked()),actionCollection(),"label");
    p_multilineeditaction=new KRadioAction("Multiline",loader->loadIcon("multiline",KIcon::User),0,this,SLOT(fieldbutton_clicked()),actionCollection(),"multiline");
    p_booleanaction=new KRadioAction("Boolean",loader->loadIcon("boolean22x22",KIcon::User),0,this,SLOT(fieldbutton_clicked()),actionCollection(),"boolean");
    p_comboboxaction=new KRadioAction("Combobox",loader->loadIcon("combobox22x22",KIcon::User),0,this,SLOT(fieldbutton_clicked()),actionCollection(),"combobox");
    p_gridaction=new KRadioAction("Grid",loader->loadIcon("grid22x22",KIcon::User),0,this,SLOT(fieldbutton_clicked()),actionCollection(),"grid");
    p_selectoraction=new KRadioAction("Selector",loader->loadIcon("rowselector22x22",KIcon::User),0,this,SLOT(fieldbutton_clicked()),actionCollection(),"selector");
    p_buttonaction=new KRadioAction("Button",loader->loadIcon("button",KIcon::User),0,this,SLOT(fieldbutton_clicked()),actionCollection(),"button");
    p_bulkaction=new KActionMenu(i18n("Set to all"),0,actionCollection(),"bulk");
    p_bulkfontaction=new KAction(i18n("Font"),0,0,this,SLOT(bulkfont_clicked()),actionCollection(),"bulkfont");
    p_bulkforegroundcolouraction=new KAction(i18n("Foregroundcolour"),0,0,this,SLOT(bulkforegroundcolour_clicked()),actionCollection(),"bulkforeground");
    p_bulkbackgroundcolouraction=new KAction(i18n("Backgroundcolour"),0,0,this,SLOT(bulkbackgroundcolour_clicked()),actionCollection(),"bulkbackground");
    p_bulkaction->insert(p_bulkfontaction);
    p_bulkaction->insert(p_bulkforegroundcolouraction);
    p_bulkaction->insert(p_bulkbackgroundcolouraction);

    p_pointeraction->setExclusiveGroup("design");
    p_labelaction->setExclusiveGroup("design");
    p_lineeditaction->setExclusiveGroup("design");
    p_multilineeditaction->setExclusiveGroup("design");
    p_booleanaction->setExclusiveGroup("design");
    p_comboboxaction->setExclusiveGroup("design");
    p_gridaction->setExclusiveGroup("design");
    p_selectoraction->setExclusiveGroup("design");
    p_buttonaction->setExclusiveGroup("design");

    p_pointeraction->setToolTip( i18n( "select" ) );
    p_labelaction->setToolTip( i18n( "textlabel" ));
    p_lineeditaction->setToolTip( i18n( "lineeditfield" ));
    p_multilineeditaction->setToolTip( i18n( "memofield" ));
    p_booleanaction->setToolTip( i18n( "booleanfield" ));
    p_comboboxaction->setToolTip( i18n( "comboboxfield" ));
    p_gridaction->setToolTip( i18n( "gridfield" ));
    p_selectoraction->setToolTip( i18n( "rowselector" ));
    p_buttonaction->setToolTip( i18n( "button" ));

    p_pointeraction->setChecked(true);
    connect( p_form, SIGNAL( field_created() ), this, SLOT( field_created() ) );

    toolbar = new hk_kdetoolbar( this, "toolbar" );
    p_filterdefinitionaction=new KAction(i18n("Filterdefinition"),loader->loadIcon("filter",KIcon::User),0,toolbar,SLOT(filterdefinebutton_clicked()),actionCollection(),"filterdefinition");
    p_filterexecaction=new KToggleAction(i18n("Filterexecution"),loader->loadIcon("filterexec",KIcon::User),0,toolbar,SLOT(filterexecbutton_clicked()),actionCollection(),"filterexec");
    toolbar->set_filteractions(p_filterdefinitionaction,p_filterexecaction);

    set_nodesignmode(runtime_only());
    //setCentralWidget(p_scrollview);
    createGUI(0L);
    toolBar("designtoolbar")->setBarPos(KToolBar::Left);
    set_designmode();
    p_form->reset_has_changed();
}


/*
 *  Destroys the object and frees any allocated resources
 */
hk_kdeform::~hk_kdeform()
{
#ifdef HK_DEBUG
    hkdebug("hk_kdeform::~hk_kdeform");
#endif
    delete p_rowselector;
}


hk_presentation::enum_mode  hk_kdeform::mode(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdeform::mode");
#endif

    return p_form->mode();
}


void    hk_kdeform::set_mode(hk_presentation::enum_mode s)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdeform::set_mode(s)");
#endif

    p_form->set_mode(s);

    if (s==hk_presentation::viewmode)
    {
        toolBar("designtoolbar")->hide();
        p_viewaction->setChecked(true);
        toolbar->set_viewmode();
        p_bulkaction->setEnabled(false);
    }
    else
    {
        toolBar("designtoolbar")->show();
        p_designaction->setChecked(true);
        toolbar->set_designmode();
        p_bulkaction->setEnabled(true);
    }
    p_form->repaint(0,0,p_form->QWidget::width(),p_form->QWidget::height(),true);

}


void hk_kdeform::set_designmode(void)
{
    set_mode(hk_presentation::designmode);
}


void hk_kdeform::set_viewmode(void)
{
    set_mode(hk_presentation::viewmode);
}


hk_dsgrid*      hk_kdeform::new_grid(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdeform::new_grid");
#endif
    hk_dsgrid* d=p_form->new_grid();
    return d;
}


hk_dslineedit*  hk_kdeform::new_lineedit(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdeform::new_field");
#endif
    hk_dslineedit* d=p_form->new_lineedit();
    return d;
}


hk_dsboolean*   hk_kdeform::new_bool(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdeform::new_bool");
#endif
    hk_dsboolean* d=p_form->new_bool();
    return d;
}


hk_dsmemo*  hk_kdeform::new_memo(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdeform::new_memo");
#endif
    hk_dsmemo* d=p_form->new_memo();
    return d;
}


hk_button*      hk_kdeform::new_button(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdeform::new_button");
#endif
    hk_button* d=p_form->new_button();
    return d;
}


hk_dsrowselector*       hk_kdeform::new_rowselector(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdeform::new_rowselector");
#endif
    hk_dsrowselector* d=p_form->new_rowselector();
    return d;
}


void        hk_kdeform::set_formsize(unsigned int width, unsigned int height)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdeform::set_formsize");
#endif
    p_form->set_designsize(width,height);
}


void    hk_kdeform::set_database(hk_database* db)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdeform::database(db)");
#endif

    p_form->set_database(db);
}


hk_database*        hk_kdeform::database(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdeform::database");
#endif
    return p_form->database();
}


list<hk_datasource*>*   hk_kdeform::datasources(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdeform::datasources");
#endif
    return p_form->datasources();
}


long    hk_kdeform::new_datasource(const hk_string& name,bool query)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdeform::new_datasource(name,query)");
#endif
    return p_form->new_datasource(name,query);
}


hk_datasource*  hk_kdeform::get_datasource(long nr)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdeform::get:datasource(nr)");
#endif
    return p_form->get_datasource(nr);
}


void hk_kdeform::formbutton_clicked(void)
{
    set_mode(hk_presentation::viewmode);

}


void hk_kdeform::designbutton_clicked(void)
{
    if (p_nodesignmode)  set_mode(hk_form::viewmode);
    else set_mode(hk_form::designmode);

}


bool    hk_kdeform::set_presentationdatasource(long n, bool r)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdeform::set_presentationdatasource(n)");
#endif
    p_rowselector->set_presentationdatasource(n,false);
    bool res=true;
    toolbar->set_datasource(p_form->get_datasource(n));
    if (r) res= p_form->set_presentationdatasource(n,false);
    return res;
}


long    hk_kdeform::presentationdatasource(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdeform::presentationdatasource(n)");
#endif
    return p_form->presentationdatasource();
}


void hk_kdeform::closeEvent ( QCloseEvent* e)
{

#ifdef HK_DEBUG
    hkdebug("hk_kdeform::closeEvent");
//set_generaldebug(true);
#endif
save_form_when_changed();
 #ifdef HK_DEBUG
    hkdebug("hk_kdeform::closeEvent nach abspeichern");
#endif
   emit signal_closed(this);

    QWidget::closeEvent(e);
}


void hk_kdeform::save_form_when_changed(void)
{

   if (p_form &&p_form->has_changed())
    {
        if (toolbar->is_filter_activated())
            toolbar->deactivate_filter();
        p_form->save_form();
    }

}



void hk_kdeform::close_form(void)
{

    close();
}


void hk_kdeform::savedata(ofstream& s)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdeform::savedata(s)");
#endif
    p_form->savedata(s);

}


void hk_kdeform::loaddata(const hk_string& definition)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdeform::loaddata");
#endif
    p_form->loaddata(definition);
    p_rowselector->set_presentationdatasource(p_form->presentationdatasource());
}


void hk_kdeform::load_form(const hk_string& n)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdeform::load_form");
#endif

    if (database()==NULL)
    {
        hk_class::show_warningmessage(hk_class::hk_translate("Form error: No database defined!"));
        return ;

    }
//  p_form->formname(n);
    p_form->load_form(n);
    p_rowselector->set_presentationdatasource(p_form->presentationdatasource(),false);
    if (p_form->datasource())toolbar->set_filter(QString::fromLocal8Bit(p_form->datasource()->temporaryfilter().c_str()));
    set_caption();
}


void hk_kdeform::set_autoclose(bool c)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdeform::set_autoclose");
#endif
    p_form->set_autoclose(c);
}


void hk_kdeform::fieldbutton_clicked(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdeform::fieldbutton_clicked");
#endif

    hk_visible::enum_visibletype thisfield =hk_visible::other;
    if (p_lineeditaction->isChecked()) thisfield=hk_visible::lineedit;
    else
    if (p_labelaction->isChecked()) thisfield=hk_visible::textlabel;
        else
        if (p_multilineeditaction->isChecked()) thisfield=hk_visible::memo;
            else
            if (p_comboboxaction->isChecked()) thisfield=hk_visible::combobox;
                else
                if (p_gridaction->isChecked()) thisfield=hk_visible::grid;
                    else
                    if (p_booleanaction->isChecked()) thisfield=hk_visible::boolean;
                        else
                        if (p_buttonaction->isChecked()) thisfield=hk_visible::button;
                            else
                            if (p_selectoraction->isChecked()) thisfield=hk_visible::rowselector;
                                p_form->set_field2create(thisfield);

}


void    hk_kdeform::mousePressEvent(QMouseEvent*m)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdeform::mousePressEvent");
#endif
    QWidget::mousePressEvent(m);

}


void hk_kdeform::field_created(void)
{
    p_pointeraction->setChecked(true);
}


hk_kdesimpleform* hk_kdeform::simpleform(void)
{
    return p_form;
}


void hk_kdeform::set_nodesignmode(bool d)
{
    p_nodesignmode=d;
    toolbar->set_nodesignmode(d);

}


void hk_kdeform::save_form(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdeform::save_form");
#endif
/* if (toolbar->is_filter_activated())
    toolbar->deactivate_filter();
*/
    p_form->save_form("",false);
    set_caption();

}


void hk_kdeform::saveas_form(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdeform::save_form");
#endif
    if (toolbar->is_filter_activated())
        toolbar->deactivate_filter();

    hk_string oldname=p_form->hk_presentation::name();
    p_form->set_name("");
    if (p_form->save_form("",false))
    {
        set_caption();
    }
    else
    {
        p_form->set_name(oldname);

    }

}


void hk_kdeform::set_caption(void)
{

    KMdiChildView* v=dynamic_cast<KMdiChildView*>(parent());
    QString formname=i18n( "Form: "  );
    hk_datasource* d=p_form->datasource();
    if (d!=NULL)
    {
        if (!v)formname=QString::fromLocal8Bit(d->database()->connection()->drivername().c_str())+" "+formname;
        formname+=QString::fromLocal8Bit (p_form->hk_presentation::name().c_str());
        formname+=" (";
        hk_string driver=d->database()->name();
        formname+=QString::fromLocal8Bit(driver.c_str());
        formname+=")";

    }
    else formname+=QString::fromLocal8Bit (p_form->hk_presentation::name().c_str());
    setCaption( formname  );
    if (v) v->setCaption(formname);

}


void hk_kdeform::bulkfont_clicked(void)
{
    p_form->set_for_all(hk_presentation::bulkfont);
}


void hk_kdeform::bulkforegroundcolour_clicked(void)
{
    p_form->set_for_all(hk_presentation::bulkforeground);

}


void hk_kdeform::bulkbackgroundcolour_clicked(void)
{
    p_form->set_for_all(hk_presentation::bulkbackground);

}

hk_kdeproperty* hk_kdeform::propertyeditor(void)
{
   return p_form->propertyeditor();
}



void hk_kdeform::grid_partinfocus(hk_kdegridpart* p)
{
createGUI(p); 
}

void hk_kdeform::grid_partoutfocus(hk_kdegridpart*)
{
createGUI(0L);

}


