// ****************************************************************************
// copyright (c) 2000-2004 Horst Knorr <hk_classes@knoda.org>  
// This file is part of the hk_classes library.
// This file may be distributed and/or modified under the terms of the
// GNU Library Public License version 2 as published by the Free Software
// Foundation and appearing in the file COPYING included in the
// packaging of this file.
// This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
// ****************************************************************************
#include "hk_kdeqbe.h"
#include "hk_kdedbdesigner.h"
#include <hk_column.h>
#include <qtable.h>
#include <qsplitter.h>
#include <qstringlist.h>
#include <qlayout.h>
#include <klocale.h>
#include <qapplication.h>


class internalgrid:public QTable
{
public: 
internalgrid(QWidget* parent,hk_kdeqbe* qbe, const char* name=0):QTable(parent,name)
   {
     p_qbe=qbe;
     viewport()->setAcceptDrops(true);
     installEventFilter(this);
   }
   
protected:
bool delete_rows(void)
	{ 
	  QMemArray<int> myarray(0);
	  int i=0; int col=0;
	  int leftcol=999;
	  while (i<numSelections())
	  { 
	  QTableSelection s=selection(i);
	  if (isColumnSelected(s.leftCol(),true))
	  {
	   myarray.resize(myarray.size()+s.numCols());
	   if (s.leftCol()<leftcol)leftcol=s.leftCol();
	   for (int c=s.leftCol();c<=s.rightCol();++c)
	     {
	      myarray[col]=c;
	      ++col;
	     }
	  }    
	  ++i;
	  }
	  myarray.sort();
	  if (myarray.size()==0) return false;
	  removeColumns(myarray);
         setCurrentCell(currentRow(),leftcol);  
 	 p_qbe->slot_has_changed();
	 return true;
	}
	
	
bool   eventFilter( QObject *o, QEvent *e )
	{
	  if (e->type()==QEvent::KeyPress)
          {
            QKeyEvent *ke = (QKeyEvent*)e;
            if (ke->key() == Key_Delete&& o->isWidgetType())
	    {
	      
	       QWidget* w=(QWidget*)o;
	       while (w)
	       {
	       if ( w==this)
	       {
	         if (delete_rows()) return true;
		}
		w=w->parentWidget();
	       }
	    }	
	  }
	
        return QTable::eventFilter(o,e);
       };
hk_kdeqbe* p_qbe;



virtual void contentsDragEnterEvent(QDragEnterEvent* event)
   {
       event->accept(event->provides("application/x-hk_kdedbdesigner"));
   }

virtual void contentsDropEvent(QDropEvent* event)
{
  
   if (! event->encodedData("application/x-hk_kdedbdesigner"))
    {
      cerr <<"internalgrid event->encodedData==0 !!!"<<endl;
      return;
    }
   hk_string eventtxt=u2l(event->encodedData("application/x-hk_kdedbdesigner").data());
   long vupn;
   hk_string columnname;
   if (!(     hk_class::get_tagvalue(eventtxt,"VUPN",vupn)
         && hk_class::get_tagvalue(eventtxt,"VALUE",columnname)))
	 {
            hk_class::show_warningmessage("Error in drag&drop protocol");
            cerr <<eventtxt<<endl;
	    return;
	 }
    
    int dcol=columnAt(event->pos().x());
    p_qbe->add_column(dcol,vupn,columnname);
    event->acceptAction(true);

} // end drop Event


}; //  internalgrid END 





class hk_kdeqbeprivate
{
public:

hk_kdeqbeprivate()
	{
	  p_designer=NULL;
	}
hk_kdedbdesigner* p_designer;
QTable* p_table;
QSplitter* p_splitter;
QVBoxLayout* p_layout;
QStringList p_tablenames;

};

const int maxrows=15;
const int maxcolumns=64;





hk_kdeqbe::hk_kdeqbe(QWidget* w,const char* n,WFlags f) :KParts::MainWindow(w,n,f),hk_qbe()
{
  p_private= new hk_kdeqbeprivate;
  p_private->p_layout=new QVBoxLayout(this);
  p_private->p_splitter=new QSplitter(this);
  p_private->p_layout->addWidget(p_private->p_splitter);
  p_private->p_splitter->setOrientation(QSplitter::Vertical);
  p_private->p_designer=new hk_kdedbdesigner(p_private->p_splitter);
  p_private->p_designer->set_presentation(this);
  p_private->p_table=new internalgrid(p_private->p_splitter,this);
  p_private->p_table->setNumRows(maxrows);
  p_private->p_table->setNumCols(maxcolumns);
  p_private->p_table->verticalHeader()->setLabel(0,i18n("Table:"));
  p_private->p_table->verticalHeader()->setLabel(1,i18n("Fieldname:"));
  p_private->p_table->verticalHeader()->setLabel(2,i18n("Alias:"));
  p_private->p_table->verticalHeader()->setLabel(3,i18n("Function:"));
  p_private->p_table->verticalHeader()->setLabel(4,i18n("Order:"));
  p_private->p_table->verticalHeader()->setLabel(5,i18n("Show:"));
  p_private->p_table->verticalHeader()->setLabel(6,i18n("Updatevalue:"));
  p_private->p_table->verticalHeader()->setLabel(7,i18n("Criteria:"));
  p_private->p_table->verticalHeader()->setLabel(8,i18n("Or:"));
  for (int k=9;k<maxrows;++k)
   {
  	p_private->p_table->verticalHeader()->setLabel(k,"");
   }
  
  for (int k=0;k<p_private->p_table->numCols();++k)
   {
     init_column(k);
   }
  widget_specific_querytype_has_changed(hk_qbe::qt_select,hk_qbe::qt_select); 
  connect(p_private->p_table, SIGNAL(valueChanged(int,int)),this,SLOT(value_changed(int,int)));
  connect(p_private->p_designer,SIGNAL(signal_definition_has_changed()),this, SLOT (datasourcedefiniton_changed()));
}



hk_kdeqbe::~hk_kdeqbe()
{
delete p_private;
}




void hk_kdeqbe::init_column(int col)
{
  QStringList sl;
  p_private->p_table->horizontalHeader()->setLabel(col,"");
  QComboTableItem* citem= new QComboTableItem(p_private->p_table,sl);
  p_private->p_table->setItem(0,col,citem);
  citem= new QComboTableItem(p_private->p_table,sl);
  citem->setEditable(true);
  p_private->p_table->setItem(1,col,citem);
	
  sl.clear();
  sl.append(i18n("Group"));
  sl.append(i18n("Sum"));
  sl.append(i18n("Count"));
  sl.append(i18n("Min"));
  sl.append(i18n("Max"));
  sl.append(i18n("Average"));
  sl.append(i18n("Condition"));
  citem= new QComboTableItem(p_private->p_table,sl);
  p_private->p_table->setItem(3,col,citem);
	
  sl.clear();
  sl.append(i18n("none"));
  sl.append(i18n("ascending"));
  sl.append(i18n("descending"));
  citem= new QComboTableItem(p_private->p_table,sl);
  p_private->p_table->setItem(4,col,citem);
  sl.clear();
  sl.append(i18n("Yes"));
  sl.append(i18n("No"));
  QComboTableItem* ch=new QComboTableItem(p_private->p_table,sl);
  p_private->p_table->setItem(5,col,ch);
  p_private->p_table->setColumnWidth(col,160);
}



void hk_kdeqbe::set_datasource(hk_datasource* ds)
{
     hk_qbe::set_datasource(ds);
     hk_database* db=NULL;
     if (ds) db=ds->database(); 
     p_private->p_designer->set_database(db);
     p_private->p_designer->set_presentation(this);
}




void hk_kdeqbe::add_datasource(void)
{
   p_private->p_designer->add_datasource();
}




void hk_kdeqbe::set_has_changed(void)
{
  hk_qbe::set_has_changed();
  if (! block_has_changed()) emit signal_qbe_has_changed();
}




void hk_kdeqbe::slot_has_changed(void)
{
  set_has_changed();

}



void hk_kdeqbe::datasourcedefiniton_changed(void)
{
  set_tablenames();
}



void hk_kdeqbe::set_tablenamelist(void)
{ 
 p_private->p_tablenames.clear();
  p_private->p_tablenames.append("");
  list<hk_datasource*>* dslist=datasources();
  list<hk_datasource*>::iterator it=dslist->begin();
  while (it!=dslist->end())
  {
    p_private->p_tablenames.append(QString::fromLocal8Bit(
    unique_shortdatasourcename((*it)->presentationnumber()).c_str()));
    ++it;
  }
}

void hk_kdeqbe::set_tablenames(void)
{
  set_tablenamelist();
  for (int k=0;k<p_private->p_table->numCols();++k)
  {
    
    QComboTableItem* item=(QComboTableItem*)(p_private->p_table->item(0,k));
    QString current=item->currentText();
    init_tablenames(k);
    int i=p_private->p_tablenames.findIndex(current);
    if (i>-1)item->setCurrentItem(i);
  }
}

void hk_kdeqbe::init_tablenames(int col)
{
   QComboTableItem* item=(QComboTableItem*)(p_private->p_table->item(0,col));
    item->setStringList(p_private->p_tablenames);
}


void hk_kdeqbe::value_changed(int row, int col)
{
   set_has_changed();
   if (row==0/*table*/)
      {
         set_columnnames(col);
      }
}



void hk_kdeqbe::set_columnnames(int col)
{
   set_has_changed();
   QComboTableItem* item=(QComboTableItem*)(p_private->p_table->item(1,col));
   hk_string tbl=p_private->p_table->item(0,col)->text().local8Bit().data();
   hk_datasource* ds= get_datasource_by_shortname(tbl);
  ((QComboTableItem*)p_private->p_table->item(1,col))->setEditable(tbl=="");

   QStringList strlist;
    strlist.append("");
    if (ds)
    {
     list<hk_column*>* collist=ds->columns();
     if (collist)
     {
      list<hk_column*>::iterator it=collist->begin();
      while (it!=collist->end())
      {  
       strlist.append(QString::fromLocal8Bit((*it)->name().c_str()));
       ++it;
      }
     }
    }
   item->setStringList(strlist);
}


  void hk_kdeqbe::widget_specific_querytype_has_changed(enum_querytype ,enum_querytype nt)
  {
       switch (nt)
      {
        case qt_select:  
			p_private->p_table->showRow(2);//Alias
			p_private->p_table->hideRow(3);//Function
			p_private->p_table->showRow(4);//Order
			p_private->p_table->showRow(5);//show
			p_private->p_table->hideRow(6);//UpdateValue
			break;
        case qt_groupselect:  
			p_private->p_table->showRow(2);//Alias
			p_private->p_table->showRow(3);//Function
			p_private->p_table->showRow(4);//Order
			p_private->p_table->hideRow(5);//show
			p_private->p_table->hideRow(6);//UpdateValue
			break;
	case qt_update: 
			p_private->p_table->hideRow(2);//Alias
			p_private->p_table->hideRow(3);//Function
			p_private->p_table->hideRow(4);//Order
			p_private->p_table->hideRow(5);//show
			p_private->p_table->showRow(6);//UpdateValue
			break;
	case qt_delete: 
			p_private->p_table->hideRow(2);//Alias
			p_private->p_table->hideRow(3);//Function
			p_private->p_table->hideRow(4);//Order
			p_private->p_table->hideRow(5);//show
			p_private->p_table->hideRow(6);//UpdateValue
      }
  emit signal_qbetype_has_changed();
  }
  


void hk_kdeqbe::set_columnvalues(void)
{
  set_block_has_changed(true);
  clear_definition(false);
  for (int i=0;i<p_private->p_table->numCols();++i)
  {
    if ( ((QComboTableItem*)(p_private->p_table->item(1,i)))->currentItem()>0 // field
          || !(((QComboTableItem*)(p_private->p_table->item(1,i)))->text().isEmpty())
       )
     { 

        hk_qbedataclass cl;
	hk_datasource* ds=get_datasource_by_shortname(p_private->p_table->item(0,i)->text().local8Bit().data());
	if (ds)
	{
	  cl.table=ds->presentationnumber();
	}  else cl.table=-1;
	cl.field=p_private->p_table->item(1,i)->text().local8Bit().data();
	if (p_private->p_table->item(2,i))cl.alias=p_private->p_table->item(2,i)->text().local8Bit().data();
	switch(((QComboTableItem*)(p_private->p_table->item(3,i)))->currentItem())
	{
	  case 0: cl.functiontype=ft_group;break;
	  case 1: cl.functiontype=ft_sum;break;
	  case 2: cl.functiontype=ft_count;break;
	  case 3: cl.functiontype=ft_min;break;
	  case 4: cl.functiontype=ft_max;break;
	  case 5: cl.functiontype=ft_condition;break;
	}
	switch(((QComboTableItem*)(p_private->p_table->item(4,i)))->currentItem())
	{
	  case 0: cl.order=none;break;
	  case 1: cl.order=ascending;break;
	  case 2: cl.order=descending;break;
	}
	cl.show=(((QComboTableItem*)(p_private->p_table->item(5,i)))->currentItem()==0);
	
	
	if (p_private->p_table->item(6,i))cl.updatevalue=p_private->p_table->item(6,i)->text().local8Bit().data();
	int endconditions=7;
	for (int c=7;c<maxrows;++c)
	  {
	    hk_string condi= trim(p_private->p_table->text(c,i).local8Bit().data());
	    if (condi.size()>0) endconditions=c; 
	  
	  }
	
         for(int c=7;c<=endconditions;++c)
	 	{
		  hk_string condi= trim(p_private->p_table->text(c,i).local8Bit().data());
		  cl.conditions.insert(cl.conditions.end(),condi);
		}
        add_definition(&cl);
     }  
  }
  set_block_has_changed(false);
}

void hk_kdeqbe::loaddata(const hk_string& definition)
{
   hk_qbe::loaddata(definition);
   list<hk_qbe::hk_qbedataclass>::const_iterator it=definitionlist()->begin();
   int counter=0;
   set_tablenames();
   while (it!=definitionlist()->end())
   {  
	QComboTableItem* item=(QComboTableItem*)(p_private->p_table->item(0,counter));
        int i=p_private->p_tablenames.findIndex(QString::fromLocal8Bit(unique_shortdatasourcename((*it).table).c_str()));
        if (i>-1)
	   { 
	      item->setCurrentItem(i);  // set tablename
	      set_columnnames(counter);
	   }
	
	item=(QComboTableItem*)(p_private->p_table->item(1,counter));
        
	i=-1;
	for (int k=0;k<item->count();++k)
	  {
	    if (item->text(k)==QString::fromLocal8Bit((*it).field.c_str()))
	      i=k;
	  }
        if (i>-1)
	   { 
	      item->setCurrentItem(i);  // set fieldname
	   }
	 if ((*it).table==-1) 
	  {
	    QStringList strlist;
            strlist.append("");
	    strlist.append(QString::fromLocal8Bit((*it).field.c_str()));
            item->setEditable(true);
	    item->setStringList(strlist);
	    item->setCurrentItem(1);
	  } 
	//set alias
	p_private->p_table->setText(2,counter,QString::fromLocal8Bit((*it).alias.c_str()));   
        
	//set functiontype
	i=0;
	switch ((*it).functiontype)
	{
	case ft_group:i=0;break;
	case ft_sum:i=1;break;
	case ft_count:i=2;break;
	case ft_min:i=3;break;
	case ft_max:i=4;break;
	case ft_avg:i=5;break;
	case ft_condition:i=6;break;
        }
	item=(QComboTableItem*)(p_private->p_table->item(3,counter));
	item->setCurrentItem(i);
	
	// set order
	item=(QComboTableItem*)(p_private->p_table->item(4,counter));
	switch ((*it).order)
	{
	case none: i=0;break;
	case ascending: i=1;break;
	case descending: i=2;break;
	}
	item->setCurrentItem(i);
	
	//set show
	item=(QComboTableItem*)(p_private->p_table->item(5,counter));
	if ((*it).show) i=0; else i=1;
	item->setCurrentItem(i);
	//set updatevalue
	p_private->p_table->setText(6,counter,QString::fromLocal8Bit((*it).updatevalue.c_str()));   
        vector<hk_string>::iterator condit;
	vector<hk_string> l=(*it).conditions;
	condit=l.begin();
	i=7;
	while( condit!=l.end())
	{
	 p_private->p_table->setText(i,counter,QString::fromLocal8Bit((*condit).c_str()));
	 ++condit;++i;
	}
       
    ++it;++counter;
   }
  emit (signal_distinct_has_changed());
}



void hk_kdeqbe::add_column(int pos, int table, const hk_string& columnname)
{
//return;

p_private->p_table->insertColumns(pos);
init_column(pos);
init_tablenames(pos);
int i=p_private->p_tablenames.findIndex(QString::fromLocal8Bit(unique_shortdatasourcename(table).c_str()));
QComboTableItem* item=(QComboTableItem*)(p_private->p_table->item(0,pos));
if (i>-1)
   {  
      item->setCurrentItem(i);  // set tablename
      set_columnnames(pos);
   }

item=(QComboTableItem*)(p_private->p_table->item(1,pos));
        
i=-1;
for (int k=0;k<item->count();++k)
  {
    if (item->text(k)==QString::fromLocal8Bit(columnname.c_str()))
      i=k;
  }
   if (i>-1)
   { 
      item->setCurrentItem(i);  // set fieldname
   }
 p_private->p_table->setCurrentCell(p_private->p_table->currentRow(),pos);  
   
}



void hk_kdeqbe::distinct_changed(void)
{
  set_distinct(!distinct());
}

