// ****************************************************************************
// copyright (c) 2000-2004 Horst Knorr <hk_classes@knoda.org>
// This file is part of the hk_kdeclasses library.
// This file may be distributed and/or modified under the terms of the
// GNU Library Public License version 2 as published by the Free Software
// Foundation and appearing in the file LGPL included in the
// packaging of this file.
// This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
// ****************************************************************************
//$Revision: 1.86 $
#include "hk_kdesimpleform.h"
#include "hk_kdeform.h"
#include "hk_kdegrid.h"
#include "hk_kdesimplegrid.h"
#include "hk_kdelineedit.h"
#include "hk_kdeboolean.h"
#include "hk_kdesimpleform.moc"
#include "hk_kderowselector.h"
#include "hk_kdememo.h"
#include "hk_kdebutton.h"
#include "hk_kdecombobox.h"
#include "hk_kdeformfocus.h"
#include "hk_kdeproperty.h"
#include "hk_kdelabel.h"
#include "hk_kdegridpart.h"
#include "hk_kdedbdesigner.h"

#include "hk_visible.h"
#include "hk_dsvisible.h"
#include "hk_datasource.h"

#include <qkeycode.h>
#include <qpopupmenu.h>
#include <qfocusdata.h>
#include <qpainter.h>
#include <qevent.h>
#include <qcolor.h>
#include <kparts/partmanager.h>
#include <klocale.h>
#include <kaction.h>
#include <qdragobject.h>
#include <qclipboard.h>
#include <qimage.h>
#include <qpixmap.h>
#include <kdockwidget.h>
#include <kglobal.h>
#include <kiconloader.h>
#include <kparts/genericfactory.h>

#ifdef HAVE_SSTREAM
#include <sstream>
#else
#include <strstream.h>
#endif


class hk_kdesimpleformprivate
{
public:
hk_kdesimpleformprivate()
   {
     while_modechange=false;
     p_dbdesigneraction=NULL;
     p_designer=NULL;
     p_propertydock=NULL;
   }

 ~hk_kdesimpleformprivate()
   {
    if (p_designer) delete p_designer;
   }

bool while_modechange;
hk_kdedbdesignerwindow* p_designer;
KAction * p_dbdesigneraction;
KDockWidget* p_propertydock;
};



hk_kdesimpleform::hk_kdesimpleform(QWidget* wid) :QWidget(wid),hk_form()
{
#ifdef HK_DEBUG
    hkclassname("hk_kdesimpleform");
    hkdebug("hk_kdesimpleform::hk_kdesimpleform");
#endif
//	setBackgroundMode(PaletteMid);
     p_private=new hk_kdesimpleformprivate;
    p_partsmanager= new KParts::PartManager(this);

    setFixedWidth(p_actualwidth);
    setFixedHeight(p_actualheight);
    p_autoclose=true;
    p_field2create=other;
    p_property=NULL;
    p_focus = new hk_kdeformfocus(this);
    p_createflag=false;
    p_controlbutton=false;
    setFocusPolicy(StrongFocus);
    setFocus();
    p_kdeform=NULL;
    p_popup=NULL;
    p_sourcevanishflag=false;
    p_deleteaction=NULL;
    p_copyaction=NULL;
    p_pasteaction=NULL;
    p_cutaction=NULL;
    p_formpropertyaction=NULL;
    p_resizeaction=NULL;
    p_minwidthaction=NULL;
    p_maxwidthaction=NULL;
    p_minheightaction=NULL;
    p_maxheightaction=NULL;
    p_minsizeaction=NULL;
    p_maxsizeaction=NULL;
    p_alignaction=NULL;
    p_alignleftaction=NULL;
    p_alignrightaction=NULL;
    p_aligntopaction=NULL;
    p_alignbottomaction=NULL;

    connect (QApplication::clipboard(), SIGNAL(dataChanged()),this, SLOT(enable_actions()));
    QColor qcolor=paletteBackgroundColor();
    hk_colour colour(qcolor.red(),qcolor.green(),qcolor.red());
    set_backgroundcolour(colour,false,true);
    qcolor=paletteForegroundColor();
    colour.set_colour(qcolor.red(),qcolor.green(),qcolor.red());
    set_foregroundcolour(colour,false,true);
}


hk_kdesimpleform::~hk_kdesimpleform(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdesimpleform::~hk_kdesimpleform");
#endif
    delete p_focus;
    //delete p_property;
    
    while(p_partsmanager->activePart())
    {
       p_partsmanager->removePart(p_partsmanager->activePart());
    }
    
    delete p_partsmanager;
    delete p_deleteaction;
    delete p_copyaction;
    delete p_pasteaction;
    delete p_cutaction;
    delete p_private;
    p_private=NULL;
}


hk_dsgrid*  hk_kdesimpleform::widget_specific_new_grid(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdesimpleform::widget_specific_new_grid(void)");
#endif
    KLibFactory* p_factory= KLibLoader::self()->factory( "libhk_kdegridpart" );
    KParts::ReadWritePart* p_part=(KParts::ReadWritePart*) p_factory->create (this, "hk_kdegridpart", "KParts::ReadWritePart");
   if (!p_part)
    {
     show_warningmessage(hk_translate("Fatal error! Grid part could not be loaded!\nThis is a installation error. Check your installation!\
 Did you install knoda into the correct directory? Program will exit now...")); 
     exit(1);
    } 
 
    p_partsmanager->addPart(p_part);
    hk_kdegrid* g=p_part?(hk_kdegrid*)p_part->widget():new hk_kdegrid(this,0,0,this);
    if (g==NULL) return NULL;
    g->show();
#ifdef HK_DEBUG
    g->hkclassname("hk_kdegrid");
#endif
//	set_focus(g);
    connect(g->simplegrid(),SIGNAL(signal_infocus(hk_kdegridpart*)),this,SLOT(grid_partinfocus(hk_kdegridpart*)));
    connect (g->simplegrid(), SIGNAL(signal_outfocus(hk_kdegridpart*)),this,SLOT(grid_partoutfocus(hk_kdegridpart*)));

    return g;
}


hk_dslineedit*      hk_kdesimpleform::widget_specific_new_lineedit(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdesimpleform::widget_specific_new_lineedit(void)");
#endif
    hk_kdelineedit* l=new hk_kdelineedit(this,this);
    l->show();
#ifdef HK_DEBUG
    l->hkclassname("lineedit");
#endif
//	set_focus(l);
    return l;
}


hk_dsboolean*       hk_kdesimpleform::widget_specific_new_bool(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdesimpleform::widget_specific_new_bool(void)");
#endif
    hk_kdeboolean* b=new hk_kdeboolean(this,this);
    b->show();
#ifdef HK_DEBUG
    b->hkclassname("bool");
#endif
    b->setBackgroundMode(backgroundMode());
//	set_focus(b);
    return b;
}


hk_dscombobox*      hk_kdesimpleform::widget_specific_new_combobox(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdesimpleform::widget_specific_new_combobox(void)");
#endif
    hk_kdecombobox* c=new hk_kdecombobox(this,this);
    c->show();
#ifdef HK_DEBUG
    c->hkclassname("combobox");
#endif
//	set_focus(c);
    return c;
}


hk_dsmemo*      hk_kdesimpleform::widget_specific_new_memo(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdesimpleform::widget_specific_new_memo(void)");
#endif
    hk_kdememo* m=new hk_kdememo(this,this);
    m->show();
#ifdef HK_DEBUG
    m->hkclassname("memo");
#endif
//	set_focus(m);
    return m;
}


hk_button*      hk_kdesimpleform::widget_specific_new_button(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdesimpleform::widget_specific_new_button(void)");
#endif
    hk_kdebutton* b=new hk_kdebutton(this,this);
    b->show();
#ifdef HK_DEBUG
    b->hkclassname("button");
#endif
    return b;
}


hk_dsrowselector*   hk_kdesimpleform::widget_specific_new_rowselector(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdesimpleform::widget_specific_new_rowselector(void)");
#endif
    hk_kderowselector* s=new hk_kderowselector(this,this);
    s->show();
#ifdef HK_DEBUG
    s->hkclassname("rowselector");
#endif
    return s;
}


hk_label* hk_kdesimpleform::widget_specific_new_label(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdesimpleform::widget_specific_new_lineedit(void)");
#endif
    hk_kdelabel* s=new hk_kdelabel(this);
    s->show();
#ifdef HK_DEBUG
    s->hkclassname("label");
#endif
    s->setBackgroundMode(backgroundMode());
    return s;
}


void    hk_kdesimpleform::widget_specific_fieldresize(hk_visible* v)
{
 if (!v ||!p_property) return;
 if (v==p_property->object())
 	{
	//p_property->set_visible();
	p_property->set_geometry();
	}
}


void    hk_kdesimpleform::widget_specific_presentationresize(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdesimpleform::widget_specific_presentationresize");
#endif
    setFixedWidth(p_actualwidth);
    setFixedHeight(p_actualheight);
}


void hk_kdesimpleform::before_source_vanishes(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdesimpleform::before_source_vanishes");
#endif
    bool doemit=false;
    if (p_kdeform) p_kdeform->save_form_when_changed();
    hk_form::before_source_vanishes();
    
   QWidget* p=parentWidget();
 
    if (p_autoclose &&!p_sourcevanishflag)
    {
        if (p!=NULL)
        {
            doemit=true;
        }
    }
    p_sourcevanishflag=true;

if (doemit)
 {
   reparent(0L,WDestructiveClose,QPoint(0,0));
    if (p_kdeform)
      {hk_kdeform* k=p_kdeform;
       set_kdeform(NULL);
       k->close();
      } 
    else p->close();
   close();
}
}


void hk_kdesimpleform::database_has_vanished(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdesimpleform::database_has_vanished");
#endif
    bool doemit=false;
    hk_form::database_has_vanished();
   QWidget* p=parentWidget();
    
    if (p_autoclose&&!p_sourcevanishflag)
    {
        if (parentWidget()!=NULL)
        {
            doemit=true;
        }
    }
    p_sourcevanishflag=true;
if (doemit)
 {
   reparent(0L,WDestructiveClose,QPoint(0,0));
    if (p_kdeform)
      {hk_kdeform* k=p_kdeform;
       set_kdeform(NULL);
       k->close();
      } 
    else p->close();
   close();
}
}


void    hk_kdesimpleform::mousePressEvent(QMouseEvent* m)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdesimpleform::mousePressEvent");
#endif
    if (mode()==designmode)
    {
        switch (m->button())
        {
            case LeftButton:
            {
                emit mouseclick(m->pos());
                if (p_field2create!=other)create_field(m->pos());
                else
                {
                    clearfocus();
                    if (p_property!=NULL) p_property->set_object(this);
                }
                break;
            }

            case RightButton:
            {
                mousemenu(m);
                break;
            }
            default:      ;
        }
    }
    else
    { //viewmode
    //execute script
      if (m->button()== LeftButton) action_on_click();
    }
    QWidget::mousePressEvent(m);
}


void    hk_kdesimpleform::mouseReleaseEvent(QMouseEvent* )
{
}


void hk_kdesimpleform::set_field2create(enum_visibletype v)
{
    p_field2create=v;

}


void hk_kdesimpleform::create_field(const QPoint& position)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdesimpleform::create_field");
#endif
    hk_visible* newfield=NULL;
    QPoint point=position;
	if (snap2gridx()>0&&point.x()%snap2gridx()>0&&!p_controlbutton)
		point.setX(point.x()-point.x()%snap2gridx());
	if (snap2gridy()>0&&point.y()%snap2gridy()>0&&!p_controlbutton)
		point.setY(point.y()-point.y()%snap2gridy());

    switch (p_field2create)
    {
        case lineedit : newfield = new_lineedit();
        break;
        case textlabel : newfield = new_label();
        break;
        case button : newfield = new_button();
        break;
        case rowselector : newfield = new_rowselector();
        break;
        case memo : newfield = new_memo();
        break;
        case boolean : newfield = new_bool();
        break;
        case grid : newfield = new_grid();
        break;
        case combobox : newfield = new_combobox();
        break;
        default:;

    }
    if (newfield!=NULL)
    {
        if (sizetype()==hk_presentation::relative)
	{
	newfield->set_position((point.x()*10000)/QWidget::width(),(point.y()*10000)/QWidget::height());
        if (newfield->type()==grid)
            newfield->set_size((point.x()*10000)/QWidget::width(),(point.y()*10000)/QWidget::height(),4000,3000);
	}
	else
	{
        if (newfield->type()==grid||newfield->type()==memo)
            newfield->set_size((unsigned int)point.x(),(unsigned int)point.y(),300,200);
	else
		newfield->set_size((unsigned int)point.x(),(unsigned int)point.y(),100,30);

	}
        set_focus(dynamic_cast <QWidget*>(newfield));
    }
#ifdef HK_DEBUG
    hkdebug("hk_kdesimpleform::create_field focus setzen");
#endif
    p_focus->set_positions();
    p_createflag=true;
    emit field_created();
    p_field2create=other;
}


void hk_kdesimpleform::paintEvent(QPaintEvent* e)
{
    if (mode()==hk_presentation::viewmode)
    {
        QWidget::paintEvent(e) ;
        return;
    }

    QPainter p(this);
    p.setClipRegion( e->rect() );
    p.setPen( colorGroup().background() );
    p.setPen( colorGroup().foreground() );
    for (int a=0; a<QWidget::width()/10+20; a++ )
    {
        for (int b=0; b<QWidget::height()/10+20;b++ )
            p.drawPoint(a*10,b*10);
    }

}


bool hk_kdesimpleform::eventFilter(QObject* object,QEvent* event)
{
    if (   mode()!=designmode
        ||!object->isWidgetType()
        )
        return QWidget::eventFilter(object,event);
    hk_visible* v = dynamic_cast <hk_visible*>(object);
    hk_visible* p = dynamic_cast <hk_visible*> ( ((QWidget*) object)->parentWidget() );
    if ((v==NULL&& p==NULL)|| dynamic_cast <hk_marker*>(object)!=NULL||!is_formobject((QWidget*) object))
    {
        return QWidget::eventFilter(object,event);
    }
    return formeventFilter(object,event);
}


bool hk_kdesimpleform::formeventFilter(QObject* object,QEvent* event)
{
#ifdef HK_DEBUG
//hkdebug("hk_kdesimpleform::formeventFilter");
#endif
    QWidget* widget= (QWidget*) object;
// check for special widget treatment

    if (dynamic_cast <hk_visible*>(object) == NULL)
    {
        widget = widget->parentWidget();
        QWidget* object =widget;
        while (object!=NULL)
        {
            if (dynamic_cast <hk_kdegrid*>(object)!=NULL)
            {
                widget=object;
                object=NULL;
            }
            else    object=object->parentWidget();
        }
    }
    else
    {
        QWidget* object =widget;
        while (object!=NULL)
        {
            if (dynamic_cast <hk_kdegrid*>(object)!=NULL)
            {
                widget=object;
                object=NULL;
            }
            else    object=object->parentWidget();
        }
    }

    if (dynamic_cast <hk_kderowselector*>(widget)!=NULL)
    {
        if (dynamic_cast <hk_kdegrid*>(widget->parentWidget())!=NULL)
            widget = widget->parentWidget();
    }

// ENDE check for special widget treatment

    switch (event->type())
    {
        case QEvent::KeyPress        :
        {
            keyPressEvent((QKeyEvent*)event);
            break;
        };
        case QEvent::KeyRelease      :
        {
            keyReleaseEvent((QKeyEvent*)event);
            break;
        };
        case QEvent::MouseButtonPress    :
        {

            if (object==this)
            {
                if (((QMouseEvent*)event)->button() !=RightButton)
                {
                    mousePressEvent((QMouseEvent*) event);
                    return true;
                }
            }
            else
            if (((QMouseEvent*)event)->button() ==LeftButton)
            {                                     //select object
                                                  // i.e. a menu
                if ( dynamic_cast <QPopupMenu*>(object))
                    return QWidget::eventFilter(object,event);

                set_focus(widget);
                if (widget!=NULL)p_focus->show();
                p_originalposition=mapFromGlobal(((QMouseEvent*)event)->globalPos());
		if (snap2gridx()>0&&p_originalposition.x()%snap2gridx()>0&&!p_controlbutton)p_originalposition.setX(p_originalposition.x()-p_originalposition.x()%snap2gridx());
		if (snap2gridy()>0&&p_originalposition.y()%snap2gridy()>0&&!p_controlbutton)p_originalposition.setY(p_originalposition.y()-p_originalposition.y()%snap2gridy());
                return true;
            }
            else
            if (((QMouseEvent*)event)->button() ==RightButton)
            {
                mousemenu((QMouseEvent*)event);
                return true;
            }
            break;
        };
        case QEvent::MouseMove       :
        {
            if (
                (((QMouseEvent*)event)->state() & LeftButton ) == LeftButton&&
                widget==p_focus->widget()
                )
            {
//move object
                QPoint newpos=mapFromGlobal(((QMouseEvent*)event)->globalPos());
		if (snap2gridx()>0&&newpos.x()%snap2gridx()>0&&!p_controlbutton)
			newpos.setX(newpos.x()-newpos.x()%snap2gridx());
		if (snap2gridy()>0&&newpos.y()%snap2gridy()>0&&!p_controlbutton)
			newpos.setY(newpos.y()-newpos.y()%snap2gridy());
		QPoint difference=p_originalposition-newpos;
		QPoint buf=p_originalposition;
                p_originalposition=newpos;
                if ( widget->x()-difference.x()<0)
		    {
		      difference.setX(widget->x());
		      p_originalposition.setX(buf.x());
		    }
                if ( widget->y()-difference.y()<0)
		    {
		     difference.setY(widget->y());
		      p_originalposition.setY(buf.y());
		    }
                if ( widget->x()+widget->width()-difference.x()>(signed)designwidth())
                    difference.setX(-(designwidth()-widget->x()-widget->width()));
                if ( widget->y()+widget->height()-difference.y()>(signed)designheight())
                    difference.setY(-(designheight()-widget->y()-widget->height()));
                widget->move(widget->x()-difference.x(),widget->y()-difference.y());
                p_focus->set_positions();
                p_property->focus_resized();
            }
            break;
        };

        case QEvent::MouseButtonDblClick : return true;
        default              :;

    }

    return QWidget::eventFilter(object,event);

}


void hk_kdesimpleform::widget_specific_modechanges(enum_mode s)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdesimpleform::widget_specific_modechanges");
#endif
    list<hk_kdeformfocus*>::iterator it=p_multiplefocus.begin();

    if(s==designmode)
    {
        setFocusPolicy(StrongFocus);
        setFocus();
        qApp->installEventFilter(this);
        show_property();
        if (p_focus->widget()!=NULL)
            p_property->set_object( dynamic_cast <hk_visible*> (p_focus->widget()));
        else p_property->set_object(this);
        while (it!=p_multiplefocus.end())
        {
            hk_kdeformfocus* f=(*it);
            f->show();
            it++;
        }
        p_focus->show();

    }
    else                                          // s!=design
    {
        qApp->removeEventFilter(this);
        while (it!=p_multiplefocus.end())
        {
            hk_kdeformfocus* f=(*it);
            f->hide();
            it++;
        }
        p_focus->hide();
        if(p_property!=NULL) 
	  {
	       if (p_private->p_propertydock)
	       {
                 if (p_private->p_propertydock->mayBeHide())
		    p_private->p_propertydock->changeHideShowState();
		 //p_private->p_propertydock->hide();
	       }	 
               else
	       p_property->hide();
	  }
        setFocusPolicy(ClickFocus);

    }
    enable_actions();
}


void hk_kdesimpleform::widget_specific_after_loadform(void)
{
    clearfocus();
    qApp->processEvents();
}


void hk_kdesimpleform::clearmultiplefocus(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdesimpleform::clearmultiplefocus");
#endif
    list<hk_kdeformfocus*>::iterator it=p_multiplefocus.begin();
    while (it!=p_multiplefocus.end())
    {
        hk_kdeformfocus* f=(*it);
        it++;
        if (f!=p_focus) delete f;
    }
    p_multiplefocus.erase(p_multiplefocus.begin(),p_multiplefocus.end());
}


void hk_kdesimpleform::keyPressEvent ( QKeyEvent * event )
{
#ifdef HK_DEBUG
    hkdebug("hk_kdesimpleform::keyPressEvent");
#endif
    switch(event->key())
    {
        case Key_Control:  p_controlbutton=true;
        break;
   case Key_Left:
            if (p_focus &&p_focus->widget()&&mode()==designmode)
            {
              hk_visible* widget=dynamic_cast<hk_visible*>(p_focus->widget());
              if (widget)
              {
               unsigned int diff=(p_controlbutton?1:snap2gridx());
	       if (sizetype()==relative) diff =horizontal2relativ(diff);
               if (widget->x()>=diff) widget->set_x(widget->x()-diff);
              }

            }
break;
case Key_Right:
if (p_focus &&p_focus->widget()&&mode()==designmode)
{
hk_visible* widget=dynamic_cast<hk_visible*>(p_focus->widget());
if (widget)
{
   unsigned int diff=(p_controlbutton?1:snap2gridx());
	       if (sizetype()==relative) diff =horizontal2relativ(diff);
if (widget->x()+widget->width()+diff<=10000) widget->set_x(widget->x()+diff);
}

}
break;
case Key_Up:
if (p_focus &&p_focus->widget()&&mode()==designmode)
{
hk_visible* widget=dynamic_cast<hk_visible*>(p_focus->widget());
if (widget)
{
unsigned int diff=(p_controlbutton?1:snap2gridy());
	       if (sizetype()==relative) diff =vertical2relativ(diff);
if (widget->y()>=diff) widget->set_y(widget->y()-diff);
}

}
break;
case Key_Down:
if (p_focus &&p_focus->widget()&&mode()==designmode)
{
hk_visible* widget=dynamic_cast<hk_visible*>(p_focus->widget());
if (widget)
{
unsigned int diff=(p_controlbutton?1:snap2gridy());
	       if (sizetype()==relative) diff =vertical2relativ(diff);
if (widget->y()+widget->height()+diff<=10000) widget->set_y(widget->y()+diff);
}

}
break;
        default  :     ;
    }
    QWidget::keyPressEvent(event);

}


void hk_kdesimpleform::keyReleaseEvent ( QKeyEvent * event)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdesimpleform::keyReleaseEvent");
#endif
    if (event->key()==Key_Control)  p_controlbutton=false;
    QWidget::keyReleaseEvent(event);

}


void hk_kdesimpleform::clearfocus(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdesimpleform::clearfocus");
#endif
    if (p_focus!=NULL) p_focus->set_widget(NULL);
    p_controlbutton=false;
    clearmultiplefocus();
    enable_actions();

}


void hk_kdesimpleform::set_focus(QWidget*f)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdesimpleform::set_focus");
#endif
    if (f==NULL || f==this)
    {
        clearfocus();
        return;
    }
    if (p_controlbutton==true)
    {

        if (p_focus->widget()==f )
        {
            return;
        }
        list<hk_kdeformfocus*>::iterator it=p_multiplefocus.begin();
        while (it!=p_multiplefocus.end())         //check if widget is already set
        {
            hk_kdeformfocus* w=(*it);
            it++;
            if (w->widget()==f) return;
        }

    }

    if (p_controlbutton==true&& p_focus->widget()!=NULL &&p_focus->widget()!=this)
    {
        p_multiplefocus.insert(p_multiplefocus.end(),p_focus);
        hk_kdeformfocus* pf=p_focus;
        p_focus = new hk_kdeformfocus(this);
        pf->repaint();
    }
    else clearmultiplefocus();
    p_focus->set_widget(f);
    enable_actions();
    hk_visible* v= dynamic_cast<hk_visible*>(f);
    if (p_property!=NULL)
    {
        QObject::connect(p_focus,SIGNAL(size_changed()),p_property,SLOT(focus_resized()));
        p_property->set_object(v);
    }

}


void hk_kdesimpleform::delete_widgets(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdesimpleform::delete_widgets");
#endif
    if (mode()!=designmode) return;

    QWidget* w=NULL;
    QWidget* del=NULL;

    list<hk_kdeformfocus*>::iterator it=p_multiplefocus.begin();
    while (it!=p_multiplefocus.end())
    {
        hk_kdeformfocus* f=(*it);
        it++;
        w=f->widget();
        del=w;
        f->set_widget(NULL);
        hk_kdegrid* g=dynamic_cast <hk_kdegrid*>(w);
        remove_visible(dynamic_cast <hk_visible*>(del));
        if (g)
        {
            delete g->part();

        }
        else     delete w;
    }
    w=p_focus->widget();
    del=w;
    p_focus->set_widget(NULL);
    hk_kdegrid* g=dynamic_cast <hk_kdegrid*>(w);
    remove_visible(dynamic_cast <hk_visible*>(del));
    if (g)delete g->part();else delete w;
    if (p_property!=NULL) p_property->set_object(this);
    clearfocus();
    set_has_changed();
}


void hk_kdesimpleform::mousemenu(QMouseEvent* m)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdesimpleform::mousemenu");
#endif

    if (p_popup!=NULL) return;
    p_popup=new QPopupMenu(this);
    if (p_multiplefocus.size()>0)
    {

        QPopupMenu* p_adjustsize =new QPopupMenu(this);
        QPopupMenu* p_align =new QPopupMenu(this);
        p_popup->insertItem( i18n( "Adjust &size" ),p_adjustsize,1 );
        p_popup->insertItem( i18n( "&Align" ),p_align,2 );

        p_adjustsize->insertItem( i18n( "Minimum width" ),3 );
        p_adjustsize->insertItem( i18n( "Maximum width" ),4 );
        p_adjustsize->insertItem( i18n( "Minimum height" ),5 );
        p_adjustsize->insertItem( i18n( "Maximum height" ),6 );
        p_adjustsize->insertItem( i18n( "Minimum size" ),7 );
        p_adjustsize->insertItem( i18n( "Maximum size" ),8 );

        p_align->insertItem( i18n( "&Left" ),9 );
        p_align->insertItem( i18n( "&Right" ),10 );
        p_align->insertItem( i18n( "&Top" ),11 );
        p_align->insertItem( i18n( "&Bottom" ),12);
    }
    QPopupMenu* p_settoall =new QPopupMenu(this);
    p_popup->insertItem(i18n("Set to all"),p_settoall,18);
    p_settoall->insertItem(i18n("Font"),19);
    p_settoall->insertItem(i18n("Foregroundcolour"),20);
    p_settoall->insertItem(i18n("Backgroundcolour"),21);

    if (p_focus->widget()!=NULL)
    {
        p_popup->insertItem( i18n( "&Delete" ),13 );
        p_popup->insertSeparator();
        p_popup->insertItem(i18n("Into background"),16);
        p_popup->insertItem(i18n("Into foreground"),17);
        p_popup->insertSeparator();
    }
    p_popup->insertItem( i18n( "Show &property editor" ),14 );
    p_popup->insertItem( i18n( "&Save form" ),15 );

    int r = p_popup->exec( m->globalPos() );
    switch (r)
    {
        case 3:       adjust_widgets(sminw);
        break;
        case 4:       adjust_widgets(smaxw);
        break;
        case 5:       adjust_widgets(sminh);
        break;
        case 6:       adjust_widgets(smaxh);
        break;
        case 7:       adjust_widgets(smins);
        break;
        case 8:       adjust_widgets(smaxs);;
        break;
        case 9:       adjust_widgets(al);
        break;
        case 10:      adjust_widgets(ar);
        break;
        case 11:      adjust_widgets(at);
        break;
        case 12:      adjust_widgets(ab);
        break;
        case 13:      delete_widgets();
        break;
        case 14:
        {
            show_property();
            break;
        }
        case 15:
        {
            save_form("",false);
            break;
        }
        case 16:
        {
            hk_visible* v=dynamic_cast<hk_visible*>(p_focus->widget());
            if (v)
            {
                v->lower_widget();
                p_focus->widget()->lower();
                p_focus->set_widget(p_focus->widget());
            }
            if (p_multiplefocus.size()>0)
            {
                list<hk_kdeformfocus*>::reverse_iterator it=p_multiplefocus.rbegin();
                while(it!=p_multiplefocus.rend())
                {

                    v=dynamic_cast<hk_visible*>((*it)->widget());
                    if (v)
                    {
                        v->lower_widget();
                        (*it)->widget()->lower();
                        ++it;
                    }
                }
            }

            break;
        }
        case 17:
        {
            if (p_multiplefocus.size()>0)
            {
                list<hk_kdeformfocus*>::iterator it=p_multiplefocus.begin();
                while(it!=p_multiplefocus.end())
                {

                    hk_visible* v=dynamic_cast<hk_visible*>((*it)->widget());
                    if (v)
                    {
                        v->raise_widget();
                        (*it)->widget()->raise();
                        ++it;
                    }
                }
            }

            hk_visible* v=dynamic_cast<hk_visible*>(p_focus->widget());
            if (v)
            {
                v->raise_widget();
                p_focus->widget()->raise();
                p_focus->set_widget(p_focus->widget());
            }
            break;
        }
        case 19 :   set_for_all(bulkfont);break;
        case 20:    set_for_all(bulkforeground);break;
        case 21:    set_for_all(bulkbackground);break;
        default:;
    }

    delete p_popup;
    p_popup=NULL;

}


void hk_kdesimpleform::show_property(void)
{

    if (mode()!=hk_presentation::designmode)return;
    bool newproperty=false;
    if (p_property==NULL)
    {   
         p_property=new hk_kdeproperty(this,0,false);
         if (p_kdeform)
        {
	 QPixmap p;
	 p_private->p_propertydock=p_kdeform->createDockWidget("Property editor",p,0L,"");
	 p_private->p_propertydock->setWidget(p_property);
	 p_private->p_propertydock->manualDock(p_kdeform->getMainDockWidget(),KDockWidget::DockRight);
	}
       newproperty=true;

    }
    if (p_property!=NULL)
    {   
     if (p_private->p_propertydock)
        {
	  //p_private->p_propertydock->makeDockVisible();
	     if (p_private->p_propertydock->mayBeShow())
	     p_private->p_propertydock->changeHideShowState();
          //p_private->p_propertydock->show();
	}  
     
     else
     p_property->show();
     //qApp->processEvents();
       if (newproperty)
       {
	int screenwidth=qApp->desktop()->availableGeometry(this).width();
	int screenheight=qApp->desktop()->availableGeometry(this).height();
	     if (!p_private->p_propertydock)
		p_property->move(screenwidth-p_property->frameGeometry().width(),
			 screenheight-p_property->frameGeometry().height());
	}
    }
}


void hk_kdesimpleform::adjust_widgets(hk_kdesimpleform::enum_adjust s)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdesimpleform::adjust_widgets");
#endif
    int maxw=0;
    int maxh=0;
    int minw=90000;
    int minh=90000;
    int minx=90000;
    int miny=90000;
    int maxx=0;
    int maxy=0;
    list<hk_kdeformfocus*>::iterator it=p_multiplefocus.begin();
    while (it!=p_multiplefocus.end())
    {
        hk_kdeformfocus* f=(*it);
        it++;
        QWidget* w=f->widget();
        if  (maxw <w->width()) maxw=w->width();
        if  (maxh <w->height()) maxh=w->height();
        if  (minw >w->width()) minw=w->width();
        if  (minh >w->height()) minh=w->height();
        if  (minx >w->x()) minx=w->x();
        if  (maxx <w->x()+w->width()) maxx=w->x()+w->width();
        if  (miny >w->y()) miny=w->y();
        if  (maxy <w->y()+w->height()) maxy=w->y()+w->height();

    }
    QWidget* w=p_focus->widget();
    if (w==NULL)
    {
        return;
    }
    if  (maxw <w->width()) maxw=w->width();
    if  (maxh <w->height()) maxh=w->height();
    if  (minw >w->width()) minw=w->width();
    if  (minh >w->height()) minh=w->height();
    if  (minx >w->x()) minx=w->x();
    if  (maxx <w->x()+w->width()) maxx=w->x()+w->width();
    if  (miny >w->y()) miny=w->y();
    if  (maxy <w->y()+w->height()) maxy=w->y()+w->height();

    it=p_multiplefocus.begin();
    while (it!=p_multiplefocus.end())
    {
        hk_kdeformfocus* f=(*it);
        it++;
        resize_widget(f->widget(),s,minw,maxw,minh,maxh,minx,maxx,miny,maxy);
    }

    resize_widget(p_focus->widget(),s,minw,maxw,minh,maxh,minx,maxx,miny,maxy);
    repaint_focus();
}


void hk_kdesimpleform::resize_widget(QWidget* w,enum_adjust s,int minw,int maxw,int minh,int maxh, int minx, int maxx, int miny, int maxy)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdesimpleform::resize_widget");
#endif
    switch (s)
    {
        case hk_kdesimpleform::sminw :  w->setGeometry(w->x(),w->y(),minw,w->height());
        break;
        case hk_kdesimpleform::smaxw :  w->setGeometry(w->x(),w->y(),maxw,w->height());
        break;
        case hk_kdesimpleform::sminh :  w->setGeometry(w->x(),w->y(),w->width(),minh);
        break;
        case hk_kdesimpleform::smaxh :  w->setGeometry(w->x(),w->y(),w->width(),maxh);
        break;
        case hk_kdesimpleform::smins :  w->setGeometry(w->x(),w->y(),minw,minh);
        break;
        case hk_kdesimpleform::smaxs :  w->setGeometry(w->x(),w->y(),maxw,maxh);
        break;
        case hk_kdesimpleform::al :  w->setGeometry(minx,w->y(),w->width(),w->height());
        break;
        case hk_kdesimpleform::ar :  w->setGeometry(maxx-w->width(),w->y(),w->width(),w->height());
        break;
        case hk_kdesimpleform::at :  w->setGeometry(w->x(),miny,w->width(),w->height());
        break;
        case hk_kdesimpleform::ab :  w->setGeometry(w->x(),maxy-w->height(),w->width(),w->height());
        break;
        default:;
    }

}


void hk_kdesimpleform::repaint_focus(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdesimpleform::repaint_focus");
#endif
    list<hk_kdeformfocus*>::iterator it=p_multiplefocus.begin();
    while (it!=p_multiplefocus.end())
    {
        hk_kdeformfocus* f=(*it);
        it++;
        f->set_positions();
    }
    p_focus->set_positions();
}


void hk_kdesimpleform::widget_specific_presentationdatasource(long p)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdesimpleform::widget_specific_new_presentationdatasource");
#endif
    if (p_kdeform!=NULL) p_kdeform->set_presentationdatasource(p,false);

}


void hk_kdesimpleform::set_kdeform(hk_kdeform* k)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdesimpleform::set_kdeform");
#endif
    p_kdeform=k;
    if (p_kdeform)
    {
    KIconLoader* loader=KGlobal::iconLoader();
    loader->addAppDir("hk_kdeclasses");
    p_deleteaction=new KAction(i18n("&Delete"),Key_Delete,this,SLOT(delete_widgets()),p_kdeform->actionCollection(),"deleteclicked");
    p_copyaction=new KAction(i18n("&Copy"),CTRL+Key_C,this,SLOT(copy()),p_kdeform->actionCollection(),"copy");
    p_pasteaction=new KAction(i18n("&Paste"),CTRL+Key_V,this,SLOT(paste()),p_kdeform->actionCollection(),"paste");
    p_cutaction=new KAction(i18n("Cu&t"),CTRL+Key_X,this,SLOT(cut()),p_kdeform->actionCollection(),"cutclicked");
    p_formpropertyaction=new KAction(i18n("&Propertyeditor"),loader->loadIcon("propertyeditor",KIcon::User),0,this,SLOT(show_property()),p_kdeform->actionCollection(),"viewproperty");

    p_resizeaction=new KActionMenu(i18n("Adjust &size"),0,p_kdeform->actionCollection(),"size");
    p_minwidthaction=new KAction(i18n("Minimum width"),0,0,this,SLOT(adjust_minw()),p_kdeform->actionCollection(),"minwidth");
    p_maxwidthaction=new KAction(i18n("Maximum width"),0,0,this,SLOT(adjust_maxw()),p_kdeform->actionCollection(),"maxwidth");
    p_minheightaction=new KAction(i18n("Minimum height"),0,0,this,SLOT(adjust_minh()),p_kdeform->actionCollection(),"minheight");
    p_maxheightaction=new KAction(i18n("Maximum height"),0,0,this,SLOT(adjust_maxh()),p_kdeform->actionCollection(),"maxheight");
    p_minsizeaction=new KAction(i18n("Minimum size"),0,0,this,SLOT(adjust_mins()),p_kdeform->actionCollection(),"minsize");
    p_maxsizeaction=new KAction(i18n("Maximum size"),0,0,this,SLOT(adjust_maxs()),p_kdeform->actionCollection(),"maxsize");
    p_resizeaction->insert(p_minwidthaction);
    p_resizeaction->insert(p_maxwidthaction);
    p_resizeaction->insert(p_minheightaction);
    p_resizeaction->insert(p_maxheightaction);
    p_resizeaction->insert(p_minsizeaction);
    p_resizeaction->insert(p_maxsizeaction);

    p_alignaction=new KActionMenu(i18n("&Align"),0,p_kdeform->actionCollection(),"align");
    p_alignleftaction=new KAction(i18n("&Left"),0,0,this,SLOT(align_left()),p_kdeform->actionCollection(),"alignleft");
    p_alignrightaction=new KAction(i18n("&Right"),0,0,this,SLOT(align_right()),p_kdeform->actionCollection(),"alignright");
    p_aligntopaction=new KAction(i18n("&Top"),0,0,this,SLOT(align_top()),p_kdeform->actionCollection(),"aligntop");
    p_alignbottomaction=new KAction(i18n("&Bottom"),0,0,this,SLOT(align_bottom()),p_kdeform->actionCollection(),"alignbottom");
    p_alignaction->insert(p_alignleftaction);
    p_alignaction->insert(p_alignrightaction);
    p_alignaction->insert(p_aligntopaction);
    p_alignaction->insert(p_alignbottomaction);
    p_private->p_dbdesigneraction=new KAction(i18n("Database designer"),loader->loadIcon("dbdesigner",KIcon::User),0,this,SLOT(dbdesignaction()),p_kdeform->actionCollection(),"dbdesigner");
   }
   else
   {
    delete p_deleteaction;
    delete p_copyaction;
    delete p_pasteaction;
    delete p_cutaction;
    delete p_formpropertyaction;

    delete p_resizeaction;
    delete p_minwidthaction;
    delete p_maxwidthaction;
    delete p_minheightaction;
    delete p_maxheightaction;
    delete p_minsizeaction;
    delete p_maxsizeaction;
    delete p_alignaction;
    delete p_alignleftaction;
    delete p_alignrightaction;
    delete p_aligntopaction;
    delete p_alignbottomaction;
    delete p_private->p_dbdesigneraction;

    
    p_deleteaction=NULL;
    p_copyaction=NULL;
    p_pasteaction=NULL;
    p_cutaction=NULL;
    p_formpropertyaction=NULL;

    p_resizeaction=NULL;
    p_minwidthaction=NULL;
    p_maxwidthaction=NULL;
    p_minheightaction=NULL;
    p_maxheightaction=NULL;
    p_minsizeaction=NULL;
    p_maxsizeaction=NULL;
    p_alignaction=NULL;
    p_alignleftaction=NULL;
    p_alignrightaction=NULL;
    p_aligntopaction=NULL;
    p_alignbottomaction=NULL;
    p_private->p_dbdesigneraction=NULL;
   
   }
}


bool hk_kdesimpleform::is_formobject(QWidget* v)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdesimpleform::is_formobject");
#endif
    QWidget* object =v;

    while (object!=NULL)
    {
        if (object==this) return true;
        if (object==p_property) return false;
        object=object->parentWidget();

    }

    return false;
}


void hk_kdesimpleform::create_copydata(ostream& stream,QWidget*w)
{
    hk_string vistag="FORMOBJECT";
#ifdef HAVE_SSTREAM
    stringstream tststream;
#else
    strstream tststream;
#endif
    hk_string tststring;
    if (w)
    {
        hk_visible* v = dynamic_cast<hk_visible*> (w);
        if (v)
        {
            start_mastertag(stream,vistag);
            v->savedata(stream);
            v->savedata(tststream);
            end_mastertag(stream,vistag);
        };

    };

}


void hk_kdesimpleform::copy_widgets(void)
{
    if (mode()!=designmode) return;
    if (!p_focus || !p_focus->widget()) return;
    QStoredDrag* p_drag = new QStoredDrag("application/x-hk_kdesimpleformcopy");
    hk_string cpyinfo;
#ifdef HAVE_SSTREAM
    stringstream stream;
#else
    strstream stream;
#endif

    list<hk_kdeformfocus*>::iterator it=p_multiplefocus.begin();
    while (it!=p_multiplefocus.end())
    {
        create_copydata(stream,(*it)->widget());
        it++;
    }
    if (p_focus) create_copydata(stream,p_focus->widget());
    char c;
    while (stream.get(c))
    {
        cpyinfo+=c;
    }
//cout <<"cpyinfo "<<endl<<cpyinfo <<endl;

    QCString cstr =cpyinfo.c_str();
    p_drag->setEncodedData(cstr);
    QApplication::clipboard()->setData(p_drag);

}


void hk_kdesimpleform::paste_widgets(void)
{
    if (!QApplication::clipboard()->data()) return;
    if (!QApplication::clipboard()->data()->encodedData("application/x-hk_kdesimpleformcopy"))return ;
    clearfocus();
    p_controlbutton=true;
    hk_string definition=u2l(QApplication::clipboard()->data()->encodedData("application/x-hk_kdesimpleformcopy").data());
    cout <<"einzufgen=:"<<endl<<definition<<endl<<"ENDE"<<endl;
    int i=1;
    hk_string value;
    hk_string buffer2;
    while (get_tagvalue(definition,"FORMOBJECT",value,i))
    {
        get_tagvalue(value,"VISIBLETYPE",buffer2);
        hk_visible* vis=new_object(buffer2);
        if (vis!=NULL)
        {
            vis->set_load_presentationnumber(false);
            vis->loaddata(value);
            register_object(vis);
            QWidget* w=dynamic_cast<QWidget*>(vis);
            if (w)set_focus(w);
        }
        i++;
    }

}


void hk_kdesimpleform::cut_widgets(void)
{
    copy_widgets();
    delete_widgets();

}


void hk_kdesimpleform::enable_actions(void)
{
    if (mode()==viewmode)
    {
        if (p_copyaction)p_copyaction->setEnabled(true);
        if (p_cutaction)p_cutaction->setEnabled(false);
        if (p_pasteaction)p_pasteaction->setEnabled(true);
        if (p_deleteaction)p_deleteaction->setEnabled(false);
	if (p_private->p_dbdesigneraction) p_private->p_dbdesigneraction->setEnabled(false);

    }
    else
    {                                             //designmode
        if (p_copyaction)p_copyaction->setEnabled(p_focus&&p_focus->widget());
        if (p_cutaction)p_cutaction->setEnabled(p_focus&&p_focus->widget());
        if (p_deleteaction)p_deleteaction->setEnabled(p_focus&&p_focus->widget());
        if (p_pasteaction) p_pasteaction->setEnabled(QApplication::clipboard()->data()&&QApplication::clipboard()->data()->provides("application/x-hk_kdesimpleformcopy"));
	if (p_private->p_dbdesigneraction) p_private->p_dbdesigneraction->setEnabled(true);

    }
    if (p_resizeaction) p_resizeaction->setEnabled(mode()==designmode&&p_multiplefocus.size()>0);
    if (p_alignaction) p_alignaction->setEnabled(mode()==designmode&&p_multiplefocus.size()>0);

}


bool    hk_kdesimpleform::set_mode(enum_mode s)
{
    if (p_private->while_modechange) return true;
    p_private->while_modechange=true;
    bool r=hk_form::set_mode(s);

   if (s==hk_presentation::viewmode)
    {
        p_formpropertyaction->setEnabled(false);
	if (p_private->p_designer)
		{
			delete p_private->p_designer;
			p_private->p_designer=NULL;
		}

    }
    else
    {
        p_formpropertyaction->setEnabled(true);

    }
    p_kdeform->set_mode(s);
    p_private->while_modechange=false;

    return r;

}


void hk_kdesimpleform::align_left(void)
{
    adjust_widgets(al);
}


void hk_kdesimpleform::align_right(void)
{
    adjust_widgets(ar);
}


void hk_kdesimpleform::align_top(void)
{
    adjust_widgets(at);
}


void hk_kdesimpleform::align_bottom(void)
{
    adjust_widgets(ab);
}


void hk_kdesimpleform::adjust_minw(void)
{
    adjust_widgets(sminw);
}


void hk_kdesimpleform::adjust_maxw(void)
{
    adjust_widgets(smaxw);
}


void hk_kdesimpleform::adjust_minh(void)
{
    adjust_widgets(sminh);
}


void hk_kdesimpleform::adjust_maxh(void)
{
    adjust_widgets(smaxh);
}


void hk_kdesimpleform::adjust_mins(void)
{
    adjust_widgets(smins);
}


void hk_kdesimpleform::adjust_maxs(void)
{
    adjust_widgets(smaxs);
}


void    hk_kdesimpleform::widget_specific_backgroundcolour_changed(const hk_colour& oldcolour)
{
    hk_colour c=backgroundcolour();
    QColor newcolour(c.red(),c.green(),c.blue());
    setPaletteBackgroundColor(newcolour);
    list<hk_visible*>::iterator it=visibles()->begin();
    while (it!=visibles()->end())
    {
        switch ((*it)->type())
        {
            case textlabel :;
            case boolean :   if ((*it)->backgroundcolour()==oldcolour)
            (*it)->set_backgroundcolour(backgroundcolour());
            break;
            default:;

        }

        ++it;
    }

}


void    hk_kdesimpleform::widget_specific_foregroundcolour_changed(const hk_colour&)
{
    hk_colour c=foregroundcolour();
    QColor newcolour(c.red(),c.green(),c.blue());
    setPaletteForegroundColor(newcolour);

}


void hk_kdesimpleform::set_for_all(enum_bulkoperation bulk)
{
    if (p_focus)
    {
        hk_visible* v= dynamic_cast<hk_visible*>(p_focus->widget());
        if (v)
        {
            switch (bulk)
            {
                case bulkforeground : set_foregroundcolour(v->foregroundcolour());
                break;
                case bulkbackground : set_backgroundcolour(v->backgroundcolour());
                break;
                case bulkfont: set_font(v->font());

            }
        }
    }
    bulk_operation(bulk);

}

hk_kdeproperty* hk_kdesimpleform::propertyeditor(void)
{
   return p_property;
}


hk_kdeform* hk_kdesimpleform::kdeform()
{
   return p_kdeform;
}


void hk_kdesimpleform::script_error(hk_visible* v, hk_interpreter::enum_action a)
{
   if (!v)
   {
    cerr<<"hk_kdesimpleform::script_error called without visible object!"<<endl;
    return;

   }



    hk_string error=replace_all("%LINENUMBER%",hk_translate("Line %LINENUMBER%: "),longint2string(interpreter()->error_rownumber()))
    				+interpreter()->errormessage();

hk_dsvisible* dv=dynamic_cast<hk_dsvisible*>(v);
if (dv)
   {
	hk_datasource* ds=dv->datasource();
	if (ds) ds->set_ignore_changed_data();
   }

if (!runtime_only())
   {
      kdeform()->set_mode(hk_presentation::designmode);
   	 if (p_property)
	    {
	     set_focus(dynamic_cast<QWidget*>(v));
	     switch (a)
	     {
		case hk_interpreter::a_click :
				p_property->pushactionbutton_clicked(presentation()->interpreter()->error_rownumber()-1,error);
				break;
		case hk_interpreter::a_doubleclick :
				p_property->doubleclickactionbutton_clicked(presentation()->interpreter()->error_rownumber()-1,error);
				break;
		case hk_interpreter::a_onopen :
				p_property->openactionbutton_clicked(presentation()->interpreter()->error_rownumber()-1,error);
				break;
		case hk_interpreter::a_onclose :
				p_property->closeactionbutton_clicked(presentation()->interpreter()->error_rownumber()-1,error);
				break;
		case hk_interpreter::a_after_row_change :
				p_property->afterrowchangebutton_clicked(presentation()->interpreter()->error_rownumber()-1,error);
				break;
		case hk_interpreter::a_before_row_change :
				p_property->beforerowchangebutton_clicked(presentation()->interpreter()->error_rownumber()-1,error);
				break;
		case hk_interpreter::a_after_update :
				p_property->afterupdatebutton_clicked(presentation()->interpreter()->error_rownumber()-1,error);
				break;
		case hk_interpreter::a_before_update :
				p_property->beforeupdatebutton_clicked(presentation()->interpreter()->error_rownumber()-1,error);
				break;
		case hk_interpreter::a_before_delete :
				p_property->beforedeletebutton_clicked(presentation()->interpreter()->error_rownumber()-1,error);
				break;
		case hk_interpreter::a_after_delete :
				p_property->afterdeletebutton_clicked(presentation()->interpreter()->error_rownumber()-1,error);
				break;
		case hk_interpreter::a_before_insert :
				p_property->beforeinsertbutton_clicked(presentation()->interpreter()->error_rownumber()-1,error);
				break;
		case hk_interpreter::a_after_insert :
				p_property->afterinsertbutton_clicked(presentation()->interpreter()->error_rownumber()-1,error);
				break;
			default:;

	     }
           }

   }
   else     show_warningmessage(error);



}


bool hk_kdesimpleform::ctrl_key_pressed(void) const
{
return p_controlbutton;
}


void hk_kdesimpleform::grid_partinfocus(hk_kdegridpart* p)
{
if (!p_kdeform) return;
p_kdeform->grid_partinfocus(p);
if (!p) return;
}

void hk_kdesimpleform::grid_partoutfocus(hk_kdegridpart*)
{
if (p_kdeform)p_kdeform->grid_partoutfocus(0L);
/*p_copyaction->setEnabled(false);
p_pasteaction->setEnabled(false);*/

}





void hk_kdesimpleform::copy(void)
{
if (mode()==designmode)
  {
    copy_widgets();
    return;
  }
  hk_kdelineedit* l=dynamic_cast<hk_kdelineedit*>(focusWidget());
  if (l)  l->copy();
  else
  {
   hk_kdesimplegrid* g=dynamic_cast<hk_kdesimplegrid*>(focusWidget());
   if (g) g->copy();
     else
      {
       hk_kdecombobox* c=dynamic_cast<hk_kdecombobox*>(focusWidget());
       if (c &&c->lineEdit()) c->lineEdit()->copy();
      }
  }

}

void hk_kdesimpleform::paste(void)
{
if (mode()==designmode)
  {
    paste_widgets();
    return;
  }
  hk_kdelineedit* l=dynamic_cast<hk_kdelineedit*>(focusWidget());
  if (l)  l->paste();
  else
  {
   hk_kdesimplegrid* g=dynamic_cast<hk_kdesimplegrid*>(focusWidget());
   if (g) g->paste();
     else
      {
       hk_kdecombobox* c=dynamic_cast<hk_kdecombobox*>(focusWidget());
       if (c &&c->lineEdit()) c->lineEdit()->paste();
      }
  }
}



void hk_kdesimpleform::cut(void)
{
if (mode()==designmode)
  {
    cut_widgets();
    return;
  }
  hk_kdelineedit* l=dynamic_cast<hk_kdelineedit*>(focusWidget());
  if (l)  l->cut();
  else
  {
   hk_kdesimplegrid* g=dynamic_cast<hk_kdesimplegrid*>(focusWidget());
   if (g) g->cut();
     else
      {
       hk_kdecombobox* c=dynamic_cast<hk_kdecombobox*>(focusWidget());
       if (c &&c->lineEdit()) c->lineEdit()->cut();
      }
  }

}


void hk_kdesimpleform::dbdesignaction(void)
{
     if (p_private->p_designer)
     	{
	 p_private->p_designer->raise();
	 return;
	}

    p_private->p_designer=new hk_kdedbdesignerwindow();
    connect (p_private->p_designer,SIGNAL(signal_closed()),this,SLOT(designer_deleted()));
    p_private->p_designer->designer()->set_database(database());
    p_private->p_designer->designer()->set_presentation(this);
    set_block_has_changed(true);
    p_private->p_designer->show();
    set_block_has_changed(false);
}

void hk_kdesimpleform::designer_deleted(void)
{
 if (p_property)
     p_property->set_object(p_property->object());
p_private->p_designer=NULL;
}


