// ****************************************************************************
// copyright (c) 2000-2004 Horst Knorr <hk_classes@knoda.org>  
// This file is part of the hk_kdeclasses library.
// This file may be distributed and/or modified under the terms of the
// GNU Library Public License version 2 as published by the Free Software
// Foundation and appearing in the file LGPL included in the
// packaging of this file.
// This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
// ****************************************************************************

#ifndef HK_KDESIMPLEGRID
#define HK_KDESIMPLEGRID
#include <hk_dsvisible.h>
#include <qheader.h>
#include <qtimer.h>
#include <qtable.h>
#include <qgridview.h>
#include <hk_dsboolean.h>

#include <hk_kderowselector.h>
class hk_kdesimpleform;
class hk_kdesimplegrid;
class hk_kdegridpart;
class hk_kdegrid;
class QLabel;
class hk_column;
class hk_kdelineedit;
class hk_kdesimplegridprivate;
/**
 *
 *@short KDE Widget to display data in a grid.
 *@version $Revision: 1.47 $
 *@author Horst Knorr (hk_classes@knoda.org)
 *
 *@internal
 *
 *This widget shows data of a datasource in a grid.
 *If the data is not readonly you can edit the data just by typing
 *in the cell.
 *Usually you don't have to use this widget, use @ref hk_kdegrid instead.
 *This widget has no rowselector.
 *You can navigate through the cells via mouse clicks or keyboard.

 */

class hk_kdesimplegrid :public QTable, public hk_dsvisible
{
    Q_OBJECT
        friend class hk_kdegrid;
    public:
        hk_kdesimplegrid(hk_kdegrid* grid, QLabel* statusbar, hk_kdesimpleform* form=NULL);
        virtual  ~hk_kdesimplegrid(void);
        virtual  QTableItem* item(int row,int col) const;
        virtual void sortColumn ( int col, bool ascending = true, bool wholeRows = false );
        hk_column* actual_column(void);
        QString text(int row, int col) const;
        void show_gridcolumndialog(void);

	signals:
	void signal_infocus(hk_kdegridpart*);
	void signal_outfocus(hk_kdegridpart*);
	//void signal_verticalheader_mouserelease();
    public slots:
/**
 *prints the whole grid using KPrinter
 */
        void print_grid(void);

    protected:
        virtual void adjustRow(int){}
        bool eventFilter(QObject* object,QEvent* event);
        void widget_specific_enable_disable(void);
        void widget_specific_row_added(void);
        void widget_specific_row_deleted(void);
        bool widget_specific_row_change(void);
        void widget_specific_insert_mode(void);
	void columns_created(void);
        bool  datasource_enable(void);
        bool  datasource_disable(void);
        void activateNextCell(void);
        void resizeData(int len);
        void paintCell(QPainter* p,int row, int col, const QRect& cr,bool selected,const QColorGroup &cg);
        void paint_textcell(QPainter* p,int row, int col, const QRect& cr,bool selected,const QColorGroup &cg);
        void paint_boolcell(QPainter* p,int row, int col, const QRect& cr,bool selected,const QColorGroup &cg);
        void paint_combocell(QPainter* p,int row, int col, const QRect& cr,bool selected,const QColorGroup &cg);
        void setCellContentFromEditor( int row, int col);
        QDragObject* dragObject ();
        void contentsDragEnterEvent(QDragEnterEvent*);
        void contentsDropEvent(QDropEvent*);
        QWidget* createEditor(int row, int col,bool initFromCell) const;
//void before_row_change(void);
void focusOutEvent ( QFocusEvent * );
void focusInEvent ( QFocusEvent * );
        void    keyPressEvent(QKeyEvent * );
        bool    key_pressevent_navigation(QKeyEvent *);


   public slots:
   void copy(void);
   void paste(void);
   void cut(void);

    protected slots:
        void row_changed(int row,int column);
        void set_columnwidth(int col,int,int newwidth);
        void column_moved(int section,int from,int to);
        void show_contextmenu(int row, int col,const QPoint& pos);
        void selection_changed(void);
	void slot_mouse_clicked(void);
	void slot_mouse_doubleclicked(void);
	void slot_verticalheader_resized(int,int,int);
	void slot_verticalheader_mouserelease(void);
	void widget_specific_rowheight_changes(void);
    private:
        typedef class
        {
            public:
                int start;                        //starting row or column
                int end;                          //final row or column
                int offset;                       // needed offset
        } sectionclass;
        void print_singlepage(QPainter&,QPaintDeviceMetrics&metrics,sectionclass& vertical,sectionclass& horizontal,int topborder,int bottomborder,int leftborder,int rightborder);
        void paste_tsv(const QString&);
	QString marked_text();
        void    set_statustext(void);
        void    nextcell();
        void    previouscell();
        bool    delete_selected_rows(void);
        QWidget* create_lineeditor(int row, int col)const;
        void print_frame(QPainter& painter,QPaintDeviceMetrics&metrics,int topborder,int bottomborder,int leftborder,int rightborder);
        int  print_header(QPainter& painter,QPaintDeviceMetrics&metrics,sectionclass& horizontal,int topborder,int bottomborder,int leftborder,int rightborder);
        hk_kdegrid* p_grid;
        QLabel*     p_statusbar;

        hk_kdesimplegridprivate* p_hk_kdesimplegridprivate;
        QPixmap arrow_image;
        QIconSet no_image;
        unsigned int p_currentrow;
        mutable bool p_combobox_created;
        int pagenumber;
};

/**
 *@internal
 */
class internalcheckbox :public QFrame, public hk_dsboolean
{
    Q_OBJECT
        public:
        internalcheckbox(QWidget* w);
        ~internalcheckbox();
    protected:
        void paintEvent(QPaintEvent*);
        void focusInEvent(QFocusEvent * f);
        bool datasource_enable(void);
        void keyPressEvent(QKeyEvent* e);
        void mousePressEvent(QMouseEvent* m);

    private slots:
        void    blinkcursorslot(void);

    private:
        void blinkon();
        QTimer      p_blinktimer;
        bool p_cursoron;
        int p_blinkspeed;
};
#endif
